/*
 * Decompiled with CFR 0.152.
 */
package net.nutritionz.network;

import com.google.common.collect.LinkedHashMultimap;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import net.nutritionz.NutritionMain;
import net.nutritionz.access.HungerManagerAccess;
import net.nutritionz.network.NutritionServerPacket;

@Environment(value=EnvType.CLIENT)
public class NutritionClientPacket {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NutritionServerPacket.NUTRITION_SYNC_PACKET, (client, handler, buf, sender) -> {
            int carbohydrateLevel = buf.readInt();
            int proteinLevel = buf.readInt();
            int fatLevel = buf.readInt();
            int vitaminLevel = buf.readInt();
            int mineralLevel = buf.readInt();
            client.execute(() -> {
                ((HungerManagerAccess)client.field_1724.method_7344()).setNutritionLevel(0, carbohydrateLevel);
                ((HungerManagerAccess)client.field_1724.method_7344()).setNutritionLevel(1, proteinLevel);
                ((HungerManagerAccess)client.field_1724.method_7344()).setNutritionLevel(2, fatLevel);
                ((HungerManagerAccess)client.field_1724.method_7344()).setNutritionLevel(3, vitaminLevel);
                ((HungerManagerAccess)client.field_1724.method_7344()).setNutritionLevel(4, mineralLevel);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NutritionServerPacket.ITEM_NUTRITION_PACKET, (client, handler, buf, sender) -> {
            ArrayList<Integer> list = new ArrayList<Integer>();
            while (buf.isReadable()) {
                list.add(buf.readInt());
            }
            client.execute(() -> {
                NutritionMain.NUTRITION_ITEM_MAP.clear();
                for (int i = 0; i < list.size(); i += 6) {
                    ArrayList<Integer> nutritionList = new ArrayList<Integer>();
                    nutritionList.add((Integer)list.get(i + 1));
                    nutritionList.add((Integer)list.get(i + 2));
                    nutritionList.add((Integer)list.get(i + 3));
                    nutritionList.add((Integer)list.get(i + 4));
                    nutritionList.add((Integer)list.get(i + 5));
                    NutritionMain.NUTRITION_ITEM_MAP.put((class_1792)class_7923.field_41178.method_10200(((Integer)list.get(i)).intValue()), nutritionList);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NutritionServerPacket.EFFECT_NUTRITION_PACKET, (client, handler, buf, sender) -> {
            ArrayList list = new ArrayList();
            for (int i = 0; i < 2; ++i) {
                HashMap map = new HashMap();
                int size = buf.readInt();
                for (int u = 0; u < size; ++u) {
                    ArrayList<Object> objectList = new ArrayList<Object>();
                    int nutritionKey = buf.readInt();
                    int nutritionSize = buf.readInt();
                    for (int o = 0; o < nutritionSize; ++o) {
                        class_2960 identifier;
                        if (buf.readBoolean()) {
                            identifier = buf.method_10810();
                            int duration = buf.readInt();
                            int amplifier = buf.readInt();
                            objectList.add(new class_1293((class_1291)class_7923.field_41174.method_10223(identifier), duration, amplifier, false, false, true));
                            continue;
                        }
                        identifier = buf.method_10810();
                        UUID uuid = buf.method_10790();
                        float value = buf.readFloat();
                        String operation = buf.method_19772();
                        LinkedHashMultimap attributeModifiers = LinkedHashMultimap.create();
                        attributeModifiers.put((Object)((class_1320)class_7923.field_41190.method_10223(identifier)), (Object)new class_1322(uuid, ((class_1320)class_7923.field_41190.method_10223(identifier)).method_26830(), (double)value, class_1322.class_1323.valueOf((String)operation.toUpperCase())));
                        objectList.add(attributeModifiers);
                    }
                    map.put(nutritionKey, objectList);
                }
                list.add(map);
            }
            client.execute(() -> {
                NutritionMain.NUTRITION_POSITIVE_EFFECTS.clear();
                NutritionMain.NUTRITION_NEGATIVE_EFFECTS.clear();
                Iterator iterator = list.iterator();
                boolean positive = true;
                while (iterator.hasNext()) {
                    HashMap map = (HashMap)iterator.next();
                    if (positive) {
                        map.forEach((nutritionKey, effectList) -> NutritionMain.NUTRITION_POSITIVE_EFFECTS.put((Integer)nutritionKey, (List<Object>)effectList));
                    } else {
                        map.forEach((nutritionKey, effectList) -> NutritionMain.NUTRITION_NEGATIVE_EFFECTS.put((Integer)nutritionKey, (List<Object>)effectList));
                    }
                    positive = false;
                }
            });
        });
    }

    public static void writeC2SNutritionPacket() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        class_2817 packet = new class_2817(NutritionServerPacket.SEND_NUTRITION_PACKET, buf);
        class_310.method_1551().method_1562().method_2883((class_2596)packet);
    }
}

