/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.obscuria.tooltips.config.ClientConfig;
import dev.obscuria.tooltips.mixin.ClientTextTooltipAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2477;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5683;
import net.minecraft.class_5684;

public interface TooltipHelper {
    public static void enableGlowingRenderer() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
    }

    public static void disableGlowingRenderer() {
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    public static int widthOf(List<class_5684> components, class_327 font) {
        int max = 0;
        for (class_5684 component : components) {
            int width = component.method_32664(font);
            if (width <= max) continue;
            max = width;
        }
        return max;
    }

    public static int heightOf(List<class_5684> components) {
        int sum = 0;
        for (class_5684 component : components) {
            sum += component.method_32661();
        }
        return sum;
    }

    public static List<class_5684> wrapLines(class_332 graphics, List<class_5684> components, class_327 font) {
        int maxWidth = (int)((double)graphics.method_51421() * 0.5);
        if (!TooltipHelper.shouldWrap(components, font, maxWidth)) {
            return components;
        }
        ArrayList<class_5684> result = new ArrayList<class_5684>(components.size() * 2);
        for (class_5684 component : components) {
            if (!(component instanceof class_5683)) {
                result.add(component);
                continue;
            }
            class_5683 tooltip = (class_5683)component;
            if (tooltip.method_32664(font) <= maxWidth) {
                result.add((class_5684)tooltip);
                continue;
            }
            for (class_5348 line : font.method_27527().method_27495(TooltipHelper.textOf(tooltip), maxWidth, class_2583.field_24360)) {
                result.add((class_5684)new class_5683(class_2477.method_10517().method_30934(line)));
            }
        }
        return result;
    }

    private static boolean shouldWrap(List<class_5684> components, class_327 font, int maxWidth) {
        if (!((Boolean)ClientConfig.AUTO_WRAP_ENABLED.get()).booleanValue()) {
            return false;
        }
        for (class_5684 component : components) {
            class_5683 tooltip;
            if (!(component instanceof class_5683) || (tooltip = (class_5683)component).method_32664(font) <= maxWidth) continue;
            return true;
        }
        return false;
    }

    private static class_5348 textOf(class_5683 tooltip) {
        class_5481 sequence = ((ClientTextTooltipAccessor)tooltip).getText();
        ArrayList<String> elements = new ArrayList<String>();
        ArrayList<class_2583> styles = new ArrayList<class_2583>();
        StringBuilder builder = new StringBuilder();
        AtomicReference<class_2583> currentStyle = new AtomicReference<class_2583>(class_2583.field_24360);
        sequence.accept((i, style, codePoint) -> {
            if (!style.equals(currentStyle.get())) {
                if (!builder.isEmpty()) {
                    elements.add(builder.toString());
                    styles.add((class_2583)currentStyle.get());
                    builder.setLength(0);
                }
                currentStyle.set(style);
            }
            builder.appendCodePoint(codePoint);
            return true;
        });
        if (!builder.isEmpty()) {
            elements.add(builder.toString());
            styles.add(currentStyle.get());
        }
        return new LineComponent(elements, styles);
    }

    public record LineComponent(List<String> elements, List<class_2583> styles) implements class_5348
    {
        public <T> Optional<T> method_27657(class_5348.class_5245<T> consumer) {
            for (String element : this.elements) {
                consumer.accept(element);
            }
            return Optional.empty();
        }

        public <T> Optional<T> method_27658(class_5348.class_5246<T> consumer, class_2583 base) {
            for (int i = 0; i < this.elements.size(); ++i) {
                class_2583 style = this.styles.get(i).method_27702(base);
                consumer.accept(style, this.elements.get(i));
            }
            return Optional.empty();
        }
    }
}

