/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client;

import dev.obscuria.fragmentum.client.ClientGroupTooltip;
import dev.obscuria.tooltips.client.TooltipHelper;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.component.StackBuffer;
import dev.obscuria.tooltips.client.tooltip.TooltipScroll;
import dev.obscuria.tooltips.client.tooltip.layout.ArmorPreviewLayout;
import dev.obscuria.tooltips.client.tooltip.layout.DefaultLayout;
import dev.obscuria.tooltips.client.tooltip.layout.ToolPreviewLayout;
import dev.obscuria.tooltips.client.tooltip.layout.TooltipLayout;
import dev.obscuria.tooltips.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import org.joml.Vector2ic;

public final class TooltipRenderer {
    private static class_1799 lastStack = class_1799.field_8037;
    private static class_1799 actualStack = class_1799.field_8037;
    private static TooltipLayout<?> layout = new DefaultLayout();
    private static TooltipState state = new EmptyState();

    public static boolean render(class_332 graphics, class_327 font, List<class_5684> components, int mouseX, int mouseY, class_8000 positioner) {
        if (!((Boolean)ClientConfig.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (components.isEmpty()) {
            return false;
        }
        if (!TooltipRenderer.perform(components)) {
            return false;
        }
        if (state instanceof EmptyState) {
            return false;
        }
        components = new ArrayList<class_5684>(components);
        components = layout.rawProcessPreWrap(state, components, font);
        components = TooltipHelper.wrapLines(graphics, components, font);
        components = layout.rawProcessPostWrap(state, components, font);
        Integer margin = (Integer)ClientConfig.CONTENT_MARGIN.get();
        int width = margin * 2 + TooltipHelper.widthOf(components, font);
        int height = margin * 2 + TooltipHelper.heightOf(components) - 2;
        Vector2ic pos = positioner.method_47944(graphics.method_51421(), graphics.method_51443(), mouseX, mouseY, width, height);
        TooltipScroll.update(state, 6 + height, graphics.method_51443());
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, TooltipScroll.getScroll(), 400.0f);
        graphics.method_51452();
        state.renderPanel(graphics, pos, width, height);
        state.renderEffects(graphics, pos, width, height);
        graphics.method_51452();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, 2.0f);
        state.renderFrame(graphics, pos, width, height);
        graphics.method_51448().method_22909();
        graphics.method_51452();
        int componentX = margin + pos.x();
        int componentY = margin + pos.y();
        for (class_5684 component : components) {
            component.method_32665(font, componentX, componentY, graphics.method_51448().method_23760().method_23761(), graphics.method_51450());
            component.method_32666(font, componentX, componentY, graphics);
            componentY += component.method_32661();
        }
        graphics.method_51448().method_22909();
        lastStack = actualStack;
        actualStack = class_1799.field_8037;
        state.update();
        return true;
    }

    private static boolean perform(List<class_5684> components) {
        StackBuffer buffer = (StackBuffer)ClientGroupTooltip.findFirst(components, StackBuffer.class);
        if (buffer == null) {
            return false;
        }
        actualStack = buffer.stack();
        if (class_1799.method_31577((class_1799)lastStack, (class_1799)actualStack)) {
            return true;
        }
        layout = TooltipRenderer.shouldShowArmorPreview(actualStack) ? ArmorPreviewLayout.INSTANCE : (TooltipRenderer.shouldShowToolPreview(actualStack) ? ToolPreviewLayout.INSTANCE : DefaultLayout.INSTANCE);
        state = layout.extractState(actualStack);
        return true;
    }

    private static boolean shouldShowArmorPreview(class_1799 stack) {
        if (!((Boolean)ClientConfig.ARMOR_PREVIEW_ENABLED.get()).booleanValue()) {
            return false;
        }
        if (ClientConfig.isInArmorPreviewBlacklist(stack.method_7909())) {
            return false;
        }
        return stack.method_7909() instanceof class_1738 || ClientConfig.isInArmorPreviewWhitelist(stack.method_7909());
    }

    private static boolean shouldShowToolPreview(class_1799 stack) {
        if (!((Boolean)ClientConfig.TOOL_PREVIEW_ENABLED.get()).booleanValue()) {
            return false;
        }
        if (ClientConfig.isInToolPreviewBlacklist(stack.method_7909())) {
            return false;
        }
        return stack.method_7909() instanceof class_1831 || ClientConfig.isInToolPreviewWhitelist(stack.method_7909());
    }

    private static final class EmptyState
    extends TooltipState {
        private EmptyState() {
            super(class_1799.field_8037);
        }
    }
}

