/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import net.puffish.skillsmod.api.Events;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSource;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.calculation.LegacyBuiltinPrototypes;
import net.puffish.skillsmod.calculation.operation.BuiltinOperations;
import net.puffish.skillsmod.commands.CategoryCommand;
import net.puffish.skillsmod.commands.ExperienceCommand;
import net.puffish.skillsmod.commands.OpenCommand;
import net.puffish.skillsmod.commands.PointsCommand;
import net.puffish.skillsmod.commands.SkillsCommand;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.config.Config;
import net.puffish.skillsmod.config.ModConfig;
import net.puffish.skillsmod.config.PackConfig;
import net.puffish.skillsmod.config.experience.ExperienceConfig;
import net.puffish.skillsmod.config.experience.ExperienceSourceConfig;
import net.puffish.skillsmod.config.reader.ConfigReader;
import net.puffish.skillsmod.config.reader.FileConfigReader;
import net.puffish.skillsmod.config.reader.PackConfigReader;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.config.skill.SkillRewardConfig;
import net.puffish.skillsmod.experience.ExperienceCurve;
import net.puffish.skillsmod.experience.source.BuiltinExperienceSources;
import net.puffish.skillsmod.impl.config.ConfigContextImpl;
import net.puffish.skillsmod.impl.rewards.RewardUpdateContextImpl;
import net.puffish.skillsmod.network.Packets;
import net.puffish.skillsmod.reward.BuiltinRewards;
import net.puffish.skillsmod.reward.builtin.PointsReward;
import net.puffish.skillsmod.server.data.CategoryData;
import net.puffish.skillsmod.server.data.PlayerData;
import net.puffish.skillsmod.server.data.ServerData;
import net.puffish.skillsmod.server.event.ServerEventListener;
import net.puffish.skillsmod.server.event.ServerEventReceiver;
import net.puffish.skillsmod.server.network.ServerPacketSender;
import net.puffish.skillsmod.server.network.packets.in.SkillClickInPacket;
import net.puffish.skillsmod.server.network.packets.out.ExperienceUpdateOutPacket;
import net.puffish.skillsmod.server.network.packets.out.HideCategoryOutPacket;
import net.puffish.skillsmod.server.network.packets.out.NewPointOutPacket;
import net.puffish.skillsmod.server.network.packets.out.OpenScreenOutPacket;
import net.puffish.skillsmod.server.network.packets.out.PointsUpdateOutPacket;
import net.puffish.skillsmod.server.network.packets.out.ShowCategoryOutPacket;
import net.puffish.skillsmod.server.network.packets.out.ShowToastOutPacket;
import net.puffish.skillsmod.server.network.packets.out.SkillUpdateOutPacket;
import net.puffish.skillsmod.server.setup.ServerPlatform;
import net.puffish.skillsmod.server.setup.ServerRegistrar;
import net.puffish.skillsmod.server.setup.SkillsArgumentTypes;
import net.puffish.skillsmod.server.setup.SkillsGameRules;
import net.puffish.skillsmod.util.ChangeListener;
import net.puffish.skillsmod.util.DisposeContext;
import net.puffish.skillsmod.util.Event;
import net.puffish.skillsmod.util.PathUtils;
import net.puffish.skillsmod.util.PointSources;
import net.puffish.skillsmod.util.PrefixedLogger;
import net.puffish.skillsmod.util.ToastType;
import net.puffish.skillsmod.util.VersionedConfigContext;

public class SkillsMod {
    public static final int MIN_CONFIG_VERSION = 1;
    public static final int MAX_CONFIG_VERSION = 3;
    public static final Event<Events.SkillUnlock> SKILL_UNLOCK = Event.create(c -> (categoryId, skillId) -> c.forEach(e -> e.onSkillUnlock(categoryId, skillId)));
    public static final Event<Events.SkillLock> SKILL_LOCK = Event.create(c -> (categoryId, skillId) -> c.forEach(e -> e.onSkillLock(categoryId, skillId)));
    private static SkillsMod instance;
    private final PrefixedLogger logger = new PrefixedLogger("puffish_skills");
    private final Path modConfigDir;
    private final ServerPacketSender packetSender;
    private final ServerPlatform platform;
    private final SkillsGameRules gameRules;
    private final ChangeListener<Optional<Map<class_2960, CategoryConfig>>> categories = new ChangeListener(Optional.empty(), () -> {});

    private SkillsMod(Path modConfigDir, ServerPacketSender packetSender, ServerPlatform platform, SkillsGameRules gameRules) {
        this.modConfigDir = modConfigDir;
        this.packetSender = packetSender;
        this.platform = platform;
        this.gameRules = gameRules;
    }

    public static SkillsMod getInstance() {
        return instance;
    }

    public ServerPlatform getPlatform() {
        return this.platform;
    }

    public static void setup(Path configDir, ServerRegistrar registrar, ServerEventReceiver eventReceiver, ServerPacketSender packetSender, ServerPlatform platform) {
        Path modConfigDir = configDir.resolve("puffish_skills");
        try {
            Files.createDirectories(modConfigDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SkillsGameRules gameRules = SkillsGameRules.register(registrar);
        instance = new SkillsMod(modConfigDir, packetSender, platform, gameRules);
        registrar.registerInPacket(Packets.SKILL_CLICK, SkillClickInPacket::read, instance::onSkillClickPacket);
        registrar.registerOutPacket(Packets.SHOW_CATEGORY);
        registrar.registerOutPacket(Packets.HIDE_CATEGORY);
        registrar.registerOutPacket(Packets.SKILL_UPDATE);
        registrar.registerOutPacket(Packets.POINTS_UPDATE);
        registrar.registerOutPacket(Packets.EXPERIENCE_UPDATE);
        registrar.registerOutPacket(Packets.SHOW_TOAST);
        registrar.registerOutPacket(Packets.OPEN_SCREEN);
        registrar.registerOutPacket(Packets.NEW_POINT);
        eventReceiver.registerListener(instance.new EventListener());
        SkillsArgumentTypes.register(registrar);
        BuiltinRewards.register();
        BuiltinOperations.register();
        BuiltinExperienceSources.register();
        LegacyBuiltinPrototypes.register();
    }

    public static class_2960 createIdentifier(String path) {
        return new class_2960("puffish_skills", path);
    }

    public static class_2960 convertIdentifier(class_2960 id) {
        if (id.method_12836().equals("minecraft")) {
            return SkillsMod.createIdentifier(id.method_12832());
        }
        return id;
    }

    public static class_5250 createTranslatable(String type, String path, Object ... args) {
        return class_2561.method_43469((String)class_156.method_646((String)type, (class_2960)SkillsMod.createIdentifier(path)), (Object[])args);
    }

    public PrefixedLogger getLogger() {
        return this.logger;
    }

    private void copyConfigFromJar() {
        PathUtils.copyFileFromJar(Path.of("config", "config.json"), this.modConfigDir.resolve("config.json"));
    }

    private void loadModConfig(MinecraftServer server) {
        if (!Files.exists(this.modConfigDir, new LinkOption[0]) || PathUtils.isDirectoryEmpty(this.modConfigDir)) {
            this.copyConfigFromJar();
        }
        FileConfigReader reader = new FileConfigReader(this.modConfigDir);
        ConfigContextImpl context = new ConfigContextImpl(server);
        reader.read(Path.of("config.json", new String[0])).andThen(rootElement -> ModConfig.parse(rootElement, (ConfigContext)context)).andThen(modConfig -> this.loadCategories(reader, (Config)modConfig, "puffish_skills", context).ifSuccess(map -> {
            LinkedHashMap<class_2960, CategoryConfig> cumulatedMap = new LinkedHashMap<class_2960, CategoryConfig>((Map<class_2960, CategoryConfig>)map);
            this.showSuccess("Mod configuration", modConfig.showWarnings(), context);
            if (this.loadPackConfig(server, cumulatedMap, modConfig.showWarnings())) {
                this.categories.set(Optional.of(cumulatedMap), () -> {
                    for (CategoryConfig category : cumulatedMap.values()) {
                        category.dispose(new DisposeContext(server));
                    }
                });
            } else {
                this.categories.set(Optional.empty(), () -> {});
            }
        })).ifFailure(problem -> {
            this.categories.set(Optional.empty(), () -> {});
            this.showFailure("Mod configuration", (Problem)problem);
        });
    }

    private Result<Map<class_2960, CategoryConfig>, Problem> loadCategories(ConfigReader reader, Config config, String namespace, ConfigContext context) {
        VersionedConfigContext versionedContext = new VersionedConfigContext(context, config.version());
        return reader.readCategories(namespace, config.categories(), versionedContext);
    }

    private boolean loadPackConfig(MinecraftServer server, Map<class_2960, CategoryConfig> cumulatedMap, boolean showWarning) {
        class_3300 resourceManager = server.method_34864();
        Map resources = resourceManager.method_14488("puffish_skills", id -> id.method_12832().endsWith("config.json"));
        boolean allSuccess = true;
        for (Map.Entry entry : resources.entrySet()) {
            class_3298 resource = (class_3298)entry.getValue();
            class_2960 id2 = (class_2960)entry.getKey();
            String namespace = id2.method_12836();
            PackConfigReader reader = new PackConfigReader(resourceManager, namespace);
            ConfigContextImpl context = new ConfigContextImpl(server);
            if (!reader.readResource(id2, resource).andThen(rootElement -> PackConfig.parse(namespace, rootElement, (ConfigContext)context)).andThen(packConfig -> this.loadCategories(reader, (Config)packConfig, namespace, context)).andThen(map -> {
                ArrayList<Problem> problems = new ArrayList<Problem>();
                for (class_2960 key : map.keySet()) {
                    if (!cumulatedMap.containsKey(key)) continue;
                    problems.add(Problem.message("Category `" + String.valueOf(key) + "` already exists."));
                }
                if (problems.isEmpty()) {
                    return Result.success(map);
                }
                return Result.failure(Problem.combine(problems));
            }).ifFailure(problem -> this.showFailure("Data pack `" + namespace + "`", (Problem)problem)).ifSuccess(map -> {
                cumulatedMap.putAll((Map<class_2960, CategoryConfig>)map);
                this.showSuccess("Data pack `" + namespace + "`", showWarning, context);
            }).getSuccess().isEmpty()) continue;
            allSuccess = false;
        }
        return allSuccess;
    }

    private void showSuccess(String name, boolean showWarnings, ConfigContextImpl context) {
        if (showWarnings && !context.warnings().isEmpty()) {
            this.logger.warn(name + " loaded successfully with warning(s):" + System.lineSeparator() + context.warnings().stream().collect(Collectors.joining(System.lineSeparator())));
        } else {
            this.logger.info(name + " loaded successfully!");
        }
    }

    private void showFailure(String name, Problem problem) {
        this.logger.error(name + " could not be loaded:" + System.lineSeparator() + String.valueOf(problem));
    }

    private void onSkillClickPacket(class_3222 player, SkillClickInPacket packet) {
        if (player.method_7325()) {
            return;
        }
        this.tryUnlockSkill(player, packet.getCategoryId(), packet.getSkillId(), false);
    }

    public void unlockSkill(class_3222 player, class_2960 categoryId, String skillId) {
        this.tryUnlockSkill(player, categoryId, skillId, true);
    }

    public void tryUnlockSkill(class_3222 player, class_2960 categoryId, String skillId, boolean force) {
        this.getCategory(categoryId).ifPresent(category -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            category.skills().getById(skillId).ifPresent(skill -> {
                if (categoryData.canUnlockSkill((CategoryConfig)category, (SkillConfig)skill, force)) {
                    this.watchNewPoints(player, (CategoryConfig)category, categoryData, false, () -> {
                        categoryData.unlockSkill(skillId);
                        this.packetSender.send(player, new SkillUpdateOutPacket(categoryId, skillId, true));
                        this.syncPoints(player, (CategoryConfig)category, categoryData);
                    });
                    SKILL_UNLOCK.invoker().onSkillUnlock(categoryId, skillId);
                    this.updateSkillRewards(player, (CategoryConfig)category, categoryData, (SkillConfig)skill, true);
                }
            });
        });
    }

    public void lockSkill(class_3222 player, class_2960 categoryId, String skillId) {
        this.getCategory(categoryId).ifPresent(category -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            category.skills().getById(skillId).ifPresent(skill -> {
                this.watchNewPoints(player, (CategoryConfig)category, categoryData, false, () -> {
                    categoryData.lockSkill(skillId);
                    this.packetSender.send(player, new SkillUpdateOutPacket(categoryId, skillId, false));
                    this.syncPoints(player, (CategoryConfig)category, categoryData);
                });
                SKILL_LOCK.invoker().onSkillLock(categoryId, skillId);
                this.updateSkillRewards(player, (CategoryConfig)category, categoryData, (SkillConfig)skill, false);
            });
        });
    }

    public void resetSkills(class_3222 player, class_2960 categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            categoryData.resetSkills();
            this.updateRewards(player, (CategoryConfig)category, categoryData);
            this.showCategory(player, (CategoryConfig)category, categoryData);
        });
    }

    public void eraseCategory(class_3222 player, class_2960 categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.removeCategoryData((CategoryConfig)category);
            this.updateCategory(player, (CategoryConfig)category);
        });
    }

    public void unlockCategory(class_3222 player, class_2960 categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            categoryData.unlock();
            this.showCategory(player, (CategoryConfig)category, categoryData);
        });
    }

    public void lockCategory(class_3222 player, class_2960 categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            categoryData.lock();
            this.hideCategory(player, (CategoryConfig)category);
        });
    }

    public Optional<Boolean> hasExperience(class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> category.experience().isPresent());
    }

    public void addExperience(class_3222 player, class_2960 categoryId, int amount) {
        this.getCategory(categoryId).ifPresent(category -> category.experience().ifPresent(experience -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            this.addExperience(player, (CategoryConfig)category, (ExperienceConfig)experience, categoryData, amount);
        }));
    }

    public void addExperience(class_3222 player, CategoryConfig category, ExperienceConfig experience, CategoryData categoryData, int amount) {
        this.setExperience(player, category, experience, categoryData, categoryData.getExperience() + amount);
    }

    public void setExperience(class_3222 player, class_2960 categoryId, int amount) {
        this.getCategory(categoryId).ifPresent(category -> category.experience().ifPresent(experience -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            this.setExperience(player, (CategoryConfig)category, (ExperienceConfig)experience, categoryData, amount);
        }));
    }

    public void setExperience(class_3222 player, CategoryConfig category, ExperienceConfig experience, CategoryData categoryData, int amount) {
        int levelLimit;
        ExperienceCurve curve = experience.curve();
        int level = curve.getProgress(amount).currentLevel();
        if (level >= (levelLimit = curve.getLevelLimit())) {
            level = levelLimit;
            amount = curve.getRequiredTotal(levelLimit - 1);
        }
        categoryData.setExperience(amount);
        this.syncExperience(player, category, experience, categoryData);
        this.setPoints(player, category, categoryData, PointSources.EXPERIENCE, level, false);
    }

    public Optional<Integer> getExperience(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).flatMap(category -> {
            if (category.experience().isEmpty()) {
                return Optional.empty();
            }
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            return Optional.of(categoryData.getExperience());
        });
    }

    public void addPoints(class_3222 player, class_2960 categoryId, class_2960 source, int count, boolean isSilent) {
        this.getCategory(categoryId).ifPresent(category -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            this.addPoints(player, (CategoryConfig)category, categoryData, source, count, isSilent);
        });
    }

    public void addPoints(class_3222 player, CategoryConfig category, CategoryData categoryData, class_2960 source, int count, boolean isSilent) {
        this.setPoints(player, category, categoryData, source, categoryData.getPoints(source) + count, isSilent);
    }

    public void setPoints(class_3222 player, class_2960 categoryId, class_2960 source, int count, boolean isSilent) {
        this.getCategory(categoryId).ifPresent(category -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            this.setPoints(player, (CategoryConfig)category, categoryData, source, count, isSilent);
        });
    }

    public void setPoints(class_3222 player, CategoryConfig category, CategoryData categoryData, class_2960 source, int count, boolean isSilent) {
        this.watchNewPoints(player, category, categoryData, isSilent, () -> {
            categoryData.setPoints(source, count);
            this.syncPoints(player, category, categoryData);
        });
    }

    public Optional<Integer> getPoints(class_3222 player, class_2960 categoryId, class_2960 source) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            return categoryData.getPoints(source);
        });
    }

    public Optional<Integer> getPointsTotal(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            return categoryData.getPointsTotal();
        });
    }

    public Optional<Stream<class_2960>> getPointsSources(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            return categoryData.getPointsSources();
        });
    }

    public Optional<Integer> getPointsLeft(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            return categoryData.getPointsLeft((CategoryConfig)category);
        });
    }

    public Optional<Integer> getSpentPoints(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            return categoryData.getSpentPoints((CategoryConfig)category);
        });
    }

    public Optional<Integer> getCurrentLevel(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> category.experience().map(experience -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            return experience.curve().getProgress(categoryData.getExperience()).currentLevel();
        }).orElse(0));
    }

    public Optional<Integer> getCurrentExperience(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> category.experience().map(experience -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            return experience.curve().getProgress(categoryData.getExperience()).currentExperience();
        }).orElse(0));
    }

    public Optional<Integer> getRequiredExperience(class_2960 categoryId, int level) {
        return this.getCategory(categoryId).map(category -> category.experience().map(experience -> experience.curve().getRequired(level)).orElse(0));
    }

    public Optional<Integer> getRequiredTotalExperience(class_2960 categoryId, int level) {
        return this.getCategory(categoryId).map(category -> category.experience().map(experience -> experience.curve().getRequiredTotal(level)).orElse(0));
    }

    public Optional<Skill.State> getSkillState(class_3222 player, class_2960 categoryId, String skillId) {
        return this.getCategory(categoryId).flatMap(category -> category.skills().getById(skillId).flatMap(skill -> category.definitions().getById(skill.definitionId()).map(definition -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            return categoryData.getSkillState((CategoryConfig)category, (SkillConfig)skill, (SkillDefinitionConfig)definition);
        })));
    }

    public Collection<class_2960> getUnlockedCategories(class_3222 player) {
        PlayerData playerData = this.getPlayerData(player);
        return this.getAllCategories().stream().filter(playerData::isCategoryUnlocked).map(CategoryConfig::id).toList();
    }

    public Collection<class_2960> getCategories(boolean onlyWithExperience) {
        return this.getAllCategories().stream().filter(category -> !onlyWithExperience || category.experience().isPresent()).map(CategoryConfig::id).toList();
    }

    public Optional<Collection<String>> getUnlockedSkills(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getOrCreateCategoryData((CategoryConfig)category);
            return categoryData.getUnlockedSkillIds();
        });
    }

    public Optional<Collection<String>> getSkills(class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> category.skills().getAll().stream().map(SkillConfig::id).toList());
    }

    public boolean hasCategory(class_2960 categoryId) {
        return this.getCategory(categoryId).isPresent();
    }

    public boolean hasSkill(class_2960 categoryId, String skillId) {
        return this.getCategory(categoryId).map(category -> category.skills().getById(skillId).isPresent()).orElse(false);
    }

    private void showCategory(class_3222 player, CategoryConfig category, CategoryData categoryData) {
        this.updatePoints(category, categoryData);
        this.updateRewards(player, category, categoryData);
        this.packetSender.send(player, new ShowCategoryOutPacket(category, categoryData));
    }

    private void hideCategory(class_3222 player, CategoryConfig category) {
        this.resetRewards(player, category);
        this.packetSender.send(player, new HideCategoryOutPacket(category.id()));
    }

    public void exportPlayerData(class_3222 player, class_2487 nbt) {
        this.getPlayerData(player).writeNbt(nbt);
    }

    public void importPlayerData(class_3222 player, class_2487 nbt) {
        for (CategoryConfig category : this.getAllCategories()) {
            this.resetRewards(player, category);
        }
        this.putPlayerData(player, PlayerData.read(nbt));
        this.updateAllCategories(player);
    }

    private void watchNewPoints(class_3222 player, CategoryConfig category, CategoryData categoryData, boolean isSilent, Runnable runnable) {
        if (isSilent) {
            runnable.run();
        } else {
            int pointsLeft = categoryData.getPointsLeft(category);
            runnable.run();
            if (categoryData.getPointsLeft(category) > pointsLeft && player.method_37908().method_8450().method_8355(this.gameRules.announceNewPoints())) {
                this.packetSender.send(player, new NewPointOutPacket(category.id()));
            }
        }
    }

    private void syncPoints(class_3222 player, CategoryConfig category, CategoryData categoryData) {
        this.packetSender.send(player, new PointsUpdateOutPacket(category.id(), categoryData.getSpentPoints(category), categoryData.getPointsTotal()));
    }

    private void syncExperience(class_3222 player, CategoryConfig category, ExperienceConfig experience, CategoryData categoryData) {
        ExperienceCurve.Progress progress = experience.curve().getProgress(categoryData.getExperience());
        this.packetSender.send(player, new ExperienceUpdateOutPacket(category.id(), progress.currentLevel(), progress.currentExperience(), progress.requiredExperience()));
    }

    public void visitExperienceSources(class_3222 player, Function<ExperienceSource, Integer> function) {
        if (this.platform.isFakePlayer(player)) {
            return;
        }
        PlayerData playerData = this.getPlayerData(player);
        for (CategoryConfig category : this.getAllCategories()) {
            if (!playerData.isCategoryUnlocked(category)) continue;
            category.experience().ifPresent(experience -> this.visitExperienceSources(player, playerData, category, (ExperienceConfig)experience, function));
        }
    }

    private void visitExperienceSources(class_3222 player, PlayerData playerData, CategoryConfig category, ExperienceConfig experience, Function<ExperienceSource, Integer> function) {
        int amount = 0;
        HashMap<class_3222, Integer> teamAmounts = new HashMap<class_3222, Integer>();
        for (ExperienceSourceConfig experienceSource : experience.experienceSources()) {
            Integer result = function.apply(experienceSource.instance());
            if (result == 0) continue;
            amount += result.intValue();
            experienceSource.teamSharing().ifPresent(teamSharing -> {
                List teamPlayers = player.method_51469().method_18766(otherPlayer -> player != otherPlayer && player.method_5722((class_1297)otherPlayer) && player.method_5739((class_1297)otherPlayer) <= teamSharing.distanceLimit() && this.getPlayerData((class_3222)otherPlayer).isCategoryUnlocked(category));
                for (class_3222 teamPlayer : teamPlayers) {
                    teamAmounts.compute(teamPlayer, (key, value) -> (value == null ? 0 : value) + result);
                }
            });
        }
        if (amount != 0) {
            CategoryData categoryData = playerData.getOrCreateCategoryData(category);
            this.addExperience(player, category, experience, categoryData, amount);
        }
        teamAmounts.forEach((teamPlayer, teamPlayerAmount) -> {
            CategoryData categoryData = this.getPlayerData((class_3222)teamPlayer).getOrCreateCategoryData(category);
            this.addExperience((class_3222)teamPlayer, category, experience, categoryData, (int)teamPlayerAmount);
        });
    }

    public void updateRewards(class_3222 player, Predicate<SkillRewardConfig> predicate) {
        if (this.platform.isFakePlayer(player)) {
            return;
        }
        PlayerData playerData = this.getPlayerData(player);
        for (CategoryConfig category : this.getAllCategories()) {
            this.getCategoryDataIfUnlocked(playerData, category).ifPresent(categoryData -> {
                for (SkillDefinitionConfig definition : category.definitions().getAll()) {
                    int count = categoryData.countUnlocked(category, definition.id());
                    for (SkillRewardConfig reward : definition.rewards()) {
                        if (!predicate.test(reward)) continue;
                        reward.instance().update(new RewardUpdateContextImpl(player, count, false));
                    }
                }
            });
        }
    }

    private void updateRewards(class_3222 player, CategoryConfig category, CategoryData categoryData) {
        for (SkillDefinitionConfig definition : category.definitions().getAll()) {
            int count = categoryData.countUnlocked(category, definition.id());
            for (SkillRewardConfig reward : definition.rewards()) {
                reward.instance().update(new RewardUpdateContextImpl(player, count, false));
            }
        }
    }

    private void updateSkillRewards(class_3222 player, CategoryConfig category, CategoryData categoryData, SkillConfig skill, boolean isUnlock) {
        category.definitions().getById(skill.definitionId()).ifPresent(definition -> {
            int count = categoryData.countUnlocked(category, definition.id());
            for (SkillRewardConfig reward : definition.rewards()) {
                reward.instance().update(new RewardUpdateContextImpl(player, count, isUnlock));
            }
        });
    }

    private void resetRewards(class_3222 player, CategoryConfig category) {
        for (SkillDefinitionConfig definition : category.definitions().getAll()) {
            for (SkillRewardConfig reward : definition.rewards()) {
                reward.instance().update(new RewardUpdateContextImpl(player, 0, false));
            }
        }
    }

    private Optional<CategoryData> getCategoryDataIfUnlocked(class_3222 player, CategoryConfig category) {
        return this.getCategoryDataIfUnlocked(this.getPlayerData(player), category);
    }

    private Optional<CategoryData> getCategoryDataIfUnlocked(PlayerData playerData, CategoryConfig category) {
        if (playerData.isCategoryUnlocked(category)) {
            return Optional.of(playerData.getOrCreateCategoryData(category));
        }
        return Optional.empty();
    }

    public Optional<Boolean> isCategoryUnlocked(class_3222 player, class_2960 categoryId) {
        return this.getCategory(categoryId).map(category -> this.getPlayerData(player).isCategoryUnlocked((CategoryConfig)category));
    }

    private Optional<CategoryConfig> getCategory(class_2960 categoryId) {
        return this.categories.get().flatMap(map -> Optional.ofNullable((CategoryConfig)map.get(categoryId)));
    }

    private Collection<CategoryConfig> getAllCategories() {
        return this.categories.get().map(Map::values).orElseGet(Collections::emptyList);
    }

    private void updatePoints(CategoryConfig category, CategoryData categoryData) {
        categoryData.setPoints(PointSources.STARTING, category.general().startingPoints());
        category.experience().ifPresent(experience -> categoryData.setPoints(PointSources.EXPERIENCE, experience.curve().getProgress(categoryData.getExperience()).currentLevel()));
        int legacy = categoryData.getPoints(PointSources.LEGACY);
        if (legacy != 0) {
            categoryData.setPoints(PointSources.LEGACY, 0);
            categoryData.setPoints(PointSources.COMMANDS, legacy - category.general().startingPoints());
        }
    }

    private void updateCategory(class_3222 player, CategoryConfig category) {
        this.getCategoryDataIfUnlocked(player, category).ifPresentOrElse(categoryData -> this.showCategory(player, category, (CategoryData)categoryData), () -> this.hideCategory(player, category));
    }

    public void updateAllCategories(class_3222 player) {
        if (this.isConfigValid()) {
            Collection<CategoryConfig> categories = this.getAllCategories();
            if (categories.isEmpty()) {
                this.showToast(player, ToastType.MISSING_CONFIG);
            } else {
                for (CategoryConfig category : categories) {
                    this.updateCategory(player, category);
                }
            }
        } else {
            this.showToast(player, ToastType.INVALID_CONFIG);
        }
    }

    private void showToast(class_3222 player, ToastType type) {
        if (this.isOperatorOrHost(player)) {
            this.packetSender.send(player, new ShowToastOutPacket(type));
        }
    }

    public void openScreen(class_3222 player, Optional<class_2960> categoryId) {
        this.packetSender.send(player, new OpenScreenOutPacket(categoryId));
    }

    private boolean isConfigValid() {
        return this.categories.get().isPresent();
    }

    private PlayerData getPlayerData(class_3222 player) {
        return ServerData.getOrCreate(this.getPlayerServer(player)).getPlayerData(player);
    }

    private void putPlayerData(class_3222 player, PlayerData playerData) {
        ServerData.getOrCreate(this.getPlayerServer(player)).putPlayerData(player, playerData);
    }

    public MinecraftServer getPlayerServer(class_3222 player) {
        return player.field_13995;
    }

    private boolean isOperatorOrHost(class_3222 player) {
        MinecraftServer server = this.getPlayerServer(player);
        return server.method_19466(player.method_7334()) || server.method_3760().method_14569(player.method_7334());
    }

    private class EventListener
    implements ServerEventListener {
        private EventListener() {
        }

        @Override
        public void onServerStarting(MinecraftServer server) {
            SkillsMod.this.loadModConfig(server);
        }

        @Override
        public void onServerReload(MinecraftServer server) {
            for (class_3222 player : server.method_3760().method_14571()) {
                for (CategoryConfig category : SkillsMod.this.getAllCategories()) {
                    SkillsMod.this.hideCategory(player, category);
                }
            }
            SkillsMod.this.loadModConfig(server);
            for (class_3222 player : server.method_3760().method_14571()) {
                SkillsMod.this.updateAllCategories(player);
            }
        }

        @Override
        public void onPlayerJoin(class_3222 player) {
            PointsReward.cleanup(player);
            SkillsMod.this.updateAllCategories(player);
        }

        @Override
        public void onPlayerLeave(class_3222 player) {
            for (CategoryConfig category : SkillsMod.this.getAllCategories()) {
                SkillsMod.this.resetRewards(player, category);
            }
        }

        @Override
        public void onCommandsRegister(CommandDispatcher<class_2168> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"puffish_skills").then(CategoryCommand.create())).then(SkillsCommand.create())).then(PointsCommand.create())).then(ExperienceCommand.create())).then(OpenCommand.create()));
        }
    }
}

