/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import questsadditions.utils.BlockTypes;

public abstract class BlockInteractionTask
extends Task {
    protected static final class_2960 DEFAULT = new class_2960("minecraft:dirt");
    private class_2960 block = DEFAULT;
    private long value = 100L;
    private BlockTypes type = BlockTypes.BLOCK;

    public BlockInteractionTask(long id, Quest q) {
        super(id, q);
    }

    public BlockTypes getBlockType() {
        return this.type;
    }

    public class_2960 getBlock() {
        return this.block;
    }

    public boolean checkBlock(class_2248 block) {
        if (this.type == BlockTypes.BLOCK) {
            return this.block.equals((Object)RegistrarManager.getId((Object)block, (class_5321)class_7924.field_41254));
        }
        return block.method_40142().method_40220(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)this.block));
    }

    public class_2561 getBlockName() {
        if (this.type == BlockTypes.BLOCK) {
            return class_2561.method_43471((String)("block." + this.block.method_12836() + "." + this.block.method_12832()));
        }
        return class_2561.method_43470((String)this.block.toString());
    }

    public long getMaxProgress() {
        return this.value;
    }

    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10569("block_type", this.type.ordinal());
        nbt.method_10582("block", this.block.toString());
        nbt.method_10544("value", this.value);
    }

    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.type = BlockTypes.values()[nbt.method_10550("block_type")];
        this.block = new class_2960(nbt.method_10558("block"));
        this.value = nbt.method_10537("value");
    }

    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10817((Enum)this.type);
        buffer.method_10788(this.block.toString(), Short.MAX_VALUE);
        buffer.method_10791(this.value);
    }

    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.type = (BlockTypes)buffer.method_10818(BlockTypes.class);
        this.block = new class_2960(buffer.method_10800(Short.MAX_VALUE));
        this.value = buffer.method_10816();
    }

    @Environment(value=EnvType.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("block_type", (Object)this.type, v -> {
            this.type = v;
        }, BlockTypes.NAME_MAP).setNameKey("questsadditions.task.block_interaction_type");
        config.addString("block", this.block.toString(), v -> {
            this.block = new class_2960(v);
        }, "minecraft:dirt");
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 100L, 1L, Long.MAX_VALUE).setNameKey("questsadditions.task.count");
    }

    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        if (this.type == BlockTypes.BLOCK) {
            class_1792 item = ((class_2248)class_7923.field_41175.method_10223(this.block)).method_8389();
            return ItemIcon.getItemIcon((class_1792)(item != null ? item : (class_1792)FTBQuestsItems.MISSING_ITEM.get()));
        }
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (class_6880 block : class_7923.field_41175.method_40260(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)this.block))) {
            Icon icon = ItemIcon.getItemIcon((class_1799)new class_1799((class_1935)block.comp_349()));
            if (icon.isEmpty()) continue;
            icons.add(icon);
        }
        if (icons.isEmpty()) {
            return ItemIcon.getItemIcon((class_1792)((class_1792)FTBQuestsItems.MISSING_ITEM.get()));
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }
}

