/*
 * Decompiled with CFR 0.152.
 */
package atonkish.reinfbarrel;

import atonkish.reinfbarrel.api.ReinforcedBarrelsModInitializer;
import atonkish.reinfbarrel.api.ReinforcedBarrelsRegistry;
import atonkish.reinfbarrel.util.ReinforcingMaterialSettings;
import atonkish.reinfbarrel.world.poi.ModPointOfInterestTypes;
import atonkish.reinfcore.api.ReinforcedCoreModInitializer;
import atonkish.reinfcore.api.ReinforcedCoreRegistry;
import atonkish.reinfcore.util.ReinforcingMaterial;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReinforcedBarrelsMod
implements ReinforcedCoreModInitializer {
    public static final String MOD_ID = "reinfbarrel";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"reinfbarrel");

    public void onInitializeReinforcedCore() {
        ReinforcedBarrelsMod.initializeReinforcedCore();
        ReinforcedBarrelsMod.initializeReinforcedBarrels();
        FabricLoader.getInstance().getEntrypoints(MOD_ID, ReinforcedBarrelsModInitializer.class).forEach(ReinforcedBarrelsModInitializer::onInitializeReinforcedBarrels);
        ModPointOfInterestTypes.init();
    }

    private static void initializeReinforcedCore() {
        for (ReinforcingMaterialSettings materialSettings : ReinforcingMaterialSettings.values()) {
            ReinforcingMaterial material = materialSettings.getMaterial();
            ReinforcedCoreRegistry.registerMaterialSingleBlockScreenModel((ReinforcingMaterial)material);
            ReinforcedCoreRegistry.registerMaterialSingleBlockScreenHandler((ReinforcingMaterial)material);
        }
    }

    private static void initializeReinforcedBarrels() {
        for (ReinforcingMaterialSettings materialSettings : ReinforcingMaterialSettings.values()) {
            ReinforcingMaterial material = materialSettings.getMaterial();
            ReinforcedBarrelsRegistry.registerMaterialOpenStat(MOD_ID, material);
            ReinforcedBarrelsRegistry.registerMaterialBlock(MOD_ID, material, materialSettings.getBlockSettings());
            ReinforcedBarrelsRegistry.registerMaterialBlockEntityType(MOD_ID, material);
            ReinforcedBarrelsRegistry.registerMaterialItem(MOD_ID, material, materialSettings.getItemSettings());
        }
        if (!FabricLoader.getInstance().isModLoaded("reinfshulker") && !FabricLoader.getInstance().isModLoaded("reinfchest")) {
            ReinforcedBarrelsRegistry.registerMaterialItemGroupIcon(MOD_ID, ReinforcingMaterialSettings.NETHERITE.getMaterial());
        }
    }
}

