/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.blockentities;

import com.github.teamfusion.rottencreatures.common.registries.RCBlockEntityTypes;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class TreasureChestBlockEntity
extends class_2586 {
    private static final int MAX_ITEMS = 64;
    private final class_2371<class_1799> items = class_2371.method_10211();
    private int totalCount = 0;
    private UUID ownerUUID;
    public int maxStackSize = 64;

    public TreasureChestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(RCBlockEntityTypes.TREASURE_CHEST.get(), blockPos, blockState);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_2499 itemsList = new class_2499();
        for (class_1799 stack : this.items) {
            class_2487 itemTag = new class_2487();
            stack.method_7953(itemTag);
            itemsList.add((Object)itemTag);
        }
        tag.method_10566("Items", (class_2520)itemsList);
        tag.method_10569("ItemCount", this.totalCount);
        tag.method_10569("MaxStackSize", this.maxStackSize);
        if (this.ownerUUID != null) {
            tag.method_25927("Owner", this.ownerUUID);
        }
    }

    public void method_11014(class_2487 tag) {
        class_1799 stack;
        super.method_11014(tag);
        this.items.clear();
        this.totalCount = 0;
        if (tag.method_10573("Items", 9)) {
            class_2499 itemsList = tag.method_10554("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                class_2487 itemTag = itemsList.method_10602(i);
                class_1799 stack2 = class_1799.method_7915((class_2487)itemTag);
                if (stack2.method_7960()) continue;
                this.items.add((Object)stack2);
                this.totalCount += stack2.method_7947();
            }
        } else if (tag.method_10573("Item", 10) && !(stack = class_1799.method_7915((class_2487)tag.method_10562("Item"))).method_7960()) {
            this.items.add((Object)stack);
            this.totalCount = stack.method_7947();
        }
        this.maxStackSize = tag.method_10545("MaxStackSize") ? tag.method_10550("MaxStackSize") : (!this.items.isEmpty() ? Math.min(((class_1799)this.items.get(0)).method_7914(), 64) : 64);
        if (tag.method_25928("Owner")) {
            this.ownerUUID = tag.method_25926("Owner");
        }
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public boolean hasContents() {
        return !this.items.isEmpty() && this.totalCount != 0;
    }

    public class_2371<class_1799> addItemsWithReplacement(class_1799 stack, int count) {
        if (stack.method_7960() || count <= 0) {
            return class_2371.method_10211();
        }
        class_2371 replacedItems = class_2371.method_10211();
        int itemMaxStackSize = stack.method_7914();
        if (this.items.isEmpty()) {
            this.maxStackSize = itemMaxStackSize;
            this.addItem(stack, Math.min(count, this.maxStackSize));
            return replacedItems;
        }
        if (((class_1799)this.items.get(0)).method_7914() != itemMaxStackSize) {
            replacedItems.addAll(this.removeAllItems());
            this.maxStackSize = itemMaxStackSize;
            this.addItem(stack, Math.min(count, this.maxStackSize));
            return replacedItems;
        }
        int spaceLeft = this.maxStackSize - this.totalCount;
        int toAdd = Math.min(count, this.maxStackSize);
        if (spaceLeft >= toAdd) {
            for (int i = 0; i < this.items.size() && toAdd > 0; ++i) {
                int canAdd;
                class_1799 existingStack = (class_1799)this.items.get(i);
                if (!class_1799.method_31577((class_1799)existingStack, (class_1799)stack) || (canAdd = Math.min(toAdd, existingStack.method_7914() - existingStack.method_7947())) <= 0) continue;
                existingStack.method_7933(canAdd);
                toAdd -= canAdd;
                this.totalCount += canAdd;
                this.method_5431();
            }
            if (toAdd > 0) {
                this.addItem(stack, toAdd);
            }
        } else {
            int itemsReplaced = 0;
            int remainingToAdd = toAdd;
            for (int i = 0; i < this.items.size() && itemsReplaced < toAdd && remainingToAdd > 0; ++i) {
                class_1799 oldStack = (class_1799)this.items.get(i);
                if (class_1799.method_31577((class_1799)oldStack, (class_1799)stack)) continue;
                int toRemove = Math.min(oldStack.method_7947(), remainingToAdd);
                if (toRemove == oldStack.method_7947()) {
                    replacedStack = oldStack.method_7972();
                    this.items.remove(i);
                    --i;
                    replacedItems.add((Object)replacedStack);
                    this.totalCount -= toRemove;
                } else {
                    replacedStack = oldStack.method_7972();
                    replacedStack.method_7939(toRemove);
                    replacedItems.add((Object)replacedStack);
                    oldStack.method_7934(toRemove);
                    this.totalCount -= toRemove;
                }
                itemsReplaced += toRemove;
                remainingToAdd -= toRemove;
            }
            if (remainingToAdd > 0) {
                while (this.totalCount + remainingToAdd > this.maxStackSize && !this.items.isEmpty()) {
                    class_1799 oldStack = (class_1799)this.items.get(0);
                    int toRemove = Math.min(oldStack.method_7947(), this.totalCount + remainingToAdd - this.maxStackSize);
                    if (toRemove == oldStack.method_7947()) {
                        this.items.remove(0);
                        replacedItems.add((Object)oldStack);
                        this.totalCount -= toRemove;
                    } else {
                        class_1799 replacedStack = oldStack.method_7972();
                        replacedStack.method_7939(toRemove);
                        replacedItems.add((Object)replacedStack);
                        oldStack.method_7934(toRemove);
                        this.totalCount -= toRemove;
                    }
                    itemsReplaced += toRemove;
                    remainingToAdd -= toRemove;
                }
            }
            remainingToAdd = toAdd;
            for (int i = 0; i < this.items.size() && remainingToAdd > 0; ++i) {
                int canAdd;
                class_1799 existingStack = (class_1799)this.items.get(i);
                if (!class_1799.method_31577((class_1799)existingStack, (class_1799)stack) || (canAdd = Math.min(remainingToAdd, existingStack.method_7914() - existingStack.method_7947())) <= 0) continue;
                existingStack.method_7933(canAdd);
                remainingToAdd -= canAdd;
                this.totalCount += canAdd;
                this.method_5431();
            }
            if (remainingToAdd > 0) {
                this.addItem(stack, remainingToAdd);
            }
        }
        this.items.removeIf(class_1799::method_7960);
        return replacedItems;
    }

    private void addItem(class_1799 stack, int count) {
        int stackSize;
        int itemMaxStackSize = stack.method_7914();
        for (int toAdd = count; toAdd > 0; toAdd -= stackSize) {
            class_1799 newStack = stack.method_7972();
            stackSize = Math.min(toAdd, itemMaxStackSize);
            newStack.method_7939(stackSize);
            this.items.add((Object)newStack);
            this.totalCount += stackSize;
        }
        this.method_5431();
    }

    public class_2371<class_1799> removeAllItems() {
        class_2371 result = class_2371.method_10211();
        result.addAll(this.items);
        this.items.clear();
        this.totalCount = 0;
        this.maxStackSize = 64;
        this.method_5431();
        return result;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
        this.method_5431();
    }

    public boolean isOwner(UUID playerUUID) {
        return this.ownerUUID != null && this.ownerUUID.equals(playerUUID);
    }
}

