/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful;

import com.github.thedeathlycow.scorchful.block.NetherLilyBehaviours;
import com.github.thedeathlycow.scorchful.block.SandCauldronBehaviours;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.enchantment.RehydrationEnchantment;
import com.github.thedeathlycow.scorchful.event.ScorchfulLivingEntityEvents;
import com.github.thedeathlycow.scorchful.item.FireChargeThrower;
import com.github.thedeathlycow.scorchful.item.HeatResistantArmourTagApplicator;
import com.github.thedeathlycow.scorchful.registry.SBlocks;
import com.github.thedeathlycow.scorchful.registry.SEnchantments;
import com.github.thedeathlycow.scorchful.registry.SItemGroups;
import com.github.thedeathlycow.scorchful.registry.SItems;
import com.github.thedeathlycow.scorchful.registry.SParticleTypes;
import com.github.thedeathlycow.scorchful.registry.SSoundEvents;
import com.github.thedeathlycow.scorchful.registry.SStats;
import com.github.thedeathlycow.scorchful.registry.SStatusEffects;
import com.github.thedeathlycow.scorchful.registry.STemperatureEffects;
import com.github.thedeathlycow.scorchful.server.ThirstCommand;
import com.github.thedeathlycow.scorchful.temperature.AmbientTemperatureController;
import com.github.thedeathlycow.scorchful.temperature.AttributeController;
import com.github.thedeathlycow.scorchful.temperature.WetTickController;
import com.github.thedeathlycow.scorchful.worldgen.NetherBiomeModifications;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingMode;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentControllerInitializeEvent;
import com.github.thedeathlycow.thermoo.api.temperature.event.PlayerEnvironmentEvents;
import com.mojang.brigadier.CommandDispatcher;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scorchful
implements ModInitializer {
    public static final String MODID = "scorchful";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"scorchful");
    public static final int CONFIG_VERSION = 4;
    private static ConfigHolder<ScorchfulConfig> configHolder;

    @Contract(value="_->new")
    public static class_2960 id(String path) {
        return new class_2960(MODID, path);
    }

    public void onInitialize() {
        AutoConfig.register(ScorchfulConfig.class, GsonConfigSerializer::new);
        configHolder = AutoConfig.getConfigHolder(ScorchfulConfig.class);
        ScorchfulConfig.updateConfig(configHolder);
        SBlocks.registerBlocks();
        SItems.registerItems();
        SItemGroups.registerAll();
        SSoundEvents.registerAll();
        STemperatureEffects.registerAll();
        SEnchantments.registerAll();
        SStatusEffects.registerAll();
        RehydrationEnchantment.addToNetherLoot();
        SParticleTypes.registerAll();
        NetherBiomeModifications.placeFeaturesInBiomes();
        SStats.registerAll();
        SandCauldronBehaviours.registerAll();
        NetherLilyBehaviours.registerBehaviours();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ThirstCommand.register((CommandDispatcher<class_2168>)dispatcher));
        UseItemCallback.EVENT.register((Object)new FireChargeThrower());
        ModifyItemAttributeModifiersCallback.EVENT.register((Object)new HeatResistantArmourTagApplicator());
        ScorchfulLivingEntityEvents.ON_DAMAGED.register((entity, source, amount) -> {
            if (source.method_49708(class_8111.field_42325) || source.method_49708(class_8111.field_42326)) {
                entity.thermoo$addTemperature(Scorchful.getConfig().heatingConfig.getFireballHeat(), (HeatingMode)HeatingModes.ACTIVE);
            }
        });
        this.registerThermooEventListeners();
        LOGGER.info("Scorchful initialized!");
    }

    public static ScorchfulConfig getConfig() {
        return (ScorchfulConfig)configHolder.getConfig();
    }

    private void registerThermooEventListeners() {
        PlayerEnvironmentEvents.CAN_APPLY_PASSIVE_TEMPERATURE_CHANGE.register((change, player) -> {
            if (change < 0) {
                return true;
            }
            ScorchfulConfig config = Scorchful.getConfig();
            int tickInterval = config.heatingConfig.getPassiveHeatingTickInterval();
            if (tickInterval > 1 && player.field_6012 % tickInterval != 0) {
                return false;
            }
            if (!config.heatingConfig.doPassiveHeating()) {
                return false;
            }
            return player.thermoo$getTemperatureScale() < config.heatingConfig.getMaxPassiveHeatingScale();
        });
        EnvironmentControllerInitializeEvent.EVENT.register(AttributeController::new);
        EnvironmentControllerInitializeEvent.EVENT.register(AmbientTemperatureController::new);
        EnvironmentControllerInitializeEvent.EVENT.register(WetTickController::new);
    }
}

