/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.block;

import com.github.thedeathlycow.scorchful.block.SandCauldronBehaviours;
import com.github.thedeathlycow.scorchful.server.Sandstorms;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5712;

public class SandCauldronBlock
extends class_5556 {
    public static final Predicate<Sandstorms.SandstormType> REGULAR_SANDSTORM_PREDICATE = sandstorm -> sandstorm == Sandstorms.SandstormType.REGULAR;
    public static final Predicate<Sandstorms.SandstormType> RED_SANDSTORM_PREDICATE = sandstorm -> sandstorm == Sandstorms.SandstormType.RED;
    private static final float FILL_WITH_SAND_CHANCE = 0.1f;
    private final Predicate<Sandstorms.SandstormType> sandstormPredicate;
    private final class_5620 filledInteraction;

    public SandCauldronBlock(class_4970.class_2251 settings, Predicate<Sandstorms.SandstormType> sandstormPredicate, class_5620 filledInteraction) {
        super(settings, precipitation -> false, SandCauldronBehaviours.NO_CAULDRON_BEHAVIOURS);
        this.sandstormPredicate = sandstormPredicate;
        this.filledInteraction = filledInteraction;
    }

    public static boolean canFillWithSand(class_1937 world, Sandstorms.SandstormType sandstormType) {
        return switch (sandstormType) {
            case Sandstorms.SandstormType.RED, Sandstorms.SandstormType.REGULAR -> {
                if (world.method_8409().method_43057() < 0.1f) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        Sandstorms.SandstormType type = Sandstorms.getCurrentSandStorm(world, pos.method_10084());
        if (!this.sandstormPredicate.test(type) || !SandCauldronBlock.canFillWithSand(world, type) || (Integer)state.method_11654((class_2769)field_27206) == 3) {
            return;
        }
        class_2680 filled = (class_2680)state.method_28493((class_2769)field_27206);
        world.method_8501(pos, filled);
        world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)filled));
    }

    public class_1792 method_8389() {
        return class_1802.field_8638;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (this.method_32766(state)) {
            return this.filledInteraction.interact(state, world, pos, player, hand, player.method_5998(hand));
        }
        return class_1269.field_5811;
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
    }

    protected boolean method_32765(class_3611 fluid) {
        return false;
    }
}

