/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.client;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.registry.SSoundEvents;
import com.github.thedeathlycow.scorchful.server.Sandstorms;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4184;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class SandstormSounds {
    public static final SandstormSounds INSTANCE = new SandstormSounds();
    private static final int MAX_SOUND_Y_DIFF = 10;
    private static final int MAX_XZ_OFFSET = 10;
    private int timer = 0;

    public void tick(class_638 world) {
        if (!Scorchful.getConfig().clientConfig.isSandstormSoundsEnabled()) {
            return;
        }
        class_310 gameClient = class_310.method_1551();
        class_4184 camera = gameClient.field_1773.method_19418();
        if (camera == null) {
            return;
        }
        if (!world.method_8419()) {
            return;
        }
        if (world.field_9229.method_43048(3) >= this.timer) {
            ++this.timer;
            return;
        }
        this.timer = 0;
        this.chooseSpotForWindSound(world, camera).ifPresent(pos -> world.method_45446(pos, SSoundEvents.WEATHER_SANDSTORM, class_3419.field_15252, 0.1f, 0.5f, false));
    }

    private Optional<class_2338> chooseSpotForWindSound(class_638 world, class_4184 camera) {
        class_2338 cameraPos = camera.method_19328();
        int dx = world.field_9229.method_39332(-10, 10);
        int dz = world.field_9229.method_39332(-10, 10);
        class_2338 soundPos = cameraPos.method_10069(dx, 0, dz);
        class_2338 topPos = world.method_8598(class_2902.class_2903.field_13197, soundPos);
        if (Math.abs(cameraPos.method_10264() - topPos.method_10264()) <= 10 && Sandstorms.isSandStorming((class_1937)world, topPos)) {
            return Optional.of(topPos);
        }
        return Optional.empty();
    }

    private SandstormSounds() {
    }
}

