/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.components;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.compat.ScorchfulIntegrations;
import com.github.thedeathlycow.scorchful.config.DehydrationConfig;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.registry.SSoundEvents;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import net.dehydration.access.ThirstManagerAccess;
import net.dehydration.thirst.ThirstManager;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class PlayerComponent
implements Component,
ServerTickingComponent {
    public static final int MAX_WATER = 300;
    private static final String WATER_KEY = "body_water";
    private static final String REHYDRATION_DRINK_KEY = "rehydration_drink";
    private final class_1657 provider;
    private int waterDrunk = 0;
    private int rehydrationDrink = 0;

    public PlayerComponent(class_1657 provider) {
        this.provider = provider;
    }

    public int getWaterDrunk() {
        return this.waterDrunk;
    }

    public void drink(int amount) {
        this.waterDrunk = class_3532.method_15340((int)(this.waterDrunk + amount), (int)0, (int)300);
    }

    public void readFromNbt(class_2487 tag) {
        if (tag.method_10573(WATER_KEY, 3)) {
            this.waterDrunk = tag.method_10550(WATER_KEY);
        }
        if (tag.method_10573(REHYDRATION_DRINK_KEY, 3)) {
            this.rehydrationDrink = tag.method_10550(REHYDRATION_DRINK_KEY);
        }
    }

    public void writeToNbt(class_2487 tag) {
        if (this.waterDrunk > 0) {
            tag.method_10569(WATER_KEY, this.waterDrunk);
        }
        if (this.rehydrationDrink > 0) {
            tag.method_10569(REHYDRATION_DRINK_KEY, this.rehydrationDrink);
        }
    }

    public void serverTick() {
        if (!this.provider.thermoo$isCold()) {
            this.tickWater(this.provider);
        }
    }

    private void tickWater(class_1657 player) {
        ScorchfulConfig config = Scorchful.getConfig();
        if (ScorchfulIntegrations.isDehydrationLoaded()) {
            this.tickSweatDehydration(config.integrationConfig.dehydrationConfig, player);
        } else {
            this.tickSweatNormal(player);
        }
    }

    private void tickSweatNormal(class_1657 player) {
        if (this.waterDrunk > 0 && player.thermoo$getTemperature() > 0) {
            --this.waterDrunk;
            player.thermoo$addWetTicks(2);
        }
    }

    private void tickSweatDehydration(DehydrationConfig config, class_1657 player) {
        ThirstManager thirstManager = ((ThirstManagerAccess)player).getThirstManager();
        if (thirstManager.getThirstLevel() > config.getMinWaterLevelForSweat() && player.thermoo$getTemperature() > 0) {
            thirstManager.addDehydration(config.getDehydrationConsumedBySweat());
            player.thermoo$addWetTicks(2);
        }
    }

    public void tickRehydrationWaterRecapture(ScorchfulConfig config, boolean dehydrationLoaded) {
        int rehydrationCapacity = config.getRehydrationDrinkSize(dehydrationLoaded);
        this.rehydrationDrink = Math.min(this.rehydrationDrink + 1, rehydrationCapacity);
    }

    public void tickRehydration(ScorchfulConfig config, int rehydrationLevel, boolean dehydrationLoaded) {
        int rehydrationCapacity = config.getRehydrationDrinkSize(dehydrationLoaded);
        if (this.rehydrationDrink >= rehydrationCapacity) {
            if (dehydrationLoaded) {
                this.rehydrateWithDehydration(config, rehydrationLevel);
            } else {
                this.rehydrate(config, rehydrationLevel);
            }
        }
    }

    public void resetRehydration() {
        this.rehydrationDrink = 0;
    }

    private void rehydrate(ScorchfulConfig config, int rehydrationLevel) {
        class_1937 class_19372;
        if (this.waterDrunk > 1) {
            return;
        }
        float efficiency = PlayerComponent.getRehydrationEfficiency(rehydrationLevel, 0.0f, config.thirstConfig.getMaxRehydrationEfficiency());
        int drinkToAdd = class_3532.method_15375((float)((float)this.rehydrationDrink * efficiency));
        if (drinkToAdd > 0 && (class_19372 = this.provider.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.drink(drinkToAdd);
            this.playRehydrationEffects(serverWorld);
            this.resetRehydration();
        }
    }

    private void rehydrateWithDehydration(ScorchfulConfig config, int rehydrationLevel) {
        ThirstManager thirstManager = ((ThirstManagerAccess)this.provider).getThirstManager();
        DehydrationConfig dehydrationConfig = config.integrationConfig.dehydrationConfig;
        if (thirstManager.getThirstLevel() > dehydrationConfig.getMinWaterLevelForSweat()) {
            return;
        }
        int waterToAdd = this.provider.method_6051().method_39332(0, rehydrationLevel * dehydrationConfig.getMaxRehydrationWaterAddedPerLevel());
        class_1937 class_19372 = this.provider.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            thirstManager.add(waterToAdd);
            this.playRehydrationEffects(serverWorld);
            this.resetRehydration();
        }
    }

    private void playRehydrationEffects(class_3218 serverWorld) {
        class_243 pos = this.provider.method_19538();
        if (!this.provider.method_5701() && !this.provider.method_5715()) {
            serverWorld.method_45447(null, this.provider.method_24515(), SSoundEvents.REHYDRATE, this.provider.method_5634());
        }
        if (!this.provider.method_5767()) {
            float height = this.provider.method_17682();
            float width = this.provider.method_17681();
            serverWorld.method_14199((class_2394)class_2398.field_11241, pos.field_1352, pos.field_1351, pos.field_1350, 50, (double)width, (double)height, (double)width, (double)0.001f);
        }
    }

    private static float getRehydrationEfficiency(int rehydrationLevel, float min, float max) {
        return class_3532.method_16439((float)((float)rehydrationLevel / 4.0f), (float)min, (float)max);
    }
}

