/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.item;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.compat.ScorchfulIntegrations;
import com.github.thedeathlycow.scorchful.components.PlayerComponent;
import com.github.thedeathlycow.scorchful.components.ScorchfulComponents;
import com.github.thedeathlycow.scorchful.config.ThirstConfig;
import com.github.thedeathlycow.scorchful.item.WaterSkinItem;
import com.github.thedeathlycow.scorchful.registry.SSoundEvents;
import com.github.thedeathlycow.scorchful.registry.tag.SItemTags;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class QuenchingFoods {
    public static void appendTooltip(class_1799 stack, List<class_2561> tooltip) {
        QuenchingFoods.appendTooltip(stack, tooltip, QuenchingLevel.forItem(stack));
    }

    public static void appendTooltip(class_1799 stack, List<class_2561> tooltip, @Nullable QuenchingLevel level) {
        if (level != null && !ScorchfulIntegrations.isDehydrationLoaded()) {
            tooltip.add(level.tooltipText);
        }
    }

    public static void onConsume(class_1309 user, class_1799 stack) {
        QuenchingFoods.onConsume(user, stack, QuenchingLevel.forItem(stack));
    }

    public static void onConsume(class_1309 user, class_1799 stack, @Nullable QuenchingLevel level) {
        if (ScorchfulIntegrations.isDehydrationLoaded()) {
            return;
        }
        if (level != null && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            PlayerComponent component = (PlayerComponent)ScorchfulComponents.PLAYER.get((Object)player);
            component.drink(level.waterProvider.applyAsInt(Scorchful.getConfig().thirstConfig));
            if (component.getWaterDrunk() >= 275) {
                player.method_17356(SSoundEvents.ENTITY_GULP, player.method_5634(), 1.0f, 1.0f);
            }
        }
    }

    private QuenchingFoods() {
    }

    public static enum QuenchingLevel {
        PARCHING(SItemTags.IS_PARCHING, (class_2561)class_2561.method_43471((String)"item.scorchful.tooltip.parching").method_10862(WaterSkinItem.PARCHING_STYLE), ThirstConfig::getWaterFromParchingFood),
        REFRESHING(SItemTags.IS_REFRESHING, (class_2561)class_2561.method_43471((String)"item.scorchful.tooltip.refreshing").method_10862(WaterSkinItem.TOOLTIP_STYLE), ThirstConfig::getWaterFromRefreshingFood),
        SUSTAINING(SItemTags.IS_SUSTAINING, (class_2561)class_2561.method_43471((String)"item.scorchful.tooltip.sustaining").method_10862(WaterSkinItem.TOOLTIP_STYLE), ThirstConfig::getWaterFromSustainingFood),
        HYDRATING(SItemTags.IS_HYDRATING, (class_2561)class_2561.method_43471((String)"item.scorchful.tooltip.hydrating").method_10862(WaterSkinItem.TOOLTIP_STYLE), ThirstConfig::getWaterFromHydratingFood);

        public final class_6862<class_1792> tag;
        public final class_2561 tooltipText;
        public final ToIntFunction<ThirstConfig> waterProvider;

        private QuenchingLevel(class_6862<class_1792> tag, class_2561 tooltipText, ToIntFunction<ThirstConfig> waterProvider) {
            this.tag = tag;
            this.tooltipText = tooltipText;
            this.waterProvider = waterProvider;
        }

        @Nullable
        public static QuenchingLevel forItem(class_1799 stack) {
            for (QuenchingLevel level : QuenchingLevel.values()) {
                if (!stack.method_31573(level.tag)) continue;
                return level;
            }
            return null;
        }
    }
}

