/*
 * Decompiled with CFR 0.152.
 */
package com.github.galatynf.sihywtcamd.mixin.enderdragon;

import com.github.galatynf.sihywtcamd.cardinal.MyComponents;
import com.github.galatynf.sihywtcamd.cardinal.api.EnderDragonEntityComponentAPI;
import com.github.galatynf.sihywtcamd.config.ModConfig;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1510;
import net.minecraft.class_1511;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3218;
import net.minecraft.class_3310;
import net.minecraft.class_3666;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1510.class})
public class EnderDragonMixin
extends class_1308 {
    protected EnderDragonMixin(class_1299<? extends class_1308> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"tickWithEndCrystals"}, at={@At(value="HEAD")})
    private void resummonSomeCrystals(CallbackInfo ci) {
        int crystalsToSummon = ModConfig.get().bosses.enderDragon.crystalsToSummon;
        int summonedCrystals = ((EnderDragonEntityComponentAPI)MyComponents.ENDER_DRAGON_COMPONENT.get((Object)this)).getNumberOfSummonedCrystals();
        if (!this.method_37908().method_8608() && crystalsToSummon > 0 && summonedCrystals < crystalsToSummon) {
            class_3218 world = (class_3218)this.method_37908();
            float healthRatio = (float)(crystalsToSummon - summonedCrystals) / (float)(crystalsToSummon + 1);
            if (this.method_6032() < healthRatio * this.method_6063()) {
                ((EnderDragonEntityComponentAPI)MyComponents.ENDER_DRAGON_COMPONENT.get((Object)this)).incrementNumberOfSummonedCrystals();
                class_3310.class_3181 spike = this.getSpikeWithoutCrystal(world);
                if (spike == null) {
                    return;
                }
                for (class_2338 blockPos : class_2338.method_10097((class_2338)new class_2338(spike.method_13966() - 10, spike.method_13964() - 10, spike.method_13967() - 10), (class_2338)new class_2338(spike.method_13966() + 10, spike.method_13964() + 10, spike.method_13967() + 10))) {
                    world.method_8650(blockPos, false);
                }
                world.method_8437(null, (double)spike.method_13966() + 0.5, (double)spike.method_13964(), (double)spike.method_13967() + 0.5, 5.0f, class_1937.class_7867.field_40889);
                class_3666 endSpikeFeatureConfig = new class_3666(false, (List)ImmutableList.of((Object)spike), null);
                class_3031.field_13522.method_40163((class_3037)endSpikeFeatureConfig, (class_5281)world, world.method_14178().method_12129(), class_5819.method_43047(), new class_2338(spike.method_13966(), 45, spike.method_13967()));
            }
        }
    }

    @Unique
    private class_3310.class_3181 getSpikeWithoutCrystal(class_3218 world) {
        List spikes = class_3310.method_14506((class_5281)world);
        if (spikes.isEmpty()) {
            return null;
        }
        int random = this.field_5974.method_43048(spikes.size());
        for (int i = 0; i < spikes.size(); ++i) {
            class_3310.class_3181 spike = (class_3310.class_3181)spikes.get((random + i) % spikes.size());
            if (!world.method_18467(class_1511.class, spike.method_13968()).isEmpty()) continue;
            return spike;
        }
        return null;
    }
}

