/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumextras.foundation.fps;

import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import toni.sodiumextras.EmbyConfig;
import toni.sodiumextras.EmbyTools;
import toni.sodiumextras.SodiumExtras;
import toni.sodiumextras.foundation.fps.FPSDisplay;
import toni.sodiumextras.foundation.fps.FpsHistory;
import toni.sodiumextras.foundation.fps.accessors.IUsageGPU;

public class DebugOverlayEvent {
    private static final FPSDisplay DISPLAY = new FPSDisplay();
    private static final class_2561 MSG_FPS = class_2561.method_43471((String)"sodium.extras.options.displayfps.fps");
    private static final class_2561 MSG_MIN = class_2561.method_43471((String)"sodium.extras.options.displayfps.min");
    private static final class_2561 MSG_AVG = class_2561.method_43471((String)"sodium.extras.options.displayfps.avg");
    private static final class_2561 MSG_GPU = class_2561.method_43471((String)"sodium.extras.options.displayfps.gpu");
    private static final class_2561 MSG_MEM = class_2561.method_43471((String)"sodium.extras.options.displayfps.mem");
    private static final AverageQueue AVERAGE = new AverageQueue();
    private static int fps = -1;
    private static int minFPS = -1;
    private static int lastAvgFps = -1;
    private static int avgFPS = -1;
    private static int gpuPercent = -1;
    private static int memUsage = -1;

    public static void renderFPSChar(class_310 mc, class_332 graphics) {
        if (mc.field_1690.field_1866 || mc.field_1690.field_1893) {
            return;
        }
        class_327 font = mc.field_1772;
        Integer scale = (Integer)mc.field_1690.method_42474().method_41753();
        EmbyConfig.FPSDisplayMode mode = (EmbyConfig.FPSDisplayMode)((Object)EmbyConfig.fpsDisplayMode.get());
        EmbyConfig.FPSDisplaySystemMode systemMode = (EmbyConfig.FPSDisplaySystemMode)((Object)EmbyConfig.fpsDisplaySystemMode.get());
        if (mode.off() && systemMode.off()) {
            return;
        }
        DISPLAY.release();
        switch (mode) {
            case SIMPLE: {
                DISPLAY.append(DebugOverlayEvent.calculateFPS$getColor(mc)).add(DebugOverlayEvent.fix(fps)).add(" ").add(MSG_FPS.getString()).add(class_124.field_1070);
                break;
            }
            case ADVANCED: {
                DISPLAY.append(DebugOverlayEvent.calculateFPS$getColor(mc)).add(DebugOverlayEvent.fix(fps)).add(class_124.field_1070);
                DISPLAY.append(DebugOverlayEvent.calculateMinFPS$getColor(mc)).add(MSG_MIN).add(" ").add(DebugOverlayEvent.fix(minFPS)).add(class_124.field_1070);
                DISPLAY.append(DebugOverlayEvent.calculateAvgFPS$getColor(mc)).add(MSG_AVG).add(" ").add(DebugOverlayEvent.fix(avgFPS)).add(class_124.field_1070);
            }
        }
        if (!DISPLAY.isEmpty()) {
            DISPLAY.split();
        }
        switch (systemMode) {
            case GPU: {
                DISPLAY.append(DebugOverlayEvent.calculateGPUPercent$getColor(mc)).add(MSG_GPU).add(" ").add(DebugOverlayEvent.fix(gpuPercent)).add("%").add(class_124.field_1070);
                break;
            }
            case RAM: {
                DISPLAY.append(DebugOverlayEvent.calculateMemPercent$getColor()).add(MSG_MEM).add(" ").add(DebugOverlayEvent.fix(memUsage)).add("%").add(class_124.field_1070);
                break;
            }
            case ON: {
                DISPLAY.append(DebugOverlayEvent.calculateGPUPercent$getColor(mc)).add(MSG_GPU).add(" ").add(DebugOverlayEvent.fix(gpuPercent)).add("%").add(class_124.field_1070);
                DISPLAY.append(DebugOverlayEvent.calculateMemPercent$getColor()).add(MSG_MEM).add(" ").add(DebugOverlayEvent.fix(memUsage)).add("%").add(class_124.field_1070);
            }
        }
        if (DISPLAY.isEmpty()) {
            DISPLAY.add("FATAL ERROR");
        }
        float margin = scale > 0 ? (float)EmbyConfig.fpsDisplayMarginCache / (float)scale.intValue() : (float)EmbyConfig.fpsDisplayMarginCache;
        String displayString = DISPLAY.toString();
        float maxPosX = graphics.method_51421() - font.method_1727(displayString);
        float posX = switch ((EmbyConfig.FPSDisplayGravity)((Object)EmbyConfig.fpsDisplayGravity.get())) {
            default -> throw new IncompatibleClassChangeError();
            case EmbyConfig.FPSDisplayGravity.LEFT -> margin;
            case EmbyConfig.FPSDisplayGravity.CENTER -> maxPosX / 2.0f;
            case EmbyConfig.FPSDisplayGravity.RIGHT -> maxPosX - margin;
        };
        float posY = margin;
        graphics.method_51448().method_22903();
        if (EmbyConfig.fpsDisplayShadowCache) {
            int n = (int)posX - 2;
            int n2 = (int)posY - 2;
            int n3 = (int)posX + font.method_1727(displayString) + 2;
            Objects.requireNonNull(font);
            graphics.method_25294(n, n2, n3, (int)(posY + 9.0f) + 1, -1873784752);
            graphics.method_51452();
        }
        graphics.method_51433(font, displayString, (int)posX, (int)posY, -1, true);
        DISPLAY.release();
        graphics.method_51448().method_22909();
    }

    private static class_124 calculateFPS$getColor(class_310 mc) {
        fps = mc.method_47599();
        return EmbyTools.colorByLow(fps);
    }

    private static class_124 calculateMinFPS$getColor(class_310 mc) {
        int min;
        FpsHistory history = SodiumExtras.fpsHistory;
        minFPS = min = history.getMinimum();
        return EmbyTools.colorByLow(minFPS);
    }

    private static class_124 calculateAvgFPS$getColor(class_310 mc) {
        if (mc.method_47599() != lastAvgFps) {
            lastAvgFps = mc.method_47599();
            AVERAGE.push(lastAvgFps);
            avgFPS = AVERAGE.calculate();
        }
        return EmbyTools.colorByLow(avgFPS);
    }

    private static class_124 calculateGPUPercent$getColor(class_310 mc) {
        int value = (int)((IUsageGPU)mc).embPlus$getSyncGpu();
        gpuPercent = value > 0 ? Math.min(value, 100) : -1;
        return EmbyTools.colorByPercent(gpuPercent);
    }

    private static class_124 calculateMemPercent$getColor() {
        memUsage = (int)(EmbyTools.ramUsed() * 100L / Runtime.getRuntime().maxMemory());
        return EmbyTools.colorByPercent(memUsage);
    }

    private static String fix(int value) {
        return value == -1 ? "--" : "" + value;
    }

    public static class AverageQueue {
        private final int[] QUEUE = new int[14];
        private int used = 0;

        void push(int value) {
            if (this.used == this.QUEUE.length) {
                this.used = 0;
            }
            this.QUEUE[this.used] = value;
            ++this.used;
        }

        int calculate() {
            int times = 0;
            for (int i = 0; i < this.used; ++i) {
                times += this.QUEUE[i];
            }
            return times / this.used;
        }
    }
}

