/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumoptionsapi.gui;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import toni.sodiumoptionsapi.SodiumOptionsAPI;
import toni.sodiumoptionsapi.mixin.sodium.FlatButtonWidgetAccessor;
import toni.sodiumoptionsapi.util.ILeftAlignOffsetAccessor;

public class TabHeaderWidget
extends FlatButtonWidget {
    private static final class_2960 FALLBACK_LOCATION = new class_2960("textures/misc/unknown_pack.png");
    private static final Set<String> erroredLogos = new HashSet<String>();
    private final class_2960 logoTexture;
    private final boolean isTitle;

    public static class_5250 getLabel(String modId, boolean underline) {
        return (switch (modId) {
            case "sspb" -> class_2561.method_43470((String)"SSPB");
            default -> TabHeaderWidget.idComponent(modId);
        }).method_27694(s -> s.method_30938(Boolean.valueOf(underline)));
    }

    static class_5250 idComponent(String namespace) {
        return class_2561.method_43470((String)TabHeaderWidget.getModName(namespace));
    }

    public static String getModName(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(container -> container.getMetadata().getName()).orElse(modId);
    }

    public TabHeaderWidget(Dim2i dim, String modId, Runnable action) {
        super(dim, (class_2561)TabHeaderWidget.getLabel(modId, action == null), action == null ? () -> {} : action);
        this.isTitle = action == null;
        Optional logoFile = erroredLogos.contains(modId) ? Optional.empty() : FabricLoader.getInstance().getModContainer(modId).flatMap(c -> c.getMetadata().getIconPath(32).flatMap(arg_0 -> ((ModContainer)c).findPath(arg_0)));
        class_2960 texture = null;
        if (logoFile.isPresent()) {
            try (InputStream is = Files.newInputStream((Path)logoFile.get(), new OpenOption[0]);){
                if (is != null) {
                    class_1011 logo = class_1011.method_4309((InputStream)is);
                    if (logo.method_4307() != logo.method_4323()) {
                        logo.close();
                        throw new IOException("Logo " + String.valueOf(logoFile.get()) + " for " + modId + " is not square");
                    }
                    texture = new class_2960("sodium", "logo/" + modId);
                    class_310.method_1551().method_1531().method_4616(texture, (class_1044)new class_1043(logo));
                }
            }
            catch (IOException e) {
                erroredLogos.add(modId);
                SodiumOptionsAPI.LOGGER.error("Exception reading logo for " + modId, (Throwable)e);
            }
        }
        this.setStyle(this.getStyle());
        this.logoTexture = texture;
    }

    public FlatButtonWidget.Style getStyle() {
        FlatButtonWidget.Style style = new FlatButtonWidget.Style();
        style.bgHovered = this.isTitle ? ColorARGB.pack((int)0, (int)0, (int)0, (int)140) : -536870912;
        style.bgDefault = ColorARGB.pack((int)0, (int)0, (int)0, (int)140);
        style.bgDisabled = 0x60000000;
        style.textDefault = -1;
        style.textDisabled = -1862270977;
        return style;
    }

    protected boolean isHovered(int mouseX, int mouseY) {
        return false;
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        ((ILeftAlignOffsetAccessor)((Object)this)).sodiumOptionsAPI$setLeftAlignOffset(20);
        super.method_25394(drawContext, mouseX, mouseY, delta);
        Dim2i dim = ((FlatButtonWidgetAccessor)((Object)this)).getDim();
        class_2960 icon = Objects.requireNonNullElse(this.logoTexture, FALLBACK_LOCATION);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int fontHeight = 9;
        int imgY = ((FlatButtonWidgetAccessor)((Object)this)).getDim().getCenterY() - fontHeight / 2;
        drawContext.method_25290(icon, ((FlatButtonWidgetAccessor)((Object)this)).getDim().x() + 5, imgY, 0.0f, 0.0f, fontHeight, fontHeight, fontHeight, fontHeight);
    }
}

