/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1366;
import net.minecraft.class_1669;
import net.minecraft.class_1676;
import net.minecraft.class_1687;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.DayStalker;
import net.soulsweaponry.entity.mobs.Forlorn;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entity.mobs.SoulReaperGhost;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.entity.projectile.NightSkull;
import net.soulsweaponry.entity.projectile.NightsEdge;
import net.soulsweaponry.entity.projectile.NoDragWitherSkull;
import net.soulsweaponry.entity.projectile.noclip.BlackflameExplosionEntity;
import net.soulsweaponry.entity.projectile.noclip.BlackflameSnakeEntity;
import net.soulsweaponry.entity.projectile.noclip.FogEntity;
import net.soulsweaponry.entity.projectile.noclip.NightWaveEntity;
import net.soulsweaponry.entity.projectile.noclip.NoClipEntity;
import net.soulsweaponry.entity.util.BlackflameSnakeUtil;
import net.soulsweaponry.entity.util.DeathSpiralLogic;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.WeaponUtil;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class NightProwlerGoal
extends class_1366 {
    private final NightProwler boss;
    private int attackCooldown;
    private int specialCooldown;
    private int attackStatus;
    private int attackLength;
    private boolean hasExploded;
    private int changeFlightTargetTimer;
    private class_243 flightPosAdder;
    private int bonusDmg;
    private int flipCounter;
    public static final float PORTAL_RADIUS = 16.0f;

    public NightProwlerGoal(NightProwler boss, double speed, boolean pauseWhenMobIdle) {
        super((class_1314)boss, speed, pauseWhenMobIdle);
        this.boss = boss;
    }

    public boolean method_6264() {
        if (this.boss.isFlying() && this.boss.method_5968() != null) {
            return true;
        }
        return super.method_6264();
    }

    public void method_6270() {
        super.method_6270();
        int remainingTicks = this.attackLength - this.attackStatus;
        if (remainingTicks > 0) {
            this.boss.setWaitAnimation(true);
        }
        this.boss.setRemainingAniTicks(remainingTicks);
        this.attackCooldown = 20;
        this.specialCooldown = 20;
        this.attackStatus = 0;
        this.attackLength = 0;
        this.hasExploded = false;
        this.boss.setFlying(false);
        this.changeFlightTargetTimer = 0;
        this.boss.setParticleState(0);
        this.bonusDmg = 0;
        this.flipCounter = 0;
    }

    private void checkAndSetAttack(class_1309 target) {
        double distanceToEntity = this.boss.method_5858((class_1297)target);
        int rand = this.boss.method_6051().method_43048(NightProwler.ATTACKS_LENGTH);
        NightProwler.Attacks attack = NightProwler.Attacks.values()[rand];
        switch (attack) {
            case TRINITY: {
                if (!this.isInMeleeRange(target) && !this.boss.isFlying()) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case REAPING_SLASH: {
                if (this.boss.isPhaseTwo() || !(distanceToEntity < 300.0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case NIGHTS_EMBRACE: {
                if (!(this.boss.isPhaseTwo() ? !this.isSummonsAlive() : this.specialCooldown <= 0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case RIPPLE_FANG: 
            case SOUL_REAPER: {
                if (!this.isInMeleeRange(target)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case DARKNESS_RISE: {
                if (!this.isInMeleeRange(target) || this.boss.isFlying()) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case BLADES_REACH: {
                if (!(distanceToEntity < 200.0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case DIMINISHING_LIGHT: 
            case ENGULF: 
            case BLACKFLAME_SNAKE: {
                this.boss.setAttackAnimation(attack);
                break;
            }
            case ECLIPSE: {
                if (!this.boss.isPhaseTwo() || this.specialCooldown > 0) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case LUNAR_DISPLACEMENT: {
                if (!this.boss.isPhaseTwo()) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case DEATHBRINGERS_GRASP: {
                if (!(distanceToEntity < 81.0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            default: {
                this.boss.setAttackAnimation(NightProwler.Attacks.IDLE);
            }
        }
    }

    public void method_6268() {
        class_1309 target;
        if (this.boss.getRemainingAniTicks() > 0 || this.boss.getAttackAnimation().equals((Object)NightProwler.Attacks.SPAWN)) {
            return;
        }
        if (this.boss.isInitiatingPhaseTwo()) {
            this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 255));
            return;
        }
        this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
        this.specialCooldown = Math.max(this.specialCooldown - 1, 0);
        if (!this.boss.isFlying() && this.boss.shouldChaseTarget()) {
            super.method_6268();
        }
        if ((target = this.boss.method_5968()) != null) {
            if (this.boss.isFlying() && !this.boss.getAttackAnimation().equals((Object)NightProwler.Attacks.ECLIPSE)) {
                this.moveAboveTarget(target);
            }
            if (this.attackCooldown <= 0 && this.boss.getAttackAnimation().equals((Object)NightProwler.Attacks.IDLE)) {
                this.checkAndSetAttack(target);
            }
            boolean phase2 = this.boss.isPhaseTwo();
            switch (this.boss.getAttackAnimation()) {
                case TRINITY: {
                    this.attackLength = phase2 ? 90 : 110;
                    this.trinity();
                    break;
                }
                case REAPING_SLASH: {
                    this.attackLength = 70;
                    this.reapingSlash(target);
                    break;
                }
                case NIGHTS_EMBRACE: {
                    this.attackLength = phase2 ? 90 : 80;
                    this.nightsEmbrace();
                    break;
                }
                case RIPPLE_FANG: {
                    this.attackLength = phase2 ? 45 : 30;
                    this.rippleFang(target);
                    break;
                }
                case BLADES_REACH: {
                    this.attackLength = phase2 ? 60 : 40;
                    this.bladesReach(target);
                    break;
                }
                case SOUL_REAPER: {
                    this.attackLength = phase2 ? 150 : 95;
                    this.soulReaper(target);
                    break;
                }
                case DIMINISHING_LIGHT: {
                    this.attackLength = phase2 ? 60 : 40;
                    this.diminishingLight(target);
                    break;
                }
                case DARKNESS_RISE: {
                    this.attackLength = phase2 ? 70 : 40;
                    this.darknessRise(target);
                    break;
                }
                case ECLIPSE: {
                    this.attackLength = 270;
                    this.eclipse();
                    break;
                }
                case ENGULF: {
                    this.attackLength = phase2 ? 90 : 42;
                    this.engulf(target);
                    break;
                }
                case BLACKFLAME_SNAKE: {
                    this.attackLength = phase2 ? 140 : 60;
                    this.blackflameSnake(target);
                    break;
                }
                case LUNAR_DISPLACEMENT: {
                    this.attackLength = 70;
                    this.lunarDisplacement(target);
                    break;
                }
                case DEATHBRINGERS_GRASP: {
                    this.attackLength = phase2 ? 60 : 35;
                    this.deathsGrasp(target);
                }
            }
        }
    }

    private class_243 randomizeVecAdder() {
        return new class_243((double)(this.boss.method_6051().method_39332(3, 10) * (this.boss.method_6051().method_43056() ? -1 : 1)), 0.0, (double)(this.boss.method_6051().method_39332(3, 10) * (this.boss.method_6051().method_43056() ? -1 : 1)));
    }

    private void moveAboveTarget(class_1309 target) {
        class_243 vec3d2;
        boolean bl;
        double d;
        class_243 vec3d;
        block9: {
            block8: {
                this.boss.method_5988().method_35111((class_1297)target);
                this.boss.method_5951((class_1297)target, this.boss.method_20240(), this.boss.method_5978());
                vec3d = this.boss.method_18798().method_18805((double)0.8f, (double)0.6f, (double)0.8f);
                d = vec3d.field_1351;
                bl = this.boss.getAttackAnimation().equals((Object)NightProwler.Attacks.TRINITY);
                if (this.boss.method_23318() < target.method_23318()) break block8;
                double d2 = this.boss.method_23318();
                double d3 = target.method_23318();
                float f = bl ? 9.0f : 6.0f;
                if (!(d2 < d3 + (double)f)) break block9;
            }
            d = Math.max(0.0, d);
            d += 0.3 - d * (double)0.6f;
        }
        vec3d = new class_243(vec3d.field_1352, d, vec3d.field_1350);
        if (this.flightPosAdder != null) {
            ++this.changeFlightTargetTimer;
            if (this.changeFlightTargetTimer >= 40) {
                this.flightPosAdder = this.randomizeVecAdder();
                this.changeFlightTargetTimer = 0;
            }
        } else {
            this.flightPosAdder = this.randomizeVecAdder();
        }
        if ((vec3d2 = new class_243(target.method_23317() - this.boss.method_23317() + (bl ? 0.0 : this.flightPosAdder.field_1352), 0.0, target.method_23321() - this.boss.method_23321() + (bl ? 0.0 : this.flightPosAdder.field_1350))).method_37268() > 9.0) {
            class_243 vec3d3 = vec3d2.method_1029();
            vec3d = vec3d.method_1031(vec3d3.field_1352 * 0.3 - vec3d.field_1352 * 0.6, 0.0, vec3d3.field_1350 * 0.3 - vec3d.field_1350 * 0.6);
        }
        this.boss.method_18799(vec3d);
    }

    private void checkAndReset(int attackCooldown, int specialCooldown) {
        if (this.attackStatus > this.attackLength) {
            this.attackStatus = 0;
            this.attackCooldown = class_3532.method_15357((double)((double)attackCooldown * (this.boss.isPhaseTwo() ? ConfigConstructor.night_prowler_cooldown_modifier_phase_2 : ConfigConstructor.night_prowler_cooldown_modifier_phase_1)));
            if (specialCooldown != 0) {
                this.specialCooldown = class_3532.method_15357((double)((double)specialCooldown * (this.boss.isPhaseTwo() ? ConfigConstructor.night_prowler_special_cooldown_modifier_phase_2 : ConfigConstructor.night_prowler_special_cooldown_modifier_phase_1)));
            }
            this.attackLength = 0;
            this.boss.setAttackAnimation(NightProwler.Attacks.IDLE);
            this.boss.setChaseTarget(true);
            this.hasExploded = false;
            this.boss.setParticleState(0);
            this.bonusDmg = 0;
            this.flipCounter = 0;
            if (this.boss.isPhaseTwo()) {
                this.boss.setFlying(false);
            }
        }
    }

    private float getModifiedDamage(float damage) {
        return (damage + (float)this.bonusDmg) * ConfigConstructor.night_prowler_damage_modifier * (this.boss.isEmpowered() ? 1.25f : 1.0f) * (this.boss.method_6059(class_1294.field_5910) ? 1.25f : 1.0f);
    }

    private boolean damageTarget(class_1309 target, float damage) {
        if (this.boss.isPartner(target)) {
            return false;
        }
        if (target.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), this.getModifiedDamage(damage))) {
            if (this.boss.isEmpowered()) {
                target.method_6092(new class_1293(class_1294.field_5909, 60, 0));
                if (target.method_29504()) {
                    this.boss.method_6025(target.method_6063());
                }
            }
            return true;
        }
        return false;
    }

    protected void method_6288(class_1309 target, double squaredDistance) {
    }

    protected boolean isInMeleeRange(class_1309 target) {
        double distanceToEntity = this.boss.method_5858((class_1297)target);
        return distanceToEntity <= this.method_6289(target);
    }

    private void playSound(@Nullable class_2338 pos, class_3414 sound, float volume, float pitch) {
        if (pos == null) {
            pos = this.boss.method_24515();
        }
        this.boss.method_37908().method_8396(null, pos, sound, class_3419.field_15251, volume, pitch);
    }

    private void trinity() {
        DayStalker partner;
        boolean bl2;
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        boolean phase2 = this.boss.isPhaseTwo();
        int stopFlying = phase2 ? 61 : 75;
        int min = phase2 ? 65 : 77;
        int max = phase2 ? 76 : 95;
        boolean bl1 = this.attackStatus >= (phase2 ? 16 : 26) && this.attackStatus <= (phase2 ? 60 : 68);
        boolean bl = this.attackStatus >= (phase2 ? 38 : 45) && this.attackStatus <= (phase2 ? 43 : 51) ? true : (bl2 = false);
        if (bl1 && this.attackStatus % 3 == 0 && !bl2) {
            this.boss.method_5783(SoundRegistry.SCYTHE_SWIPE, 1.0f, (float)this.boss.method_6051().method_39332(6, 10) / 10.0f);
        }
        if (phase2 && this.attackStatus == 5) {
            this.boss.method_5783(class_3417.field_14588, 1.0f, 1.0f);
            this.boss.setFlying(true);
            this.boss.method_5762(0.0, 0.75, 0.0);
        }
        if (this.boss.isFlying() && this.attackStatus == stopFlying && !this.boss.method_37908().field_9236 && (partner = this.boss.getPartner((class_3218)this.boss.method_37908())) != null) {
            this.boss.setFlying(false);
            partner.setFlying(true);
            partner.flightTimer = (int)ConfigConstructor.duo_fight_time_before_switch;
            this.boss.method_18800(0.0, -2.0, 0.0);
        }
        if (!this.hasExploded && this.attackStatus >= min && this.attackStatus <= max && this.boss.method_24828()) {
            class_243 vec = this.boss.method_5720().method_1021(4.0).method_1019(this.boss.method_19538());
            class_2338 pos = new class_2338((int)vec.method_10216(), this.boss.method_31478(), (int)vec.method_10215());
            class_238 box = new class_238(pos).method_1014(3.0);
            this.aoe(box, 40.0f, 3.0f, true);
            this.hasExploded = true;
            this.boss.setTargetPos(pos);
            this.boss.setParticleState(1);
            class_243 target = class_243.method_24953((class_2382)pos);
            ParticleHandler.flashParticle(this.boss.method_37908(), target.method_10216(), target.method_10214(), target.method_10215(), new ParticleHandler.RGB(142.0f, 107.0f, 1.0f), 10.0f);
            ParticleHandler.flashParticle(this.boss.method_37908(), target.method_10216(), target.method_10214(), target.method_10215(), new ParticleHandler.RGB(72.0f, 0.0f, 140.0f), 2.0f);
            ParticleHandler.particleOutburstMap(this.boss.method_37908(), 300, pos.method_10263(), pos.method_10264(), pos.method_10260(), ParticleEvents.OBLITERATE_MAP, 1.0f);
            this.boss.method_5783(SoundRegistry.TRINITY, 1.0f, 1.0f);
            if (this.boss.isPhaseTwo()) {
                this.trinityShockwave();
            }
        } else {
            this.boss.setParticleState(0);
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 40 : 60, 0);
    }

    private void trinityShockwave() {
        float r = 1.0f;
        for (int theta = 0; theta < 360; theta += 15) {
            double x0 = this.boss.method_23317();
            double z0 = this.boss.method_23321();
            double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
            double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
            NightWaveEntity wave = new NightWaveEntity(EntityRegistry.NIGHT_WAVE, this.boss.method_37908());
            wave.method_23327(x, this.boss.method_23318(), z);
            wave.method_24919((class_1297)this.boss, 0.0f, theta - 90, 0.0f, 1.5f, 0.0f);
            wave.method_7438(this.getModifiedDamage(20.0f));
            wave.method_7432((class_1297)this.boss);
            this.boss.method_37908().method_8649((class_1297)wave);
        }
    }

    public void aoe(class_238 box, float damage, float knockback, boolean knockbackAway, class_1291[] effects) {
        for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, box)) {
            class_1309 target;
            if (!(entity instanceof class_1309) || !this.damageTarget(target = (class_1309)entity, damage) || !(knockback > 0.0f)) continue;
            double x = target.method_23317() - this.boss.method_23317();
            double z = target.method_23321() - this.boss.method_23321();
            int mod = knockbackAway ? 1 : -1;
            target.method_6005((double)knockback, -x * (double)mod, -z * (double)mod);
            for (class_1291 effect : effects) {
                target.method_6092(new class_1293(effect, 60, 0));
            }
        }
    }

    public void aoe(class_238 box, float damage, float knockback, boolean knockbackAway) {
        this.aoe(box, damage, knockback, knockbackAway, new class_1291[0]);
    }

    private void reapingSlash(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        double x = (target.method_23317() - this.boss.method_23317()) / 10.0;
        double y = (target.method_23318() - this.boss.method_23318()) / 10.0;
        double z = (target.method_23321() - this.boss.method_23321()) / 10.0;
        if (this.attackStatus >= 26 && this.attackStatus <= 40) {
            this.boss.method_18800(x, y, z);
            if (this.attackStatus % 2 == 0) {
                this.aoe(this.boss.method_5829().method_1014(2.0), 25.0f, 0.0f, true);
            }
        }
        this.checkAndReset(5, 0);
    }

    private void nightsEmbrace() {
        boolean bl1;
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        boolean phase2 = this.boss.isPhaseTwo();
        int trigger = phase2 ? 75 : 61;
        boolean bl = this.attackStatus >= (phase2 ? 18 : 13) && this.attackStatus <= (phase2 ? 46 : 56) ? true : (bl1 = false);
        if (bl1 && this.attackStatus % 3 == 0) {
            this.boss.method_5783(SoundRegistry.SCYTHE_SWIPE, 1.0f, (float)this.boss.method_6051().method_39332(6, 10) / 10.0f);
        }
        if (!this.boss.method_37908().field_9236 && this.attackStatus == trigger) {
            DayStalker partner = phase2 ? null : this.boss.getPartner((class_3218)this.boss.method_37908());
            class_2338 start = partner == null || partner.isFlying() ? this.boss.method_24515() : partner.method_24515();
            int amount = phase2 ? 4 : 8;
            int[] list = new int[amount];
            int i = 0;
            for (int theta = 0; theta < 360; theta += 360 / amount) {
                Remnant entity;
                int r = 5;
                double x0 = start.method_10263();
                double z0 = start.method_10260();
                double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
                double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
                class_2338 pos = class_2338.method_49637((double)x, (double)(start.method_10264() - 3), (double)z);
                if (phase2) {
                    entity = new Forlorn(EntityRegistry.FORLORN, this.boss.method_37908());
                    HashMap<class_1887, Integer> map = new HashMap<class_1887, Integer>();
                    map.put(class_1893.field_9111, 2);
                    map.put(class_1893.field_9109, 1);
                    Forlorn.initEquip((class_1309)entity, map);
                } else {
                    entity = new SoulReaperGhost(EntityRegistry.SOUL_REAPER_GHOST, this.boss.method_37908());
                }
                pos = this.getNonAirPos(pos, this.boss.method_37908());
                entity.method_23327(pos.method_10263(), (float)pos.method_10264() + 0.1f, pos.method_10260());
                ParticleHandler.particleOutburstMap(this.boss.method_37908(), 100, pos.method_10263(), pos.method_10264(), pos.method_10260(), ParticleEvents.CONJURE_ENTITY_MAP, 1.0f);
                DeathSpiralEntity spiral = new DeathSpiralEntity(this.boss.method_37908(), entity.method_19538(), 1.0f);
                spiral.method_33574(entity.method_19538());
                this.boss.method_37908().method_8649((class_1297)spiral);
                this.playSound(pos, SoundRegistry.NIGHTFALL_SPAWN_EVENT, 0.7f, 1.0f);
                this.boss.method_37908().method_8649((class_1297)entity);
                list[i] = entity.method_5628();
                ++i;
            }
            this.boss.setAliveSummons(list);
            this.boss.method_5783(SoundRegistry.SCYTHE_SWIPE, 1.0f, 0.75f);
        }
        this.checkAndReset(phase2 ? 10 : 60, phase2 ? 120 : 200);
    }

    private class_2338 getNonAirPos(class_2338 start, class_1937 world) {
        if (!world.method_8320(start).method_51366() && !world.method_8320(start.method_10084()).method_51366()) {
            return start;
        }
        return this.getNonAirPos(start.method_10069(0, 1, 0), world);
    }

    private boolean isSummonsAlive() {
        int i;
        int[] list = this.boss.getAliveSummonsList();
        int[] arr = new int[list.length];
        for (i = 0; i < list.length; ++i) {
            if (this.boss.method_37908().method_8469(list[i]) == null) continue;
            arr[i] = list[i];
        }
        this.boss.setAliveSummons(arr);
        i = 0;
        for (int d : arr) {
            i += d;
        }
        return i != 0;
    }

    private void rippleFang(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        boolean phase2 = this.boss.isPhaseTwo();
        if (this.attackStatus == 1) {
            this.boss.method_5783(SoundRegistry.NIGHT_SKULL_DIE, 1.0f, 0.75f);
        }
        if (this.attackStatus == (phase2 ? 29 : 18)) {
            float yawRad = (float)class_3532.method_15349((double)(target.method_23321() - this.boss.method_23321()), (double)(target.method_23317() - this.boss.method_23317()));
            float yawDeg = (float)Math.toDegrees(yawRad);
            double heightDiff = Math.abs(target.method_23318() - this.boss.method_23318());
            double maxYOffset = heightDiff + 2.0;
            WeaponUtil.doConsumerOnCircle(this.boss.method_37908(), yawDeg, this.boss.method_19538(), maxYOffset, 5, new class_241(1.5f, 1.75f), (TriConsumer<class_243, Integer, Float>)((TriConsumer)this::spawnNightsEdge));
        }
        this.checkAndReset(5, 0);
    }

    private void spawnNightsEdge(class_243 position, Integer warmup, Float yaw) {
        if (this.boss.isPhaseTwo()) {
            NightsEdge edge = new NightsEdge(EntityRegistry.NIGHTS_EDGE, this.boss.method_37908());
            edge.setOwner((class_1309)this.boss);
            edge.setWarmup(warmup);
            edge.setDamage(this.getModifiedDamage(15.69f));
            edge.method_36456(yaw.floatValue());
            edge.method_23327(position.field_1352, position.field_1351, position.field_1350);
            this.boss.method_37908().method_8649((class_1297)edge);
        } else {
            this.boss.method_37908().method_8649((class_1297)new class_1669(this.boss.method_37908(), position.field_1352, position.field_1351, position.field_1350, yaw.floatValue(), warmup.intValue(), (class_1309)this.boss));
        }
    }

    private void bladesReach(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        boolean phase2 = this.boss.isPhaseTwo();
        if (this.attackStatus == (phase2 ? 16 : 23)) {
            WeaponUtil.doConsumerOnLine(this.boss.method_37908(), (float)Math.toDegrees((float)class_3532.method_15349((double)(target.method_23321() - this.boss.method_23321()), (double)(target.method_23317() - this.boss.method_23317()))), this.boss.method_19538(), 10.0, 20, 1.25f, (TriConsumer<class_243, Integer, Float>)((TriConsumer)this::spawnNightsEdge));
            this.boss.method_5783(SoundRegistry.SCYTHE_SWIPE, 1.0f, 0.7f);
        }
        if (phase2 && this.attackStatus == 43) {
            class_243 vec = new class_243(target.method_23317() - this.boss.method_23317(), target.method_23320() - this.boss.method_23323(1.0), target.method_23321() - this.boss.method_23321());
            this.shootSplitSkulls(vec, 5, 1.75f);
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 1 : 40, 0);
    }

    private void shootSplitSkulls(class_243 target, int amount, float velocity) {
        this.shootSplitProjectile(target, amount, velocity, EntityRegistry.NO_DRAG_WITHER_SKULL);
    }

    private void shootSplitProjectile(class_243 target, int amount, float velocity, class_1299<? extends class_1676> type) {
        int m = class_3532.method_15375((float)((float)amount / 2.0f));
        this.playSound(null, class_3417.field_14588, 1.0f, 1.0f);
        for (int i = -m; i <= m; ++i) {
            class_243 vec = target.method_1024((float)Math.toRadians(5 * i));
            class_1676 entity = (class_1676)type.method_5883(this.boss.method_37908());
            if (entity == null) continue;
            entity.method_23327(this.boss.method_23317(), this.boss.method_23320(), this.boss.method_23321());
            entity.method_7485(vec.method_10216(), vec.method_10214(), vec.method_10215(), velocity, 1.0f);
            entity.method_7432((class_1297)this.boss);
            this.boss.method_37908().method_8649((class_1297)entity);
        }
    }

    private void shootSplitMoonlight(class_243 target, int amount) {
        int m = class_3532.method_15375((float)((float)amount / 2.0f));
        this.playSound(null, SoundRegistry.MOONLIGHT_BIG_EVENT, 1.0f, 1.0f);
        for (int i = -m; i <= m; ++i) {
            class_243 vec = target.method_1024((float)Math.toRadians(8 * i));
            MoonlightProjectile entity = new MoonlightProjectile(EntityRegistry.MOONLIGHT_BIG_ENTITY_TYPE, this.boss.method_37908());
            entity.setAgeAndPoints(30, 150, 4);
            entity.method_7438(this.getModifiedDamage(20.0f));
            entity.method_23327(this.boss.method_23317(), this.boss.method_23320(), this.boss.method_23321());
            entity.method_7485(vec.method_10216(), vec.method_10214(), vec.method_10215(), 1.75f, 1.0f);
            entity.method_7432((class_1297)this.boss);
            this.boss.method_37908().method_8649((class_1297)entity);
        }
    }

    private void shootSplitBoth(class_243 target, int amount) {
        int m = class_3532.method_15375((float)((float)amount / 2.0f));
        this.playSound(null, SoundRegistry.MOONLIGHT_BIG_EVENT, 1.0f, 1.0f);
        this.playSound(null, class_3417.field_14588, 1.0f, 1.0f);
        for (int i = -m; i <= m; ++i) {
            Object entity;
            boolean bl;
            class_243 vec = target.method_1024((float)Math.toRadians(8 * i));
            boolean bl2 = bl = this.flipCounter % 2 == 0 == (i % 2 == 0);
            if (bl) {
                entity = new NoDragWitherSkull((class_1299<? extends class_1687>)class_1299.field_6130, this.boss.method_37908());
            } else {
                entity = new MoonlightProjectile(EntityRegistry.MOONLIGHT_BIG_ENTITY_TYPE, this.boss.method_37908());
                ((MoonlightProjectile)((Object)entity)).setAgeAndPoints(30, 150, 4);
                ((MoonlightProjectile)((Object)entity)).method_7438(this.getModifiedDamage(20.0f));
            }
            entity.method_23327(this.boss.method_23317(), this.boss.method_23320(), this.boss.method_23321());
            entity.method_7485(vec.method_10216(), vec.method_10214(), vec.method_10215(), 1.75f, 1.0f);
            entity.method_7432((class_1297)this.boss);
            this.boss.method_37908().method_8649((class_1297)entity);
        }
        ++this.flipCounter;
    }

    private void soulReaper(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_5988().method_35111((class_1297)target);
        this.boss.method_5951((class_1297)target, this.boss.method_20240(), this.boss.method_5978());
        this.boss.method_5942().method_6340();
        class_243 vel = new class_243(target.method_23317() - this.boss.method_23317(), target.method_23320() - this.boss.method_23323(1.0), target.method_23321() - this.boss.method_23321());
        boolean phase2 = this.boss.isPhaseTwo();
        class_243 vec = this.boss.method_5720().method_1021(4.0).method_1019(this.boss.method_19538());
        vec = new class_243(vec.method_10216(), target.method_23318(), vec.method_10215());
        this.boss.setTargetPos(class_2338.method_49638((class_2374)vec).method_33096(this.boss.method_31478()));
        HashMap<Integer, class_238> map = new HashMap<Integer, class_238>();
        if (!phase2) {
            map.put(14, new class_238(class_2338.method_49638((class_2374)vec)).method_1014(2.0));
            map.put(29, new class_238(class_2338.method_49638((class_2374)vec)).method_1014(2.0));
            map.put(49, this.boss.method_5829().method_1014(2.0));
            map.put(72, this.boss.method_5829().method_1014(2.0));
        } else {
            map.put(17, new class_238(class_2338.method_49638((class_2374)vec)).method_1014(2.0));
            map.put(28, new class_238(class_2338.method_49638((class_2374)vec)).method_1014(2.0));
            map.put(50, this.boss.method_5829().method_1014(2.0));
            map.put(61, new class_238(class_2338.method_49638((class_2374)vec)).method_1014(2.0));
            map.put(74, new class_238(class_2338.method_49638((class_2374)vec)).method_1014(2.0));
            map.put(96, this.boss.method_5829().method_1014(2.0));
            map.put(109, new class_238(class_2338.method_49638((class_2374)vec)).method_1014(2.0));
            map.put(128, new class_238(class_2338.method_49638((class_2374)vec)).method_1014(3.0));
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int frame = (Integer)iterator.next();
            if (this.attackStatus != frame) continue;
            this.playSound(null, SoundRegistry.SCYTHE_SWIPE, 1.0f, (float)this.boss.method_6051().method_39332(6, 10) / 10.0f);
            this.aoe((class_238)map.get(frame), 20.0f, 0.4f, true);
            this.bonusDmg += phase2 ? 3 : 5;
            this.boss.method_18799(vel.method_1021(0.1));
            if (this.attackStatus == 61) {
                this.shootSplitSkulls(vel, 3, 1.5f);
            }
            if (this.attackStatus == 74) {
                this.boss.setParticleState(2);
                this.boss.method_5783(class_3417.field_14742, 1.0f, 1.0f);
            }
            if (this.attackStatus == 109) {
                this.shootSplitMoonlight(vel, 3);
            }
            if (this.attackStatus != 128) continue;
            this.boss.setParticleState(3);
        }
        if (this.attackStatus != 74 && this.attackStatus != 128) {
            this.boss.setParticleState(0);
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 5 : 40, 0);
    }

    private void diminishingLight(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_5988().method_35111((class_1297)target);
        this.boss.method_5951((class_1297)target, this.boss.method_20240(), this.boss.method_5978());
        this.boss.method_5942().method_6340();
        boolean phase2 = this.boss.isPhaseTwo();
        int[] frames = new int[]{20, 30, 40};
        class_243 vec = new class_243(target.method_23317() - this.boss.method_23317(), target.method_23320() - this.boss.method_23323(1.0), target.method_23321() - this.boss.method_23321());
        if (!phase2) {
            if (this.attackStatus == 25) {
                this.shootSplitMoonlight(vec, 5);
            }
        } else {
            for (int f : frames) {
                if (f != this.attackStatus) continue;
                this.shootSplitBoth(vec, 5);
            }
        }
        this.checkAndReset(this.boss.isFlying() ? 40 : 5, 0);
    }

    private void darknessRise(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        if (this.attackStatus == 24) {
            this.boss.method_5783(SoundRegistry.DARKNESS_RISE, 1.0f, 1.0f);
            this.boss.method_6092(new class_1293(class_1294.field_5910, 300, 0));
            this.boss.method_6092(new class_1293(class_1294.field_5904, 300, 1));
            float yawRad = (float)class_3532.method_15349((double)(target.method_23321() - this.boss.method_23321()), (double)(target.method_23317() - this.boss.method_23317()));
            float yawDeg = (float)Math.toDegrees(yawRad);
            double heightDiff = Math.abs(target.method_23318() - this.boss.method_23318());
            double maxYOffset = heightDiff + 2.0;
            WeaponUtil.doConsumerOnCircle(this.boss.method_37908(), yawDeg, this.boss.method_19538(), maxYOffset, this.boss.isPhaseTwo() ? 10 : 4, new class_241(1.5f, 1.75f), (TriConsumer<class_243, Integer, Float>)((TriConsumer)(pos, delay, yaw) -> {
                BlackflameExplosionEntity entity = new BlackflameExplosionEntity(this.boss.method_37908());
                entity.method_7432((class_1297)this.boss);
                entity.setRadius(2.0f);
                entity.method_7438(this.getModifiedDamage(30.0f));
                entity.setWarmup(delay + 15);
                entity.method_33574((class_243)pos);
                this.boss.method_37908().method_8649((class_1297)entity);
                class_1937 patt0$temp = this.boss.method_37908();
                if (patt0$temp instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)patt0$temp;
                    float spread = 0.01f;
                    serverWorld.method_14199((class_2394)class_2398.field_11237, pos.method_10216(), pos.method_10214(), pos.method_10215(), 4, (double)(this.boss.method_6051().method_43057() * spread - spread / 2.0f), (double)(this.boss.method_6051().method_43057() * spread - spread / 2.0f), (double)(this.boss.method_6051().method_43057() * spread - spread / 2.0f), 0.0);
                }
            }));
        }
        this.checkAndReset(10, 0);
    }

    private void eclipse() {
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        if (this.attackStatus <= 1) {
            this.boss.method_5783(SoundRegistry.PARTNER_DIES, 0.8f, 0.8f);
            this.playSound(this.boss.method_5968() != null ? this.boss.method_5968().method_24515() : this.boss.method_24515(), SoundRegistry.PARTNER_DIES, 0.8f, 0.8f);
            this.boss.setFlying(true);
            this.boss.method_5762(0.0, 0.5, 0.0);
        }
        if (this.attackStatus == 40) {
            this.boss.setParticleState(4);
        }
        if (this.attackStatus >= 50 && this.attackStatus <= 220) {
            for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, this.boss.method_5829().method_1014(35.0))) {
                if (this.attackStatus % 6 != 0 || !(entity instanceof class_1309)) continue;
                class_1309 target = (class_1309)entity;
                int radius = 10;
                class_243 spawn = new class_243(this.boss.method_23317() + (double)this.boss.method_6051().method_39332(-radius, radius), this.boss.method_23318() + 8.0, this.boss.method_23321() + (double)this.boss.method_6051().method_39332(-radius, radius));
                class_243 vec = new class_243(target.method_23317() - spawn.method_10216(), target.method_23320() - spawn.method_10214(), target.method_23321() - spawn.method_10215());
                NightSkull skull = new NightSkull((class_1299<? extends NightSkull>)EntityRegistry.NIGHT_SKULL, this.boss.method_37908());
                skull.method_33574(spawn);
                skull.method_7485(vec.method_10216(), vec.method_10214(), vec.method_10215(), 1.75f, 1.0f);
                skull.method_7432((class_1297)this.boss);
                this.boss.method_37908().method_8649((class_1297)skull);
                if (!target.method_29504() || target.field_6213 >= 2) continue;
                this.boss.method_6025(ConfigConstructor.night_prowler_eclipse_healing);
                DeathSpiralEntity spiral = new DeathSpiralEntity(this.boss.method_37908(), target.method_19538(), 1.0f);
                spiral.method_33574(target.method_19538());
                this.boss.method_37908().method_8649((class_1297)spiral);
            }
        }
        if (this.attackStatus >= 240) {
            this.boss.setParticleState(0);
            this.boss.setFlying(false);
        }
        this.checkAndReset(20, 300);
    }

    private void engulf(class_1309 target) {
        class_243 vec;
        ++this.attackStatus;
        this.boss.method_5988().method_35111((class_1297)target);
        this.boss.method_5951((class_1297)target, this.boss.method_20240(), this.boss.method_5978());
        this.boss.method_5942().method_6340();
        boolean phase2 = this.boss.isPhaseTwo();
        if (this.attackStatus == (phase2 ? 19 : 21)) {
            vec = new class_243(target.method_23317() - this.boss.method_23317(), target.method_23318() - this.boss.method_23318(), target.method_23321() - this.boss.method_23321());
            FogEntity entity = new FogEntity((class_1299<? extends FogEntity>)EntityRegistry.FOG_ENTITY, this.boss.method_37908());
            entity.method_23327(this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321());
            entity.method_7485(vec.method_10216(), vec.method_10214(), vec.method_10215(), 1.0f, 1.0f);
            entity.method_7432((class_1297)this.boss);
            this.boss.method_37908().method_8649((class_1297)entity);
            this.boss.method_5783(class_3417.field_14588, 1.0f, 1.0f);
        }
        if (phase2 && this.attackStatus == 45) {
            vec = target.method_5720().method_1021(-3.0).method_1019(target.method_19538());
            this.boss.teleportTo(vec.method_10216(), target.method_23318(), vec.method_10215());
            this.boss.method_5951((class_1297)target, 180.0f, 180.0f);
        }
        if (this.attackStatus == 54) {
            vec = this.boss.method_5720().method_1021(4.0).method_1019(this.boss.method_19538());
            vec = new class_243(vec.method_10216(), this.boss.method_23318(), vec.method_10215());
            this.boss.setTargetPos(class_2338.method_49638((class_2374)vec));
            this.aoe(new class_238(class_2338.method_49638((class_2374)vec)).method_1014(2.0), 30.0f, 1.5f, true);
            this.boss.setParticleState(2);
            this.boss.method_5783(class_3417.field_14742, 1.0f, 1.0f);
        } else {
            this.boss.setParticleState(0);
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 10 : 50, 0);
    }

    /*
     * WARNING - void declaration
     */
    private void blackflameSnake(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_5942().method_6340();
        this.boss.method_5988().method_35111((class_1297)target);
        this.boss.method_5951((class_1297)target, this.boss.method_20240() * 2, this.boss.method_5978() * 2);
        boolean phase2 = this.boss.isPhaseTwo();
        if (!phase2 && this.attackStatus == 31) {
            void var5_9;
            Object vel;
            DayStalker partner;
            this.boss.method_5783(SoundRegistry.NIGHT_SKULL_DIE, 1.0f, 0.75f);
            BlackflameSnakeEntity entity = new BlackflameSnakeEntity(EntityRegistry.BLACKFLAME_SNAKE_ENTITY, this.boss.method_37908());
            entity.method_7438(this.getModifiedDamage(30.0f));
            if (this.boss.isFlying() && (partner = this.boss.getPartner((class_3218)this.boss.method_37908())) != null) {
                vel = new class_243(target.method_23317() - partner.method_23317(), target.method_23318() - partner.method_23318(), target.method_23321() - partner.method_23321()).method_1021((double)0.2f);
                class_243 class_2432 = partner.method_19538();
                entity.method_7432((class_1297)partner);
            } else {
                vel = new class_243(target.method_23317() - this.boss.method_23317(), target.method_23318() - this.boss.method_23318(), target.method_23321() - this.boss.method_23321()).method_1021((double)0.2f);
                class_243 class_2433 = this.boss.method_19538();
                entity.method_7432((class_1297)this.boss);
            }
            entity.method_33574((class_243)var5_9);
            entity.method_18799((class_243)vel);
            entity.setTargetUuid(target.method_5667());
            this.boss.method_37908().method_8649((class_1297)entity);
        }
        if (phase2) {
            if (this.attackStatus <= 1) {
                this.boss.method_5783(SoundRegistry.NIGHT_SKULL_DIE, 1.0f, 0.75f);
                this.boss.setFlying(true);
                this.boss.method_5762(0.0, 0.5, 0.0);
            }
            if (this.attackStatus == 84) {
                this.boss.setFlying(false);
                this.boss.method_18800(0.0, -1.0, 0.0);
            }
            if (!this.hasExploded && this.boss.method_24828() && this.attackStatus >= 88 && this.attackStatus <= 110) {
                this.hasExploded = true;
                this.boss.setTargetPos(this.boss.method_24515());
                this.boss.setParticleState(2);
                this.aoe(this.boss.method_5829().method_1014(2.0), 35.0f, 2.0f, true);
                List<List<class_243>> positions = BlackflameSnakeUtil.getCurvedPositions(this.boss.method_36454(), 10.0f, this.boss.method_19538(), target.method_19538());
                for (List list : positions) {
                    for (int i = 0; i < list.size(); ++i) {
                        BlackflameExplosionEntity entity = new BlackflameExplosionEntity(this.boss.method_37908());
                        entity.method_7432((class_1297)this.boss);
                        entity.setRadius(2.0f);
                        entity.method_7438(this.getModifiedDamage(35.0f));
                        entity.setWarmup(i);
                        entity.method_33574((class_243)list.get(i));
                        this.boss.method_37908().method_8649((class_1297)entity);
                    }
                }
                BlackflameSnakeEntity entity = new BlackflameSnakeEntity(this.boss.method_37908());
                entity.method_33574(this.boss.method_19538());
                entity.method_7438(this.getModifiedDamage(30.0f));
                entity.method_18799(new class_243(target.method_23317() - this.boss.method_23317(), target.method_23318() - this.boss.method_23318(), target.method_23321() - this.boss.method_23321()).method_1021((double)0.2f));
                entity.setTargetUuid(target.method_5667());
                this.boss.method_37908().method_8649((class_1297)entity);
            } else {
                this.boss.setParticleState(0);
            }
        }
        this.checkAndReset(this.boss.isFlying() ? 60 : (this.boss.isPhaseTwo() ? 5 : 30), 0);
    }

    private void lunarDisplacement(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_5988().method_35111((class_1297)target);
        this.boss.method_5951((class_1297)target, this.boss.method_20240(), this.boss.method_5978());
        this.boss.method_5942().method_6340();
        if (this.attackStatus == 1) {
            this.playSound(target.method_24515(), SoundRegistry.NIGHT_PROWLER_SCREAM, 1.0f, 1.0f);
        }
        if (this.attackStatus == 35) {
            class_243 vec = target.method_5720().method_1021(-2.0).method_1019(target.method_19538());
            this.boss.teleportTo(vec.method_10216(), target.method_23318(), vec.method_10215());
            this.boss.method_5951((class_1297)target, 180.0f, 180.0f);
        }
        if (this.attackStatus == 42) {
            this.aoe(this.boss.method_5829().method_1014(3.0), 35.0f, 2.0f, true);
            ParticleHandler.particleSphereList(this.boss.method_37908(), 1000, this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), 1.0f, new class_2394[]{class_2398.field_22246, class_2398.field_11237});
            this.boss.method_5783(class_3417.field_15152, 1.0f, 1.0f);
            this.boss.method_5783(class_3417.field_15152, 1.0f, 0.7f);
        }
        this.checkAndReset(10, 0);
    }

    private void deathsGrasp(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_5988().method_35111((class_1297)target);
        this.boss.method_5951((class_1297)target, this.boss.method_20240(), this.boss.method_5978());
        this.boss.method_5942().method_6340();
        boolean phase2 = this.boss.isPhaseTwo();
        if (this.attackStatus == (phase2 ? 18 : 23)) {
            class_1291[] class_1291Array;
            class_243 out = this.boss.method_5720().method_18805(5.5, 0.0, 5.5).method_1031(this.boss.method_19538().method_10216(), target.method_23318(), this.boss.method_19538().method_10215());
            class_238 box = new class_238(class_2338.method_49638((class_2374)out)).method_1014(3.0);
            if (phase2) {
                class_1291[] class_1291Array2 = new class_1291[1];
                class_1291Array = class_1291Array2;
                class_1291Array2[0] = class_1294.field_5919;
            } else {
                class_1291Array = new class_1291[]{};
            }
            this.aoe(box, 10.0f, 1.0f, false, class_1291Array);
            this.boss.method_5783(SoundRegistry.SCYTHE_SWIPE, 1.0f, 0.75f);
            if (phase2 && this.boss.teleportAway()) {
                this.boss.method_5783(class_3417.field_14879, 1.0f, 1.0f);
            }
        }
        if (phase2 && this.attackStatus == 43) {
            class_243 vec = new class_243(target.method_23317() - this.boss.method_23317(), target.method_23320() - this.boss.method_23323(1.0), target.method_23321() - this.boss.method_23321());
            this.shootSplitSkulls(vec, 3, 1.75f);
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 1 : 10, 0);
    }

    public static class DeathSpiralEntity
    extends NoClipEntity {
        private DeathSpiralLogic logic = new DeathSpiralLogic(this.method_19538(), 1.0f);

        public DeathSpiralEntity(class_1299<? extends NoClipEntity> entityType, class_1937 world) {
            super(entityType, world);
        }

        protected DeathSpiralEntity(class_1937 world, class_243 pos, float radius) {
            super(EntityRegistry.DEATH_SPIRAL_ENTITY, world);
            this.logic = new DeathSpiralLogic(pos, radius);
        }

        public boolean method_5643(class_1282 source, float amount) {
            return false;
        }

        public void method_5773() {
            super.method_5773();
            this.method_33574(this.method_19538());
            if (this.method_37908().field_9236) {
                for (int i = 0; i < 4; ++i) {
                    this.logic.tick(this.method_37908(), this.method_19538());
                }
            }
            if (this.logic.isFinished() || this.field_6012 > 200) {
                this.method_31472();
            }
        }
    }
}

