/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.EnumSet;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8111;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.IAnimatedDeath;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class RimeSpectre
extends Remnant
implements GeoEntity,
IAnimatedDeath {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    protected static final class_2940<Boolean> CHARGING = class_2945.method_12791(RimeSpectre.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> ATTACKING = class_2945.method_12791(RimeSpectre.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> ATTACK_PARTICLE = class_2945.method_12791(RimeSpectre.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<class_2338> POS = class_2945.method_12791(RimeSpectre.class, (class_2941)class_2943.field_13324);

    public RimeSpectre(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new SpectreMoveControl(this);
        this.method_6173(false);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(3, (class_1352)new RimeSpectreGoal(this));
        this.field_6201.method_6277(6, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 5.0f, false));
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, true, entity -> !this.method_6181() || !(this.method_35057() instanceof class_1657)));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1308.class, true, entity -> this.method_6181() && entity instanceof class_1569 && !this.method_5722((class_1297)entity)));
        this.field_6185.method_6277(5, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42354)) {
            return false;
        }
        if (source.method_49708(class_8111.field_42349) || source.method_49708(class_8111.field_42329)) {
            return super.method_5643(source, amount);
        }
        return super.method_5643(source, amount * 0.1f);
    }

    @Override
    public int getSoulAmount() {
        return 5;
    }

    @Override
    public void initEquip() {
    }

    public static class_5132.class_5133 createSpectreAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_23716, ConfigConstructor.rime_spectre_health).method_26868(class_5134.field_23724, ConfigConstructor.rime_spectre_armor).method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23721, 10.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ATTACKING, (Object)false);
        this.field_6011.method_12784(CHARGING, (Object)false);
        this.field_6011.method_12784(ATTACK_PARTICLE, (Object)false);
        this.field_6011.method_12784(POS, (Object)new class_2338(0, 0, 0));
    }

    private PlayState predicate(AnimationState<?> state) {
        if (this.method_29504()) {
            state.getController().setAnimation(RawAnimation.begin().then("death", Animation.LoopType.HOLD_ON_LAST_FRAME));
        } else if (this.method_24345()) {
            state.getController().setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
        } else if (this.getShooting()) {
            state.getController().setAnimation(RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private PlayState idle(AnimationState<?> state) {
        state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, this::idle)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public boolean getCharging() {
        return (Boolean)this.field_6011.method_12789(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.field_6011.method_12778(CHARGING, (Object)charging);
    }

    public boolean getShooting() {
        return (Boolean)this.field_6011.method_12789(ATTACKING);
    }

    public void setShooting(boolean bl) {
        this.field_6011.method_12778(ATTACKING, (Object)bl);
    }

    public boolean getShootingParticle() {
        return (Boolean)this.field_6011.method_12789(ATTACK_PARTICLE);
    }

    public void setShootingParticle(boolean bl) {
        this.field_6011.method_12778(ATTACK_PARTICLE, (Object)bl);
    }

    public class_2338 getShootPos() {
        return (class_2338)this.field_6011.method_12789(POS);
    }

    public void setShootPos(class_2338 pos) {
        this.field_6011.method_12778(POS, (Object)pos);
    }

    public void method_5773() {
        this.field_5960 = true;
        super.method_5773();
        this.field_5960 = false;
        this.method_5875(true);
        for (class_1297 entity : this.method_37908().method_8335((class_1297)this, this.method_5829().method_1014(6.0))) {
            class_1309 target;
            if (!(entity instanceof class_1309) || this.method_6171(target = (class_1309)entity) || this.method_5722((class_1297)target)) continue;
            target.method_6092(new class_1293(EffectRegistry.FREEZING, 20, 0));
        }
        if (this.method_6059(EffectRegistry.FREEZING)) {
            this.method_6016(EffectRegistry.FREEZING);
        }
    }

    public boolean method_37222(class_1293 effect, @Nullable class_1297 source) {
        if (effect.method_5579().equals(EffectRegistry.FREEZING)) {
            return false;
        }
        return super.method_37222(effect, source);
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        super.method_5784(movementType, movement);
        this.method_5852();
    }

    @Override
    public void method_6007() {
        super.method_6007();
        this.method_37908().method_8406((class_2394)class_2398.field_28013, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
        if (this.getShootingParticle()) {
            class_2338 pos = this.getShootPos();
            double distanceToEntity = this.method_5649(pos.method_10263(), (float)pos.method_10264() + 0.5f, pos.method_10260());
            for (int i = 0; i < 20; ++i) {
                double e = (double)pos.method_10263() - this.method_23317();
                double f = (double)((float)pos.method_10264() + 0.5f) - this.method_23323(1.0);
                double g = (double)pos.method_10260() - this.method_23321();
                double h = Math.sqrt(Math.sqrt(distanceToEntity)) * 0.5;
                if (!this.method_37908().field_9236) continue;
                this.method_37908().method_8406((class_2394)class_2398.field_28013, this.method_23317(), this.method_23320(), this.method_23321(), (e + this.method_6051().method_43059() * h) / 4.0, (f + this.method_6051().method_43059()) / 4.0, (g + this.method_6051().method_43059() * h) / 4.0);
            }
        }
    }

    @Override
    public void method_6108() {
        ++this.deathTicks;
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.method_37908().method_8608()) {
            this.method_37908().method_8421((class_1297)this, (byte)60);
            if (!this.method_37908().field_9236) {
                ParticleHandler.particleSphere(this.method_37908(), 600, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), ParticleEvents.ICE_PARTICLE, 1.0f);
            }
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15081, class_3419.field_15251, 1.0f, 1.0f);
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15081, class_3419.field_15251, 1.0f, 0.5f);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    @Override
    public int getTicksUntilDeath() {
        return 15;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void setDeath() {
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14688;
    }

    @Override
    protected class_3414 method_5994() {
        return class_3417.field_15163;
    }

    @Override
    protected class_3414 method_6002() {
        return class_3417.field_14688;
    }

    public boolean method_5753() {
        return true;
    }

    @Override
    public boolean method_5999() {
        return false;
    }

    class SpectreMoveControl
    extends class_1335 {
        public SpectreMoveControl(RimeSpectre owner) {
            super((class_1308)owner);
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                class_243 vec3d = new class_243(this.field_6370 - RimeSpectre.this.method_23317(), this.field_6369 - RimeSpectre.this.method_23318(), this.field_6367 - RimeSpectre.this.method_23321());
                double d = vec3d.method_1033();
                if (d < RimeSpectre.this.method_5829().method_995()) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                    RimeSpectre.this.method_18799(RimeSpectre.this.method_18798().method_1021(0.5));
                } else {
                    RimeSpectre.this.method_18799(RimeSpectre.this.method_18798().method_1019(vec3d.method_1021(this.field_6372 * 0.05 / d)));
                    if (RimeSpectre.this.method_5968() == null) {
                        class_243 vec3d2 = RimeSpectre.this.method_18798();
                        RimeSpectre.this.method_36456(-((float)class_3532.method_15349((double)vec3d2.field_1352, (double)vec3d2.field_1350)) * 57.295776f);
                    } else {
                        double e = RimeSpectre.this.method_5968().method_23317() - RimeSpectre.this.method_23317();
                        double f = RimeSpectre.this.method_5968().method_23321() - RimeSpectre.this.method_23321();
                        RimeSpectre.this.method_36456(-((float)class_3532.method_15349((double)e, (double)f)) * 57.295776f);
                    }
                    RimeSpectre.this.field_6283 = RimeSpectre.this.method_36454();
                }
            }
        }
    }

    static class RimeSpectreGoal
    extends class_1352 {
        private final RimeSpectre mob;
        private int attackStatus;
        private int cooldown;

        public RimeSpectreGoal(RimeSpectre mob) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
            this.mob = mob;
        }

        public boolean method_6264() {
            class_1309 target = this.mob.method_5968();
            return !this.mob.method_24345() && target != null && target.method_5805() && this.mob.method_18395(target) && this.mob.method_6051().method_43048(7) == 0;
        }

        public boolean method_6266() {
            return !this.mob.method_24345() && this.mob.getCharging() && this.mob.method_5968() != null && this.mob.method_5968().method_5805();
        }

        public void method_6269() {
            class_1309 livingEntity = this.mob.method_5968();
            if (livingEntity == null) {
                return;
            }
            class_243 vec3d = livingEntity.method_33571();
            this.mob.method_5962().method_6239(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 1.0);
            this.mob.setCharging(true);
        }

        public void method_6270() {
            this.mob.setCharging(false);
            this.mob.setShooting(false);
            this.mob.setShootingParticle(false);
        }

        public boolean method_38846() {
            return true;
        }

        private void moveRandomSpot(class_243 vec3d) {
            this.mob.method_5962().method_6239(vec3d.field_1352 + (double)this.mob.method_6051().method_43048(8) - 4.0, vec3d.field_1351 + (double)this.mob.method_6051().method_43048(3), vec3d.field_1350 + (double)this.mob.method_6051().method_43048(8) - 4.0, 1.0);
        }

        public void method_6268() {
            this.cooldown = Math.max(this.cooldown - 1, 0);
            class_1309 target = this.mob.method_5968();
            if (target != null && target.method_24515() != null) {
                class_243 vec3d = target.method_33571();
                if (this.cooldown > 0) {
                    this.moveRandomSpot(vec3d);
                }
                if (this.cooldown <= 0 && !this.mob.method_5757()) {
                    this.mob.setShooting(true);
                    this.frostBeam(target);
                }
            }
        }

        private void frostBeam(class_1309 target) {
            ++this.attackStatus;
            this.mob.setShootPos(target.method_24515());
            this.mob.method_5988().method_35111((class_1297)target);
            this.mob.method_5942().method_6340();
            if (this.attackStatus >= 15) {
                this.mob.setShootingParticle(true);
                if (this.attackStatus % 2 == 0) {
                    class_238 box = new class_238(target.method_24515(), this.mob.method_24515().method_10069(0, 1, 0)).method_1014(1.0);
                    for (class_1297 entity : this.mob.method_37908().method_8335((class_1297)this.mob, box)) {
                        class_1309 living;
                        if (!(entity instanceof class_1309) || this.mob.method_6171(living = (class_1309)entity) || this.mob.method_5722((class_1297)living)) continue;
                        living.method_6092(new class_1293(EffectRegistry.FREEZING, 40, 2));
                        living.method_5643(this.mob.method_37908().method_48963().method_48812((class_1309)this.mob), 2.0f);
                    }
                }
            }
            if (this.attackStatus >= 40) {
                this.attackStatus = 0;
                this.cooldown = 40;
                this.mob.setShootingParticle(false);
                this.mob.setShooting(false);
            }
        }
    }
}

