/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.katana;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_3419;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.noclip.MoonveilWave;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.items.katana.IBleed;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public class Moonveil
extends ChargeToUseItem
implements IBleed {
    public Moonveil(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, (int)ConfigConstructor.moonveil_damage, ConfigConstructor.moonveil_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.TRANSIENT_MOONLIGHT, TooltipAbilities.BLEED);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!this.isDisabled(stack)) {
            this.applyBleed(attacker, target);
        }
        return super.method_7873(stack, target, attacker);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        int time;
        class_1657 player;
        if (user instanceof class_1657 && !(player = (class_1657)user).method_7357().method_7904((class_1792)this) && !world.field_9236 && (time = WeaponUtil.getChargeTime(stack, remainingUseTicks)) >= 10) {
            if (player.method_5715()) {
                MoonveilWave entity = new MoonveilWave(EntityRegistry.MOONVEIL_VERTICAL, world, user, 15);
                entity.setAreaParticle((class_2394)ParticleRegistry.MOONVEIL_PARTICLE);
                entity.setAreaParticleCount(10);
                entity.setDespawnParticle((class_2394)ParticleRegistry.BLUE_FLAME);
                entity.method_23327(player.method_23317(), player.method_23320() - 1.0, player.method_23321());
                entity.setDespawnParticleCount(40);
                entity.setModelRotationX(90);
                entity.setModelTranslationY(1.0f);
                entity.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 1.0f, 1.0f);
                entity.method_7438(ConfigConstructor.moonveil_vertical_damage + (float)WeaponUtil.getEnchantDamageBonus(stack));
                world.method_8649((class_1297)entity);
                world.method_8396(null, user.method_24515(), SoundRegistry.MOONVEIL_VERTICAL, class_3419.field_15248, 1.0f, 1.0f);
            } else {
                MoonveilWave entity = new MoonveilWave(world, user, 6);
                entity.setAreaParticle((class_2394)ParticleRegistry.MOONVEIL_PARTICLE);
                entity.setAreaParticleCount(15);
                entity.setDespawnParticleCount(40);
                entity.setDespawnParticle((class_2394)ParticleRegistry.BLUE_FLAME);
                entity.method_23327(player.method_23317(), player.method_23320() - (double)0.3f, player.method_23321());
                entity.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 1.0f, 1.0f);
                entity.method_7438(ConfigConstructor.moonveil_wave_damage + (float)WeaponUtil.getEnchantDamageBonus(stack) * 0.8f);
                world.method_8649((class_1297)entity);
                world.method_8396(null, user.method_24515(), SoundRegistry.MOONVEIL_HORIZONTAL, class_3419.field_15248, 1.0f, 1.0f);
            }
            stack.method_7956(3, (class_1309)player, p -> p.method_20236(user.method_6058()));
            this.applyItemCooldown(player, (int)ConfigConstructor.moonveil_ability_cooldown);
        }
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_moonveil;
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_moonveil;
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return null;
    }

    @Override
    public int getBleedAmount() {
        return (int)ConfigConstructor.moonveil_bleed_post_hit;
    }
}

