/*
 * Decompiled with CFR 0.152.
 */
package org.spoorn.spoornbountymobs.config;

import draylar.omegaconfig.OmegaConfig;
import draylar.omegaconfig.api.Comment;
import draylar.omegaconfig.api.Config;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spoorn.spoornbountymobs.config.tiers.CommonTierConfig;
import org.spoorn.spoornbountymobs.config.tiers.DoomTierConfig;
import org.spoorn.spoornbountymobs.config.tiers.EpicTierConfig;
import org.spoorn.spoornbountymobs.config.tiers.LegendaryTierConfig;
import org.spoorn.spoornbountymobs.config.tiers.RareTierConfig;
import org.spoorn.spoornbountymobs.config.tiers.UncommonTierConfig;

public class ModConfig
implements Config {
    private static final Logger log = LogManager.getLogger(ModConfig.class);
    private static ModConfig CONFIG;
    @Comment(value="Chance for mob to spawn with a bounty [1/value] [default = 300]")
    public int bountyChance = 300;
    @Comment(value="True if Bounty mobs should glow through walls permanently, else false [default = false]")
    public boolean bountyMobPermanentGlow = false;
    @Comment(value="Duration in seconds Bounty mobs should glow when they are first found if bountyMobPermanentGlow is false [default = 20]")
    public int bountyMobGlowDuration = 20;
    @Comment(value="Player's Bounty Hunter level increments at this value [default = 10]")
    public int playerBountyHunterLevelIntervals = 10;
    @Comment(value="Bonus health for Player per Bounty Hunter level [default = 2 (one heart)]")
    public double playerBonusHealthPerBountyHunterLevel = 2.0;
    @Comment(value="Bonus damage for Player per Bounty Hunter tier [default = 0.5]")
    public double playerBonusDamagePerBountyHunterTier = 0.5;
    @Comment(value="Percentage of player's Bounty score LOST on death [default = 20, min=0, max=100]")
    public double playerDeathBountyScorePenalty = 20.0;
    @Comment(value="Set to false if you don't want potion particle effects on HUD from Bounty mob attacks [default = true]")
    public boolean showBountyParticleEffects = true;
    @Comment(value="Set to false to disable broadcast message when a player is near a bounty mob [default = true]")
    public boolean broadcastMessageWhenBountySpawned = true;
    @Comment(value="Set to false to disable broadcast message when a player kills a bounty mob [default = true]")
    public boolean broadcastMessageWhenPlayerKillBountyMob = true;
    @Comment(value="Set to false to disable broadcast message when a player increases their Bounty Level [default = true]")
    public boolean broadcastMessageWhenBountyLevelUp = true;
    @Comment(value="List of usernames and mob identifiers (case sensitive) to disable broadcast messages for.\nWhen broadcasting if a player killed a bounty mob or increased their bounty level, this list is checked to disable broadcast.\nWhen a bounty mob is spawned or killed, this list is checked against the mob identifier (e.g. \"minecraft:zombie\").\nUseful when other mods add fake players, such as Kibe Utilities' mob farming blocks.")
    public List<String> broadcastDisabled = List.of("fake");
    @Comment(value="Common tier bounty mobs")
    public CommonTierConfig COMMON_TIER = new CommonTierConfig();
    @Comment(value="Uncommon tier bounty mobs")
    public UncommonTierConfig UNCOMMON_TIER = new UncommonTierConfig();
    @Comment(value="Rare tier bounty mobs")
    public RareTierConfig RARE_TIER = new RareTierConfig();
    @Comment(value="Epic tier bounty mobs")
    public EpicTierConfig EPIC_TIER = new EpicTierConfig();
    @Comment(value="Legendary tier bounty mobs")
    public LegendaryTierConfig LEGENDARY_TIER = new LegendaryTierConfig();
    @Comment(value="Doom tier bounty mobs")
    public DoomTierConfig DOOM_TIER = new DoomTierConfig();

    public static void init() {
        CONFIG = (ModConfig)OmegaConfig.register(ModConfig.class);
        if (ModConfig.CONFIG.playerBountyHunterLevelIntervals <= 0) {
            throw new IllegalArgumentException("playerBountyHunterLevelIntervals must be > 0");
        }
    }

    public static ModConfig get() {
        return CONFIG;
    }

    public String getName() {
        return "spoornbountymobs";
    }

    public String getExtension() {
        return "json5";
    }

    public void save() {
        ModConfig.writeConfig(super.getClass(), this);
    }

    public static <T extends Config> void writeConfig(Class<T> configClass, T instance) {
        String json = OmegaConfig.GSON.toJson(instance);
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(json.split("\n")));
        TreeMap<Integer, Object> insertions = new TreeMap<Integer, Object>();
        Map<String, String> keyToComments = ModConfig.populateKeyPathToComments(configClass);
        ArrayDeque<Object> prefix = new ArrayDeque<Object>();
        int currIndent = 1;
        for (int i = 0; i < lines.size(); ++i) {
            String at = (String)lines.get(i);
            String trimmed = at.trim();
            int indents = ModConfig.countGsonIndents(at);
            if (indents <= currIndent && !prefix.isEmpty()) {
                prefix.removeLast();
            }
            if (trimmed.startsWith("\"")) {
                String key = trimmed.substring(1, trimmed.indexOf("\"", 1));
                if (indents >= currIndent) {
                    if (prefix.isEmpty()) {
                        prefix.addLast(key);
                    } else {
                        prefix.addLast((String)prefix.peekLast() + "." + key);
                    }
                }
                String startingWhitespace = "  ".repeat(indents);
                for (Map.Entry<String, String> entry : keyToComments.entrySet()) {
                    Object comment = entry.getValue();
                    if (!entry.getKey().equals(prefix.peekLast())) continue;
                    comment = ((String)comment).contains("\n") ? startingWhitespace + "//" + String.join((CharSequence)String.format("\n%s//", startingWhitespace), ((String)comment).split("\n")) : String.format("%s//%s", startingWhitespace, comment);
                    insertions.put(i + insertions.size(), comment);
                    break;
                }
            }
            currIndent = indents;
        }
        for (Map.Entry entry : insertions.entrySet()) {
            Integer key = (Integer)entry.getKey();
            String value = (String)entry.getValue();
            lines.add(key, value);
        }
        StringBuilder res = new StringBuilder();
        lines.forEach(str -> res.append(String.format("%s%n", str)));
        try {
            Path configPath = OmegaConfig.getConfigPath(instance);
            configPath.toFile().getParentFile().mkdirs();
            Files.write(configPath, res.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException ioException) {
            log.error((Object)ioException);
            log.info(String.format("Write error, using default values for config %s.", configClass));
        }
    }

    public static Map<String, String> populateKeyPathToComments(Class<?> root) {
        HashMap<String, String> keyPathToComments = new HashMap<String, String>();
        ModConfig.populateKeyPathToComments(root, "", keyPathToComments, new HashSet());
        return keyPathToComments;
    }

    public static int countGsonIndents(String s) {
        String indent = "  ";
        int count = 0;
        while (s.startsWith(indent)) {
            ++count;
            s = s.substring(indent.length());
        }
        return count;
    }

    private static void populateKeyPathToComments(Class<?> clazz, String prefix, Map<String, String> keyPathToComments, Set<Class<?>> visited) {
        if (visited.contains(clazz)) {
            return;
        }
        visited.add(clazz);
        for (Field field : clazz.getDeclaredFields()) {
            String comment = ModConfig.getFieldComment(field);
            String key = prefix + field.getName();
            if (comment != null) {
                keyPathToComments.put(key, comment);
            }
            ModConfig.populateKeyPathToComments(field.getType(), key + ".", keyPathToComments, visited);
        }
    }

    private static String getFieldComment(Field field) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = field.getDeclaredAnnotations()) {
            if (!(annotation instanceof Comment)) continue;
            return ((Comment)annotation).value();
        }
        return null;
    }
}

