/*
 * Decompiled with CFR 0.152.
 */
package org.spoorn.spoornbountymobs.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistryV3;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.minecraft.class_124;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.apache.commons.math3.distribution.EnumeratedDistribution;
import org.apache.commons.math3.util.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spoorn.spoornbountymobs.config.Drop;
import org.spoorn.spoornbountymobs.config.ModConfig;
import org.spoorn.spoornbountymobs.entity.component.EntityDataComponent;
import org.spoorn.spoornbountymobs.entity.component.PlayerDataComponent;
import org.spoorn.spoornbountymobs.entity.component.SpoornBountyHostileEntityDataComponent;
import org.spoorn.spoornbountymobs.entity.component.SpoornBountyPlayerDataComponent;
import org.spoorn.spoornbountymobs.tiers.SpoornBountyTier;
import org.spoorn.spoornbountymobs.util.DropDistributionData;
import org.spoorn.spoornbountymobs.util.ItemInfo;
import org.spoorn.spoornbountymobs.util.SpoornBountyMobsUtil;

public class SpoornBountyEntityRegistry
implements EntityComponentInitializer {
    private static final Logger log = LogManager.getLogger(SpoornBountyEntityRegistry.class);
    private static final double ZERO = 0.0;
    private static final double ONE = 1.0;
    private static final class_5250 BROADCAST_1 = class_2561.method_43471((String)"sbm.broadcast.part1").method_27692(class_124.field_1068);
    private static final class_5250 BROADCAST_2 = class_2561.method_43471((String)"sbm.broadcast.part2").method_27692(class_124.field_1068);
    public static final ComponentKey<EntityDataComponent> HOSTILE_ENTITY_DATA = ComponentRegistryV3.INSTANCE.getOrCreate(EntityDataComponent.ID, EntityDataComponent.class);
    public static final ComponentKey<PlayerDataComponent> PLAYER_DATA = ComponentRegistryV3.INSTANCE.getOrCreate(PlayerDataComponent.ID, PlayerDataComponent.class);
    public static final Map<SpoornBountyTier, List<DropDistributionData>> DROP_REGISTRY = new HashMap<SpoornBountyTier, List<DropDistributionData>>();
    public static final Map<String, ItemInfo> CACHED_ITEM_REGISTRY = new HashMap<String, ItemInfo>();
    private static final Set<String> CONFIGURED_DROPS = ConcurrentHashMap.newKeySet();

    public static void init() {
        SpoornBountyEntityRegistry.registerStartTrackingCallback();
        DROP_REGISTRY.clear();
        SpoornBountyEntityRegistry.generateDropRegistry();
        SpoornBountyEntityRegistry.registerServerStartedCallback();
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerFor(class_1588.class, HOSTILE_ENTITY_DATA, SpoornBountyHostileEntityDataComponent::new);
        registry.registerForPlayers(PLAYER_DATA, SpoornBountyPlayerDataComponent::new, RespawnCopyStrategy.ALWAYS_COPY);
    }

    private static void generateDropRegistry() {
        List<Drop> commonDrops = ModConfig.get().COMMON_TIER.drops;
        List<Drop> uncommonDrops = ModConfig.get().UNCOMMON_TIER.drops;
        List<Drop> rareDrops = ModConfig.get().RARE_TIER.drops;
        List<Drop> epicDrops = ModConfig.get().EPIC_TIER.drops;
        List<Drop> legendaryDrops = ModConfig.get().LEGENDARY_TIER.drops;
        List<Drop> doomDrops = ModConfig.get().DOOM_TIER.drops;
        SpoornBountyEntityRegistry.addToDropRegistry(SpoornBountyTier.COMMON, commonDrops);
        SpoornBountyEntityRegistry.addToDropRegistry(SpoornBountyTier.UNCOMMON, uncommonDrops);
        SpoornBountyEntityRegistry.addToDropRegistry(SpoornBountyTier.RARE, rareDrops);
        SpoornBountyEntityRegistry.addToDropRegistry(SpoornBountyTier.EPIC, epicDrops);
        SpoornBountyEntityRegistry.addToDropRegistry(SpoornBountyTier.LEGENDARY, legendaryDrops);
        SpoornBountyEntityRegistry.addToDropRegistry(SpoornBountyTier.DOOM, doomDrops);
    }

    private static void addToDropRegistry(SpoornBountyTier tier, List<Drop> drops) {
        ArrayList<DropDistributionData> dropDists = new ArrayList<DropDistributionData>();
        for (Drop drop : drops) {
            EnumeratedDistribution dropDistribution = new EnumeratedDistribution(drop.items.stream().map(e -> {
                CONFIGURED_DROPS.add(e.item);
                return Pair.create((Object)e.item, (Object)e.weight);
            }).collect(Collectors.toList()));
            Pattern regex = Pattern.compile(drop.entityId);
            dropDists.add(new DropDistributionData(regex, SpoornBountyMobsUtil.bound(drop.dropChance, 0.0, 1.0), Math.max(drop.rolls, 0), (EnumeratedDistribution<String>)dropDistribution));
        }
        DROP_REGISTRY.put(tier, dropDists);
    }

    private static void registerServerStartedCallback() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            for (String item : CONFIGURED_DROPS) {
                Matcher matcher = SpoornBountyMobsUtil.ITEM_REGEX.matcher(item.trim());
                if (!matcher.matches()) {
                    throw new RuntimeException("[SpoornBountyMobs] [SpoornBountyEntityRegistry] Item regex {" + item.trim() + "} is not in a valid format.  Please check the config file at config/spoornbountymobs.json5 for acceptable formats.");
                }
                Pattern regex = Pattern.compile(matcher.group("item"));
                List<class_1792> matchingItems = class_7923.field_41178.method_10220().filter(e -> regex.asMatchPredicate().test(class_7923.field_41178.method_10221(e).toString())).collect(Collectors.toList());
                String countStr = matcher.group("count");
                int count = countStr == null ? 1 : Integer.parseInt(countStr.trim());
                String nbtStr = matcher.group("nbt");
                class_2487 nbtCompound = null;
                if (nbtStr != null) {
                    try {
                        nbtCompound = class_2522.method_10718((String)nbtStr);
                    }
                    catch (CommandSyntaxException e2) {
                        throw new RuntimeException("[SpoornBountyMobs] Could not read Nbt compound from \"" + item + "\"");
                    }
                }
                CACHED_ITEM_REGISTRY.putIfAbsent(item, new ItemInfo(count, matchingItems, nbtCompound));
            }
            CONFIGURED_DROPS.clear();
        });
    }

    private static void registerStartTrackingCallback() {
        EntityTrackingEvents.START_TRACKING.register((trackedEntity, player) -> {
            double spawnChance = ModConfig.get().bountyChance;
            if (spawnChance > 0.0 && SpoornBountyMobsUtil.isHostileEntity(trackedEntity)) {
                class_1588 hostileEntity = (class_1588)trackedEntity;
                EntityDataComponent component = SpoornBountyMobsUtil.getSpoornEntityDataComponent((class_1297)hostileEntity);
                if (!component.hasTracked() && (double)SpoornBountyMobsUtil.RANDOM.nextFloat() < 1.0 / (double)ModConfig.get().bountyChance) {
                    component.setHasBounty(true);
                    component.setBonusBountyLevelHealth(SpoornBountyMobsUtil.getHealthIncreaseFromBountyScore((class_1657)player, (class_1297)hostileEntity));
                    SpoornBountyTier tier = (SpoornBountyTier)SpoornBountyMobsUtil.SPOORN_BOUNTY_TIERS.sample();
                    component.setSpoornBountyTier(tier);
                    if (SpoornBountyMobsUtil.RANDOM.nextFloat() < tier.getChanceWeaknessAttack()) {
                        component.setHasWeaknessAttack(true);
                    }
                    if (SpoornBountyMobsUtil.RANDOM.nextFloat() < tier.getChanceWitherAttack()) {
                        component.setHasWitherAttack(true);
                    }
                    if (SpoornBountyMobsUtil.RANDOM.nextFloat() < tier.getChanceBlindnessAttack()) {
                        component.setHasBlindnessAttack(true);
                    }
                    if (SpoornBountyMobsUtil.RANDOM.nextFloat() < tier.getChancePoisonAttack()) {
                        component.setHasPoisonAttack(true);
                    }
                    if (SpoornBountyMobsUtil.RANDOM.nextFloat() < tier.getChanceSlownessAttack()) {
                        component.setHasSlownessAttack(true);
                    }
                    if (SpoornBountyMobsUtil.RANDOM.nextFloat() < tier.getChanceHungerAttack()) {
                        component.setHasHungerAttack(true);
                    }
                    if (SpoornBountyMobsUtil.RANDOM.nextFloat() < tier.getChanceBurningAttack()) {
                        component.setHasBurningAttack(true);
                    }
                    HOSTILE_ENTITY_DATA.sync((Object)hostileEntity);
                    hostileEntity.method_18382();
                    hostileEntity.method_6033(hostileEntity.method_6063());
                    int glowDuration = ModConfig.get().bountyMobPermanentGlow ? Integer.MAX_VALUE : ModConfig.get().bountyMobGlowDuration * 20;
                    hostileEntity.method_6092(SpoornBountyMobsUtil.getStatusEffectInstance(class_1294.field_5912, glowDuration, 0));
                    if (SpoornBountyMobsUtil.RANDOM.nextFloat() < tier.getChanceResistance()) {
                        hostileEntity.method_6092(SpoornBountyMobsUtil.getStatusEffectInstanceMaxDuration(class_1294.field_5907, 1));
                    }
                    if (SpoornBountyMobsUtil.RANDOM.nextFloat() < tier.getChanceRegeneration()) {
                        hostileEntity.method_6092(SpoornBountyMobsUtil.getStatusEffectInstanceMaxDuration(class_1294.field_5924, 1));
                    }
                    if (SpoornBountyMobsUtil.RANDOM.nextFloat() < tier.getChanceSpeed()) {
                        hostileEntity.method_6092(SpoornBountyMobsUtil.getStatusEffectInstanceMaxDuration(class_1294.field_5904, 1));
                    }
                    try {
                        String playerName;
                        List<String> broadcastDisabled;
                        if (ModConfig.get().broadcastMessageWhenBountySpawned && !(broadcastDisabled = ModConfig.get().broadcastDisabled).contains(playerName = player.method_5476().getString()) && !broadcastDisabled.contains(class_7923.field_41177.method_10221((Object)hostileEntity.method_5864()).toString())) {
                            class_5250 playerpart = class_2561.method_43470((String)playerName).method_27692(class_124.field_1062);
                            class_5250 tierpart = class_2561.method_43470((String)tier.getTierType().getName()).method_27695(tier.getTierType().getFormattings());
                            class_5250 mobpart = class_2561.method_43471((String)hostileEntity.method_5476().getString()).method_27692(class_124.field_1077);
                            player.method_5682().method_3760().method_43514((class_2561)playerpart.method_10852((class_2561)BROADCAST_1).method_10852((class_2561)tierpart).method_10852((class_2561)BROADCAST_2).method_10852((class_2561)mobpart), false);
                        }
                    }
                    catch (Exception e) {
                        log.error("Exception while trying to broadcast message for SpoornBountyMobs", (Throwable)e);
                    }
                }
                component.track();
            }
        });
    }
}

