/*
 * Decompiled with CFR 0.152.
 */
package org.spoorn.spoornbountymobs.entity.component;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import org.spoorn.spoornbountymobs.config.ModConfig;
import org.spoorn.spoornbountymobs.entity.component.PlayerDataComponent;
import org.spoorn.spoornbountymobs.tiers.SpoornBountyTier;
import org.spoorn.spoornbountymobs.util.SpoornBountyMobsUtil;

public class SpoornBountyPlayerDataComponent
implements PlayerDataComponent,
AutoSyncedComponent {
    private static final String COMMON_COUNT = "commonKillCount";
    private static final String UNCOMMON_COUNT = "uncommonKillCount";
    private static final String RARE_COUNT = "rareKillCount";
    private static final String EPIC_COUNT = "epicKillCount";
    private static final String LEGENDARY_COUNT = "legendaryKillCount";
    private static final String DOOM_COUNT = "doomKillCount";
    private static final String BOUNTY_SCORE = "bountyScore";
    private static final String HIGHEST_BOUNTY_HUNTER_TIER = "highestBountyTier";
    private Object provider;
    private int commonKillCount;
    private int uncommonKillCount;
    private int rareKillCount;
    private int epicKillCount;
    private int legendaryKillCount;
    private int doomKillCount;
    private double bountyScore;
    private int highestBountyHunterLevel;

    public SpoornBountyPlayerDataComponent(Object provider) {
        this.provider = provider;
    }

    @Override
    public void incrementBountyKillCount(SpoornBountyTier spoornBountyTier) {
        switch (spoornBountyTier.getTierType()) {
            case COMMON_TIER: {
                ++this.commonKillCount;
                this.bountyScore += SpoornBountyTier.COMMON.getBountyScoreScale();
                break;
            }
            case UNCOMMON_TIER: {
                ++this.uncommonKillCount;
                this.bountyScore += SpoornBountyTier.UNCOMMON.getBountyScoreScale();
                break;
            }
            case RARE_TIER: {
                ++this.rareKillCount;
                this.bountyScore += SpoornBountyTier.RARE.getBountyScoreScale();
                break;
            }
            case EPIC_TIER: {
                ++this.epicKillCount;
                this.bountyScore += SpoornBountyTier.EPIC.getBountyScoreScale();
                break;
            }
            case LEGENDARY_TIER: {
                ++this.legendaryKillCount;
                this.bountyScore += SpoornBountyTier.LEGENDARY.getBountyScoreScale();
                break;
            }
            case DOOM_TIER: {
                ++this.doomKillCount;
                this.bountyScore += SpoornBountyTier.DOOM.getBountyScoreScale();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + spoornBountyTier.getTierType());
            }
        }
    }

    public void readFromNbt(class_2487 tag) {
        this.commonKillCount = tag.method_10550(COMMON_COUNT);
        this.uncommonKillCount = tag.method_10550(UNCOMMON_COUNT);
        this.rareKillCount = tag.method_10550(RARE_COUNT);
        this.epicKillCount = tag.method_10550(EPIC_COUNT);
        this.legendaryKillCount = tag.method_10550(LEGENDARY_COUNT);
        this.doomKillCount = tag.method_10550(DOOM_COUNT);
        this.bountyScore = tag.method_10574(BOUNTY_SCORE);
        this.highestBountyHunterLevel = tag.method_10550(HIGHEST_BOUNTY_HUNTER_TIER);
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10569(COMMON_COUNT, this.commonKillCount);
        tag.method_10569(UNCOMMON_COUNT, this.uncommonKillCount);
        tag.method_10569(RARE_COUNT, this.rareKillCount);
        tag.method_10569(EPIC_COUNT, this.epicKillCount);
        tag.method_10569(LEGENDARY_COUNT, this.legendaryKillCount);
        tag.method_10569(DOOM_COUNT, this.doomKillCount);
        tag.method_10549(BOUNTY_SCORE, this.bountyScore);
        tag.method_10569(HIGHEST_BOUNTY_HUNTER_TIER, this.highestBountyHunterLevel);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(((class_1657)this.provider).method_5476().getString());
        stringBuilder.append("(commonKillCount=");
        stringBuilder.append(this.commonKillCount);
        stringBuilder.append(", uncommonKillCount=");
        stringBuilder.append(this.uncommonKillCount);
        stringBuilder.append(", rareKillCount=");
        stringBuilder.append(this.rareKillCount);
        stringBuilder.append(", epicKillCount=");
        stringBuilder.append(this.epicKillCount);
        stringBuilder.append(", legendaryKillCount=");
        stringBuilder.append(this.legendaryKillCount);
        stringBuilder.append(", doomKillCount=");
        stringBuilder.append(this.doomKillCount);
        stringBuilder.append(", bountyScore=");
        stringBuilder.append(this.bountyScore);
        stringBuilder.append(", highestBountyHunterLevel=");
        stringBuilder.append(this.highestBountyHunterLevel);
        stringBuilder.append(", currentBountyHunterLevel=");
        stringBuilder.append(SpoornBountyMobsUtil.getBountyHunterLevel((class_1657)this.provider));
        stringBuilder.append(", bonusHealth=");
        stringBuilder.append((float)ModConfig.get().playerBonusHealthPerBountyHunterLevel * (float)this.highestBountyHunterLevel);
        stringBuilder.append(", bonusDamage=");
        stringBuilder.append(SpoornBountyMobsUtil.getPlayerBonusDamage((class_1657)this.provider));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public int getCommonKillCount() {
        return this.commonKillCount;
    }

    @Override
    public int getUncommonKillCount() {
        return this.uncommonKillCount;
    }

    @Override
    public int getRareKillCount() {
        return this.rareKillCount;
    }

    @Override
    public int getEpicKillCount() {
        return this.epicKillCount;
    }

    @Override
    public int getLegendaryKillCount() {
        return this.legendaryKillCount;
    }

    @Override
    public int getDoomKillCount() {
        return this.doomKillCount;
    }

    @Override
    public double getBountyScore() {
        return this.bountyScore;
    }

    @Override
    public void setBountyScore(double bountyScore) {
        this.bountyScore = bountyScore;
    }

    @Override
    public int getHighestBountyHunterLevel() {
        return this.highestBountyHunterLevel;
    }

    @Override
    public void setHighestBountyHunterLevel(int highestBountyHunterLevel) {
        this.highestBountyHunterLevel = highestBountyHunterLevel;
    }
}

