/*
 * Decompiled with CFR 0.152.
 */
package org.spoorn.spoornbountymobs.mixin;

import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spoorn.spoornbountymobs.entity.SpoornBountyEntityRegistry;
import org.spoorn.spoornbountymobs.entity.component.EntityDataComponent;
import org.spoorn.spoornbountymobs.util.SpoornBountyMobsUtil;

@Mixin(value={class_1297.class})
public abstract class EntityMixin {
    private Logger log = LogManager.getLogger((String)"SpoornBountyMobsEntityMixin");
    @Shadow
    private class_4048 field_18065;
    @Shadow
    private class_238 field_6005;

    @Shadow
    public abstract void method_5857(class_238 var1);

    @Shadow
    protected abstract boolean method_5629(class_238 var1);

    @Inject(method={"getDimensions"}, at={@At(value="TAIL")}, cancellable=true)
    private void resizeEntity(class_4050 pose, CallbackInfoReturnable<class_4048> cir) {
        EntityDataComponent entityDataComponent;
        float scale;
        class_1297 entity = (class_1297)this;
        if (SpoornBountyMobsUtil.entityIsHostileAndHasBounty(entity) && (scale = (entityDataComponent = SpoornBountyMobsUtil.getSpoornEntityDataComponent(entity)).getSpoornBountyTier().getMobSizeScale()) > 1.0f) {
            class_4048 dimensions = (class_4048)cir.getReturnValue();
            class_4048 newDimensions = dimensions.method_19539(scale, scale);
            class_238 box = this.field_6005;
            double distX = box.field_1320 - box.field_1323;
            double diffX = distX / 2.0 * (double)scale - distX / 2.0;
            double distZ = box.field_1324 - box.field_1321;
            double diffZ = distZ / 2.0 * (double)scale - distZ / 2.0;
            class_238 newBox = new class_238(box.field_1323 - diffX, box.field_1322, box.field_1321 - diffZ, box.field_1320 + diffX, box.field_1322 + (double)newDimensions.field_18068, box.field_1324 + diffZ);
            if (this.method_5629(newBox)) {
                this.method_5857(newBox);
                this.field_18065 = newDimensions;
                cir.setReturnValue((Object)newDimensions);
                cir.cancel();
            } else {
                entityDataComponent.setSpoornBountyTier(entityDataComponent.getSpoornBountyTier().toBuilder().mobSizeScale(1.0f).build());
                SpoornBountyEntityRegistry.HOSTILE_ENTITY_DATA.sync((Object)entity);
                this.log.warn("Entity {} could not increase scale as it collides with terrain/entities.", (Object)entity);
            }
        }
    }

    @Inject(method={"applyDamageEffects"}, at={@At(value="TAIL")})
    public void applyStatusEffects(class_1309 attacker, class_1297 target, CallbackInfo ci) {
        if (target instanceof class_1309 && SpoornBountyMobsUtil.entityIsHostileAndHasBounty((class_1297)attacker)) {
            EntityDataComponent component = SpoornBountyMobsUtil.getSpoornEntityDataComponent((class_1297)attacker);
            class_1309 livingEntity = (class_1309)target;
            if (component.hasWeaknessAttack()) {
                livingEntity.method_6092(SpoornBountyMobsUtil.getStatusEffectInstance(class_1294.field_5911, 100, 1));
            }
            if (component.hasWitherAttack()) {
                livingEntity.method_6092(SpoornBountyMobsUtil.getStatusEffectInstance(class_1294.field_5920, 100, 1));
            }
            if (component.hasBlindnessAttack()) {
                livingEntity.method_6092(SpoornBountyMobsUtil.getStatusEffectInstance(class_1294.field_5919, 100, 1));
            }
            if (component.hasPoisonAttack()) {
                livingEntity.method_6092(SpoornBountyMobsUtil.getStatusEffectInstance(class_1294.field_5899, 100, 1));
            }
            if (component.hasSlownessAttack()) {
                livingEntity.method_6092(SpoornBountyMobsUtil.getStatusEffectInstance(class_1294.field_5909, 100, 1));
            }
            if (component.hasHungerAttack()) {
                livingEntity.method_6092(SpoornBountyMobsUtil.getStatusEffectInstance(class_1294.field_5903, 100, 1));
            }
            if (component.hasBurningAttack()) {
                livingEntity.method_5639(5);
            }
        }
    }
}

