/*
 * Decompiled with CFR 0.152.
 */
package org.spoorn.spoornbountymobs.mixin;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spoorn.spoornbountymobs.config.ModConfig;
import org.spoorn.spoornbountymobs.entity.SpoornBountyEntityRegistry;
import org.spoorn.spoornbountymobs.entity.component.EntityDataComponent;
import org.spoorn.spoornbountymobs.entity.component.PlayerDataComponent;
import org.spoorn.spoornbountymobs.tiers.SpoornBountyTier;
import org.spoorn.spoornbountymobs.util.DropDistributionData;
import org.spoorn.spoornbountymobs.util.ItemInfo;
import org.spoorn.spoornbountymobs.util.SpoornBountyMobsUtil;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin {
    private static final class_5250 BROADCAST = class_2561.method_43471((String)"sbm.broadcast.levelup").method_27692(class_124.field_1068);
    private static final class_5250 TAKEDOWN_BROADCAST_1 = class_2561.method_43471((String)"sbm.broadcast.playerkillbounty.part1").method_27692(class_124.field_1068);
    private static final class_5250 TAKEDOWN_BROADCAST_2 = class_2561.method_43471((String)"sbm.broadcast.playerkillbounty.part2").method_27692(class_124.field_1068);

    @Inject(method={"onKilledOther"}, at={@At(value="TAIL")})
    public void incrementBountyCount(class_3218 world, class_1309 other, CallbackInfoReturnable<Boolean> cir) {
        if (SpoornBountyMobsUtil.entityIsHostileAndHasBounty((class_1297)other)) {
            List<DropDistributionData> allDropDists;
            String entityId;
            SpoornBountyTier tier;
            List<DropDistributionData> filteredDropDists;
            class_1657 player = (class_1657)this;
            EntityDataComponent entityDataComponent = SpoornBountyMobsUtil.getSpoornEntityDataComponent((class_1297)other);
            PlayerDataComponent playerDataComponent = SpoornBountyMobsUtil.getPlayerDataComponent(player);
            playerDataComponent.incrementBountyKillCount(entityDataComponent.getSpoornBountyTier());
            int highestLevel = playerDataComponent.getHighestBountyHunterLevel();
            int currLevel = SpoornBountyMobsUtil.getBountyHunterLevel(player);
            if (currLevel > highestLevel) {
                playerDataComponent.setHighestBountyHunterLevel(currLevel);
                try {
                    String playerName;
                    List<String> broadcastDisabled;
                    if (ModConfig.get().broadcastMessageWhenBountyLevelUp && !(broadcastDisabled = ModConfig.get().broadcastDisabled).contains(playerName = player.method_5476().getString())) {
                        class_5250 playerpart = class_2561.method_43470((String)playerName).method_27692(class_124.field_1062);
                        class_5250 levelpart = class_2561.method_43470((String)Integer.toString(currLevel)).method_27692(class_124.field_1076);
                        player.method_5682().method_3760().method_43514((class_2561)playerpart.method_10852((class_2561)BROADCAST).method_10852((class_2561)levelpart), false);
                    }
                }
                catch (Exception e) {
                    System.err.println("[SpoornBountyMobs] Error broadcasting SpoornBountyMobs level up: " + e);
                }
            }
            if (!(filteredDropDists = SpoornBountyMobsUtil.filterPatternInMap(tier = entityDataComponent.getSpoornBountyTier(), entityId = class_7923.field_41177.method_10221((Object)other.method_5864()).toString(), allDropDists = SpoornBountyEntityRegistry.DROP_REGISTRY.get(tier))).isEmpty()) {
                for (int k = 0; k < filteredDropDists.size(); ++k) {
                    DropDistributionData dropDist = filteredDropDists.get(k);
                    for (int i = 0; i < dropDist.rolls; ++i) {
                        if (!(SpoornBountyMobsUtil.RANDOM.nextDouble() < dropDist.dropChance)) continue;
                        String sampledItemRegex = (String)dropDist.itemDrops.sample();
                        ItemInfo itemInfo = SpoornBountyEntityRegistry.CACHED_ITEM_REGISTRY.get(sampledItemRegex);
                        List<class_1792> matchingItems = itemInfo.items;
                        if (matchingItems == null || matchingItems.isEmpty()) {
                            System.err.println("[SpoornBountyMobs] Configuration specified item \"" + sampledItemRegex + "\" did not match any item in the registry!  Did you configure SpoornBountyMobs drops correctly?");
                            continue;
                        }
                        class_1792 itemToDrop = SpoornBountyMobsUtil.sampleFromList(matchingItems);
                        class_1799 itemStackToDrop = new class_1799((class_1935)itemToDrop, itemInfo.count);
                        if (itemInfo.nbt != null) {
                            itemStackToDrop.method_7980(itemInfo.nbt);
                        }
                        other.method_5775(itemStackToDrop);
                    }
                }
            }
            SpoornBountyEntityRegistry.PLAYER_DATA.sync((Object)player);
            if (ModConfig.get().broadcastMessageWhenPlayerKillBountyMob) {
                try {
                    String playerName = player.method_5476().getString();
                    List<String> broadcastDisabled = ModConfig.get().broadcastDisabled;
                    if (!broadcastDisabled.contains(playerName) && !broadcastDisabled.contains(class_7923.field_41177.method_10221((Object)other.method_5864()).toString())) {
                        class_5250 playerpart = class_2561.method_43470((String)playerName).method_27692(class_124.field_1062);
                        class_5250 tierpart = class_2561.method_43470((String)tier.getTierType().getName()).method_27695(tier.getTierType().getFormattings());
                        class_5250 mobpart = class_2561.method_43471((String)other.method_5476().getString()).method_27692(class_124.field_1077);
                        player.method_5682().method_3760().method_43514((class_2561)playerpart.method_10852((class_2561)TAKEDOWN_BROADCAST_1).method_10852((class_2561)tierpart).method_10852((class_2561)TAKEDOWN_BROADCAST_2).method_10852((class_2561)mobpart), false);
                    }
                }
                catch (Exception e) {
                    System.err.println("Exception while trying to broadcast player killed bounty mob message for SpoornBountyMobs: " + e);
                }
            }
        }
    }
}

