/*
 * Decompiled with CFR 0.152.
 */
package org.spoorn.spoornbountymobs.tiers;

import org.spoorn.spoornbountymobs.config.ModConfig;
import org.spoorn.spoornbountymobs.config.tiers.CommonTierConfig;
import org.spoorn.spoornbountymobs.config.tiers.DoomTierConfig;
import org.spoorn.spoornbountymobs.config.tiers.EpicTierConfig;
import org.spoorn.spoornbountymobs.config.tiers.LegendaryTierConfig;
import org.spoorn.spoornbountymobs.config.tiers.RareTierConfig;
import org.spoorn.spoornbountymobs.config.tiers.UncommonTierConfig;
import org.spoorn.spoornbountymobs.tiers.SpoornBountyTierTypes;

public final class SpoornBountyTier {
    public static SpoornBountyTier COMMON;
    public static SpoornBountyTier UNCOMMON;
    public static SpoornBountyTier RARE;
    public static SpoornBountyTier EPIC;
    public static SpoornBountyTier LEGENDARY;
    public static SpoornBountyTier DOOM;
    private SpoornBountyTierTypes tierType;
    private double weight;
    private float mobSizeScale;
    private int glowColor;
    private double bountyScoreScale;
    private float maxBaseHealthIncrease;
    private int experienceScale;
    private double minBaseDamageIncrease;
    private double maxBaseDamageIncrease;
    private double milestoneDamageIncrease;
    private float chanceWeaknessAttack;
    private float chanceWitherAttack;
    private float chanceBlindnessAttack;
    private float chancePoisonAttack;
    private float chanceSlownessAttack;
    private float chanceHungerAttack;
    private float chanceBurningAttack;
    private float chanceResistance;
    private float chanceRegeneration;
    private float chanceSpeed;

    public static void init() {
        CommonTierConfig commonConfig = ModConfig.get().COMMON_TIER;
        UncommonTierConfig uncommonConfig = ModConfig.get().UNCOMMON_TIER;
        RareTierConfig rareConfig = ModConfig.get().RARE_TIER;
        EpicTierConfig epicConfig = ModConfig.get().EPIC_TIER;
        LegendaryTierConfig legendaryConfig = ModConfig.get().LEGENDARY_TIER;
        DoomTierConfig doomConfig = ModConfig.get().DOOM_TIER;
        COMMON = new SpoornBountyTier(SpoornBountyTierTypes.COMMON_TIER, commonConfig.spawnChance, (float)commonConfig.mobSizeScale, commonConfig.glowColor, 1.0, commonConfig.baseBonusHealth, commonConfig.experienceScale, 0.0, 1.0, commonConfig.milestoneDamageIncrease, 0.1f, 0.05f, 0.0f, 0.1f, 0.1f, 0.05f, 0.0f, 0.0f, 0.0f, 0.0f);
        UNCOMMON = new SpoornBountyTier(SpoornBountyTierTypes.UNCOMMON_TIER, uncommonConfig.spawnChance, (float)uncommonConfig.mobSizeScale, uncommonConfig.glowColor, 2.0, uncommonConfig.baseBonusHealth, uncommonConfig.experienceScale, 1.0, 2.0, uncommonConfig.milestoneDamageIncrease, 0.15f, 0.1f, 0.0f, 0.1f, 0.1f, 0.05f, 0.0f, 0.1f, 0.1f, 0.05f);
        RARE = new SpoornBountyTier(SpoornBountyTierTypes.RARE_TIER, rareConfig.spawnChance, (float)rareConfig.mobSizeScale, rareConfig.glowColor, 4.0, rareConfig.baseBonusHealth, rareConfig.experienceScale, 2.0, 3.0, rareConfig.milestoneDamageIncrease, 0.2f, 0.15f, 0.05f, 0.15f, 0.15f, 0.1f, 0.0f, 0.15f, 0.15f, 0.1f);
        EPIC = new SpoornBountyTier(SpoornBountyTierTypes.EPIC_TIER, epicConfig.spawnChance, (float)epicConfig.mobSizeScale, epicConfig.glowColor, 5.0, epicConfig.baseBonusHealth, epicConfig.experienceScale, 3.0, 4.0, epicConfig.milestoneDamageIncrease, 0.2f, 0.2f, 0.1f, 0.2f, 0.2f, 0.15f, 0.0f, 0.2f, 0.2f, 0.15f);
        LEGENDARY = new SpoornBountyTier(SpoornBountyTierTypes.LEGENDARY_TIER, legendaryConfig.spawnChance, (float)legendaryConfig.mobSizeScale, legendaryConfig.glowColor, 7.0, legendaryConfig.baseBonusHealth, legendaryConfig.experienceScale, 4.0, 5.0, legendaryConfig.milestoneDamageIncrease, 0.25f, 0.25f, 0.1f, 0.25f, 0.2f, 0.2f, 0.0f, 0.25f, 0.25f, 0.2f);
        DOOM = new SpoornBountyTier(SpoornBountyTierTypes.DOOM_TIER, doomConfig.spawnChance, (float)doomConfig.mobSizeScale, doomConfig.glowColor, 8.0, doomConfig.baseBonusHealth, doomConfig.experienceScale, 5.0, 6.0, doomConfig.milestoneDamageIncrease, 0.3f, 0.3f, 0.15f, 0.3f, 0.3f, 0.3f, 0.2f, 0.3f, 0.3f, 0.25f);
    }

    public static SpoornBountyTier fromValue(SpoornBountyTierTypes spoornBountyTierTypes) {
        switch (spoornBountyTierTypes) {
            case COMMON_TIER: {
                return COMMON;
            }
            case UNCOMMON_TIER: {
                return UNCOMMON;
            }
            case RARE_TIER: {
                return RARE;
            }
            case EPIC_TIER: {
                return EPIC;
            }
            case LEGENDARY_TIER: {
                return LEGENDARY;
            }
            case DOOM_TIER: {
                return DOOM;
            }
        }
        return COMMON;
    }

    public static SpoornBountyTierBuilder builder() {
        return new SpoornBountyTierBuilder();
    }

    public SpoornBountyTierBuilder toBuilder() {
        return new SpoornBountyTierBuilder().tierType(this.tierType).weight(this.weight).mobSizeScale(this.mobSizeScale).glowColor(this.glowColor).bountyScoreScale(this.bountyScoreScale).maxBaseHealthIncrease(this.maxBaseHealthIncrease).experienceScale(this.experienceScale).minBaseDamageIncrease(this.minBaseDamageIncrease).maxBaseDamageIncrease(this.maxBaseDamageIncrease).milestoneDamageIncrease(this.milestoneDamageIncrease).chanceWeaknessAttack(this.chanceWeaknessAttack).chanceWitherAttack(this.chanceWitherAttack).chanceBlindnessAttack(this.chanceBlindnessAttack).chancePoisonAttack(this.chancePoisonAttack).chanceSlownessAttack(this.chanceSlownessAttack).chanceHungerAttack(this.chanceHungerAttack).chanceBurningAttack(this.chanceBurningAttack).chanceResistance(this.chanceResistance).chanceRegeneration(this.chanceRegeneration).chanceSpeed(this.chanceSpeed);
    }

    public SpoornBountyTier(SpoornBountyTierTypes tierType, double weight, float mobSizeScale, int glowColor, double bountyScoreScale, float maxBaseHealthIncrease, int experienceScale, double minBaseDamageIncrease, double maxBaseDamageIncrease, double milestoneDamageIncrease, float chanceWeaknessAttack, float chanceWitherAttack, float chanceBlindnessAttack, float chancePoisonAttack, float chanceSlownessAttack, float chanceHungerAttack, float chanceBurningAttack, float chanceResistance, float chanceRegeneration, float chanceSpeed) {
        this.tierType = tierType;
        this.weight = weight;
        this.mobSizeScale = mobSizeScale;
        this.glowColor = glowColor;
        this.bountyScoreScale = bountyScoreScale;
        this.maxBaseHealthIncrease = maxBaseHealthIncrease;
        this.experienceScale = experienceScale;
        this.minBaseDamageIncrease = minBaseDamageIncrease;
        this.maxBaseDamageIncrease = maxBaseDamageIncrease;
        this.milestoneDamageIncrease = milestoneDamageIncrease;
        this.chanceWeaknessAttack = chanceWeaknessAttack;
        this.chanceWitherAttack = chanceWitherAttack;
        this.chanceBlindnessAttack = chanceBlindnessAttack;
        this.chancePoisonAttack = chancePoisonAttack;
        this.chanceSlownessAttack = chanceSlownessAttack;
        this.chanceHungerAttack = chanceHungerAttack;
        this.chanceBurningAttack = chanceBurningAttack;
        this.chanceResistance = chanceResistance;
        this.chanceRegeneration = chanceRegeneration;
        this.chanceSpeed = chanceSpeed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpoornBountyTier)) {
            return false;
        }
        SpoornBountyTier other = (SpoornBountyTier)o;
        if (Double.compare(this.getWeight(), other.getWeight()) != 0) {
            return false;
        }
        if (this.getGlowColor() != other.getGlowColor()) {
            return false;
        }
        if (Double.compare(this.getBountyScoreScale(), other.getBountyScoreScale()) != 0) {
            return false;
        }
        if (Float.compare(this.getMaxBaseHealthIncrease(), other.getMaxBaseHealthIncrease()) != 0) {
            return false;
        }
        if (this.getExperienceScale() != other.getExperienceScale()) {
            return false;
        }
        if (Double.compare(this.getMinBaseDamageIncrease(), other.getMinBaseDamageIncrease()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxBaseDamageIncrease(), other.getMaxBaseDamageIncrease()) != 0) {
            return false;
        }
        if (Double.compare(this.getMilestoneDamageIncrease(), other.getMilestoneDamageIncrease()) != 0) {
            return false;
        }
        if (Float.compare(this.getChanceWeaknessAttack(), other.getChanceWeaknessAttack()) != 0) {
            return false;
        }
        if (Float.compare(this.getChanceWitherAttack(), other.getChanceWitherAttack()) != 0) {
            return false;
        }
        if (Float.compare(this.getChanceBlindnessAttack(), other.getChanceBlindnessAttack()) != 0) {
            return false;
        }
        if (Float.compare(this.getChancePoisonAttack(), other.getChancePoisonAttack()) != 0) {
            return false;
        }
        if (Float.compare(this.getChanceSlownessAttack(), other.getChanceSlownessAttack()) != 0) {
            return false;
        }
        if (Float.compare(this.getChanceHungerAttack(), other.getChanceHungerAttack()) != 0) {
            return false;
        }
        if (Float.compare(this.getChanceBurningAttack(), other.getChanceBurningAttack()) != 0) {
            return false;
        }
        if (Float.compare(this.getChanceResistance(), other.getChanceResistance()) != 0) {
            return false;
        }
        if (Float.compare(this.getChanceRegeneration(), other.getChanceRegeneration()) != 0) {
            return false;
        }
        if (Float.compare(this.getChanceSpeed(), other.getChanceSpeed()) != 0) {
            return false;
        }
        SpoornBountyTierTypes this$tierType = this.getTierType();
        SpoornBountyTierTypes other$tierType = other.getTierType();
        return !(this$tierType == null ? other$tierType != null : !((Object)((Object)this$tierType)).equals((Object)other$tierType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $weight = Double.doubleToLongBits(this.getWeight());
        result = result * 59 + (int)($weight >>> 32 ^ $weight);
        result = result * 59 + this.getGlowColor();
        long $bountyScoreScale = Double.doubleToLongBits(this.getBountyScoreScale());
        result = result * 59 + (int)($bountyScoreScale >>> 32 ^ $bountyScoreScale);
        result = result * 59 + Float.floatToIntBits(this.getMaxBaseHealthIncrease());
        result = result * 59 + this.getExperienceScale();
        long $minBaseDamageIncrease = Double.doubleToLongBits(this.getMinBaseDamageIncrease());
        result = result * 59 + (int)($minBaseDamageIncrease >>> 32 ^ $minBaseDamageIncrease);
        long $maxBaseDamageIncrease = Double.doubleToLongBits(this.getMaxBaseDamageIncrease());
        result = result * 59 + (int)($maxBaseDamageIncrease >>> 32 ^ $maxBaseDamageIncrease);
        long $milestoneDamageIncrease = Double.doubleToLongBits(this.getMilestoneDamageIncrease());
        result = result * 59 + (int)($milestoneDamageIncrease >>> 32 ^ $milestoneDamageIncrease);
        result = result * 59 + Float.floatToIntBits(this.getChanceWeaknessAttack());
        result = result * 59 + Float.floatToIntBits(this.getChanceWitherAttack());
        result = result * 59 + Float.floatToIntBits(this.getChanceBlindnessAttack());
        result = result * 59 + Float.floatToIntBits(this.getChancePoisonAttack());
        result = result * 59 + Float.floatToIntBits(this.getChanceSlownessAttack());
        result = result * 59 + Float.floatToIntBits(this.getChanceHungerAttack());
        result = result * 59 + Float.floatToIntBits(this.getChanceBurningAttack());
        result = result * 59 + Float.floatToIntBits(this.getChanceResistance());
        result = result * 59 + Float.floatToIntBits(this.getChanceRegeneration());
        result = result * 59 + Float.floatToIntBits(this.getChanceSpeed());
        SpoornBountyTierTypes $tierType = this.getTierType();
        result = result * 59 + ($tierType == null ? 43 : ((Object)((Object)$tierType)).hashCode());
        return result;
    }

    public String toString() {
        return "SpoornBountyTier(tierType=" + this.getTierType() + ", weight=" + this.getWeight() + ", mobSizeScale=" + this.getMobSizeScale() + ", glowColor=" + this.getGlowColor() + ", bountyScoreScale=" + this.getBountyScoreScale() + ", maxBaseHealthIncrease=" + this.getMaxBaseHealthIncrease() + ", experienceScale=" + this.getExperienceScale() + ", minBaseDamageIncrease=" + this.getMinBaseDamageIncrease() + ", maxBaseDamageIncrease=" + this.getMaxBaseDamageIncrease() + ", milestoneDamageIncrease=" + this.getMilestoneDamageIncrease() + ", chanceWeaknessAttack=" + this.getChanceWeaknessAttack() + ", chanceWitherAttack=" + this.getChanceWitherAttack() + ", chanceBlindnessAttack=" + this.getChanceBlindnessAttack() + ", chancePoisonAttack=" + this.getChancePoisonAttack() + ", chanceSlownessAttack=" + this.getChanceSlownessAttack() + ", chanceHungerAttack=" + this.getChanceHungerAttack() + ", chanceBurningAttack=" + this.getChanceBurningAttack() + ", chanceResistance=" + this.getChanceResistance() + ", chanceRegeneration=" + this.getChanceRegeneration() + ", chanceSpeed=" + this.getChanceSpeed() + ")";
    }

    public SpoornBountyTierTypes getTierType() {
        return this.tierType;
    }

    public double getWeight() {
        return this.weight;
    }

    public float getMobSizeScale() {
        return this.mobSizeScale;
    }

    public int getGlowColor() {
        return this.glowColor;
    }

    public double getBountyScoreScale() {
        return this.bountyScoreScale;
    }

    public float getMaxBaseHealthIncrease() {
        return this.maxBaseHealthIncrease;
    }

    public int getExperienceScale() {
        return this.experienceScale;
    }

    public double getMinBaseDamageIncrease() {
        return this.minBaseDamageIncrease;
    }

    public double getMaxBaseDamageIncrease() {
        return this.maxBaseDamageIncrease;
    }

    public double getMilestoneDamageIncrease() {
        return this.milestoneDamageIncrease;
    }

    public float getChanceWeaknessAttack() {
        return this.chanceWeaknessAttack;
    }

    public float getChanceWitherAttack() {
        return this.chanceWitherAttack;
    }

    public float getChanceBlindnessAttack() {
        return this.chanceBlindnessAttack;
    }

    public float getChancePoisonAttack() {
        return this.chancePoisonAttack;
    }

    public float getChanceSlownessAttack() {
        return this.chanceSlownessAttack;
    }

    public float getChanceHungerAttack() {
        return this.chanceHungerAttack;
    }

    public float getChanceBurningAttack() {
        return this.chanceBurningAttack;
    }

    public float getChanceResistance() {
        return this.chanceResistance;
    }

    public float getChanceRegeneration() {
        return this.chanceRegeneration;
    }

    public float getChanceSpeed() {
        return this.chanceSpeed;
    }

    public static class SpoornBountyTierBuilder {
        private SpoornBountyTierTypes tierType;
        private double weight;
        private float mobSizeScale;
        private int glowColor;
        private double bountyScoreScale;
        private float maxBaseHealthIncrease;
        private int experienceScale;
        private double minBaseDamageIncrease;
        private double maxBaseDamageIncrease;
        private double milestoneDamageIncrease;
        private float chanceWeaknessAttack;
        private float chanceWitherAttack;
        private float chanceBlindnessAttack;
        private float chancePoisonAttack;
        private float chanceSlownessAttack;
        private float chanceHungerAttack;
        private float chanceBurningAttack;
        private float chanceResistance;
        private float chanceRegeneration;
        private float chanceSpeed;

        SpoornBountyTierBuilder() {
        }

        public SpoornBountyTierBuilder tierType(SpoornBountyTierTypes tierType) {
            this.tierType = tierType;
            return this;
        }

        public SpoornBountyTierBuilder weight(double weight) {
            this.weight = weight;
            return this;
        }

        public SpoornBountyTierBuilder mobSizeScale(float mobSizeScale) {
            this.mobSizeScale = mobSizeScale;
            return this;
        }

        public SpoornBountyTierBuilder glowColor(int glowColor) {
            this.glowColor = glowColor;
            return this;
        }

        public SpoornBountyTierBuilder bountyScoreScale(double bountyScoreScale) {
            this.bountyScoreScale = bountyScoreScale;
            return this;
        }

        public SpoornBountyTierBuilder maxBaseHealthIncrease(float maxBaseHealthIncrease) {
            this.maxBaseHealthIncrease = maxBaseHealthIncrease;
            return this;
        }

        public SpoornBountyTierBuilder experienceScale(int experienceScale) {
            this.experienceScale = experienceScale;
            return this;
        }

        public SpoornBountyTierBuilder minBaseDamageIncrease(double minBaseDamageIncrease) {
            this.minBaseDamageIncrease = minBaseDamageIncrease;
            return this;
        }

        public SpoornBountyTierBuilder maxBaseDamageIncrease(double maxBaseDamageIncrease) {
            this.maxBaseDamageIncrease = maxBaseDamageIncrease;
            return this;
        }

        public SpoornBountyTierBuilder milestoneDamageIncrease(double milestoneDamageIncrease) {
            this.milestoneDamageIncrease = milestoneDamageIncrease;
            return this;
        }

        public SpoornBountyTierBuilder chanceWeaknessAttack(float chanceWeaknessAttack) {
            this.chanceWeaknessAttack = chanceWeaknessAttack;
            return this;
        }

        public SpoornBountyTierBuilder chanceWitherAttack(float chanceWitherAttack) {
            this.chanceWitherAttack = chanceWitherAttack;
            return this;
        }

        public SpoornBountyTierBuilder chanceBlindnessAttack(float chanceBlindnessAttack) {
            this.chanceBlindnessAttack = chanceBlindnessAttack;
            return this;
        }

        public SpoornBountyTierBuilder chancePoisonAttack(float chancePoisonAttack) {
            this.chancePoisonAttack = chancePoisonAttack;
            return this;
        }

        public SpoornBountyTierBuilder chanceSlownessAttack(float chanceSlownessAttack) {
            this.chanceSlownessAttack = chanceSlownessAttack;
            return this;
        }

        public SpoornBountyTierBuilder chanceHungerAttack(float chanceHungerAttack) {
            this.chanceHungerAttack = chanceHungerAttack;
            return this;
        }

        public SpoornBountyTierBuilder chanceBurningAttack(float chanceBurningAttack) {
            this.chanceBurningAttack = chanceBurningAttack;
            return this;
        }

        public SpoornBountyTierBuilder chanceResistance(float chanceResistance) {
            this.chanceResistance = chanceResistance;
            return this;
        }

        public SpoornBountyTierBuilder chanceRegeneration(float chanceRegeneration) {
            this.chanceRegeneration = chanceRegeneration;
            return this;
        }

        public SpoornBountyTierBuilder chanceSpeed(float chanceSpeed) {
            this.chanceSpeed = chanceSpeed;
            return this;
        }

        public SpoornBountyTier build() {
            return new SpoornBountyTier(this.tierType, this.weight, this.mobSizeScale, this.glowColor, this.bountyScoreScale, this.maxBaseHealthIncrease, this.experienceScale, this.minBaseDamageIncrease, this.maxBaseDamageIncrease, this.milestoneDamageIncrease, this.chanceWeaknessAttack, this.chanceWitherAttack, this.chanceBlindnessAttack, this.chancePoisonAttack, this.chanceSlownessAttack, this.chanceHungerAttack, this.chanceBurningAttack, this.chanceResistance, this.chanceRegeneration, this.chanceSpeed);
        }

        public String toString() {
            return "SpoornBountyTier.SpoornBountyTierBuilder(tierType=" + this.tierType + ", weight=" + this.weight + ", mobSizeScale=" + this.mobSizeScale + ", glowColor=" + this.glowColor + ", bountyScoreScale=" + this.bountyScoreScale + ", maxBaseHealthIncrease=" + this.maxBaseHealthIncrease + ", experienceScale=" + this.experienceScale + ", minBaseDamageIncrease=" + this.minBaseDamageIncrease + ", maxBaseDamageIncrease=" + this.maxBaseDamageIncrease + ", milestoneDamageIncrease=" + this.milestoneDamageIncrease + ", chanceWeaknessAttack=" + this.chanceWeaknessAttack + ", chanceWitherAttack=" + this.chanceWitherAttack + ", chanceBlindnessAttack=" + this.chanceBlindnessAttack + ", chancePoisonAttack=" + this.chancePoisonAttack + ", chanceSlownessAttack=" + this.chanceSlownessAttack + ", chanceHungerAttack=" + this.chanceHungerAttack + ", chanceBurningAttack=" + this.chanceBurningAttack + ", chanceResistance=" + this.chanceResistance + ", chanceRegeneration=" + this.chanceRegeneration + ", chanceSpeed=" + this.chanceSpeed + ")";
        }
    }
}

