/*
 * Decompiled with CFR 0.152.
 */
package org.spoorn.spoornbountymobs.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import org.apache.commons.math3.distribution.EnumeratedDistribution;
import org.apache.commons.math3.util.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spoorn.spoornbountymobs.config.ModConfig;
import org.spoorn.spoornbountymobs.entity.SpoornBountyEntityRegistry;
import org.spoorn.spoornbountymobs.entity.component.EntityDataComponent;
import org.spoorn.spoornbountymobs.entity.component.PlayerDataComponent;
import org.spoorn.spoornbountymobs.tiers.SpoornBountyTier;
import org.spoorn.spoornbountymobs.util.DropDistributionData;

public class SpoornBountyMobsUtil {
    private static final Logger log = LogManager.getLogger(SpoornBountyMobsUtil.class);
    public static final Random RANDOM = new Random();
    public static final EnumeratedDistribution<SpoornBountyTier> SPOORN_BOUNTY_TIERS = new EnumeratedDistribution((List)ImmutableList.of((Object)new Pair((Object)SpoornBountyTier.COMMON, (Object)SpoornBountyTier.COMMON.getWeight()), (Object)new Pair((Object)SpoornBountyTier.UNCOMMON, (Object)SpoornBountyTier.UNCOMMON.getWeight()), (Object)new Pair((Object)SpoornBountyTier.RARE, (Object)SpoornBountyTier.RARE.getWeight()), (Object)new Pair((Object)SpoornBountyTier.EPIC, (Object)SpoornBountyTier.EPIC.getWeight()), (Object)new Pair((Object)SpoornBountyTier.LEGENDARY, (Object)SpoornBountyTier.LEGENDARY.getWeight()), (Object)new Pair((Object)SpoornBountyTier.DOOM, (Object)SpoornBountyTier.DOOM.getWeight())));
    public static final Pattern ITEM_REGEX = Pattern.compile("^((?<count>\\d+)\\s+)?\\s*(?<item>[^{].+:.+[^}])\\s*(\\s+(?<nbt>\\{.*\\}))?$");
    private static final Cache<Pair<SpoornBountyTier, String>, List<DropDistributionData>> ENTITY_TO_DROP_DATA = CacheBuilder.newBuilder().maximumSize(100L).build();

    public static boolean isHostileEntity(class_1297 entity) {
        return entity instanceof class_1588;
    }

    public static boolean isPlayerEntity(class_1297 entity) {
        return entity instanceof class_1657;
    }

    public static boolean entityIsHostileAndHasBounty(class_1297 entity) {
        return SpoornBountyMobsUtil.isHostileEntity(entity) && SpoornBountyMobsUtil.getSpoornEntityDataComponent(entity).hasBounty();
    }

    public static EntityDataComponent getSpoornEntityDataComponent(class_1297 entity) {
        return (EntityDataComponent)SpoornBountyEntityRegistry.HOSTILE_ENTITY_DATA.get((Object)entity);
    }

    public static PlayerDataComponent getPlayerDataComponent(class_1657 player) {
        return (PlayerDataComponent)SpoornBountyEntityRegistry.PLAYER_DATA.get((Object)player);
    }

    public static class_1293 getStatusEffectInstance(class_1291 statusEffect, int duration, int amplifier) {
        return SpoornBountyMobsUtil.getStatusEffectInstance(statusEffect, duration, amplifier, ModConfig.get().showBountyParticleEffects);
    }

    public static class_1293 getStatusEffectInstanceMaxDuration(class_1291 statusEffect, int amplifier) {
        return SpoornBountyMobsUtil.getStatusEffectInstance(statusEffect, Integer.MAX_VALUE, amplifier, false);
    }

    public static class_1293 getStatusEffectInstance(class_1291 statusEffect, int duration, int amplifier, boolean showParticles) {
        return new class_1293(statusEffect, duration, amplifier, false, showParticles, true);
    }

    public static float getHealthIncreaseFromBountyScore(class_1657 player, class_1297 entity) {
        EntityDataComponent entityDataComponent = SpoornBountyMobsUtil.getSpoornEntityDataComponent(entity);
        if (!entityDataComponent.hasBounty()) {
            return 0.0f;
        }
        int bountyTier = SpoornBountyMobsUtil.getBountyHunterLevel(player);
        switch (entityDataComponent.getSpoornBountyTier().getTierType()) {
            case COMMON_TIER: {
                return bountyTier * ModConfig.get().COMMON_TIER.milestoneHealthIncrease;
            }
            case UNCOMMON_TIER: {
                return bountyTier * ModConfig.get().UNCOMMON_TIER.milestoneHealthIncrease;
            }
            case RARE_TIER: {
                return bountyTier * ModConfig.get().RARE_TIER.milestoneHealthIncrease;
            }
            case EPIC_TIER: {
                return bountyTier * ModConfig.get().EPIC_TIER.milestoneHealthIncrease;
            }
            case LEGENDARY_TIER: {
                return bountyTier * ModConfig.get().LEGENDARY_TIER.milestoneHealthIncrease;
            }
            case DOOM_TIER: {
                return bountyTier * ModConfig.get().DOOM_TIER.milestoneHealthIncrease;
            }
        }
        return 0.0f;
    }

    public static double getDamageIncreaseFromBountyScore(class_1657 player, class_1297 entity) {
        EntityDataComponent entityDataComponent = SpoornBountyMobsUtil.getSpoornEntityDataComponent(entity);
        if (!entityDataComponent.hasBounty()) {
            return 0.0;
        }
        int bountyTier = SpoornBountyMobsUtil.getBountyHunterLevel(player);
        return entityDataComponent.getSpoornBountyTier().getMilestoneDamageIncrease() * (double)bountyTier;
    }

    public static int getBountyHunterLevel(class_1657 player) {
        return (int)SpoornBountyMobsUtil.calculateBountyScore(player) / ModConfig.get().playerBountyHunterLevelIntervals;
    }

    public static double getPlayerBonusDamage(class_1657 player) {
        return ModConfig.get().playerBonusDamagePerBountyHunterTier * (double)SpoornBountyMobsUtil.getBountyHunterLevel(player);
    }

    public static List<DropDistributionData> filterPatternInMap(SpoornBountyTier tier, String entityId, List<DropDistributionData> dropDists) {
        Pair cacheKey = Pair.create((Object)tier, (Object)entityId);
        List cacheEntry = (List)ENTITY_TO_DROP_DATA.getIfPresent((Object)cacheKey);
        if (cacheEntry != null) {
            return cacheEntry;
        }
        ArrayList<DropDistributionData> res = new ArrayList<DropDistributionData>();
        for (DropDistributionData dropDist : dropDists) {
            if (!dropDist.entityIdPattern.asMatchPredicate().test(entityId)) continue;
            res.add(dropDist);
        }
        ENTITY_TO_DROP_DATA.put((Object)cacheKey, res);
        return res;
    }

    public static <T> T sampleFromList(List<T> l) {
        return l.get(RANDOM.nextInt(l.size()));
    }

    public static double bound(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private static double calculateBountyScore(class_1657 player) {
        return SpoornBountyMobsUtil.getPlayerDataComponent(player).getBountyScore();
    }
}

