/*
 * Decompiled with CFR 0.152.
 */
package io.github.xiaocihua.stacktonearbychests;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.widget.data.Vec2i;
import io.github.xiaocihua.stacktonearbychests.EndWorldTickExecutor;
import io.github.xiaocihua.stacktonearbychests.ForEachContainerTask;
import io.github.xiaocihua.stacktonearbychests.InventoryActions;
import io.github.xiaocihua.stacktonearbychests.KeySequence;
import io.github.xiaocihua.stacktonearbychests.LockedSlots;
import io.github.xiaocihua.stacktonearbychests.ModOptions;
import io.github.xiaocihua.stacktonearbychests.gui.ModOptionsGui;
import io.github.xiaocihua.stacktonearbychests.gui.ModOptionsScreen;
import io.github.xiaocihua.stacktonearbychests.gui.PosUpdatableButtonWidget;
import io.github.xiaocihua.stacktonearbychests.mixin.HandledScreenAccessor;
import io.github.xiaocihua.stacktonearbychests.mixin.HorseScreenAccessor;
import io.github.xiaocihua.stacktonearbychests.mixin.RecipeBookWidgetAccessor;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.impl.client.screen.ScreenExtensions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1492;
import net.minecraft.class_1496;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3802;
import net.minecraft.class_3934;
import net.minecraft.class_3979;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_466;
import net.minecraft.class_479;
import net.minecraft.class_481;
import net.minecraft.class_485;
import net.minecraft.class_486;
import net.minecraft.class_4894;
import net.minecraft.class_490;
import net.minecraft.class_491;
import net.minecraft.class_492;
import net.minecraft.class_494;
import net.minecraft.class_507;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class StackToNearbyChests
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"StackToNearbyChests");
    public static final boolean IS_IPN_MOD_LOADED = FabricLoader.getInstance().isModLoaded("inventoryprofilesnext");
    public static final boolean IS_EASY_SHULKER_BOXES_MOD_LOADED = FabricLoader.getInstance().isModLoaded("easyshulkerboxes");
    public static final boolean IS_METAL_BUNDLES_MOD_LOADED = FabricLoader.getInstance().isModLoaded("metalbundles");
    private static final class_2960 BUTTON_TEXTURE = new class_2960("stack-to-nearby-chests", "textures/buttons.png");
    public static Optional<PosUpdatableButtonWidget> currentStackToNearbyContainersButton = Optional.empty();

    public void onInitializeClient() {
        KeySequence.init();
        LockedSlots.init();
        InventoryActions.init();
        EndWorldTickExecutor.init();
        ForEachContainerTask.init();
        ScreenEvents.AFTER_INIT.register(this::addButtonsAndKeys);
        ModOptions.get().keymap.stackToNearbyContainersKey.registerNotOnScreen(InventoryActions::stackToNearbyContainers, class_1269.field_5811);
        ModOptions.get().keymap.restockFromNearbyContainersKey.registerNotOnScreen(InventoryActions::restockFromNearbyContainers, class_1269.field_5811);
        ModOptions.get().keymap.openModOptionsScreenKey.registerNotOnScreen(() -> class_310.method_1551().method_1507((class_437)new ModOptionsScreen((GuiDescription)new ModOptionsGui())), class_1269.field_5814);
    }

    private void addButtonsAndKeys(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        class_746 player = client.field_1724;
        if (player == null || player.method_7325()) {
            return;
        }
        ModOptions.Appearance appearanceOption = ModOptions.get().appearance;
        boolean showButtonTooltip = appearanceOption.showButtonTooltip.booleanValue();
        if (screen instanceof class_485) {
            class_485 inventoryScreen = (class_485)screen;
            if (screen instanceof class_490 || screen instanceof class_481 && appearanceOption.showTheButtonsOnTheCreativeInventoryScreen.booleanValue()) {
                StackToNearbyChests.addButtonsOnInventoryScreen((ScreenExtensions)screen, inventoryScreen, showButtonTooltip, appearanceOption);
            }
            ScreenKeyboardEvents.afterKeyPress((class_437)screen).register((scr, key, scancode, modifiers) -> {
                if (StackToNearbyChests.isTextFieldActive(scr) || StackToNearbyChests.isInventoryTabNotSelected(scr)) {
                    return;
                }
                ModOptions.Keymap keymap = ModOptions.get().keymap;
                boolean triggered = false;
                class_1735 focusedSlot = ((HandledScreenAccessor)inventoryScreen).getFocusedSlot();
                if (focusedSlot != null && focusedSlot.method_7681()) {
                    triggered = keymap.quickStackItemsOfTheSameTypeAsTheOneUnderTheCursorToNearbyContainersKey.testThenRun(() -> InventoryActions.stackToNearbyContainers(focusedSlot.method_7677().method_7909()));
                }
                if (!triggered) {
                    keymap.stackToNearbyContainersKey.testThenRun(InventoryActions::stackToNearbyContainers);
                }
                keymap.restockFromNearbyContainersKey.testThenRun(InventoryActions::restockFromNearbyContainers);
            });
        } else if (StackToNearbyChests.isContainerScreen(screen)) {
            class_1703 screenHandler = ((class_465)screen).method_17577();
            if (ModOptions.get().appearance.showQuickStackButton.booleanValue()) {
                new PosUpdatableButtonWidget.Builder((class_465)screen).setUV(32, 0).setTexture(BUTTON_TEXTURE, 64, 32).setTooltip((class_2561)(showButtonTooltip ? class_2561.method_43471((String)"stack-to-nearby-chests.tooltip.quickStackButton") : null)).setPosUpdater(parent -> StackToNearbyChests.getAbsolutePos(parent, appearanceOption.quickStackButtonPosX, appearanceOption.quickStackButtonPosY)).setPressAction(button -> InventoryActions.quickStack(screenHandler)).build();
            }
            if (ModOptions.get().appearance.showRestockButton.booleanValue()) {
                new PosUpdatableButtonWidget.Builder((class_465)screen).setUV(48, 0).setTexture(BUTTON_TEXTURE, 64, 32).setTooltip((class_2561)(showButtonTooltip ? class_2561.method_43471((String)"stack-to-nearby-chests.tooltip.restockButton") : null)).setPosUpdater(parent -> StackToNearbyChests.getAbsolutePos(parent, appearanceOption.restockButtonPosX, appearanceOption.restockButtonPosY)).setPressAction(button -> InventoryActions.restock(screenHandler)).build();
            }
            ScreenKeyboardEvents.afterKeyPress((class_437)screen).register((scr, key, scancode, modifiers) -> {
                if (StackToNearbyChests.isTextFieldActive(scr) || StackToNearbyChests.isInventoryTabNotSelected(scr)) {
                    return;
                }
                ModOptions.get().keymap.quickStackKey.testThenRun(() -> InventoryActions.quickStack(screenHandler));
                ModOptions.get().keymap.restockKey.testThenRun(() -> InventoryActions.restock(screenHandler));
            });
        }
    }

    private static void addButtonsOnInventoryScreen(ScreenExtensions screen, class_485<?> inventoryScreen, boolean showButtonTooltip, ModOptions.Appearance appearanceOption) {
        if (ModOptions.get().appearance.showStackToNearbyContainersButton.booleanValue()) {
            PosUpdatableButtonWidget buttonWidget = new PosUpdatableButtonWidget.Builder((class_465<?>)inventoryScreen).setUV(0, 0).setTexture(BUTTON_TEXTURE, 64, 32).setTooltip(showButtonTooltip ? StackToNearbyChests.getTooltipWithHint("stack-to-nearby-chests.tooltip.stackToNearbyContainersButton") : null).setPosUpdater(parent -> new Vec2i(parent.getX() + appearanceOption.stackToNearbyContainersButtonPosX.intValue(), parent.getY() + appearanceOption.stackToNearbyContainersButtonPosY.intValue())).setPressAction(button -> {
                class_1703 screenHandler = inventoryScreen.method_17577();
                class_1799 cursorStack = screenHandler.method_34255();
                if (cursorStack.method_7960()) {
                    InventoryActions.stackToNearbyContainers();
                } else {
                    class_1792 item = cursorStack.method_7909();
                    screenHandler.field_7761.stream().filter(slot -> slot.field_7871 instanceof class_1661).filter(slot -> slot.method_34266() < 36).filter(Predicate.not(LockedSlots::isLocked)).filter(slot -> !slot.method_7681() || InventoryActions.canMerge(slot.method_7677(), cursorStack)).peek(slot -> InventoryActions.pickup(screenHandler, slot)).anyMatch(slot -> cursorStack.method_7960());
                    InventoryActions.stackToNearbyContainers(item);
                }
            }).build();
            currentStackToNearbyContainersButton = Optional.ofNullable(buttonWidget);
            screen.fabric_getRemoveEvent().register(s -> {
                currentStackToNearbyContainersButton = Optional.empty();
            });
        }
        if (ModOptions.get().appearance.showRestockFromNearbyContainersButton.booleanValue()) {
            new PosUpdatableButtonWidget.Builder((class_465<?>)inventoryScreen).setUV(16, 0).setTexture(BUTTON_TEXTURE, 64, 32).setTooltip(showButtonTooltip ? StackToNearbyChests.getTooltipWithHint("stack-to-nearby-chests.tooltip.restockFromNearbyContainersButton") : null).setPosUpdater(parent -> new Vec2i(parent.getX() + appearanceOption.restockFromNearbyContainersButtonPosX.intValue(), parent.getY() + appearanceOption.restockFromNearbyContainersButtonPosY.intValue())).setPressAction(button -> InventoryActions.restockFromNearbyContainers()).build();
        }
    }

    private static boolean isTextFieldActive(class_437 screen) {
        class_342 textField;
        class_342 searchField;
        class_364 focusedElement = screen.method_25399();
        if (focusedElement instanceof class_507 && (searchField = ((RecipeBookWidgetAccessor)focusedElement).getSearchField()) != null && searchField.method_20315()) {
            return true;
        }
        return focusedElement instanceof class_342 && (textField = (class_342)focusedElement).method_20315();
    }

    private static boolean isInventoryTabNotSelected(class_437 screen) {
        class_481 creativeInventoryScreen;
        return screen instanceof class_481 && !(creativeInventoryScreen = (class_481)screen).method_47424();
    }

    public static Vec2i getAbsolutePos(HandledScreenAccessor parent, ModOptions.IntOption x, ModOptions.IntOption y) {
        return new Vec2i(parent.getX() + parent.getBackgroundWidth() + x.intValue(), parent.getY() + parent.getBackgroundHeight() / 2 + y.intValue());
    }

    private static class_2561 getTooltipWithHint(String translationKey) {
        return class_2561.method_43471((String)translationKey).method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"stack-to-nearby-chests.tooltip.hint").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1063)));
    }

    public static boolean isContainerScreen(class_437 screen) {
        if (!(screen instanceof class_465)) {
            return false;
        }
        if (screen instanceof class_466 || screen instanceof class_3802 || screen instanceof class_3934 || screen instanceof class_479 || screen instanceof class_494 || screen instanceof class_486 || screen instanceof class_492 || screen instanceof class_4894 || screen instanceof class_3979 || screen instanceof class_485) {
            return false;
        }
        if (screen instanceof class_491) {
            class_1492 abstractDonkeyEntity;
            class_1496 class_14962 = ((HorseScreenAccessor)screen).getEntity();
            return class_14962 instanceof class_1492 && (abstractDonkeyEntity = (class_1492)class_14962).method_6703();
        }
        return true;
    }
}

