/*
 * Decompiled with CFR 0.152.
 */
package net.stamina.mixin;

import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.stamina.access.StaminaAccess;
import net.stamina.init.AttributeInit;
import net.stamina.init.ConfigInit;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements StaminaAccess {
    @Shadow
    @Mutable
    @Final
    private class_1656 field_7503;
    private static final class_1322 STAMINA_SPEED_REDUCTION = new class_1322(UUID.fromString("1dfe298b-4f31-432a-a159-f766c304cac7"), "Stamina speed reduction", (double)-0.05f, class_1322.class_1323.field_6330);
    private int stamina = (int)this.method_26825(AttributeInit.GENERIC_MAX_STAMINA);
    private int exhaustionTime = 0;

    public PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbtMixin(class_2487 nbt, CallbackInfo info) {
        this.stamina = nbt.method_10550("Stamina");
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbtMixin(class_2487 nbt, CallbackInfo info) {
        nbt.method_10569("Stamina", this.stamina);
    }

    @Inject(method={"addExhaustion"}, at={@At(value="HEAD")})
    private void addExhaustionMixin(float exhaustion, CallbackInfo info) {
        this.addStamina(-((int)(exhaustion * 10.0f)));
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tickMixin(CallbackInfo info) {
        if (!this.method_5624()) {
            if (this.exhaustionTime <= 0) {
                if ((float)this.method_7344().method_7586() > 6.0f) {
                    this.addStamina(1);
                }
            } else {
                --this.exhaustionTime;
            }
        } else if (!this.field_7503.field_7477) {
            this.addStamina(-1);
        }
    }

    @Inject(method={"createPlayerAttributes"}, at={@At(value="RETURN")})
    private static void createPlayerAttributesMixin(CallbackInfoReturnable<class_5132.class_5133> info) {
        ((class_5132.class_5133)info.getReturnValue()).method_26867(AttributeInit.GENERIC_MAX_STAMINA);
    }

    @Override
    public void addStamina(int stamina) {
        if ((double)(this.stamina + stamina) > this.method_26825(AttributeInit.GENERIC_MAX_STAMINA)) {
            this.stamina = (int)this.method_26825(AttributeInit.GENERIC_MAX_STAMINA);
        } else if (this.stamina + stamina <= 0) {
            this.stamina = 0;
            this.exhaustionTime = ConfigInit.CONFIG.exhaustionTime;
            if (!this.method_37908().method_8608() && !this.method_5996(class_5134.field_23719).method_6196(STAMINA_SPEED_REDUCTION)) {
                this.method_5996(class_5134.field_23719).method_26835(STAMINA_SPEED_REDUCTION);
            }
        } else {
            this.stamina += stamina;
            if (!this.method_37908().method_8608() && this.method_5996(class_5134.field_23719).method_6196(STAMINA_SPEED_REDUCTION)) {
                this.method_5996(class_5134.field_23719).method_6202(STAMINA_SPEED_REDUCTION);
            }
        }
    }

    @Override
    public int getStamina() {
        return this.stamina;
    }

    @Override
    public void setStamina(int stamina) {
        this.stamina = (double)stamina > this.method_26825(AttributeInit.GENERIC_MAX_STAMINA) ? (int)this.method_26825(AttributeInit.GENERIC_MAX_STAMINA) : (stamina < 0 ? 0 : stamina);
    }

    @Shadow
    public class_1702 method_7344() {
        return null;
    }
}

