/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.entity.summons;

import com.github.teamfusion.summonerscrolls.common.entity.base.ISummon;
import com.github.teamfusion.summonerscrolls.common.sound.SummonerSoundEvents;
import java.time.LocalDate;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3321;
import net.minecraft.class_3414;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_8111;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class IronGolemSummon
extends class_1439
implements ISummon,
class_5354 {
    private UUID ownerUUID;
    private int despawnDelay;
    private static final class_2940<Integer> DATA_REMAINING_ANGER_TIME = class_2945.method_12791(IronGolemSummon.class, (class_2941)class_2943.field_13327);
    private static final class_6019 PERSISTENT_ANGER_TIME = class_4802.method_24505((int)20, (int)39);
    @Nullable
    protected UUID persistentAngerTarget;

    public IronGolemSummon(class_1299<? extends class_1439> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    protected void method_5959() {
        this.commonGoals(this.field_6185, this.field_6201);
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.0, true));
    }

    public static class_5132.class_5133 createSummonAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 22.0).method_26868(class_5134.field_23724, 2.0).method_26868(class_5134.field_23716, 100.0).method_26867(class_5134.field_23727);
    }

    @Override
    public class_1309 getSummon() {
        return this;
    }

    @Override
    public class_1309 getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.method_37908().method_18470(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        ISummon summon;
        if (this.isStupid(damageSource)) {
            return false;
        }
        if (damageSource.method_49708(class_8111.field_42347)) {
            return super.method_5643(damageSource, amount);
        }
        class_1297 directEntity = damageSource.method_5529();
        if (directEntity == this.getOwner()) {
            return false;
        }
        if (directEntity instanceof ISummon && (summon = (ISummon)directEntity).getOwner() == this.getOwner()) {
            return false;
        }
        return super.method_5643(damageSource, amount);
    }

    private boolean isStupid(class_1282 damageSource) {
        return damageSource.method_49708(class_8111.field_42340) || damageSource.method_49708(class_8111.field_42345) || damageSource.method_49708(class_8111.field_42339) || damageSource.method_49708(class_8111.field_42344);
    }

    public void method_5697(class_1297 entity) {
        if (entity == this.getOwner()) {
            return;
        }
        super.method_5697(entity);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (player.method_5715()) {
            this.method_5768();
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    protected class_3414 method_6002() {
        LocalDate today = LocalDate.now();
        boolean aprilFools = today.getMonthValue() == 4 && today.getDayOfMonth() == 1 && today.getYear() != 2025;
        return aprilFools ? SummonerSoundEvents.SUMMON_DEATH_APRIL.get() : SummonerSoundEvents.SUMMON_DEATH.get();
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("DespawnDelay", this.despawnDelay);
        if (this.getOwnerUUID() != null) {
            tag.method_25927("Owner", this.getOwnerUUID());
        }
    }

    public void method_5749(class_2487 tag) {
        UUID uuid;
        super.method_5749(tag);
        if (tag.method_10573("DespawnDelay", 99)) {
            this.despawnDelay = tag.method_10550("DespawnDelay");
        }
        if (tag.method_25928("Owner")) {
            uuid = tag.method_25926("Owner");
        } else {
            String s = tag.method_10558("Owner");
            uuid = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)s);
        }
        if (uuid != null) {
            this.setOwnerUUID(uuid);
        }
    }

    public boolean method_5936() {
        return false;
    }

    public void method_6007() {
        super.method_6007();
        if (--this.despawnDelay <= 0 || this.getOwner() == null) {
            this.method_5768();
        }
        if (this.field_6012 % 2 == 0) {
            this.spawnSummonParticles(this.field_5974, (class_1936)this.method_37908(), this.method_23317(), this.method_23319(), this.method_23321());
        }
    }

    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        if (!this.method_37908().method_8608()) {
            int count = 80;
            for (int j = 0; j < count; ++j) {
                class_1937 world = this.method_37908();
                class_5819 random = world.method_8409();
                float horizontal = (float)random.method_43051(-10, 10) * 0.125f;
                float vertical = (float)random.method_43051(-8, 8) * 0.125f;
                ((class_3218)world).method_14199((class_2394)class_2398.field_11203, this.method_23317(), this.method_23318() + (double)(this.method_17682() / 2.0f), this.method_23321(), 1, (double)horizontal, (double)vertical, (double)horizontal, 0.0);
            }
        }
        this.method_31472();
    }

    @Override
    public void setDespawnDelay(int delay) {
        this.despawnDelay = Math.max(1, delay);
    }

    @Override
    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(DATA_REMAINING_ANGER_TIME);
    }

    public void method_29514(int time) {
        this.field_6011.method_12778(DATA_REMAINING_ANGER_TIME, (Object)time);
    }

    @Nullable
    public UUID method_29508() {
        return this.persistentAngerTarget;
    }

    public void method_29513(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void method_29509() {
        this.method_29514(PERSISTENT_ANGER_TIME.method_35008(this.field_5974));
    }
}

