/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.item;

import com.github.teamfusion.summonerscrolls.common.registry.SummonerItems;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_174;
import net.minecraft.class_1744;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3745;
import net.minecraft.class_5150;
import net.minecraft.class_5244;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SummonerCrossBow
extends class_1811
implements class_5150 {
    private static final String TAG_CHARGED = "Charged";
    private static final String TAG_CHARGED_PROJECTILES = "ChargedProjectiles";
    private static final int MAX_CHARGE_DURATION = 25;
    public static final int DEFAULT_RANGE = 8;
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;
    private static final float START_SOUND_PERCENT = 0.2f;
    private static final float MID_SOUND_PERCENT = 0.5f;
    private static final float ARROW_POWER = 3.15f;
    private static final float FIREWORK_POWER = 1.6f;

    public SummonerCrossBow(class_1792.class_1793 properties) {
        super(properties);
    }

    public Predicate<class_1799> method_19268() {
        return arg -> arg.method_31574(SummonerItems.SUMMON_ARROW.get());
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (SummonerCrossBow.isCharged(itemStack)) {
            SummonerCrossBow.performShooting(level, (class_1309)player, interactionHand, itemStack, SummonerCrossBow.getShootingPower(itemStack), 1.0f);
            SummonerCrossBow.setCharged(itemStack, false);
            return class_1271.method_22428((Object)itemStack);
        }
        this.startSoundPlayed = false;
        this.midLoadSoundPlayed = false;
        player.method_6019(interactionHand);
        return class_1271.method_22428((Object)itemStack);
    }

    private static float getShootingPower(class_1799 itemStack) {
        return SummonerCrossBow.containsChargedProjectile(itemStack, class_1802.field_8639) ? 1.6f : 3.15f;
    }

    public void method_7840(class_1799 itemStack, class_1937 level, class_1309 livingEntity, int i) {
        int j = this.method_7881(itemStack) - i;
        float f = SummonerCrossBow.getPowerForTime(j, itemStack);
        if (f >= 1.0f && !SummonerCrossBow.isCharged(itemStack) && SummonerCrossBow.tryLoadProjectiles(livingEntity, itemStack)) {
            SummonerCrossBow.setCharged(itemStack, true);
            class_3419 soundSource = livingEntity instanceof class_1657 ? class_3419.field_15248 : class_3419.field_15251;
            level.method_43128(null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), class_3417.field_14626, soundSource, 1.0f, 1.0f / (level.method_8409().method_43057() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean tryLoadProjectiles(class_1309 livingEntity, class_1799 itemStack) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)itemStack);
        int j = i == 0 ? 1 : 3;
        boolean bl = livingEntity instanceof class_1657 && ((class_1657)livingEntity).method_31549().field_7477;
        class_1799 itemStack2 = livingEntity.method_18808(itemStack);
        class_1799 itemStack3 = itemStack2.method_7972();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemStack2 = itemStack3.method_7972();
            }
            if (itemStack2.method_7960() && bl) {
                itemStack2 = new class_1799((class_1935)class_1802.field_8107);
                itemStack3 = itemStack2.method_7972();
            }
            SummonerCrossBow.addChargedProjectile(itemStack, SummonerItems.SUMMON_ARROW.get().method_7854());
        }
        return true;
    }

    public static boolean isCharged(class_1799 itemStack) {
        class_2487 compoundTag = itemStack.method_7969();
        return compoundTag != null && compoundTag.method_10577(TAG_CHARGED);
    }

    public static void setCharged(class_1799 itemStack, boolean bl) {
        class_2487 compoundTag = itemStack.method_7948();
        compoundTag.method_10556(TAG_CHARGED, bl);
    }

    private static void addChargedProjectile(class_1799 itemStack, class_1799 itemStack2) {
        class_2487 compoundTag = itemStack.method_7948();
        class_2499 listTag = compoundTag.method_10573(TAG_CHARGED_PROJECTILES, 9) ? compoundTag.method_10554(TAG_CHARGED_PROJECTILES, 10) : new class_2499();
        class_2487 compoundTag2 = new class_2487();
        itemStack2.method_7953(compoundTag2);
        listTag.add((Object)compoundTag2);
        compoundTag.method_10566(TAG_CHARGED_PROJECTILES, (class_2520)listTag);
    }

    private static List<class_1799> getChargedProjectiles(class_1799 itemStack) {
        ArrayList list = Lists.newArrayList();
        class_2487 compoundTag = itemStack.method_7969();
        if (compoundTag != null && compoundTag.method_10573(TAG_CHARGED_PROJECTILES, 9)) {
            class_2499 listTag = compoundTag.method_10554(TAG_CHARGED_PROJECTILES, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                class_2487 compoundTag2 = listTag.method_10602(i);
                list.add(class_1799.method_7915((class_2487)compoundTag2));
            }
        }
        return list;
    }

    private static void clearChargedProjectiles(class_1799 itemStack) {
        class_2487 compoundTag = itemStack.method_7969();
        if (compoundTag != null) {
            class_2499 listTag = compoundTag.method_10554(TAG_CHARGED_PROJECTILES, 9);
            listTag.clear();
            compoundTag.method_10566(TAG_CHARGED_PROJECTILES, (class_2520)listTag);
        }
    }

    public static boolean containsChargedProjectile(class_1799 itemStack, class_1792 item) {
        return SummonerCrossBow.getChargedProjectiles(itemStack).stream().anyMatch(itemStackx -> itemStackx.method_31574(item));
    }

    private static void shootProjectile(class_1937 level, class_1309 livingEntity, class_1268 interactionHand, class_1799 itemStack, class_1799 itemStack2, float f, boolean bl, float g, float h, float i) {
        if (!level.field_9236) {
            class_1665 projectile;
            boolean bl2 = itemStack2.method_31574(class_1802.field_8639);
            if (bl2) {
                projectile = new class_1671(level, itemStack2, (class_1297)livingEntity, livingEntity.method_23317(), livingEntity.method_23320() - (double)0.15f, livingEntity.method_23321(), true);
            } else {
                projectile = SummonerCrossBow.getArrow(level, livingEntity, itemStack, itemStack2);
                if (bl || i != 0.0f) {
                    projectile.field_7572 = class_1665.class_1666.field_7594;
                }
            }
            if (livingEntity instanceof class_3745) {
                class_3745 crossbowAttackMob = (class_3745)livingEntity;
                crossbowAttackMob.method_18811(crossbowAttackMob.method_5968(), itemStack, (class_1676)projectile, i);
            } else {
                class_243 vec3 = livingEntity.method_18864(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(i * ((float)Math.PI / 180)), vec3.field_1352, vec3.field_1351, vec3.field_1350);
                class_243 vec32 = livingEntity.method_5828(1.0f);
                Vector3f vector3f = vec32.method_46409().rotate((Quaternionfc)quaternionf);
                ((class_1676)projectile).method_7485((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), g, h);
            }
            itemStack.method_7956(bl2 ? 3 : 1, livingEntity, livingEntityx -> livingEntityx.method_20236(interactionHand));
            level.method_8649((class_1297)projectile);
            level.method_43128((class_1657)null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), class_3417.field_15187, class_3419.field_15248, 1.0f, f);
        }
    }

    private static class_1665 getArrow(class_1937 level, class_1309 livingEntity, class_1799 itemStack, class_1799 itemStack2) {
        class_1744 arrowItem = (class_1744)(itemStack2.method_7909() instanceof class_1744 ? itemStack2.method_7909() : class_1802.field_8107);
        class_1665 abstractArrow = arrowItem.method_7702(level, itemStack2, livingEntity);
        if (livingEntity instanceof class_1657) {
            abstractArrow.method_7439(true);
        }
        abstractArrow.method_7444(class_3417.field_14636);
        abstractArrow.method_7442(true);
        int i = class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)itemStack);
        if (i > 0) {
            abstractArrow.method_7451((byte)i);
        }
        return abstractArrow;
    }

    public static void performShooting(class_1937 level, class_1309 livingEntity, class_1268 interactionHand, class_1799 itemStack, float f, float g) {
        List<class_1799> list = SummonerCrossBow.getChargedProjectiles(itemStack);
        float[] fs = SummonerCrossBow.getShotPitches(livingEntity.method_6051());
        for (int i = 0; i < list.size(); ++i) {
            boolean bl;
            class_1799 itemStack2 = list.get(i);
            boolean bl2 = bl = livingEntity instanceof class_1657 && ((class_1657)livingEntity).method_31549().field_7477;
            if (itemStack2.method_7960()) continue;
            if (i == 0) {
                SummonerCrossBow.shootProjectile(level, livingEntity, interactionHand, itemStack, itemStack2, fs[i], bl, f, g, 0.0f);
                continue;
            }
            if (i == 1) {
                SummonerCrossBow.shootProjectile(level, livingEntity, interactionHand, itemStack, itemStack2, fs[i], bl, f, g, -10.0f);
                continue;
            }
            if (i != 2) continue;
            SummonerCrossBow.shootProjectile(level, livingEntity, interactionHand, itemStack, itemStack2, fs[i], bl, f, g, 10.0f);
        }
        SummonerCrossBow.onCrossbowShot(level, livingEntity, itemStack);
    }

    private static float[] getShotPitches(class_5819 randomSource) {
        boolean bl = randomSource.method_43056();
        return new float[]{1.0f, SummonerCrossBow.getRandomShotPitch(bl, randomSource), SummonerCrossBow.getRandomShotPitch(!bl, randomSource)};
    }

    private static float getRandomShotPitch(boolean bl, class_5819 randomSource) {
        float f = bl ? 0.63f : 0.43f;
        return 1.0f / (randomSource.method_43057() * 0.5f + 1.8f) + f;
    }

    private static void onCrossbowShot(class_1937 level, class_1309 livingEntity, class_1799 itemStack) {
        if (livingEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)livingEntity;
            if (!level.field_9236) {
                class_174.field_1196.method_9115(serverPlayer, itemStack);
            }
            serverPlayer.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
        }
        SummonerCrossBow.clearChargedProjectiles(itemStack);
    }

    public void method_7852(class_1937 level, class_1309 livingEntity, class_1799 itemStack, int i) {
        if (!level.field_9236) {
            int j = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)itemStack);
            class_3414 soundEvent = this.getStartSound(j);
            class_3414 soundEvent2 = j == 0 ? class_3417.field_14860 : null;
            float f = (float)(itemStack.method_7935() - i) / (float)SummonerCrossBow.getChargeDuration(itemStack);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                level.method_43128((class_1657)null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), soundEvent, class_3419.field_15248, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundEvent2 != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                level.method_43128((class_1657)null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), soundEvent2, class_3419.field_15248, 0.5f, 1.0f);
            }
        }
    }

    public int method_7881(class_1799 itemStack) {
        return SummonerCrossBow.getChargeDuration(itemStack) + 3;
    }

    public static int getChargeDuration(class_1799 itemStack) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)itemStack);
        return i == 0 ? 25 : 25 - 5 * i;
    }

    public class_1839 method_7853(class_1799 itemStack) {
        return class_1839.field_8947;
    }

    private class_3414 getStartSound(int i) {
        return switch (i) {
            case 1 -> class_3417.field_15011;
            case 2 -> class_3417.field_14916;
            case 3 -> class_3417.field_15089;
            default -> class_3417.field_14765;
        };
    }

    private static float getPowerForTime(int i, class_1799 itemStack) {
        float f = (float)i / (float)SummonerCrossBow.getChargeDuration(itemStack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void method_7851(class_1799 itemStack, @Nullable class_1937 level, List<class_2561> list, class_1836 tooltipFlag) {
        List<class_1799> list2 = SummonerCrossBow.getChargedProjectiles(itemStack);
        if (SummonerCrossBow.isCharged(itemStack) && !list2.isEmpty()) {
            class_1799 itemStack2 = list2.get(0);
            list.add((class_2561)class_2561.method_43471((String)"item.minecraft.crossbow.projectile").method_10852(class_5244.field_41874).method_10852(itemStack2.method_7954()));
            if (tooltipFlag.method_8035() && itemStack2.method_31574(class_1802.field_8639)) {
                ArrayList list3 = Lists.newArrayList();
                class_1802.field_8639.method_7851(itemStack2, level, (List)list3, tooltipFlag);
                if (!list3.isEmpty()) {
                    for (int i = 0; i < list3.size(); ++i) {
                        list3.set(i, class_2561.method_43470((String)"  ").method_10852((class_2561)list3.get(i)).method_27692(class_124.field_1080));
                    }
                    list.addAll(list3);
                }
            }
        }
    }

    public boolean method_7838(class_1799 itemStack) {
        return itemStack.method_31574((class_1792)this);
    }

    public int method_24792() {
        return 8;
    }
}

