/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.util.cooldowns;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_3532;

public class SummonerItemCooldowns {
    private final Map<class_1799, SummonerCooldownInstance> cooldowns = Maps.newHashMap();
    private int tickCount;

    public static SummonerItemCooldowns createSummonerItemCooldowns() {
        return new SummonerItemCooldowns();
    }

    public boolean isOnCooldown(class_1799 itemStack) {
        return this.getCooldownPercent(itemStack, 0.0f) > 0.0f;
    }

    public float getCooldownPercent(class_1799 itemStack, float f) {
        SummonerCooldownInstance CooldownInstance = this.cooldowns.get(itemStack);
        if (CooldownInstance != null) {
            float g = CooldownInstance.endTime - CooldownInstance.startTime;
            float h = (float)CooldownInstance.endTime - ((float)this.tickCount + f);
            return class_3532.method_15363((float)(h / g), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    public void tick() {
        ++this.tickCount;
        if (!this.cooldowns.isEmpty()) {
            Iterator<Map.Entry<class_1799, SummonerCooldownInstance>> iterator = this.cooldowns.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<class_1799, SummonerCooldownInstance> entry = iterator.next();
                if (entry.getValue().endTime > this.tickCount) continue;
                iterator.remove();
                this.onCooldownEnded(entry.getKey());
            }
        }
    }

    public void addCooldown(class_1799 itemStack, int i) {
        this.cooldowns.put(itemStack, new SummonerCooldownInstance(this.tickCount, this.tickCount + i));
        this.onCooldownStarted(itemStack, i);
    }

    public void removeCooldown(class_1799 itemStack) {
        this.cooldowns.remove(itemStack);
        this.onCooldownEnded(itemStack);
    }

    protected void onCooldownStarted(class_1799 itemStack, int i) {
    }

    protected void onCooldownEnded(class_1799 itemStack) {
    }

    static class SummonerCooldownInstance {
        final int startTime;
        final int endTime;

        SummonerCooldownInstance(int i, int j) {
            this.startTime = i;
            this.endTime = j;
        }
    }
}

