/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.animation.system.core.types;

import andrews.table_top_craft.animation.system.core.BasicKeyframe;
import andrews.table_top_craft.animation.system.core.bulders.EasingBuilder;
import andrews.table_top_craft.animation.system.core.types.util.EasingMath;
import andrews.table_top_craft.animation.system.core.types.util.EasingType;
import net.minecraft.class_3532;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EasingTypes {
    private final EasingType easingType;
    public static final EasingTypes LINEAR = EasingBuilder.type(EasingType.LINEAR).build();
    public static final EasingTypes CATMULLROM = EasingBuilder.type(EasingType.CATMULLROM).build();
    public static final EasingTypes EASE_IN_SINE = EasingBuilder.type(EasingType.EASE_IN_SINE).build();
    public static final EasingTypes EASE_OUT_SINE = EasingBuilder.type(EasingType.EASE_OUT_SINE).build();
    public static final EasingTypes EASE_IN_OUT_SINE = EasingBuilder.type(EasingType.EASE_IN_OUT_SINE).build();
    public static final EasingTypes EASE_IN_QUAD = EasingBuilder.type(EasingType.EASE_IN_QUAD).build();
    public static final EasingTypes EASE_OUT_QUAD = EasingBuilder.type(EasingType.EASE_OUT_QUAD).build();
    public static final EasingTypes EASE_IN_OUT_QUAD = EasingBuilder.type(EasingType.EASE_IN_OUT_QUAD).build();
    public static final EasingTypes EASE_IN_CUBIC = EasingBuilder.type(EasingType.EASE_IN_CUBIC).build();
    public static final EasingTypes EASE_OUT_CUBIC = EasingBuilder.type(EasingType.EASE_OUT_CUBIC).build();
    public static final EasingTypes EASE_IN_OUT_CUBIC = EasingBuilder.type(EasingType.EASE_IN_OUT_CUBIC).build();
    public static final EasingTypes EASE_IN_QUART = EasingBuilder.type(EasingType.EASE_IN_QUART).build();
    public static final EasingTypes EASE_OUT_QUART = EasingBuilder.type(EasingType.EASE_OUT_QUART).build();
    public static final EasingTypes EASE_IN_OUT_QUART = EasingBuilder.type(EasingType.EASE_IN_OUT_QUART).build();
    public static final EasingTypes EASE_IN_QUINT = EasingBuilder.type(EasingType.EASE_IN_QUINT).build();
    public static final EasingTypes EASE_OUT_QUINT = EasingBuilder.type(EasingType.EASE_OUT_QUINT).build();
    public static final EasingTypes EASE_IN_OUT_QUINT = EasingBuilder.type(EasingType.EASE_IN_OUT_QUINT).build();
    public static final EasingTypes EASE_IN_EXPO = EasingBuilder.type(EasingType.EASE_IN_EXPO).build();
    public static final EasingTypes EASE_OUT_EXPO = EasingBuilder.type(EasingType.EASE_OUT_EXPO).build();
    public static final EasingTypes EASE_IN_OUT_EXPO = EasingBuilder.type(EasingType.EASE_IN_OUT_EXPO).build();
    public static final EasingTypes EASE_IN_CIRC = EasingBuilder.type(EasingType.EASE_IN_CIRC).build();
    public static final EasingTypes EASE_OUT_CIRC = EasingBuilder.type(EasingType.EASE_OUT_CIRC).build();
    public static final EasingTypes EASE_IN_OUT_CIRC = EasingBuilder.type(EasingType.EASE_IN_OUT_CIRC).build();
    private final float optionalValue;

    public void storeEasedValues(Vector3f animationVecCache, float keyframeDelta, BasicKeyframe[] keyframes, Vector3f cachedLastVec, int currentKeyframeIdx, float elapsedSeconds) {
        Vector3f current = keyframes[currentKeyframeIdx].target(elapsedSeconds);
        switch (this.easingType) {
            case LINEAR: {
                cachedLastVec.lerp((Vector3fc)current, keyframeDelta, animationVecCache);
                break;
            }
            case CATMULLROM: {
                Vector3f old = keyframes[Math.max(0, currentKeyframeIdx - 2)].target(0.0f);
                Vector3f future = keyframes[Math.min(keyframes.length - 1, currentKeyframeIdx + 1)].target(0.0f);
                animationVecCache.set(class_3532.method_41303((float)keyframeDelta, (float)old.x(), (float)cachedLastVec.x(), (float)current.x(), (float)future.x()), class_3532.method_41303((float)keyframeDelta, (float)old.y(), (float)cachedLastVec.y(), (float)current.y(), (float)future.y()), class_3532.method_41303((float)keyframeDelta, (float)old.z(), (float)cachedLastVec.z(), (float)current.z(), (float)future.z()));
                break;
            }
            case STEPS: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeSteps(keyframeDelta, this.optionalValue), animationVecCache);
                break;
            }
            case EASE_IN_SINE: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInSine(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_OUT_SINE: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeOutSine(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_IN_OUT_SINE: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInOutSine(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_IN_QUAD: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInQuad(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_OUT_QUAD: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeOutQuad(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_IN_OUT_QUAD: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInOutQuad(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_IN_CUBIC: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInCubic(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_OUT_CUBIC: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeOutCubic(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_IN_OUT_CUBIC: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInOutCubic(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_IN_QUART: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInQuart(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_OUT_QUART: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeOutQuart(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_IN_OUT_QUART: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInOutQuart(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_IN_QUINT: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInQuint(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_OUT_QUINT: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeOutQuint(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_IN_OUT_QUINT: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInOutQuint(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_IN_EXPO: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInExpo(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_OUT_EXPO: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeOutExpo(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_IN_OUT_EXPO: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInOutExpo(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_IN_CIRC: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInCirc(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_OUT_CIRC: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeOutCirc(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_IN_OUT_CIRC: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInOutCirc(keyframeDelta), animationVecCache);
                break;
            }
            case EASE_IN_BACK: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInBack(keyframeDelta, this.optionalValue), animationVecCache);
                break;
            }
            case EASE_OUT_BACK: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeOutBack(keyframeDelta, this.optionalValue), animationVecCache);
                break;
            }
            case EASE_IN_OUT_BACK: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInOutBack(keyframeDelta, this.optionalValue), animationVecCache);
                break;
            }
            case EASE_IN_ELASTIC: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInElastic(keyframeDelta, this.optionalValue), animationVecCache);
                break;
            }
            case EASE_OUT_ELASTIC: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeOutElastic(keyframeDelta, this.optionalValue), animationVecCache);
                break;
            }
            case EASE_IN_OUT_ELASTIC: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInOutElastic(keyframeDelta, this.optionalValue), animationVecCache);
                break;
            }
            case EASE_IN_BOUNCE: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInBounce(keyframeDelta, this.optionalValue), animationVecCache);
                break;
            }
            case EASE_OUT_BOUNCE: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeOutBounce(keyframeDelta, this.optionalValue), animationVecCache);
                break;
            }
            case EASE_IN_OUT_BOUNCE: {
                cachedLastVec.lerp((Vector3fc)current, EasingMath.easeInOutBounce(keyframeDelta, this.optionalValue), animationVecCache);
            }
        }
    }

    public EasingTypes(EasingType easingType, float value) {
        this.easingType = easingType;
        this.optionalValue = value;
    }

    public EasingType getEasingType() {
        return this.easingType;
    }

    public float getOptionalValue() {
        return this.optionalValue;
    }
}

