/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.animation.system.core.types.util;

import java.util.function.IntPredicate;
import net.minecraft.class_3532;

public class EasingMath {
    public static float easeSteps(float value, float steps) {
        float stepLength;
        float result;
        if (value < 0.0f) {
            return 0.0f;
        }
        if (steps < 2.0f) {
            steps = 2.0f;
        }
        if (value > (result = (steps - 1.0f) * (stepLength = 1.0f / steps))) {
            return result;
        }
        IntPredicate isTargetBeforeOrAt = i -> value < (float)i * stepLength;
        int stepIndex = class_3532.method_15360((int)0, (int)(Math.round(steps) - 1), (IntPredicate)isTargetBeforeOrAt);
        if (stepIndex < 0) {
            stepIndex = -(stepIndex + 1);
        }
        return (float)(stepIndex - 1) * stepLength;
    }

    public static float easeInSine(float value) {
        return 1.0f - class_3532.method_15362((float)(value * (float)Math.PI / 2.0f));
    }

    public static float easeOutSine(float value) {
        return class_3532.method_15374((float)(value * (float)Math.PI / 2.0f));
    }

    public static float easeInOutSine(float value) {
        return -(class_3532.method_15362((float)((float)Math.PI * value)) - 1.0f) / 2.0f;
    }

    public static float easeInQuad(float value) {
        return value * value;
    }

    public static float easeOutQuad(float value) {
        return 1.0f - (1.0f - value) * (1.0f - value);
    }

    public static float easeInOutQuad(float value) {
        return (double)value < 0.5 ? 2.0f * value * value : 1.0f - (float)Math.pow(-2.0f * value + 2.0f, 2.0) / 2.0f;
    }

    public static float easeInCubic(float value) {
        return value * value * value;
    }

    public static float easeOutCubic(float value) {
        return 1.0f - (float)Math.pow(1.0f - value, 3.0);
    }

    public static float easeInOutCubic(float value) {
        return (double)value < 0.5 ? 4.0f * value * value * value : 1.0f - (float)Math.pow(-2.0f * value + 2.0f, 3.0) / 2.0f;
    }

    public static float easeInQuart(float value) {
        return value * value * value * value;
    }

    public static float easeOutQuart(float value) {
        return 1.0f - (float)Math.pow(1.0f - value, 4.0);
    }

    public static float easeInOutQuart(float value) {
        return (double)value < 0.5 ? 8.0f * value * value * value * value : 1.0f - (float)Math.pow(-2.0f * value + 2.0f, 4.0) / 2.0f;
    }

    public static float easeInQuint(float value) {
        return value * value * value * value * value;
    }

    public static float easeOutQuint(float value) {
        return 1.0f - (float)Math.pow(1.0f - value, 5.0);
    }

    public static float easeInOutQuint(float value) {
        return (double)value < 0.5 ? 16.0f * value * value * value * value * value : 1.0f - (float)Math.pow(-2.0f * value + 2.0f, 5.0) / 2.0f;
    }

    public static float easeInExpo(float value) {
        return value == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * value - 10.0f);
    }

    public static float easeOutExpo(float value) {
        return value == 1.0f ? 1.0f : 1.0f - (float)Math.pow(2.0, -10.0f * value);
    }

    public static float easeInOutExpo(float value) {
        return value == 0.0f ? 0.0f : (value == 1.0f ? 1.0f : ((double)value < 0.5 ? (float)Math.pow(2.0, 20.0f * value - 10.0f) / 2.0f : (2.0f - (float)Math.pow(2.0, -20.0f * value + 10.0f)) / 2.0f));
    }

    public static float easeInCirc(float value) {
        return 1.0f - class_3532.method_15355((float)(1.0f - (float)Math.pow(value, 2.0)));
    }

    public static float easeOutCirc(float value) {
        return class_3532.method_15355((float)(1.0f - (float)Math.pow(value - 1.0f, 2.0)));
    }

    public static float easeInOutCirc(float value) {
        return (double)value < 0.5 ? (1.0f - class_3532.method_15355((float)(1.0f - (float)Math.pow(2.0f * value, 2.0)))) / 2.0f : (class_3532.method_15355((float)(1.0f - (float)Math.pow(-2.0f * value + 2.0f, 2.0))) + 1.0f) / 2.0f;
    }

    public static float easeInBack(float value, float overshoot) {
        return (1.70158f * overshoot + 1.0f) * value * value * value - 1.70158f * overshoot * value * value;
    }

    public static float easeOutBack(float value, float overshoot) {
        return 1.0f + (1.70158f * overshoot + 1.0f) * (float)Math.pow(value - 1.0f, 3.0) + 1.70158f * overshoot * (float)Math.pow(value - 1.0f, 2.0);
    }

    public static float easeInOutBack(float value, float overshoot) {
        return (double)value < 0.5 ? (float)Math.pow(2.0f * value, 2.0) * ((1.70158f * overshoot + 1.0f) * 2.0f * value - 1.70158f * overshoot) / 2.0f : ((float)Math.pow(2.0f * value - 2.0f, 2.0) * ((1.70158f * overshoot + 1.0f) * (value * 2.0f - 2.0f) + 1.70158f * overshoot) + 2.0f) / 2.0f;
    }

    public static float easeInElastic(float value, float bounciness) {
        return 1.0f - (float)Math.pow(class_3532.method_15362((float)(value * (float)Math.PI / 2.0f)), 3.0) * class_3532.method_15362((float)(value * (float)Math.PI * bounciness));
    }

    public static float easeOutElastic(float value, float bounciness) {
        return 1.0f - (1.0f - (float)Math.pow(class_3532.method_15362((float)((1.0f - value) * (float)Math.PI / 2.0f)), 3.0) * class_3532.method_15362((float)((1.0f - value) * (float)Math.PI * bounciness)));
    }

    public static float easeInOutElastic(float value, float bounciness) {
        return value < 0.5f ? (1.0f - (float)Math.pow(class_3532.method_15362((float)(value * (float)Math.PI)), 3.0) * class_3532.method_15362((float)(value * (float)Math.PI * bounciness))) / 2.0f : 1.0f - (1.0f - (float)Math.pow(class_3532.method_15362((float)((1.0f - value) * (float)Math.PI)), 3.0) * class_3532.method_15362((float)((1.0f - value) * (float)Math.PI * bounciness))) / 2.0f;
    }

    public static float easeInBounce(float value, float bounciness) {
        if (value < 0.36363637f) {
            return 7.5625f * value * value;
        }
        if (value < 0.72727275f) {
            return 30.25f * bounciness * (float)Math.pow(value - 0.54545456f, 2.0) + 1.0f - bounciness;
        }
        if ((double)value < 0.9090909090909091) {
            return 121.0f * bounciness * bounciness * (float)Math.pow(value - 0.8181818f, 2.0) + 1.0f - bounciness * bounciness;
        }
        return 484.0f * bounciness * bounciness * bounciness * (float)Math.pow(value - 0.95454544f, 2.0) + 1.0f - bounciness * bounciness * bounciness;
    }

    public static float easeOutBounce(float value, float bounciness) {
        return 1.0f - EasingMath.easeInBounce(1.0f - value, bounciness);
    }

    public static float easeInOutBounce(float value, float bounciness) {
        return (double)value < 0.5 ? (1.0f - EasingMath.easeOutBounce(1.0f - 2.0f * value, bounciness)) / 2.0f : (1.0f + EasingMath.easeOutBounce(2.0f * value - 1.0f, bounciness)) / 2.0f;
    }
}

