/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.block_entities;

import andrews.table_top_craft.animation.system.base.AnimatedBlockEntity;
import andrews.table_top_craft.animation.system.core.AdvancedAnimationState;
import andrews.table_top_craft.animation.system.core.Animation;
import andrews.table_top_craft.animation.system.core.types.EasingTypes;
import andrews.table_top_craft.block_entities.animations.ChessAnimations;
import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.ChessMoveLog;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.KingSideCastleMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MajorAttackMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MajorMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnAttackMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnEnPassantAttackMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnJumpMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnPromotion;
import andrews.table_top_craft.game_logic.chess.board.moves.QueenSideCastleMove;
import andrews.table_top_craft.game_logic.chess.board.tiles.BaseChessTile;
import andrews.table_top_craft.game_logic.chess.pgn.FenUtil;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.pieces.BishopPiece;
import andrews.table_top_craft.game_logic.chess.pieces.KingPiece;
import andrews.table_top_craft.game_logic.chess.pieces.KnightPiece;
import andrews.table_top_craft.game_logic.chess.pieces.PawnPiece;
import andrews.table_top_craft.game_logic.chess.pieces.QueenPiece;
import andrews.table_top_craft.game_logic.chess.pieces.RookPiece;
import andrews.table_top_craft.game_logic.chess.player.MoveTransition;
import andrews.table_top_craft.objects.blocks.ChessBlock;
import andrews.table_top_craft.registry.TTCBlockEntities;
import andrews.table_top_craft.util.NBTColorSaving;
import andrews.table_top_craft.util.NetworkUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ChessBlockEntity
extends AnimatedBlockEntity {
    public final List<AdvancedAnimationState> lingeringStates = new ArrayList<AdvancedAnimationState>();
    public final AdvancedAnimationState selectedPieceState = new AdvancedAnimationState(new AtomicReference<Animation>());
    public AdvancedAnimationState moveState;
    public int selectedPiecePos;
    public final AdvancedAnimationState placedState = new AdvancedAnimationState(new AtomicReference<Animation>());
    public long doingAnimationTimer;
    public BaseMove move;
    public MoveTransition transition;
    public byte currentCord;
    public byte destCord;
    public boolean playedParticles;
    private Board board;
    private BaseChessTile sourceTile;
    private BaseChessTile destinationTile;
    private BasePiece humanMovedPiece;
    private final ChessMoveLog moveLog;
    private boolean showTileInfo;
    private boolean showAvailableMoves;
    private boolean showPreviousMove;
    private boolean useCustomPlate;
    private boolean playPieceAnimations = true;
    private boolean displayParticles = true;
    private boolean waitingForPromotion;
    private byte promotionCoordinate = (byte)-1;
    private UUID promotionPlayerUUID;
    private boolean whiteCheckMate = false;
    private boolean blackCheckMate = false;
    private String tileInfoColor;
    private String whiteTilesColor;
    private String blackTilesColor;
    private String whitePiecesColor;
    private String blackPiecesColor;
    private String legalMoveColor;
    private String invalidMoveColor;
    private String attackMoveColor;
    private String previousMoveColor;
    private String castleMoveColor;
    private int pieceSet;
    private BasePiece cachedPiece;
    private final List<MoveTransition> moveTransitionsCache = new ArrayList<MoveTransition>();

    public ChessBlockEntity(class_2338 pos, class_2680 state) {
        super(TTCBlockEntities.CHESS, pos, state);
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT)) {
            this.selectedPieceState.setAnimation(ChessAnimations.SELECTED_PIECE);
            this.placedState.setAnimation(ChessAnimations.PLACED);
        }
        this.moveLog = new ChessMoveLog();
    }

    public class_2487 method_16887() {
        class_2487 compound = new class_2487();
        this.saveToNBT(compound);
        return compound;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        this.saveToNBT(compound);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.loadFromNBT(compound);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, ChessBlockEntity blockEntity) {
        blockEntity.incTicksExisted();
        if (blockEntity.placedState.method_41327() && blockEntity.placedState.isFinished()) {
            blockEntity.placedState.method_41325();
        }
        if (blockEntity.doingAnimationTimer != 0L) {
            if (blockEntity.doingAnimationTimer >= System.currentTimeMillis() && blockEntity.move != null && blockEntity.transition != null && blockEntity.move.isAttack() && !blockEntity.playedParticles) {
                int timeMod = 250;
                boolean isBlack = blockEntity.move.getMovedPiece().getPieceColor().isBlack();
                byte destCoordinate = (byte)blockEntity.move.getDestinationCoordinate();
                float xSpeed = 0.0f;
                float ySpeed = 0.0f;
                float zSpeed = 0.0f;
                if (blockEntity.move.isEnPassantMove()) {
                    destCoordinate = (byte)(destCoordinate + (isBlack ? -8 : 8));
                    timeMod = 400;
                    if (blockEntity.method_11010().method_28498((class_2769)ChessBlock.FACING)) {
                        switch ((class_2350)blockEntity.method_11010().method_11654((class_2769)ChessBlock.FACING)) {
                            case field_11043: {
                                zSpeed = isBlack ? -0.4f : 0.4f;
                                break;
                            }
                            case field_11035: {
                                zSpeed = isBlack ? 0.4f : -0.4f;
                                break;
                            }
                            case field_11034: {
                                xSpeed = isBlack ? 0.4f : -0.4f;
                                break;
                            }
                            case field_11039: {
                                xSpeed = isBlack ? -0.4f : 0.4f;
                            }
                        }
                    }
                } else if (blockEntity.move.isAttack()) {
                    BasePiece.PieceType type = blockEntity.move.getMovedPiece().getPieceType();
                    int startX = blockEntity.move.getCurrentCoordinate() % 8;
                    int startY = blockEntity.move.getCurrentCoordinate() / 8;
                    int destX = blockEntity.move.getDestinationCoordinate() % 8;
                    int destY = blockEntity.move.getDestinationCoordinate() / 8;
                    int deltaY = startY - destY;
                    deltaY = !isBlack ? deltaY : -deltaY;
                    int deltaX = startX - destX;
                    deltaX = !isBlack ? -deltaX : deltaX;
                    float[] result = ChessBlockEntity.calculateSpeedAndTimeMod(type, isBlack, (class_2350)blockEntity.method_11010().method_11654((class_2769)ChessBlock.FACING), deltaY, deltaX);
                    zSpeed = result[0];
                    xSpeed = result[1];
                    timeMod = (int)result[2];
                }
                if (blockEntity.doingAnimationTimer - (long)timeMod < System.currentTimeMillis()) {
                    if (blockEntity.getDisplayParticles() && level instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)level;
                        NetworkUtil.playChesParticlesFromServer(serverLevel, pos, destCoordinate, isBlack, xSpeed, ySpeed, zSpeed);
                    }
                    blockEntity.playedParticles = true;
                }
            }
            if (blockEntity.doingAnimationTimer < System.currentTimeMillis() && blockEntity.move != null && blockEntity.transition != null) {
                blockEntity.setBoard(blockEntity.transition.getTransitionBoard());
                blockEntity.getMoveLog().addMove(blockEntity.move);
                if (blockEntity.move.isPawnPromotion()) {
                    blockEntity.setWaitingForPromotion(true);
                    blockEntity.setPromotionCoordinate((byte)blockEntity.move.getDestinationCoordinate());
                    if (level instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)level;
                        List players = serverLevel.method_18456();
                        for (class_3222 serverPlayer : players) {
                            if (!serverPlayer.method_5667().equals(blockEntity.getPromotionPlayerUUID())) continue;
                            NetworkUtil.openChessPromotionFromServer(blockEntity.method_11016(), blockEntity.move.getMovedPiece().getPieceColor().isWhite(), serverPlayer);
                        }
                    }
                    blockEntity.setPromotionPlayerUUID(null);
                }
                blockEntity.doingAnimationTimer = 0L;
                blockEntity.move = null;
                blockEntity.transition = null;
                blockEntity.playedParticles = false;
                level.method_8413(pos, level.method_8320(pos), level.method_8320(pos), 2);
                blockEntity.method_5431();
            }
        }
        if (blockEntity.getHumanMovedPiece() != null) {
            if (blockEntity.getPlayPieceAnimations() && !blockEntity.selectedPieceState.method_41327()) {
                blockEntity.selectedPiecePos = blockEntity.getHumanMovedPiece().getPiecePosition();
                blockEntity.lingeringStates.clear();
                blockEntity.selectedPieceState.interpolateAndStart(0.15f, EasingTypes.LINEAR, false, blockEntity.getTicksExisted());
            } else if (!blockEntity.getPlayPieceAnimations() && blockEntity.selectedPieceState.method_41327()) {
                blockEntity.selectedPieceState.interpolateAndStop(0.15f, EasingTypes.LINEAR, false);
                blockEntity.lingeringStates.add(new AdvancedAnimationState(blockEntity.selectedPieceState));
                blockEntity.selectedPieceState.method_41325();
            }
        } else if (blockEntity.selectedPieceState.method_41327()) {
            blockEntity.selectedPieceState.interpolateAndStop(0.15f, EasingTypes.LINEAR, false);
            blockEntity.lingeringStates.add(new AdvancedAnimationState(blockEntity.selectedPieceState));
            blockEntity.selectedPieceState.method_41325();
        }
    }

    private void saveToNBT(class_2487 compound) {
        int i;
        class_2487 chessNBT = new class_2487();
        if (this.board != null) {
            chessNBT.method_10582("BoardFEN", FenUtil.createFENFromGame(this.board));
            StringBuilder builder = new StringBuilder();
            for (i = 0; i < 64; ++i) {
                if (!this.board.getTile(i).isTileOccupied() || !this.board.getTile(i).getPiece().isFirstMove()) continue;
                builder.append(i).append("/");
            }
            if (builder.length() >= 2) {
                builder.setLength(builder.length() - 1);
            }
            chessNBT.method_10582("FirstMoves", builder.toString());
            chessNBT.method_10556("IsWhiteCastled", this.board.getWhiteChessPlayer().isCastled());
            chessNBT.method_10556("IsBlackCastled", this.board.getBlackChessPlayer().isCastled());
            chessNBT.method_10556("WhiteCheckMate", this.getBoard().getWhiteChessPlayer().isInCheckMate());
            chessNBT.method_10556("BlackCheckMate", this.getBoard().getBlackChessPlayer().isInCheckMate());
        }
        if (this.moveLog != null) {
            class_2499 chessMoves = new class_2499();
            for (i = 0; i < this.moveLog.size(); ++i) {
                class_2487 chessMove = new class_2487();
                chessMove.method_10582("Move" + (i + 1), this.moveLog.getMoves().get(i).saveToNBT());
                chessMoves.add((Object)chessMove);
            }
            chessNBT.method_10566("MoveLog", (class_2520)chessMoves);
        }
        chessNBT.method_10569("ShowTileInfo", !this.showTileInfo ? 0 : 1);
        chessNBT.method_10569("ShowAvailableMoves", !this.showAvailableMoves ? 0 : 1);
        chessNBT.method_10569("ShowPreviousMove", !this.showPreviousMove ? 0 : 1);
        chessNBT.method_10569("UseCustomPlate", !this.useCustomPlate ? 0 : 1);
        chessNBT.method_10569("PlayPieceAnimations", !this.playPieceAnimations ? 0 : 1);
        chessNBT.method_10569("DisplayParticles", !this.displayParticles ? 0 : 1);
        chessNBT.method_10569("WaitingForPromotion", !this.waitingForPromotion ? 0 : 1);
        chessNBT.method_10567("PromotionCoordinate", this.getPromotionCoordinate());
        chessNBT.method_10582("TileInfoColor", this.getTileInfoColor());
        chessNBT.method_10582("WhiteTilesColor", this.getWhiteTilesColor());
        chessNBT.method_10582("BlackTilesColor", this.getBlackTilesColor());
        chessNBT.method_10582("WhitePiecesColor", this.getWhitePiecesColor());
        chessNBT.method_10582("BlackPiecesColor", this.getBlackPiecesColor());
        chessNBT.method_10582("LegalMoveColor", this.getLegalMoveColor());
        chessNBT.method_10582("InvalidMoveColor", this.getInvalidMoveColor());
        chessNBT.method_10582("AttackMoveColor", this.getAttackMoveColor());
        chessNBT.method_10582("PreviousMoveColor", this.getPreviousMoveColor());
        chessNBT.method_10582("CastleMoveColor", this.getCastleMoveColor());
        chessNBT.method_10569("SourceTile", this.sourceTile == null ? -1 : this.sourceTile.getTileCoordinate());
        chessNBT.method_10569("HumanMovedPiece", this.humanMovedPiece == null ? -1 : this.humanMovedPiece.getPiecePosition());
        chessNBT.method_10569("PieceSet", this.getPieceSet());
        compound.method_10566("ChessValues", (class_2520)chessNBT);
    }

    private void loadFromNBT(class_2487 compound) {
        class_2487 chessNBT = compound.method_10562("ChessValues");
        if (chessNBT.method_10573("BoardFEN", 8) && chessNBT.method_10573("FirstMoves", 8)) {
            boolean isWhiteCastled = chessNBT.method_10577("IsWhiteCastled");
            boolean isBlackCastled = chessNBT.method_10577("IsBlackCastled");
            if (FenUtil.isFENValid(chessNBT.method_10558("BoardFEN"))) {
                if (this.field_11863 != null && this.field_11863.method_8608() && this.moveState != null && !FenUtil.createFENFromGame(this.board).equals(chessNBT.method_10558("BoardFEN"))) {
                    this.moveState = null;
                }
                this.board = FenUtil.createGameFromFEN(chessNBT.method_10558("BoardFEN"), chessNBT.method_10558("FirstMoves"), isWhiteCastled, isBlackCastled);
            } else {
                this.board = Board.createStandardBoard();
            }
        }
        if (chessNBT.method_10545("MoveLog")) {
            class_2499 listNBT = chessNBT.method_10554("MoveLog", 10);
            this.moveLog.clear();
            block24: for (int i = 0; i < listNBT.size(); ++i) {
                class_2487 compoundTag = listNBT.method_10602(i);
                String move = compoundTag.method_10558("Move" + (i + 1));
                String[] moveInfo = move.split("/");
                PieceColor pieceColor = PieceColor.WHITE;
                if (moveInfo[1].equals("B")) {
                    pieceColor = PieceColor.BLACK;
                }
                switch (moveInfo[0]) {
                    default: {
                        continue block24;
                    }
                    case "pawn_jump": {
                        this.moveLog.addMove(new PawnJumpMove(this.getBoard(), new PawnPiece(pieceColor, Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[3])));
                        continue block24;
                    }
                    case "pawn_move": {
                        this.moveLog.addMove(new PawnMove(this.getBoard(), new PawnPiece(pieceColor, Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[3])));
                        continue block24;
                    }
                    case "pawn_attack": {
                        this.moveLog.addMove(new PawnAttackMove(this.getBoard(), new PawnPiece(pieceColor, Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[3]), this.getPieceFromType(moveInfo[5], pieceColor, Integer.parseInt(moveInfo[4]))));
                        continue block24;
                    }
                    case "pawn_enpassant": {
                        this.moveLog.addMove(new PawnEnPassantAttackMove(this.getBoard(), new PawnPiece(pieceColor, Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[3]), new PawnPiece(this.getOppositeColor(pieceColor), Integer.parseInt(moveInfo[4]))));
                        continue block24;
                    }
                    case "pawn_attack_promotion": {
                        this.moveLog.addMove(new PawnPromotion(new PawnAttackMove(this.getBoard(), new PawnPiece(pieceColor, Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[3]), this.getPieceFromType(moveInfo[5], pieceColor, Integer.parseInt(moveInfo[4]))), moveInfo[6]));
                        continue block24;
                    }
                    case "pawn_promotion": {
                        this.moveLog.addMove(new PawnPromotion(new PawnMove(this.getBoard(), new PawnPiece(pieceColor, Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[3])), moveInfo[4]));
                        continue block24;
                    }
                    case "major_move": {
                        this.moveLog.addMove(new MajorMove(this.getBoard(), this.getPieceFromType(moveInfo[4], this.getOppositeColor(pieceColor), Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[3])));
                        continue block24;
                    }
                    case "major_attack": {
                        this.moveLog.addMove(new MajorAttackMove(this.getBoard(), this.getPieceFromType(moveInfo[3], this.getOppositeColor(pieceColor), Integer.parseInt(moveInfo[2])), Integer.parseInt(moveInfo[4]), this.getPieceFromType(moveInfo[6], pieceColor, Integer.parseInt(moveInfo[5]))));
                        continue block24;
                    }
                    case "king_side_castle": {
                        this.moveLog.addMove(new KingSideCastleMove(this.getBoard(), new KingPiece(pieceColor, Integer.parseInt(moveInfo[2]), false, false), Integer.parseInt(moveInfo[3]), new RookPiece(pieceColor, Integer.parseInt(moveInfo[4])), Integer.parseInt(moveInfo[5]), Integer.parseInt(moveInfo[6])));
                        continue block24;
                    }
                    case "queen_side_castle": {
                        this.moveLog.addMove(new QueenSideCastleMove(this.getBoard(), new KingPiece(pieceColor, Integer.parseInt(moveInfo[2]), false, false), Integer.parseInt(moveInfo[3]), new RookPiece(pieceColor, Integer.parseInt(moveInfo[4])), Integer.parseInt(moveInfo[5]), Integer.parseInt(moveInfo[6])));
                    }
                }
            }
        }
        if (chessNBT.method_10573("ShowTileInfo", 3)) {
            boolean bl = this.showTileInfo = chessNBT.method_10550("ShowTileInfo") != 0;
        }
        if (chessNBT.method_10573("ShowAvailableMoves", 3)) {
            boolean bl = this.showAvailableMoves = chessNBT.method_10550("ShowAvailableMoves") != 0;
        }
        if (chessNBT.method_10573("ShowPreviousMove", 3)) {
            boolean bl = this.showPreviousMove = chessNBT.method_10550("ShowPreviousMove") != 0;
        }
        if (chessNBT.method_10573("TileInfoColor", 8)) {
            this.tileInfoColor = chessNBT.method_10558("TileInfoColor");
        }
        if (chessNBT.method_10573("UseCustomPlate", 3)) {
            boolean bl = this.useCustomPlate = chessNBT.method_10550("UseCustomPlate") != 0;
        }
        if (chessNBT.method_10573("PlayPieceAnimations", 3)) {
            boolean bl = this.playPieceAnimations = chessNBT.method_10550("PlayPieceAnimations") != 0;
        }
        if (chessNBT.method_10573("DisplayParticles", 3)) {
            boolean bl = this.displayParticles = chessNBT.method_10550("DisplayParticles") != 0;
        }
        if (chessNBT.method_10573("WaitingForPromotion", 3)) {
            boolean bl = this.waitingForPromotion = chessNBT.method_10550("WaitingForPromotion") != 0;
        }
        if (chessNBT.method_10573("PromotionCoordinate", 1)) {
            this.promotionCoordinate = chessNBT.method_10571("PromotionCoordinate");
        }
        if (chessNBT.method_10573("WhiteTilesColor", 8)) {
            this.whiteTilesColor = chessNBT.method_10558("WhiteTilesColor");
        }
        if (chessNBT.method_10573("BlackTilesColor", 8)) {
            this.blackTilesColor = chessNBT.method_10558("BlackTilesColor");
        }
        if (chessNBT.method_10573("WhitePiecesColor", 8)) {
            this.whitePiecesColor = chessNBT.method_10558("WhitePiecesColor");
        }
        if (chessNBT.method_10573("BlackPiecesColor", 8)) {
            this.blackPiecesColor = chessNBT.method_10558("BlackPiecesColor");
        }
        if (chessNBT.method_10573("LegalMoveColor", 8)) {
            this.legalMoveColor = chessNBT.method_10558("LegalMoveColor");
        }
        if (chessNBT.method_10573("InvalidMoveColor", 8)) {
            this.invalidMoveColor = chessNBT.method_10558("InvalidMoveColor");
        }
        if (chessNBT.method_10573("AttackMoveColor", 8)) {
            this.attackMoveColor = chessNBT.method_10558("AttackMoveColor");
        }
        if (chessNBT.method_10573("PreviousMoveColor", 8)) {
            this.previousMoveColor = chessNBT.method_10558("PreviousMoveColor");
        }
        if (chessNBT.method_10573("CastleMoveColor", 8)) {
            this.castleMoveColor = chessNBT.method_10558("CastleMoveColor");
        }
        if (chessNBT.method_10573("SourceTile", 3)) {
            BaseChessTile baseChessTile = this.sourceTile = chessNBT.method_10550("SourceTile") == -1 ? null : this.getBoard().getTile(chessNBT.method_10550("SourceTile"));
        }
        if (chessNBT.method_10573("HumanMovedPiece", 3)) {
            BasePiece basePiece = this.humanMovedPiece = chessNBT.method_10550("HumanMovedPiece") == -1 ? null : this.getBoard().getTile(chessNBT.method_10550("HumanMovedPiece")).getPiece();
        }
        if (chessNBT.method_10573("PieceSet", 3)) {
            this.pieceSet = chessNBT.method_10550("PieceSet");
        }
        if (chessNBT.method_10545("WhiteCheckMate")) {
            this.whiteCheckMate = chessNBT.method_10577("WhiteCheckMate");
        }
        if (chessNBT.method_10545("BlackCheckMate")) {
            this.blackCheckMate = chessNBT.method_10577("BlackCheckMate");
        }
    }

    private static float[] calculateSpeedAndTimeMod(BasePiece.PieceType type, boolean isBlack, class_2350 facing, int deltaY, int deltaX) {
        float[] result = new float[3];
        float zSpeed = 0.0f;
        float xSpeed = 0.0f;
        int timeMod = 250;
        if (type.equals((Object)BasePiece.PieceType.ROOK)) {
            if (Math.abs(deltaY) > 4) {
                switch (facing) {
                    case field_11043: {
                        zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        break;
                    }
                    case field_11035: {
                        zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        break;
                    }
                    case field_11034: {
                        xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        break;
                    }
                    case field_11039: {
                        xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                    }
                }
                timeMod = 550;
            }
            if (Math.abs(deltaX) > 4) {
                switch (facing) {
                    case field_11043: {
                        xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        break;
                    }
                    case field_11035: {
                        xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        break;
                    }
                    case field_11034: {
                        zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        break;
                    }
                    case field_11039: {
                        zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                    }
                }
                timeMod = 550;
            }
        } else if (type.equals((Object)BasePiece.PieceType.BISHOP)) {
            if (Math.abs(deltaY) > 3) {
                switch (facing) {
                    case field_11043: {
                        zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        break;
                    }
                    case field_11035: {
                        zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        break;
                    }
                    case field_11034: {
                        zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        break;
                    }
                    case field_11039: {
                        zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                    }
                }
                timeMod = 550;
            }
        } else if (type.equals((Object)BasePiece.PieceType.QUEEN)) {
            if (Math.abs(deltaX) != Math.abs(deltaY)) {
                if (Math.abs(deltaY) > 3) {
                    switch (facing) {
                        case field_11043: {
                            zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                            break;
                        }
                        case field_11035: {
                            zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                            break;
                        }
                        case field_11034: {
                            xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                            break;
                        }
                        case field_11039: {
                            xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        }
                    }
                    timeMod = 550;
                }
                if (Math.abs(deltaX) > 3) {
                    switch (facing) {
                        case field_11043: {
                            xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                            break;
                        }
                        case field_11035: {
                            xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                            break;
                        }
                        case field_11034: {
                            zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                            break;
                        }
                        case field_11039: {
                            zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        }
                    }
                    timeMod = 550;
                }
            } else if (Math.abs(deltaY) > 3) {
                switch (facing) {
                    case field_11043: {
                        zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        break;
                    }
                    case field_11035: {
                        zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        break;
                    }
                    case field_11034: {
                        zSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        xSpeed = (isBlack ? -0.4f : 0.4f) * (float)(deltaY < 0 ? -1 : 1);
                        break;
                    }
                    case field_11039: {
                        zSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaX < 0 ? -1 : 1);
                        xSpeed = (isBlack ? 0.4f : -0.4f) * (float)(deltaY < 0 ? -1 : 1);
                    }
                }
                timeMod = 550;
            }
        }
        result[0] = zSpeed;
        result[1] = xSpeed;
        result[2] = timeMod;
        return result;
    }

    private BasePiece getPieceFromType(String pieceType, PieceColor pieceColor, int piecePosition) {
        return switch (pieceType) {
            case "P" -> new PawnPiece(this.getOppositeColor(pieceColor), piecePosition);
            case "R" -> new RookPiece(this.getOppositeColor(pieceColor), piecePosition);
            case "N" -> new KnightPiece(this.getOppositeColor(pieceColor), piecePosition);
            case "B" -> new BishopPiece(this.getOppositeColor(pieceColor), piecePosition);
            case "Q" -> new QueenPiece(this.getOppositeColor(pieceColor), piecePosition);
            case "K" -> new KingPiece(this.getOppositeColor(pieceColor), piecePosition, true, true);
            default -> null;
        };
    }

    private PieceColor getOppositeColor(PieceColor color) {
        return color.isWhite() ? PieceColor.BLACK : PieceColor.WHITE;
    }

    public ChessMoveLog getMoveLog() {
        return this.moveLog;
    }

    public void setCastleMoveColor(String colorForNBT) {
        this.castleMoveColor = colorForNBT;
    }

    public String getCastleMoveColor() {
        return this.castleMoveColor == null ? NBTColorSaving.createCastleMoveColor() : this.castleMoveColor;
    }

    public void setPreviousMoveColor(String colorForNBT) {
        this.previousMoveColor = colorForNBT;
    }

    public String getPreviousMoveColor() {
        return this.previousMoveColor == null ? NBTColorSaving.createPreviousMoveColor() : this.previousMoveColor;
    }

    public void setAttackMoveColor(String colorForNBT) {
        this.attackMoveColor = colorForNBT;
    }

    public String getAttackMoveColor() {
        return this.attackMoveColor == null ? NBTColorSaving.createAttackMoveColor() : this.attackMoveColor;
    }

    public void setInvalidMoveColor(String colorForNBT) {
        this.invalidMoveColor = colorForNBT;
    }

    public String getInvalidMoveColor() {
        return this.invalidMoveColor == null ? NBTColorSaving.createInvalidMoveColor() : this.invalidMoveColor;
    }

    public void setLegalMoveColor(String colorForNBT) {
        this.legalMoveColor = colorForNBT;
    }

    public String getLegalMoveColor() {
        return this.legalMoveColor == null ? NBTColorSaving.createLegalMoveColor() : this.legalMoveColor;
    }

    public void setWhitePiecesColor(String colorForNBT) {
        this.whitePiecesColor = colorForNBT;
    }

    public String getWhitePiecesColor() {
        return this.whitePiecesColor == null ? NBTColorSaving.createWhitePiecesColor() : this.whitePiecesColor;
    }

    public void setBlackPiecesColor(String colorForNBT) {
        this.blackPiecesColor = colorForNBT;
    }

    public String getBlackPiecesColor() {
        return this.blackPiecesColor == null ? NBTColorSaving.createBlackPiecesColor() : this.blackPiecesColor;
    }

    public void setWhiteTilesColor(String colorForNBT) {
        this.whiteTilesColor = colorForNBT;
    }

    public String getWhiteTilesColor() {
        return this.whiteTilesColor == null ? NBTColorSaving.createWhiteTilesColor() : this.whiteTilesColor;
    }

    public void setBlackTilesColor(String colorForNBT) {
        this.blackTilesColor = colorForNBT;
    }

    public String getBlackTilesColor() {
        return this.blackTilesColor == null ? NBTColorSaving.createBlackTilesColor() : this.blackTilesColor;
    }

    public void setTileInfoColor(String colorForNBT) {
        this.tileInfoColor = colorForNBT;
    }

    public String getTileInfoColor() {
        return this.tileInfoColor == null ? NBTColorSaving.createWhiteColor() : this.tileInfoColor;
    }

    public void setShowPreviousMove(boolean shouldShowPreviousMove) {
        this.showPreviousMove = shouldShowPreviousMove;
    }

    public boolean getShowPreviousMove() {
        return this.showPreviousMove;
    }

    public void setShowAvailableMoves(boolean shouldShowAvailableMoves) {
        this.showAvailableMoves = shouldShowAvailableMoves;
    }

    public boolean getShowAvailableMoves() {
        return this.showAvailableMoves;
    }

    public void setUseCustomPlate(boolean shouldUseCustomPlate) {
        this.useCustomPlate = shouldUseCustomPlate;
    }

    public boolean getUseCustomPlate() {
        return this.useCustomPlate;
    }

    public void setPlayPieceAnimations(boolean shouldPlayPieceAnimations) {
        this.playPieceAnimations = shouldPlayPieceAnimations;
    }

    public boolean getPlayPieceAnimations() {
        return this.playPieceAnimations;
    }

    public void setDisplayParticles(boolean shouldDisplayParticles) {
        this.displayParticles = shouldDisplayParticles;
    }

    public boolean getDisplayParticles() {
        return this.displayParticles;
    }

    public void setShowTileInfo(boolean shouldShowTileInfo) {
        this.showTileInfo = shouldShowTileInfo;
    }

    public boolean getShouldShowTileInfo() {
        return this.showTileInfo;
    }

    public void setWaitingForPromotion(boolean waitingForPromotion) {
        this.waitingForPromotion = waitingForPromotion;
    }

    public boolean getWaitingForPromotion() {
        return this.waitingForPromotion;
    }

    public void setPromotionCoordinate(byte promotionCoordinate) {
        this.promotionCoordinate = promotionCoordinate;
    }

    public byte getPromotionCoordinate() {
        return this.promotionCoordinate;
    }

    public void setBoard(Board board) {
        this.board = board;
        this.method_5431();
    }

    public Board getBoard() {
        return this.board;
    }

    public void setSourceTile(BaseChessTile sourceTile) {
        this.sourceTile = sourceTile;
    }

    public BaseChessTile getSourceTile() {
        return this.sourceTile;
    }

    public void setHumanMovedPiece(BasePiece humanMovedPiece) {
        this.humanMovedPiece = humanMovedPiece;
    }

    public BasePiece getHumanMovedPiece() {
        return this.humanMovedPiece;
    }

    public void setDestinationTile(BaseChessTile destinationTile) {
        this.destinationTile = destinationTile;
    }

    public BaseChessTile getDestinationTile() {
        return this.destinationTile;
    }

    public int getPieceSet() {
        return this.pieceSet;
    }

    public void setPieceSet(int set) {
        this.pieceSet = set;
        this.method_5431();
    }

    public BasePiece getCachedPiece() {
        return this.cachedPiece;
    }

    public void setCachedPiece(BasePiece cachedPiece) {
        this.cachedPiece = cachedPiece;
    }

    public List<MoveTransition> getMoveTransitionsCache() {
        return this.moveTransitionsCache;
    }

    public void clearMoveTransitionsCache() {
        this.moveTransitionsCache.clear();
    }

    public void addToMoveTransitionsCache(MoveTransition transition) {
        this.moveTransitionsCache.add(transition);
    }

    public void setPromotionPlayerUUID(UUID uuid) {
        this.promotionPlayerUUID = uuid;
    }

    public UUID getPromotionPlayerUUID() {
        return this.promotionPlayerUUID;
    }

    public boolean isWhiteCheckMate() {
        return this.whiteCheckMate;
    }

    public boolean isBlackCheckMate() {
        return this.blackCheckMate;
    }
}

