/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.block_entities;

import andrews.table_top_craft.objects.blocks.ChessTimerBlock;
import andrews.table_top_craft.registry.TTCBlockEntities;
import andrews.table_top_craft.util.NetworkUtil;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class ChessTimerBlockEntity
extends class_2586 {
    private long leftTimer = 1800000L;
    private long rightTimer = 1800000L;
    public long leftTimerCache;
    public long rightTimerCache;
    public long lastSwitchTime;

    public ChessTimerBlockEntity(class_2338 pos, class_2680 state) {
        super(TTCBlockEntities.CHESS_TIMER, pos, state);
    }

    public class_2487 method_16887() {
        class_2487 compound = new class_2487();
        this.saveToNBT(compound);
        return compound;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        this.saveToNBT(compound);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.loadFromNBT(compound);
    }

    private void saveToNBT(class_2487 compound) {
        class_2487 chessTimerTag = new class_2487();
        chessTimerTag.method_10544("LeftTimer", this.leftTimer);
        chessTimerTag.method_10544("RightTimer", this.rightTimer);
        compound.method_10566("ChessTimerValues", (class_2520)chessTimerTag);
        if (this.method_10997() != null && !this.method_10997().method_8608() && this.rightTimerCache == 0L) {
            this.leftTimerCache = System.currentTimeMillis();
            this.rightTimerCache = System.currentTimeMillis();
        }
    }

    private void loadFromNBT(class_2487 compound) {
        class_2487 chessTimerTag = compound.method_10562("ChessTimerValues");
        this.leftTimer = chessTimerTag.method_10537("LeftTimer");
        this.rightTimer = chessTimerTag.method_10537("RightTimer");
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, ChessTimerBlockEntity blockEntity) {
        if (!level.method_8608()) {
            if (((ChessTimerBlock.PressedButton)((Object)state.method_11654(ChessTimerBlock.PRESSED_BUTTON))).equals((Object)ChessTimerBlock.PressedButton.LEFT)) {
                if (System.currentTimeMillis() >= blockEntity.rightTimerCache) {
                    boolean updateNeighbors = false;
                    blockEntity.rightTimerCache = System.currentTimeMillis() + 1000L;
                    if (blockEntity.getRightTimer() == 1000L) {
                        updateNeighbors = true;
                    }
                    blockEntity.modifyRightTimer(-1000L);
                    level.method_8413(pos, state, state, 2);
                    if (updateNeighbors) {
                        level.method_8452(pos, state.method_26204());
                        level.method_8501(pos, (class_2680)state.method_11657(ChessTimerBlock.PRESSED_BUTTON, (Comparable)((Object)ChessTimerBlock.PressedButton.NONE)));
                        if (level instanceof class_3218) {
                            class_3218 serverLevel = (class_3218)level;
                            NetworkUtil.playChesTimerSoundFromServer(serverLevel, pos, (byte)1);
                        }
                    }
                    blockEntity.method_5431();
                }
            } else if (((ChessTimerBlock.PressedButton)((Object)state.method_11654(ChessTimerBlock.PRESSED_BUTTON))).equals((Object)ChessTimerBlock.PressedButton.RIGHT) && System.currentTimeMillis() >= blockEntity.leftTimerCache) {
                boolean updateNeighbors = false;
                blockEntity.leftTimerCache = System.currentTimeMillis() + 1000L;
                if (blockEntity.getLeftTimer() == 1000L) {
                    updateNeighbors = true;
                }
                blockEntity.modifyLeftTimer(-1000L);
                level.method_8413(pos, state, state, 2);
                if (updateNeighbors) {
                    level.method_8452(pos, state.method_26204());
                    level.method_8501(pos, (class_2680)state.method_11657(ChessTimerBlock.PRESSED_BUTTON, (Comparable)((Object)ChessTimerBlock.PressedButton.NONE)));
                    if (level instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)level;
                        NetworkUtil.playChesTimerSoundFromServer(serverLevel, pos, (byte)1);
                    }
                }
                blockEntity.method_5431();
            }
        }
    }

    public long getLeftTimer() {
        return this.leftTimer;
    }

    public long getRightTimer() {
        return this.rightTimer;
    }

    public void modifyLeftTimer(long amount) {
        this.leftTimer = this.clamp(this.leftTimer + amount, 0L, 359999000L);
    }

    public void modifyRightTimer(long amount) {
        this.rightTimer = this.clamp(this.rightTimer + amount, 0L, 359999000L);
    }

    private long clamp(long value, long min, long max) {
        return Math.max(min, Math.min(max, value));
    }

    public void resetTimers() {
        this.leftTimer = 1800000L;
        this.rightTimer = 1800000L;
    }
}

