/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.block_entities;

import andrews.table_top_craft.animation.system.base.AnimatedBlockEntity;
import andrews.table_top_craft.animation.system.core.AdvancedAnimationState;
import andrews.table_top_craft.registry.TTCBlockEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;

public class ConnectFourBlockEntity
extends AnimatedBlockEntity {
    private String game = "------/------/------/------/------/------/------";
    public AdvancedAnimationState moveState;
    public byte movingPiece = (byte)-1;
    public int ironColor = 0xF9FFFE;
    public int goldColor = 16701501;

    public ConnectFourBlockEntity(class_2338 pos, class_2680 state) {
        super(TTCBlockEntities.CONNECT_FOUR, pos, state);
    }

    public class_2487 method_16887() {
        class_2487 compound = new class_2487();
        this.saveToNBT(compound);
        return compound;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        this.saveToNBT(compound);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.loadFromNBT(compound);
    }

    private void saveToNBT(class_2487 compound) {
        class_2487 connectFourTag = new class_2487();
        connectFourTag.method_10582("Game", this.game);
        connectFourTag.method_10569("IronColor", this.ironColor);
        connectFourTag.method_10569("GoldColor", this.goldColor);
        compound.method_10566("ConnectFourValues", (class_2520)connectFourTag);
    }

    private void loadFromNBT(class_2487 compound) {
        class_2487 connectFourTag = compound.method_10562("ConnectFourValues");
        this.game = this.isValidGame(connectFourTag.method_10558("Game")) ? connectFourTag.method_10558("Game") : "------/------/------/------/------/------/------";
        this.ironColor = connectFourTag.method_10550("IronColor");
        this.goldColor = connectFourTag.method_10550("GoldColor");
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, ConnectFourBlockEntity blockEntity) {
        blockEntity.incTicksExisted();
        if (level.method_8608() && blockEntity.moveState != null && blockEntity.moveState.isFinished()) {
            blockEntity.movingPiece = (byte)-1;
            blockEntity.moveState = null;
        }
    }

    private boolean isValidGame(String game) {
        String[] columns = game.split("/");
        if (columns.length != 7) {
            return false;
        }
        for (String column : columns) {
            if (column.length() == 6) continue;
            return false;
        }
        return true;
    }

    public String[] getColumns() {
        return this.game.split("/");
    }

    public void addPieceToColumn(byte column) {
        if (this.isValidGame(this.game)) {
            String[] columns = this.getColumns();
            for (int i = 0; i < 6; ++i) {
                char columnElement = columns[column].charAt(i);
                if (columnElement == 'g' || columnElement == 'i') continue;
                StringBuilder builder = new StringBuilder();
                builder.append(this.game);
                builder.setCharAt(column * 7 + i, this.getTotalPieces() % 2 == 0 ? (char)'g' : 'i');
                this.game = builder.toString();
                return;
            }
        }
    }

    public int getTotalPieces() {
        int count = 0;
        for (int i = 0; i < this.game.length(); ++i) {
            if (this.game.charAt(i) != 'i' && this.game.charAt(i) != 'g') continue;
            ++count;
        }
        return count;
    }

    public int getTopPieceInColumn(byte column) {
        if (this.isValidGame(this.game)) {
            String[] columns = this.getColumns();
            for (int i = 5; i > 0; --i) {
                char columnElement = columns[column].charAt(i);
                if (columnElement != 'g' && columnElement != 'i') continue;
                return i;
            }
        }
        return 0;
    }

    public void reset() {
        this.game = "------/------/------/------/------/------/------";
    }

    public List<Integer> getFourInRow() {
        int row;
        int col;
        if (!this.isValidGame(this.game)) {
            return new ArrayList<Integer>();
        }
        char[][] board = new char[7][6];
        String[] columns = this.game.split("/");
        for (int i = 0; i < 7; ++i) {
            board[i] = columns[i].toCharArray();
        }
        for (col = 0; col < 7; ++col) {
            for (row = 0; row < 3; ++row) {
                if (board[col][row] == '-' || board[col][row] != board[col][row + 1] || board[col][row] != board[col][row + 2] || board[col][row] != board[col][row + 3]) continue;
                return Arrays.asList(col * 6 + row, col * 6 + row + 1, col * 6 + row + 2, col * 6 + row + 3);
            }
        }
        for (col = 0; col < 4; ++col) {
            for (row = 0; row < 6; ++row) {
                if (board[col][row] == '-' || board[col][row] != board[col + 1][row] || board[col][row] != board[col + 2][row] || board[col][row] != board[col + 3][row]) continue;
                return Arrays.asList(col * 6 + row, (col + 1) * 6 + row, (col + 2) * 6 + row, (col + 3) * 6 + row);
            }
        }
        for (col = 0; col < 4; ++col) {
            for (row = 0; row < 3; ++row) {
                if (board[col][row] == '-' || board[col][row] != board[col + 1][row + 1] || board[col][row] != board[col + 2][row + 2] || board[col][row] != board[col + 3][row + 3]) continue;
                return Arrays.asList(col * 6 + row, (col + 1) * 6 + row + 1, (col + 2) * 6 + row + 2, (col + 3) * 6 + row + 3);
            }
        }
        for (col = 6; col >= 3; --col) {
            for (row = 0; row < 3; ++row) {
                if (board[col][row] == '-' || board[col][row] != board[col - 1][row + 1] || board[col][row] != board[col - 2][row + 2] || board[col][row] != board[col - 3][row + 3]) continue;
                return Arrays.asList(col * 6 + row, (col - 1) * 6 + row + 1, (col - 2) * 6 + row + 2, (col - 3) * 6 + row + 3);
            }
        }
        return new ArrayList<Integer>();
    }

    public boolean hasFourInARow() {
        return !this.getFourInRow().isEmpty();
    }
}

