/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.block_entities;

import andrews.table_top_craft.registry.TTCBlockEntities;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;

public class TicTacToeBlockEntity
extends class_2586 {
    private String ticTacToeGame;
    private int[] frames;
    private String circleColor;
    private String crossColor;

    public TicTacToeBlockEntity(class_2338 pos, class_2680 state) {
        super(TTCBlockEntities.TIC_TAC_TOE, pos, state);
    }

    public class_2487 method_16887() {
        class_2487 compound = new class_2487();
        this.saveToNBT(compound);
        return compound;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        this.saveToNBT(compound);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.loadFromNBT(compound);
        for (int i = 0; i < 9; ++i) {
            char charAtTile = this.getTicTacToeCharAt(i);
            if (charAtTile == '-') {
                if (this.getTicTacToeFrame(i) == 0 || this.getTicTacToeFrame(i) == -1) continue;
                this.setTicTacToeFrameAt(-1, i);
                continue;
            }
            if (charAtTile != 'X' && charAtTile != 'O' || this.getTicTacToeFrame(i) != -1) continue;
            this.setTicTacToeFrameAt(0, i);
        }
    }

    private void saveToNBT(class_2487 compound) {
        class_2487 chessNBT = new class_2487();
        chessNBT.method_10582("TicTacToeGame", this.getTicTacToeGame());
        if (this.circleColor != null) {
            chessNBT.method_10582("CircleColor", this.getCircleColor());
        }
        if (this.crossColor != null) {
            chessNBT.method_10582("CrossColor", this.getCrossColor());
        }
        compound.method_10566("TicTacToeValues", (class_2520)chessNBT);
    }

    private void loadFromNBT(class_2487 compound) {
        class_2487 chessNBT = compound.method_10562("TicTacToeValues");
        if (chessNBT.method_10573("TicTacToeGame", 8)) {
            this.ticTacToeGame = chessNBT.method_10558("TicTacToeGame");
        }
        if (chessNBT.method_10573("CircleColor", 8)) {
            this.circleColor = chessNBT.method_10558("CircleColor");
        }
        if (chessNBT.method_10573("CrossColor", 8)) {
            this.crossColor = chessNBT.method_10558("CrossColor");
        }
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, TicTacToeBlockEntity blockEntity) {
        String game = blockEntity.getTicTacToeGame().replaceAll("/", "");
        for (int i = 0; i < 9; ++i) {
            if (game.charAt(i) == 'O' && blockEntity.getTicTacToeFrames()[i] >= 0 && blockEntity.getTicTacToeFrames()[i] < 15) {
                blockEntity.setTicTacToeFrameAt(blockEntity.getTicTacToeFrames()[i] + 1, i);
            }
            if (game.charAt(i) != 'X' || blockEntity.getTicTacToeFrames()[i] < 0 || blockEntity.getTicTacToeFrames()[i] >= 13) continue;
            blockEntity.setTicTacToeFrameAt(blockEntity.getTicTacToeFrames()[i] + 1, i);
        }
    }

    public String getTicTacToeGame() {
        return this.ticTacToeGame == null ? "---/---/---" : this.ticTacToeGame;
    }

    public char getTicTacToeCharAt(int index) {
        char[] gameChars = this.getTicTacToeGame().replaceAll("/", "").toCharArray();
        return gameChars[index];
    }

    public int[] getTicTacToeFrames() {
        int[] nArray;
        if (this.frames == null) {
            int[] nArray2 = new int[9];
            nArray2[0] = -1;
            nArray2[1] = -1;
            nArray2[2] = -1;
            nArray2[3] = -1;
            nArray2[4] = -1;
            nArray2[5] = -1;
            nArray2[6] = -1;
            nArray2[7] = -1;
            nArray = nArray2;
            nArray2[8] = -1;
        } else {
            nArray = this.frames;
        }
        return nArray;
    }

    public int getTicTacToeFrame(int index) {
        if (this.frames == null) {
            int c1 = this.getTicTacToeCharAt(0) == '-' ? -1 : 0;
            int c2 = this.getTicTacToeCharAt(1) == '-' ? -1 : 0;
            int c3 = this.getTicTacToeCharAt(2) == '-' ? -1 : 0;
            int c4 = this.getTicTacToeCharAt(3) == '-' ? -1 : 0;
            int c5 = this.getTicTacToeCharAt(4) == '-' ? -1 : 0;
            int c6 = this.getTicTacToeCharAt(5) == '-' ? -1 : 0;
            int c7 = this.getTicTacToeCharAt(6) == '-' ? -1 : 0;
            int c8 = this.getTicTacToeCharAt(7) == '-' ? -1 : 0;
            int c9 = this.getTicTacToeCharAt(8) == '-' ? -1 : 0;
            this.frames = new int[]{c1, c2, c3, c4, c5, c6, c7, c8, c9};
        }
        return this.frames[index];
    }

    public void setTicTacToeFrameAt(int value, int index) {
        if (this.frames == null) {
            this.frames = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
        }
        this.frames[index] = value;
    }

    public void resetFrames() {
        this.frames = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
    }

    public void setTicTacToeGame(String game) {
        this.ticTacToeGame = game;
        this.method_5431();
    }

    public String getCircleColor() {
        if (this.circleColor == null) {
            this.circleColor = "249/255/254";
        }
        return this.circleColor;
    }

    public String getCrossColor() {
        if (this.crossColor == null) {
            this.crossColor = "249/255/254";
        }
        return this.crossColor;
    }

    public void setCircleColor(String circleColor) {
        this.circleColor = circleColor;
        this.method_5431();
    }

    public void setCrossColor(String crossColor) {
        this.crossColor = crossColor;
        this.method_5431();
    }

    public boolean isGameOver(String game) {
        String[] rows = game.split("/");
        if (rows[0].equals("XXX") || rows[0].equals("OOO") || rows[1].equals("XXX") || rows[1].equals("OOO") || rows[2].equals("XXX") || rows[2].equals("OOO")) {
            return true;
        }
        if (rows[0].charAt(0) == 'X' && rows[1].charAt(0) == 'X' && rows[2].charAt(0) == 'X' || rows[0].charAt(0) == 'O' && rows[1].charAt(0) == 'O' && rows[2].charAt(0) == 'O') {
            return true;
        }
        if (rows[0].charAt(1) == 'X' && rows[1].charAt(1) == 'X' && rows[2].charAt(1) == 'X' || rows[0].charAt(1) == 'O' && rows[1].charAt(1) == 'O' && rows[2].charAt(1) == 'O') {
            return true;
        }
        if (rows[0].charAt(2) == 'X' && rows[1].charAt(2) == 'X' && rows[2].charAt(2) == 'X' || rows[0].charAt(2) == 'O' && rows[1].charAt(2) == 'O' && rows[2].charAt(2) == 'O') {
            return true;
        }
        if (rows[0].charAt(0) == 'X' && rows[1].charAt(1) == 'X' && rows[2].charAt(2) == 'X' || rows[0].charAt(0) == 'O' && rows[1].charAt(1) == 'O' && rows[2].charAt(2) == 'O') {
            return true;
        }
        return rows[0].charAt(2) == 'X' && rows[1].charAt(1) == 'X' && rows[2].charAt(0) == 'X' || rows[0].charAt(2) == 'O' && rows[1].charAt(1) == 'O' && rows[2].charAt(0) == 'O';
    }
}

