/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.block_entities.render;

import andrews.table_top_craft.animation.system.core.AnimationHandler;
import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.block_entities.model.chess.ChessBoardPlateModel;
import andrews.table_top_craft.block_entities.model.chess.ChessHighlightModel;
import andrews.table_top_craft.block_entities.model.chess.ChessTilesInfoModel;
import andrews.table_top_craft.block_entities.model.chess.GhostModel;
import andrews.table_top_craft.block_entities.render.BufferHelpers;
import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.ChessMoveLog;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.player.BlackChessPlayer;
import andrews.table_top_craft.game_logic.chess.player.MoveTransition;
import andrews.table_top_craft.game_logic.chess.player.WhiteChessPlayer;
import andrews.table_top_craft.objects.blocks.ChessBlock;
import andrews.table_top_craft.util.Color;
import andrews.table_top_craft.util.DrawScreenHelper;
import andrews.table_top_craft.util.NBTColorSaving;
import andrews.table_top_craft.util.TTCRenderTypes;
import andrews.table_top_craft.util.shader_compat.ShaderCompatHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_291;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_5944;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Quaternionf;

public class ChessBlockEntityRenderer
implements class_827<ChessBlockEntity> {
    private static final class_2960 HIGHLIGHT_TEXTURE = new class_2960("table_top_craft", "textures/tile/chess/highlight.png");
    private static final class_2960 TILES_INFO_TEXTURE = new class_2960("table_top_craft", "textures/tile/chess/chess_tiles_info.png");
    private static final class_2960 PLATE_WHITE_TILES_TEXTURE = new class_2960("table_top_craft", "textures/tile/chess/plate_white_tiles.png");
    private static final class_2960 PLATE_BLACK_TILES_TEXTURE = new class_2960("table_top_craft", "textures/tile/chess/plate_black_tiles.png");
    private static final float CHESS_SCALE = 0.125f;
    private final float CHESS_PIECE_SCALE = 0.1f;
    private static final class_1011 image = new class_1011(class_1011.class_1012.field_4997, 1, 1, true);
    private static final class_1043 texture = new class_1043(image);
    private static class_2960 resourceLocation = null;
    public static final class_2960 SHADER_COMPAT_WHITE = new class_2960("table_top_craft", "textures/tile/compat/full_white.png");
    private final ChessHighlightModel highlightModel;
    private final ChessTilesInfoModel tilesInfoModel;
    private final ChessBoardPlateModel chessBoardPlateModel;
    private final GhostModel ghostModel;
    private final List<Integer> destinationCoordinates = new ArrayList<Integer>();
    private final List<BasePiece> whiteTakenPieces = new ArrayList<BasePiece>();
    private final List<BasePiece> blackTakenPieces = new ArrayList<BasePiece>();
    int cachedIdx;

    public ChessBlockEntityRenderer(class_5614.class_5615 context) {
        this.highlightModel = new ChessHighlightModel(context.method_32140(ChessHighlightModel.CHESS_HIGHLIGHT_LAYER));
        this.tilesInfoModel = new ChessTilesInfoModel(context.method_32140(ChessTilesInfoModel.CHESS_TILES_INFO_LAYER));
        this.chessBoardPlateModel = new ChessBoardPlateModel(context.method_32140(ChessBoardPlateModel.CHESS_BOARD_PLATE_LAYER));
        this.ghostModel = new GhostModel(context.method_32140(GhostModel.LAYER));
    }

    public void render(ChessBlockEntity tileEntityIn, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        class_2680 blockstate;
        this.ghostModel.updateAnimations(tileEntityIn, partialTicks);
        class_2350 facing = class_2350.field_11043;
        if (tileEntityIn.method_11002() && (blockstate = tileEntityIn.method_10997().method_8320(tileEntityIn.method_11016())).method_26204() instanceof ChessBlock) {
            facing = (class_2350)blockstate.method_11654((class_2769)ChessBlock.FACING);
        }
        int lightU = class_765.method_24186((int)combinedLightIn);
        int lightV = class_765.method_24187((int)combinedLightIn);
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.9, 0.5);
        poseStack.method_22905(1.0f, -1.0f, -1.0f);
        switch (facing) {
            default: {
                poseStack.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
                break;
            }
            case field_11035: {
                break;
            }
            case field_11039: {
                poseStack.method_22907(class_7833.field_40715.rotationDegrees(270.0f));
                break;
            }
            case field_11034: {
                poseStack.method_22907(class_7833.field_40715.rotationDegrees(90.0f));
            }
        }
        if (tileEntityIn.getUseCustomPlate()) {
            this.renderChessBoardPlate(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, tileEntityIn);
        }
        if (tileEntityIn.getShouldShowTileInfo()) {
            this.renderTilesInfo(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, tileEntityIn);
        }
        poseStack.method_22909();
        if (tileEntityIn.getBoard() != null) {
            int column;
            int rank;
            Board board = tileEntityIn.getBoard();
            WhiteChessPlayer whiteChessPlayer = (WhiteChessPlayer)board.getWhiteChessPlayer();
            BlackChessPlayer blackChessPlayer = (BlackChessPlayer)board.getBlackChessPlayer();
            boolean isWhiteInCheckmate = tileEntityIn.isWhiteCheckMate();
            boolean isBlackInCheckmate = tileEntityIn.isBlackCheckMate();
            poseStack.method_22903();
            poseStack.method_22904(0.5, 0.9, 0.5);
            poseStack.method_22905(1.0f, -1.0f, -1.0f);
            switch (facing) {
                default: {
                    poseStack.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
                    break;
                }
                case field_11035: {
                    break;
                }
                case field_11039: {
                    poseStack.method_22907(class_7833.field_40715.rotationDegrees(270.0f));
                    break;
                }
                case field_11034: {
                    poseStack.method_22907(class_7833.field_40715.rotationDegrees(90.0f));
                }
            }
            poseStack.method_22904(0.0625, 0.0, 0.0625);
            poseStack.method_22904(0.375, 0.0, -0.5);
            int currentCoordinate = -1;
            poseStack.method_22903();
            float wR = (float)NBTColorSaving.getRed(tileEntityIn.getWhitePiecesColor()) / 255.0f;
            float wG = (float)NBTColorSaving.getGreen(tileEntityIn.getWhitePiecesColor()) / 255.0f;
            float wB = (float)NBTColorSaving.getBlue(tileEntityIn.getWhitePiecesColor()) / 255.0f;
            float bR = (float)NBTColorSaving.getRed(tileEntityIn.getBlackPiecesColor()) / 255.0f;
            float bG = (float)NBTColorSaving.getGreen(tileEntityIn.getBlackPiecesColor()) / 255.0f;
            float bB = (float)NBTColorSaving.getBlue(tileEntityIn.getBlackPiecesColor()) / 255.0f;
            class_4588 consumer = bufferIn.getBuffer(class_1921.method_23572((class_2960)SHADER_COMPAT_WHITE));
            BasePiece.PieceModelSet set = BasePiece.PieceModelSet.get(tileEntityIn.getPieceSet() + 1);
            class_1921 type = TTCRenderTypes.getChessPieceSolid(resourceLocation);
            type.method_23516();
            class_5944 shaderinstance = RenderSystem.getShader();
            if (!ShaderCompatHandler.isShaderActive()) {
                if (shaderinstance.field_29471 != null) {
                    shaderinstance.field_29471.method_1250(RenderSystem.getProjectionMatrix());
                }
                BufferHelpers.setupRender(RenderSystem.getShader(), lightU, lightV);
                shaderinstance.method_34586();
            }
            for (rank = 0; rank < 8; ++rank) {
                for (column = 0; column < 8; ++column) {
                    boolean isSelectedPiece;
                    boolean bl = isSelectedPiece = board.getTile(++currentCoordinate) == tileEntityIn.getSourceTile() && tileEntityIn.getHumanMovedPiece() != null;
                    if (!board.getTile(currentCoordinate).isTileOccupied()) continue;
                    PieceColor pieceColor = board.getTile(currentCoordinate).getPiece().getPieceColor();
                    BasePiece.PieceType pieceType = board.getTile(currentCoordinate).getPiece().getPieceType();
                    poseStack.method_22903();
                    poseStack.method_22904((double)(0.125f * (float)(-column)), 0.0, (double)(0.125f * (float)rank));
                    poseStack.method_22903();
                    poseStack.method_22904(0.0, 0.15, 0.0);
                    if (pieceColor.isWhite()) {
                        poseStack.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
                    }
                    if (isWhiteInCheckmate && pieceColor.isBlack()) {
                        poseStack.method_46416(0.0f, (float)Math.abs(Math.sin((double)((float)class_310.method_1551().field_1724.field_6012 + partialTicks) / 2.5)) * -0.05f, 0.0f);
                        poseStack.method_22907(class_7833.field_40717.rotationDegrees((float)Math.cos((double)((float)class_310.method_1551().field_1724.field_6012 + partialTicks) / 2.5) * 10.0f));
                    }
                    if (isBlackInCheckmate && pieceColor.isWhite()) {
                        poseStack.method_46416(0.0f, (float)Math.abs(Math.sin((double)((float)class_310.method_1551().field_1724.field_6012 + partialTicks) / 2.5)) * -0.05f, 0.0f);
                        poseStack.method_22907(class_7833.field_40717.rotationDegrees((float)Math.cos((double)((float)class_310.method_1551().field_1724.field_6012 + partialTicks) / 2.5) * 10.0f));
                    }
                    poseStack.method_46416(0.125f * this.ghostModel.root.field_3657 * 0.5f, 0.125f * this.ghostModel.root.field_3656 * 0.5f, 0.125f * this.ghostModel.root.field_3655 * 0.5f);
                    if (AnimationHandler.getElapsedSeconds(tileEntityIn.placedState) > tileEntityIn.placedState.getInTime()) {
                        poseStack.method_22907(new Quaternionf().rotationZYX(this.ghostModel.root.field_3674, this.ghostModel.root.field_3675, this.ghostModel.root.field_3654));
                    }
                    poseStack.method_22905(this.ghostModel.root.field_37938, this.ghostModel.root.field_37939, this.ghostModel.root.field_37940);
                    if (currentCoordinate == tileEntityIn.selectedPiecePos) {
                        poseStack.method_46416(0.125f * this.ghostModel.selected.field_3657 * 0.5f, 0.125f * this.ghostModel.selected.field_3656 * 0.5f, 0.125f * this.ghostModel.selected.field_3655 * 0.5f);
                        poseStack.method_22907(new Quaternionf().rotationZYX(this.ghostModel.selected.field_3674, this.ghostModel.selected.field_3675, this.ghostModel.selected.field_3654));
                    }
                    if (tileEntityIn.moveState != null) {
                        if (tileEntityIn.currentCord == currentCoordinate) {
                            poseStack.method_46416(0.125f * this.ghostModel.moved.field_3657 * 0.5f, 0.125f * this.ghostModel.moved.field_3656 * 0.5f, 0.125f * this.ghostModel.moved.field_3655 * 0.5f);
                            poseStack.method_22907(new Quaternionf().rotationZYX(this.ghostModel.moved.field_3674, this.ghostModel.moved.field_3675, this.ghostModel.moved.field_3654));
                        }
                        if (tileEntityIn.destCord == currentCoordinate) {
                            poseStack.method_46416(0.125f * this.ghostModel.affected.field_3657 * 0.5f, 0.125f * this.ghostModel.affected.field_3656 * 0.5f, 0.125f * this.ghostModel.affected.field_3655 * 0.5f);
                            poseStack.method_22907(new Quaternionf().rotationZYX(this.ghostModel.affected.field_3674, this.ghostModel.affected.field_3675, this.ghostModel.affected.field_3654));
                            poseStack.method_22905(this.ghostModel.affected.field_37938, this.ghostModel.affected.field_37939, this.ghostModel.affected.field_37940);
                        }
                        if (tileEntityIn.currentCord == 60 && board.getTile(60).getPiece().getPieceType().isKing() && (tileEntityIn.destCord == 62 && currentCoordinate == 63 || tileEntityIn.destCord == 58 && currentCoordinate == 56)) {
                            poseStack.method_46416(0.125f * this.ghostModel.affected.field_3657 * 0.5f, 0.125f * this.ghostModel.affected.field_3656 * 0.5f, 0.125f * this.ghostModel.affected.field_3655 * 0.5f);
                            poseStack.method_22907(new Quaternionf().rotationZYX(this.ghostModel.affected.field_3674, this.ghostModel.affected.field_3675, this.ghostModel.affected.field_3654));
                        }
                        if (tileEntityIn.currentCord == 4 && board.getTile(4).getPiece().getPieceType().isKing() && (tileEntityIn.destCord == 6 && currentCoordinate == 7 || tileEntityIn.destCord == 2 && currentCoordinate == 0)) {
                            poseStack.method_46416(0.125f * this.ghostModel.affected.field_3657 * 0.5f, 0.125f * this.ghostModel.affected.field_3656 * 0.5f, 0.125f * this.ghostModel.affected.field_3655 * 0.5f);
                            poseStack.method_22907(new Quaternionf().rotationZYX(this.ghostModel.affected.field_3674, this.ghostModel.affected.field_3675, this.ghostModel.affected.field_3654));
                        }
                        if (board.getTile(tileEntityIn.currentCord).getPiece().getPieceColor().isWhite() && tileEntityIn.currentCord / 8 == 3 && (tileEntityIn.currentCord % 8 - tileEntityIn.destCord % 8 == -1 || tileEntityIn.currentCord % 8 - tileEntityIn.destCord % 8 == 1) && board.getTile(tileEntityIn.destCord).getPiece() == null && currentCoordinate == tileEntityIn.destCord + 8) {
                            poseStack.method_46416(0.125f * this.ghostModel.affected.field_3657 * 0.5f, 0.125f * this.ghostModel.affected.field_3656 * 0.5f, 0.125f * this.ghostModel.affected.field_3655 * 0.5f);
                            poseStack.method_22907(new Quaternionf().rotationZYX(this.ghostModel.affected.field_3674, this.ghostModel.affected.field_3675, this.ghostModel.affected.field_3654));
                            poseStack.method_22905(this.ghostModel.affected.field_37938, this.ghostModel.affected.field_37939, this.ghostModel.affected.field_37940);
                        }
                        if (board.getTile(tileEntityIn.currentCord).getPiece().getPieceColor().isBlack() && tileEntityIn.currentCord / 8 == 4 && (tileEntityIn.currentCord % 8 - tileEntityIn.destCord % 8 == -1 || tileEntityIn.currentCord % 8 - tileEntityIn.destCord % 8 == 1) && board.getTile(tileEntityIn.destCord).getPiece() == null && currentCoordinate == tileEntityIn.destCord - 8) {
                            poseStack.method_46416(0.125f * this.ghostModel.affected.field_3657 * 0.5f, 0.125f * this.ghostModel.affected.field_3656 * 0.5f, 0.125f * this.ghostModel.affected.field_3655 * 0.5f);
                            poseStack.method_22907(new Quaternionf().rotationZYX(this.ghostModel.affected.field_3674, this.ghostModel.affected.field_3675, this.ghostModel.affected.field_3654));
                            poseStack.method_22905(this.ghostModel.affected.field_37938, this.ghostModel.affected.field_37939, this.ghostModel.affected.field_37940);
                        }
                    }
                    if (isSelectedPiece) {
                        Color colorW = new Color(Math.round(255.0f * wR), Math.round(255.0f * wG), Math.round(255.0f * wB));
                        float brightnessW = 0.2126f * (float)colorW.getRed() + 0.7152f * (float)colorW.getGreen() + 0.0722f * (float)colorW.getBlue();
                        Color colorB = new Color(Math.round(255.0f * bR), Math.round(255.0f * bG), Math.round(255.0f * bB));
                        float brightnessB = 0.2126f * (float)colorB.getRed() + 0.7152f * (float)colorB.getGreen() + 0.0722f * (float)colorB.getBlue();
                        if (!ShaderCompatHandler.isShaderActive()) {
                            poseStack.method_22903();
                            poseStack.method_22905(1.001f, 1.001f, 1.001f);
                            RenderSystem.polygonMode((int)1032, (int)6913);
                            float whiteLines = brightnessW * 0.5f / 255.0f;
                            float blackLines = brightnessB * 0.5f / 255.0f;
                            this.renderPiece(poseStack, tileEntityIn.getPieceSet(), pieceType, pieceColor, whiteLines, whiteLines, whiteLines, blackLines, blackLines, blackLines);
                            RenderSystem.polygonMode((int)1032, (int)6914);
                            poseStack.method_22909();
                        }
                        colorW = brightnessW > 128.0f ? colorW.darker(0.8f, 0.0f) : colorW.brighter(0.8f, 0.0f);
                        Color color = colorB = brightnessB > 128.0f ? colorB.darker(0.8f, 0.0f) : colorB.brighter(0.8f, 0.0f);
                        if (ShaderCompatHandler.isShaderActive()) {
                            DrawScreenHelper.CHESS_PIECE_MODEL.render(poseStack, consumer, pieceType, set, pieceColor.isWhite() ? (float)colorW.getRed() / 255.0f : (float)colorB.getRed() / 255.0f, pieceColor.isWhite() ? (float)colorW.getGreen() / 255.0f : (float)colorB.getGreen() / 255.0f, pieceColor.isWhite() ? (float)colorW.getBlue() / 255.0f : (float)colorB.getBlue() / 255.0f, combinedLightIn);
                        } else {
                            this.renderPiece(poseStack, tileEntityIn.getPieceSet(), pieceType, pieceColor, (float)colorW.getRed() / 255.0f, (float)colorW.getGreen() / 255.0f, (float)colorW.getBlue() / 255.0f, (float)colorB.getRed() / 255.0f, (float)colorB.getGreen() / 255.0f, (float)colorB.getBlue() / 255.0f);
                        }
                    } else if (ShaderCompatHandler.isShaderActive()) {
                        DrawScreenHelper.CHESS_PIECE_MODEL.render(poseStack, consumer, pieceType, set, pieceColor.isWhite() ? wR : bR, pieceColor.isWhite() ? wG : bG, pieceColor.isWhite() ? wB : bB, combinedLightIn);
                    } else {
                        this.renderPiece(poseStack, tileEntityIn.getPieceSet(), pieceType, pieceColor, wR, wG, wB, bR, bG, bB);
                    }
                    poseStack.method_22909();
                    poseStack.method_22909();
                }
            }
            poseStack.method_22904(-0.8125, 0.58725, 0.0625);
            this.renderTakenPieces(poseStack, bufferIn, tileEntityIn, combinedLightIn);
            if (!ShaderCompatHandler.isShaderActive()) {
                class_291.method_1354();
                shaderinstance.method_34585();
                type.method_23518();
            }
            poseStack.method_22909();
            currentCoordinate = -1;
            for (rank = 0; rank < 8; ++rank) {
                for (column = 0; column < 8; ++column) {
                    ++currentCoordinate;
                    poseStack.method_22903();
                    poseStack.method_22904((double)(0.125f * (float)(-column)), 0.0, (double)(0.125f * (float)rank));
                    if (tileEntityIn.getShowPreviousMove() && tileEntityIn.getMoveLog().getMoves().size() > 0) {
                        BaseMove lastMove = tileEntityIn.getMoveLog().getMoves().get(tileEntityIn.getMoveLog().getMoves().size() - 1);
                        for (BaseMove move : this.pieceLegalMoves(tileEntityIn)) {
                            this.destinationCoordinates.add(move.getDestinationCoordinate());
                        }
                        if (!(lastMove.getCurrentCoordinate() != currentCoordinate || this.destinationCoordinates.contains(lastMove.getCurrentCoordinate()) && tileEntityIn.getShowAvailableMoves())) {
                            this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, HighlightType.LAST_MADE_MOVE, tileEntityIn);
                        }
                        if (!(lastMove.getDestinationCoordinate() != currentCoordinate || this.destinationCoordinates.contains(lastMove.getDestinationCoordinate()) && tileEntityIn.getShowAvailableMoves())) {
                            this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, HighlightType.LAST_MADE_MOVE, tileEntityIn);
                        }
                        this.destinationCoordinates.clear();
                    }
                    if (!(tileEntityIn.getHumanMovedPiece() == null || tileEntityIn.getHumanMovedPiece().getPieceColor() != tileEntityIn.getBoard().getCurrentChessPlayer().getPieceColor() || tileEntityIn.getCachedPiece() != null && tileEntityIn.getCachedPiece().equals(tileEntityIn.getHumanMovedPiece()))) {
                        tileEntityIn.clearMoveTransitionsCache();
                        for (BaseMove move : this.pieceLegalMoves(tileEntityIn)) {
                            MoveTransition transition = board.getCurrentChessPlayer().makeMove(move);
                            tileEntityIn.addToMoveTransitionsCache(transition);
                        }
                        tileEntityIn.setCachedPiece(tileEntityIn.getHumanMovedPiece());
                    }
                    if (tileEntityIn.getShowAvailableMoves()) {
                        block20: for (int i = 0; i < this.pieceLegalMoves(tileEntityIn).size(); ++i) {
                            MoveTransition transition;
                            BaseMove move;
                            if (tileEntityIn.getMoveTransitionsCache().isEmpty() || (move = (transition = tileEntityIn.getMoveTransitionsCache().get(i)).getMove()).getDestinationCoordinate() != currentCoordinate) continue;
                            if (move.isCastlingMove()) {
                                this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, HighlightType.CASTLE_MOVE, tileEntityIn);
                                continue;
                            }
                            switch (transition.getMoveStatus()) {
                                case DONE: {
                                    this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, move.isAttack() ? HighlightType.ATTACK_MOVE : HighlightType.LEGAL_MOVE, tileEntityIn);
                                    continue block20;
                                }
                                case LEAVES_PLAYER_IN_CHECK: {
                                    this.renderHighlight(poseStack, bufferIn, combinedLightIn, combinedOverlayIn, HighlightType.LEAVES_PLAYER_IN_CHECK, tileEntityIn);
                                }
                            }
                        }
                    }
                    poseStack.method_22909();
                }
            }
            poseStack.method_22909();
        }
    }

    private void renderTakenPieces(class_4587 stack, class_4597 buffer, ChessBlockEntity chessBlockEntity, int packedLight) {
        ChessMoveLog moveLog = chessBlockEntity.getMoveLog();
        for (BaseMove move : moveLog.getMoves()) {
            if (!move.isAttack()) continue;
            BasePiece takenPiece = move.getAttackedPiece();
            if (takenPiece.getPieceColor().isWhite()) {
                this.whiteTakenPieces.add(takenPiece);
                continue;
            }
            if (takenPiece.getPieceColor().isBlack()) {
                this.blackTakenPieces.add(takenPiece);
                continue;
            }
            throw new RuntimeException("Attempted to get a Piece that had no PieceColor");
        }
        this.whiteTakenPieces.sort((piece1, piece2) -> Ints.compare((int)piece2.getPieceValue(), (int)piece1.getPieceValue()));
        this.blackTakenPieces.sort((piece1, piece2) -> Ints.compare((int)piece2.getPieceValue(), (int)piece1.getPieceValue()));
        this.renderTakenPiecesFigures(stack, buffer, chessBlockEntity, this.whiteTakenPieces, true, packedLight);
        this.renderTakenPiecesFigures(stack, buffer, chessBlockEntity, this.blackTakenPieces, false, packedLight);
        this.whiteTakenPieces.clear();
        this.blackTakenPieces.clear();
    }

    private void renderTakenPiecesFigures(class_4587 stack, class_4597 buffer, ChessBlockEntity chessBlockEntity, List<BasePiece> pieceList, boolean isWhite, int packedLight) {
        int currentCoordinate = -1;
        int currentRank = 0;
        float wR = (float)NBTColorSaving.getRed(chessBlockEntity.getWhitePiecesColor()) / 255.0f;
        float wG = (float)NBTColorSaving.getGreen(chessBlockEntity.getWhitePiecesColor()) / 255.0f;
        float wB = (float)NBTColorSaving.getBlue(chessBlockEntity.getWhitePiecesColor()) / 255.0f;
        float bR = (float)NBTColorSaving.getRed(chessBlockEntity.getBlackPiecesColor()) / 255.0f;
        float bG = (float)NBTColorSaving.getGreen(chessBlockEntity.getBlackPiecesColor()) / 255.0f;
        float bB = (float)NBTColorSaving.getBlue(chessBlockEntity.getBlackPiecesColor()) / 255.0f;
        class_4588 consumer = buffer.getBuffer(class_1921.method_23572((class_2960)SHADER_COMPAT_WHITE));
        BasePiece.PieceModelSet set = BasePiece.PieceModelSet.get(chessBlockEntity.getPieceSet() + 1);
        for (BasePiece piece : pieceList) {
            if (currentCoordinate < 7) {
                ++currentCoordinate;
            } else {
                currentCoordinate = 0;
                ++currentRank;
            }
            stack.method_22903();
            if (isWhite) {
                stack.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
            }
            if (!isWhite) {
                stack.method_22904(0.7481249999999999, 0.0, 0.75);
            }
            stack.method_22904(0.106875 * (double)(-currentCoordinate), 0.0, (double)(0.125f * (float)(-currentRank)));
            if (ShaderCompatHandler.isShaderActive()) {
                DrawScreenHelper.CHESS_PIECE_MODEL.render(stack, consumer, piece.getPieceType(), set, isWhite ? wR : bR, isWhite ? wG : bG, isWhite ? wB : bB, packedLight);
            } else {
                this.renderPiece(stack, chessBlockEntity.getPieceSet(), piece.getPieceType(), piece.getPieceColor(), wR, wG, wB, bR, bG, bB);
            }
            stack.method_22909();
        }
    }

    private void renderPiece(class_4587 poseStack, int pieceModelSet, BasePiece.PieceType pieceType, PieceColor pieceColor, float wR, float wG, float wB, float bR, float bG, float bB) {
        class_5944 shaderinstance = RenderSystem.getShader();
        BufferHelpers.updateColor(shaderinstance, new float[]{pieceColor.isWhite() ? wR : bR, pieceColor.isWhite() ? wG : bG, pieceColor.isWhite() ? wB : bB, 1.0f});
        poseStack.method_22903();
        if (shaderinstance.field_29470 != null) {
            shaderinstance.field_29470.method_1250(poseStack.method_23760().method_23761());
        }
        BasePiece.PieceModelSet set = BasePiece.PieceModelSet.get(pieceModelSet + 1);
        class_291 pawnBuffer = DrawScreenHelper.getBuffer(set, pieceType);
        BufferHelpers.draw(pawnBuffer);
        poseStack.method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private Collection<BaseMove> pieceLegalMoves(ChessBlockEntity chessBlockEntity) {
        if (chessBlockEntity.getHumanMovedPiece() != null && chessBlockEntity.getHumanMovedPiece().getPieceColor() == chessBlockEntity.getBoard().getCurrentChessPlayer().getPieceColor()) {
            ArrayList<BaseMove> pieceMoves = new ArrayList<BaseMove>();
            for (BaseMove move : chessBlockEntity.getBoard().getCurrentChessPlayer().getLegalMoves()) {
                if (move.getMovedPiece() != chessBlockEntity.getHumanMovedPiece()) continue;
                pieceMoves.add(move);
            }
            return ImmutableList.copyOf(pieceMoves);
        }
        return Collections.emptyList();
    }

    private void renderHighlight(class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn, HighlightType highlightType, ChessBlockEntity chessBlockEntity) {
        class_4588 builderHighlight = bufferIn.getBuffer(TTCRenderTypes.getEmissiveTransluscent(HIGHLIGHT_TEXTURE, false));
        poseStack.method_22903();
        poseStack.method_46416(0.0f, -1.345f, 0.0f);
        poseStack.method_22905(1.0f, 1.0f, 1.0f);
        poseStack.method_23760().method_23762().rotationZYX(0.0f, (float)Math.PI, 0.0f);
        switch (highlightType) {
            default: {
                float R = (float)NBTColorSaving.getRed(chessBlockEntity.getLegalMoveColor()) / 255.0f;
                float G = (float)NBTColorSaving.getGreen(chessBlockEntity.getLegalMoveColor()) / 255.0f;
                float B = (float)NBTColorSaving.getBlue(chessBlockEntity.getLegalMoveColor()) / 255.0f;
                float A = (float)NBTColorSaving.getAlpha(chessBlockEntity.getLegalMoveColor()) / 255.0f;
                this.highlightModel.method_2828(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R, G, B, A);
                break;
            }
            case LEAVES_PLAYER_IN_CHECK: {
                float R1 = (float)NBTColorSaving.getRed(chessBlockEntity.getInvalidMoveColor()) / 255.0f;
                float G1 = (float)NBTColorSaving.getGreen(chessBlockEntity.getInvalidMoveColor()) / 255.0f;
                float B1 = (float)NBTColorSaving.getBlue(chessBlockEntity.getInvalidMoveColor()) / 255.0f;
                float A1 = (float)NBTColorSaving.getAlpha(chessBlockEntity.getInvalidMoveColor()) / 255.0f;
                this.highlightModel.method_2828(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R1, G1, B1, A1);
                break;
            }
            case CASTLE_MOVE: {
                float R2 = (float)NBTColorSaving.getRed(chessBlockEntity.getCastleMoveColor()) / 255.0f;
                float G2 = (float)NBTColorSaving.getGreen(chessBlockEntity.getCastleMoveColor()) / 255.0f;
                float B2 = (float)NBTColorSaving.getBlue(chessBlockEntity.getCastleMoveColor()) / 255.0f;
                float A2 = (float)NBTColorSaving.getAlpha(chessBlockEntity.getCastleMoveColor()) / 255.0f;
                this.highlightModel.method_2828(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R2, G2, B2, A2);
                break;
            }
            case ATTACK_MOVE: {
                float R3 = (float)NBTColorSaving.getRed(chessBlockEntity.getAttackMoveColor()) / 255.0f;
                float G3 = (float)NBTColorSaving.getGreen(chessBlockEntity.getAttackMoveColor()) / 255.0f;
                float B3 = (float)NBTColorSaving.getBlue(chessBlockEntity.getAttackMoveColor()) / 255.0f;
                float A3 = (float)NBTColorSaving.getAlpha(chessBlockEntity.getAttackMoveColor()) / 255.0f;
                this.highlightModel.method_2828(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R3, G3, B3, A3);
                break;
            }
            case LAST_MADE_MOVE: {
                float R4 = (float)NBTColorSaving.getRed(chessBlockEntity.getPreviousMoveColor()) / 255.0f;
                float G4 = (float)NBTColorSaving.getGreen(chessBlockEntity.getPreviousMoveColor()) / 255.0f;
                float B4 = (float)NBTColorSaving.getBlue(chessBlockEntity.getPreviousMoveColor()) / 255.0f;
                float A4 = (float)NBTColorSaving.getAlpha(chessBlockEntity.getPreviousMoveColor()) / 255.0f;
                this.highlightModel.method_2828(poseStack, builderHighlight, combinedLightIn, combinedOverlayIn, R4, G4, B4, A4);
            }
        }
        poseStack.method_22909();
    }

    private void renderTilesInfo(class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn, ChessBlockEntity chessBlockEntity) {
        class_4588 builderTilesInfo = bufferIn.getBuffer(TTCRenderTypes.getEmissiveTransluscent(TILES_INFO_TEXTURE, false));
        float red = (float)NBTColorSaving.getRed(chessBlockEntity.getTileInfoColor()) / 255.0f;
        float green = (float)NBTColorSaving.getGreen(chessBlockEntity.getTileInfoColor()) / 255.0f;
        float blue = (float)NBTColorSaving.getBlue(chessBlockEntity.getTileInfoColor()) / 255.0f;
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(180.0f));
        poseStack.method_46416(0.0f, -1.32f, 0.0f);
        poseStack.method_23760().method_23762().rotationZYX(0.0f, (float)Math.PI, 0.0f);
        this.tilesInfoModel.method_2828(poseStack, builderTilesInfo, combinedLightIn, combinedOverlayIn, red, green, blue, 1.0f);
        poseStack.method_22909();
    }

    private void renderChessBoardPlate(class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn, ChessBlockEntity chessBlockEntity) {
        float whiteR = (float)NBTColorSaving.getRed(chessBlockEntity.getWhiteTilesColor()) / 255.0f;
        float whiteG = (float)NBTColorSaving.getGreen(chessBlockEntity.getWhiteTilesColor()) / 255.0f;
        float whiteB = (float)NBTColorSaving.getBlue(chessBlockEntity.getWhiteTilesColor()) / 255.0f;
        float blackR = (float)NBTColorSaving.getRed(chessBlockEntity.getBlackTilesColor()) / 255.0f;
        float blackG = (float)NBTColorSaving.getGreen(chessBlockEntity.getBlackTilesColor()) / 255.0f;
        float blackB = (float)NBTColorSaving.getBlue(chessBlockEntity.getBlackTilesColor()) / 255.0f;
        class_4588 builderBoardPlateWhiteTiles = bufferIn.getBuffer(class_1921.method_23576((class_2960)PLATE_WHITE_TILES_TEXTURE));
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40713.rotationDegrees(180.0f));
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(270.0f));
        poseStack.method_22904(0.0, -1.65, 0.0);
        this.chessBoardPlateModel.method_2828(poseStack, builderBoardPlateWhiteTiles, combinedLightIn, combinedOverlayIn, whiteR, whiteG, whiteB, 1.0f);
        poseStack.method_22909();
        class_4588 builderBoardPlateBlackTiles = bufferIn.getBuffer(class_1921.method_23576((class_2960)PLATE_BLACK_TILES_TEXTURE));
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40713.rotationDegrees(180.0f));
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(270.0f));
        poseStack.method_22904(0.0, -1.65, 0.0);
        this.chessBoardPlateModel.method_2828(poseStack, builderBoardPlateBlackTiles, combinedLightIn, combinedOverlayIn, blackR, blackG, blackB, 1.0f);
        poseStack.method_22909();
    }

    static {
        image.method_4305(0, 0, 0xFFFFFF);
        texture.method_4524();
        resourceLocation = class_310.method_1551().method_1531().method_4617("table_top_craft_dummy", texture);
    }

    static enum HighlightType {
        LEGAL_MOVE,
        LEAVES_PLAYER_IN_CHECK,
        CASTLE_MOVE,
        ATTACK_MOVE,
        LAST_MADE_MOVE;

    }
}

