/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.block_entities.render;

import andrews.table_top_craft.block_entities.ChessPieceFigureBlockEntity;
import andrews.table_top_craft.block_entities.model.piece_figure.ChessPieceFigureStandModel;
import andrews.table_top_craft.block_entities.render.BufferHelpers;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.objects.blocks.ChessPieceFigureBlock;
import andrews.table_top_craft.util.Color;
import andrews.table_top_craft.util.DrawScreenHelper;
import andrews.table_top_craft.util.NBTColorSaving;
import andrews.table_top_craft.util.TTCRenderTypes;
import andrews.table_top_craft.util.shader_compat.ShaderCompatHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1921;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_291;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_5944;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ChessPieceFigureBlockEntityRenderer
implements class_827<ChessPieceFigureBlockEntity> {
    private static final class_1011 image = new class_1011(class_1011.class_1012.field_4997, 1, 1, true);
    private static final class_1043 texture = new class_1043(image);
    private static final class_2960 resourceLocation;
    public static final class_2960 SHADER_COMPAT_WHITE;
    public static final class_2960 CHESS_PIECE_FIGURE_TEXTURE;
    private static ChessPieceFigureStandModel chessPieceFigureStandModel;
    private Color color = new Color(0, 0, 0);

    public ChessPieceFigureBlockEntityRenderer(class_5614.class_5615 context) {
        chessPieceFigureStandModel = new ChessPieceFigureStandModel(context.method_32140(ChessPieceFigureStandModel.CHESS_PIECE_FIGURE_LAYER));
    }

    public void render(ChessPieceFigureBlockEntity blockEntity, float partialTicks, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.getPieceName() != null && blockEntity.getPieceName().equals("andrew_")) {
            int tickCount = class_310.method_1551().field_1724.field_6012;
            int value = tickCount % 180 * 2;
            this.color = this.color.fromHSV(value, 1.0f, 1.0f);
            blockEntity.setPieceColor(this.color.getRed() + "/" + this.color.getGreen() + "/" + this.color.getBlue() + "/255");
        }
        ChessPieceFigureBlockEntityRenderer.renderChessPieceFigure(blockEntity, poseStack, bufferSource, false, false, partialTicks, packedLight, packedOverlay);
    }

    public static void renderChessPieceFigure(ChessPieceFigureBlockEntity blockEntity, class_4587 poseStack, class_4597 bufferSource, boolean isInGui, boolean isHeldOrHead, float partialTicks, int packedLight, int packedOverlay) {
        class_2680 blockstate;
        Matrix4f initialMatrix = poseStack.method_23760().method_23761();
        if (!blockEntity.method_11002()) {
            poseStack.method_22903();
            poseStack.method_22904(0.5, 1.5, 0.5);
            poseStack.method_22905(1.0f, -1.0f, -1.0f);
            if (blockEntity.getRotateChessPieceFigure() && isInGui) {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)class_310.method_1551().field_1724.field_6012 + partialTicks));
            }
            class_4588 vertexconsumer = bufferSource.getBuffer(class_1921.method_23572((class_2960)CHESS_PIECE_FIGURE_TEXTURE));
            chessPieceFigureStandModel.method_2828(poseStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.method_22909();
        }
        int rotation = 0;
        if (blockEntity.method_11002() && (blockstate = blockEntity.method_10997().method_8320(blockEntity.method_11016())).method_26204() instanceof ChessPieceFigureBlock) {
            rotation = (Integer)blockstate.method_11654((class_2769)ChessPieceFigureBlock.ROTATION);
        }
        int lightU = class_765.method_24186((int)packedLight);
        int lightV = class_765.method_24187((int)packedLight);
        poseStack.method_22903();
        poseStack.method_46416(0.5f, 0.125f, 0.5f);
        poseStack.method_22907(class_7833.field_40715.rotationDegrees((float)rotation * 22.5f));
        if (blockEntity.getRotateChessPieceFigure()) {
            poseStack.method_22907(class_7833.field_40715.rotationDegrees((float)class_310.method_1551().field_1724.field_6012 + partialTicks));
        }
        poseStack.method_22905(3.0f, -3.0f, -3.0f);
        if (blockEntity.getPieceName() != null && blockEntity.getPieceName().equals("Lyzantra")) {
            poseStack.method_22904(0.0, -0.2 * blockEntity.getPieceScale(), 0.0);
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
        }
        if (blockEntity.method_11002()) {
            float scale = (float)blockEntity.getPieceScale();
            poseStack.method_22905(scale, scale, scale);
        }
        float red = (float)NBTColorSaving.getRed(blockEntity.getPieceColor()) / 255.0f;
        float green = (float)NBTColorSaving.getGreen(blockEntity.getPieceColor()) / 255.0f;
        float blue = (float)NBTColorSaving.getBlue(blockEntity.getPieceColor()) / 255.0f;
        BasePiece.PieceModelSet set = BasePiece.PieceModelSet.get(blockEntity.getPieceSet());
        BasePiece.PieceType piece = BasePiece.PieceType.get(blockEntity.getPieceType());
        if (ShaderCompatHandler.isShaderActive()) {
            poseStack.method_22903();
            class_4588 consumer = bufferSource.getBuffer(class_1921.method_23572((class_2960)SHADER_COMPAT_WHITE));
            if (isInGui || isHeldOrHead) {
                poseStack.method_22905(isHeldOrHead ? 1.3f : 1.4f, isHeldOrHead ? 1.3f : 1.4f, isHeldOrHead ? 1.3f : 1.4f);
                if (blockEntity.getPieceName() != null && blockEntity.getPieceName().equals("Lyzantra")) {
                    poseStack.method_22904(0.0, 0.05, 0.0);
                }
            }
            DrawScreenHelper.CHESS_PIECE_MODEL.render(poseStack, consumer, piece, set, red, green, blue, packedLight);
            poseStack.method_22909();
        } else {
            poseStack.method_22903();
            class_1921 type = TTCRenderTypes.getChessPieceSolid(resourceLocation);
            type.method_23516();
            class_5944 shaderinstance = RenderSystem.getShader();
            if (shaderinstance.field_29471 != null) {
                shaderinstance.field_29471.method_1250(RenderSystem.getProjectionMatrix());
            }
            BufferHelpers.setupRender(RenderSystem.getShader(), lightU, lightV);
            BufferHelpers.updateColor(shaderinstance, new float[]{red, green, blue, 1.0f});
            poseStack.method_22903();
            if (shaderinstance.field_29470 != null) {
                if (isInGui || isHeldOrHead) {
                    Matrix4f mat4f = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
                    class_4587 stk = new class_4587();
                    stk.method_23760().method_23761().mul((Matrix4fc)mat4f);
                    stk.method_23760().method_23761().mul((Matrix4fc)initialMatrix);
                    stk.method_46416(0.5f, 0.125f, 0.5f);
                    if (blockEntity.getRotateChessPieceFigure()) {
                        stk.method_22907(class_7833.field_40715.rotationDegrees((float)class_310.method_1551().field_1724.field_6012 + partialTicks));
                    }
                    if (blockEntity.getPieceName() != null && blockEntity.getPieceName().equals("Lyzantra")) {
                        stk.method_22904(0.0, 0.85, 0.0);
                        stk.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
                    }
                    stk.method_22905(isHeldOrHead ? 3.0f : 4.0f, isHeldOrHead ? -3.0f : -4.0f, isHeldOrHead ? -3.0f : -4.0f);
                    shaderinstance.field_29470.method_1250(stk.method_23760().method_23761());
                } else {
                    shaderinstance.field_29470.method_1250(poseStack.method_23760().method_23761());
                }
            }
            class_291 pawnBuffer = DrawScreenHelper.getBuffer(set, piece);
            TTCRenderTypes.getChessPieceSolid(resourceLocation).method_23516();
            shaderinstance.method_34586();
            BufferHelpers.draw(pawnBuffer);
            class_291.method_1354();
            shaderinstance.method_34585();
            type.method_23518();
            poseStack.method_22909();
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    static {
        SHADER_COMPAT_WHITE = new class_2960("table_top_craft", "textures/tile/compat/full_white.png");
        CHESS_PIECE_FIGURE_TEXTURE = new class_2960("table_top_craft", "textures/tile/chess_piece_figure/chess_piece_figure.png");
        image.method_4305(0, 0, 0xFFFFFF);
        texture.method_4524();
        resourceLocation = class_310.method_1551().method_1531().method_4617("table_top_craft_dummy", texture);
    }
}

