/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess;

import andrews.table_top_craft.game_logic.chess.board.BoardUtils;
import andrews.table_top_craft.game_logic.chess.player.BaseChessPlayer;
import andrews.table_top_craft.game_logic.chess.player.BlackChessPlayer;
import andrews.table_top_craft.game_logic.chess.player.WhiteChessPlayer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PieceColor {
    WHITE{

        @Override
        public int getDirection() {
            return -1;
        }

        @Override
        public int getOppositeDirection() {
            return 1;
        }

        @Override
        public boolean isWhite() {
            return true;
        }

        @Override
        public boolean isBlack() {
            return false;
        }

        @Override
        public BaseChessPlayer chooseChessPlayer(WhiteChessPlayer whiteChessPlayer, BlackChessPlayer blackChessPlayer) {
            return whiteChessPlayer;
        }

        @Override
        public boolean isPawnPromotionSquare(int position) {
            return BoardUtils.EIGHTH_RANK[position];
        }

        public String toString() {
            return "White";
        }

        @Override
        public int pawnBonus(int position) {
            return WHITE_PAWN_PREFERRED_COORDINATES[position];
        }

        @Override
        public int knightBonus(int position) {
            return WHITE_KNIGHT_PREFERRED_COORDINATES[position];
        }

        @Override
        public int bishopBonus(int position) {
            return WHITE_BISHOP_PREFERRED_COORDINATES[position];
        }

        @Override
        public int rookBonus(int position) {
            return WHITE_ROOK_PREFERRED_COORDINATES[position];
        }

        @Override
        public int queenBonus(int position) {
            return WHITE_QUEEN_PREFERRED_COORDINATES[position];
        }

        @Override
        public int kingBonus(int position) {
            return WHITE_KING_PREFERRED_COORDINATES[position];
        }
    }
    ,
    BLACK{

        @Override
        public int getDirection() {
            return 1;
        }

        @Override
        public int getOppositeDirection() {
            return -1;
        }

        @Override
        public boolean isWhite() {
            return false;
        }

        @Override
        public boolean isBlack() {
            return true;
        }

        @Override
        public BaseChessPlayer chooseChessPlayer(WhiteChessPlayer whiteChessPlayer, BlackChessPlayer blackChessPlayer) {
            return blackChessPlayer;
        }

        @Override
        public boolean isPawnPromotionSquare(int position) {
            return BoardUtils.FIRST_RANK[position];
        }

        public String toString() {
            return "Black";
        }

        @Override
        public int pawnBonus(int position) {
            return BLACK_PAWN_PREFERRED_COORDINATES[position];
        }

        @Override
        public int knightBonus(int position) {
            return BLACK_KNIGHT_PREFERRED_COORDINATES[position];
        }

        @Override
        public int bishopBonus(int position) {
            return BLACK_BISHOP_PREFERRED_COORDINATES[position];
        }

        @Override
        public int rookBonus(int position) {
            return BLACK_ROOK_PREFERRED_COORDINATES[position];
        }

        @Override
        public int queenBonus(int position) {
            return BLACK_QUEEN_PREFERRED_COORDINATES[position];
        }

        @Override
        public int kingBonus(int position) {
            return BLACK_KING_PREFERRED_COORDINATES[position];
        }
    };

    private static final int[] WHITE_PAWN_PREFERRED_COORDINATES;
    private static final int[] BLACK_PAWN_PREFERRED_COORDINATES;
    private static final int[] WHITE_KNIGHT_PREFERRED_COORDINATES;
    private static final int[] BLACK_KNIGHT_PREFERRED_COORDINATES;
    private static final int[] WHITE_BISHOP_PREFERRED_COORDINATES;
    private static final int[] BLACK_BISHOP_PREFERRED_COORDINATES;
    private static final int[] WHITE_ROOK_PREFERRED_COORDINATES;
    private static final int[] BLACK_ROOK_PREFERRED_COORDINATES;
    private static final int[] WHITE_QUEEN_PREFERRED_COORDINATES;
    private static final int[] BLACK_QUEEN_PREFERRED_COORDINATES;
    private static final int[] WHITE_KING_PREFERRED_COORDINATES;
    private static final int[] BLACK_KING_PREFERRED_COORDINATES;

    public abstract int getDirection();

    public abstract int getOppositeDirection();

    public abstract int pawnBonus(int var1);

    public abstract int knightBonus(int var1);

    public abstract int bishopBonus(int var1);

    public abstract int rookBonus(int var1);

    public abstract int queenBonus(int var1);

    public abstract int kingBonus(int var1);

    public abstract boolean isWhite();

    public abstract boolean isBlack();

    public abstract boolean isPawnPromotionSquare(int var1);

    public abstract BaseChessPlayer chooseChessPlayer(WhiteChessPlayer var1, BlackChessPlayer var2);

    static {
        WHITE_PAWN_PREFERRED_COORDINATES = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 75, 75, 75, 75, 75, 75, 75, 75, 25, 25, 29, 29, 29, 29, 25, 25, 5, 5, 10, 55, 55, 10, 5, 5, 0, 0, 0, 20, 20, 0, 0, 0, 5, -5, -10, 0, 0, -10, -5, 5, 5, 10, 10, -20, -20, 10, 10, 5, 0, 0, 0, 0, 0, 0, 0, 0};
        BLACK_PAWN_PREFERRED_COORDINATES = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 5, 10, 10, -20, -20, 10, 10, 5, 5, -5, -10, 0, 0, -10, -5, 5, 0, 0, 0, 20, 20, 0, 0, 0, 5, 5, 10, 55, 55, 10, 5, 5, 25, 25, 29, 29, 29, 29, 25, 25, 75, 75, 75, 75, 75, 75, 75, 75, 0, 0, 0, 0, 0, 0, 0, 0};
        WHITE_KNIGHT_PREFERRED_COORDINATES = new int[]{-50, -40, -30, -30, -30, -30, -40, -50, -40, -20, 0, 0, 0, 0, -20, -40, -30, 0, 10, 15, 15, 10, 0, -30, -30, 5, 15, 20, 20, 15, 5, -30, -30, 0, 15, 20, 20, 15, 0, -30, -30, 5, 10, 15, 15, 10, 5, -30, -40, -20, 0, 5, 5, 0, -20, -40, -50, -40, -30, -30, -30, -30, -40, -50};
        BLACK_KNIGHT_PREFERRED_COORDINATES = new int[]{-50, -40, -30, -30, -30, -30, -40, -50, -40, -20, 0, 5, 5, 0, -20, -40, -30, 5, 10, 15, 15, 10, 5, -30, -30, 0, 15, 20, 20, 15, 0, -30, -30, 5, 15, 20, 20, 15, 5, -30, -30, 0, 10, 15, 15, 10, 0, -30, -40, -20, 0, 0, 0, 0, -20, -40, -50, -40, -30, -30, -30, -30, -40, -50};
        WHITE_BISHOP_PREFERRED_COORDINATES = new int[]{-20, -10, -10, -10, -10, -10, -10, -20, -10, 0, 0, 0, 0, 0, 0, -10, -10, 0, 5, 10, 10, 5, 0, -10, -10, 5, 5, 10, 10, 5, 5, -10, -10, 0, 10, 10, 10, 10, 0, -10, -10, 10, 10, 10, 10, 10, 10, -10, -10, 5, 0, 0, 0, 0, 5, -10, -20, -10, -10, -10, -10, -10, -10, -20};
        BLACK_BISHOP_PREFERRED_COORDINATES = new int[]{-20, -10, -10, -10, -10, -10, -10, -20, -10, 5, 0, 0, 0, 0, 5, -10, -10, 10, 10, 10, 10, 10, 10, -10, -10, 0, 10, 10, 10, 10, 0, -10, -10, 5, 5, 10, 10, 5, 5, -10, -10, 0, 5, 10, 10, 5, 0, -10, -10, 0, 0, 0, 0, 0, 0, -10, -20, -10, -10, -10, -10, -10, -10, -20};
        WHITE_ROOK_PREFERRED_COORDINATES = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 5, 20, 20, 20, 20, 20, 20, 5, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, 0, 0, 0, 5, 5, 0, 0, 0};
        BLACK_ROOK_PREFERRED_COORDINATES = new int[]{0, 0, 0, 5, 5, 0, 0, 0, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -5, 5, 20, 20, 20, 20, 20, 20, 5, 0, 0, 0, 0, 0, 0, 0, 0};
        WHITE_QUEEN_PREFERRED_COORDINATES = new int[]{-20, -10, -10, -5, -5, -10, -10, -20, -10, 0, 0, 0, 0, 0, 0, -10, -10, 0, 5, 5, 5, 5, 0, -10, -5, 0, 5, 5, 5, 5, 0, -5, 0, 0, 5, 5, 5, 5, 0, -5, -10, 5, 5, 5, 5, 5, 0, -10, -10, 0, 5, 0, 0, 0, 0, -10, -20, -10, -10, -5, -5, -10, -10, -20};
        BLACK_QUEEN_PREFERRED_COORDINATES = new int[]{-20, -10, -10, -5, -5, -10, -10, -20, -10, 0, 5, 0, 0, 0, 0, -10, -10, 5, 5, 5, 5, 5, 0, -10, 0, 0, 5, 5, 5, 5, 0, -5, 0, 0, 5, 5, 5, 5, 0, -5, -10, 0, 5, 5, 5, 5, 0, -10, -10, 0, 0, 0, 0, 0, 0, -10, -20, -10, -10, -5, -5, -10, -10, -20};
        WHITE_KING_PREFERRED_COORDINATES = new int[]{-30, -40, -40, -50, -50, -40, -40, -30, -30, -40, -40, -50, -50, -40, -40, -30, -30, -40, -40, -50, -50, -40, -40, -30, -30, -40, -40, -50, -50, -40, -40, -30, -20, -30, -30, -40, -40, -30, -30, -20, -10, -20, -20, -20, -20, -20, -20, -10, 20, 20, 0, 0, 0, 0, 20, 20, 20, 30, 10, 0, 0, 10, 30, 20};
        BLACK_KING_PREFERRED_COORDINATES = new int[]{20, 30, 10, 0, 0, 10, 30, 20, 20, 20, 0, 0, 0, 0, 20, 20, -10, -20, -20, -20, -20, -20, -20, -10, -20, -30, -30, -40, -40, -30, -30, -20, -30, -40, -40, -50, -50, -40, -40, -30, -30, -40, -40, -50, -50, -40, -40, -30, -30, -40, -40, -50, -50, -40, -40, -30, -30, -40, -40, -50, -50, -40, -40, -30};
    }
}

