/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.pieces;

import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.BoardUtils;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MajorAttackMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MajorMove;
import andrews.table_top_craft.game_logic.chess.board.tiles.BaseChessTile;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;

public class KnightPiece
extends BasePiece {
    private static final int[] CANDIDATE_MOVE_COORDINATES = new int[]{-17, -15, -10, -6, 6, 10, 15, 17};

    public KnightPiece(PieceColor pieceColor, int piecePosition) {
        super(BasePiece.PieceType.KNIGHT, piecePosition, pieceColor, true);
    }

    public KnightPiece(PieceColor pieceColor, int piecePosition, boolean isFirstMove) {
        super(BasePiece.PieceType.KNIGHT, piecePosition, pieceColor, isFirstMove);
    }

    @Override
    public Collection<BaseMove> calculateLegalMoves(Board board) {
        ArrayList<BaseMove> legalMoves = new ArrayList<BaseMove>();
        for (int currentCandidateOffset : CANDIDATE_MOVE_COORDINATES) {
            int candidateDestinationCoordinate = this.piecePosition + currentCandidateOffset;
            if (!BoardUtils.isValidTileCoordinate(candidateDestinationCoordinate) || KnightPiece.isFirstColumnExclusion(this.piecePosition, currentCandidateOffset) || KnightPiece.isSecondColumnExclusion(this.piecePosition, currentCandidateOffset) || KnightPiece.isSeventhColumnExclusion(this.piecePosition, currentCandidateOffset) || KnightPiece.isEighthColumnExclusion(this.piecePosition, currentCandidateOffset)) continue;
            BaseChessTile candidateDestinationTile = board.getTile(candidateDestinationCoordinate);
            if (!candidateDestinationTile.isTileOccupied()) {
                legalMoves.add(new MajorMove(board, this, candidateDestinationCoordinate));
                continue;
            }
            BasePiece pieceAtDestination = candidateDestinationTile.getPiece();
            PieceColor pieceColor = pieceAtDestination.getPieceColor();
            if (this.pieceColor == pieceColor) continue;
            legalMoves.add(new MajorAttackMove(board, this, candidateDestinationCoordinate, pieceAtDestination));
        }
        return ImmutableList.copyOf(legalMoves);
    }

    public String toString() {
        return BasePiece.PieceType.KNIGHT.toString();
    }

    @Override
    public int locationBonus() {
        return this.pieceColor.knightBonus(this.piecePosition);
    }

    @Override
    public KnightPiece movePiece(BaseMove move) {
        return new KnightPiece(move.getMovedPiece().getPieceColor(), move.getDestinationCoordinate(), false);
    }

    private static boolean isFirstColumnExclusion(int currentPosition, int candidateOffset) {
        return BoardUtils.FIRST_COLUMN[currentPosition] && (candidateOffset == -17 || candidateOffset == -10 || candidateOffset == 6 || candidateOffset == 15);
    }

    private static boolean isSecondColumnExclusion(int currentPosition, int candidateOffset) {
        return BoardUtils.SECOND_COLUMN[currentPosition] && (candidateOffset == -10 || candidateOffset == 6);
    }

    private static boolean isSeventhColumnExclusion(int currentPosition, int candidateOffset) {
        return BoardUtils.SEVENTH_COLUMN[currentPosition] && (candidateOffset == -6 || candidateOffset == 10);
    }

    private static boolean isEighthColumnExclusion(int currentPosition, int candidateOffset) {
        return BoardUtils.EIGHTH_COLUMN[currentPosition] && (candidateOffset == -15 || candidateOffset == -6 || candidateOffset == 10 || candidateOffset == 17);
    }
}

