/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.pieces;

import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.BoardUtils;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MajorAttackMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MajorMove;
import andrews.table_top_craft.game_logic.chess.board.tiles.BaseChessTile;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;

public class RookPiece
extends BasePiece {
    private static final int[] CANDIDATE_MOVE_VECTOR_COORDINATES = new int[]{-8, -1, 1, 8};

    public RookPiece(PieceColor pieceColor, int piecePosition) {
        super(BasePiece.PieceType.ROOK, piecePosition, pieceColor, true);
    }

    public RookPiece(PieceColor pieceColor, int piecePosition, boolean isFirstMove) {
        super(BasePiece.PieceType.ROOK, piecePosition, pieceColor, isFirstMove);
    }

    @Override
    public Collection<BaseMove> calculateLegalMoves(Board board) {
        ArrayList<BaseMove> legalMoves = new ArrayList<BaseMove>();
        block0: for (int candidateCoordinateOffset : CANDIDATE_MOVE_VECTOR_COORDINATES) {
            int candidateDestinationCoordinate = this.piecePosition;
            while (BoardUtils.isValidTileCoordinate(candidateDestinationCoordinate) && !RookPiece.isFirstColumnExclusion(candidateDestinationCoordinate, candidateCoordinateOffset) && !RookPiece.isEighthColumnExclusion(candidateDestinationCoordinate, candidateCoordinateOffset)) {
                if (!BoardUtils.isValidTileCoordinate(candidateDestinationCoordinate += candidateCoordinateOffset)) continue;
                BaseChessTile candidateDestinationTile = board.getTile(candidateDestinationCoordinate);
                if (!candidateDestinationTile.isTileOccupied()) {
                    legalMoves.add(new MajorMove(board, this, candidateDestinationCoordinate));
                    continue;
                }
                BasePiece pieceAtDestination = candidateDestinationTile.getPiece();
                PieceColor pieceColor = pieceAtDestination.getPieceColor();
                if (this.pieceColor == pieceColor) continue block0;
                legalMoves.add(new MajorAttackMove(board, this, candidateDestinationCoordinate, pieceAtDestination));
                continue block0;
            }
        }
        return ImmutableList.copyOf(legalMoves);
    }

    public String toString() {
        return BasePiece.PieceType.ROOK.toString();
    }

    @Override
    public int locationBonus() {
        return this.pieceColor.rookBonus(this.piecePosition);
    }

    @Override
    public RookPiece movePiece(BaseMove move) {
        return new RookPiece(move.getMovedPiece().getPieceColor(), move.getDestinationCoordinate(), false);
    }

    private static boolean isFirstColumnExclusion(int currentPosition, int candidateOffset) {
        return BoardUtils.FIRST_COLUMN[currentPosition] && candidateOffset == -1;
    }

    private static boolean isEighthColumnExclusion(int currentPosition, int candidateOffset) {
        return BoardUtils.EIGHTH_COLUMN[currentPosition] && candidateOffset == 1;
    }
}

