/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.client.util;

import andrews.table_top_craft.animation.system.core.AdvancedAnimationState;
import andrews.table_top_craft.animation.system.core.Animation;
import andrews.table_top_craft.animation.system.core.BasicKeyframe;
import andrews.table_top_craft.animation.system.core.KeyframeGroup;
import andrews.table_top_craft.animation.system.core.bulders.AnimationBuilder;
import andrews.table_top_craft.animation.system.core.bulders.EasingBuilder;
import andrews.table_top_craft.animation.system.core.types.EasingTypes;
import andrews.table_top_craft.animation.system.core.types.TransformTypes;
import andrews.table_top_craft.animation.system.core.types.util.EasingType;
import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.block_entities.ConnectFourBlockEntity;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.objects.blocks.ChessBlock;
import andrews.table_top_craft.particles.options.ChessShatterParticleOptions;
import andrews.table_top_craft.registry.TTCParticles;
import andrews.table_top_craft.screens.chess.menus.ChessPawnPromotionScreen;
import andrews.table_top_craft.screens.chess.menus.ChessPieceSelectionScreen;
import andrews.table_top_craft.util.NBTColorSaving;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_7187;

public class ClientPacketHandlerClass {
    public static void handleOpenChessPieceSelectionPacket(ChessBlockEntity chessBlockEntity, boolean isStandardSetUnlocked, boolean isClassicSetUnlocked, boolean isPandorasCreaturesSetUnlocked) {
        class_310.method_1551().method_1507((class_437)new ChessPieceSelectionScreen(chessBlockEntity, isStandardSetUnlocked, isClassicSetUnlocked, isPandorasCreaturesSetUnlocked));
    }

    public static void handleOpenChessPromotionPacket(ChessBlockEntity chessBlockEntity, boolean isWhite) {
        class_310.method_1551().method_1507((class_437)new ChessPawnPromotionScreen(chessBlockEntity, isWhite));
    }

    public static void handlePlayChessTimerSoundPacket(class_2338 pos, byte id) {
        if (class_310.method_1551().field_1687 != null) {
            switch (id) {
                case 0: {
                    class_310.method_1551().field_1687.method_45446(pos, class_3417.field_14962, class_3419.field_15245, 1.0f, 0.6f, false);
                    break;
                }
                case 1: {
                    class_310.method_1551().field_1687.method_45446(pos, class_3417.field_14962, class_3419.field_15245, 1.0f, 0.6f, false);
                    class_310.method_1551().field_1687.method_45446(pos, class_3417.field_26979, class_3419.field_15245, 3.0f, 1.2f, false);
                }
            }
        }
    }

    public static void handlePlayChessParticlesPacket(class_2338 pos, byte destCord, boolean isWhite, float xSpeed, float ySpeed, float zSpeed) {
        if (class_310.method_1551().field_1687 != null) {
            double xOffset = 0.0;
            double zOffset = 0.0;
            switch ((class_2350)class_310.method_1551().field_1687.method_8320(pos).method_11654((class_2769)ChessBlock.FACING)) {
                case field_11043: {
                    xOffset = (double)(destCord % 8) * 0.125 + 0.0625;
                    zOffset = (double)(destCord / 8) * 0.125 + 0.0625;
                    break;
                }
                case field_11035: {
                    xOffset = 1.0 - (double)(destCord % 8) * 0.125 - 0.0625;
                    zOffset = 1.0 - (double)(destCord / 8) * 0.125 - 0.0625;
                    break;
                }
                case field_11039: {
                    zOffset = 1.0 - (double)(destCord % 8) * 0.125 - 0.0625;
                    xOffset = (double)(destCord / 8) * 0.125 + 0.0625;
                    break;
                }
                case field_11034: {
                    zOffset = (double)(destCord % 8) * 0.125 + 0.0625;
                    xOffset = 1.0 - (double)(destCord / 8) * 0.125 - 0.0625;
                }
            }
            class_2586 class_25862 = class_310.method_1551().field_1687.method_8321(pos);
            if (class_25862 instanceof ChessBlockEntity) {
                int i;
                ChessBlockEntity blockEntity = (ChessBlockEntity)class_25862;
                String color = isWhite ? blockEntity.getWhitePiecesColor() : blockEntity.getBlackPiecesColor();
                int red = NBTColorSaving.getRed(color);
                int green = NBTColorSaving.getGreen(color);
                int blue = NBTColorSaving.getBlue(color);
                for (i = 0; i < 10; ++i) {
                    class_310.method_1551().field_1687.method_8406((class_2394)TTCParticles.TINY_POOF, (double)pos.method_10263() + xOffset, (double)((float)pos.method_10264() + 0.84375f), (double)pos.method_10260() + zOffset, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 14; ++i) {
                    class_310.method_1551().field_1687.method_8406((class_2394)new ChessShatterParticleOptions(red, green, blue), (double)pos.method_10263() + xOffset, (double)((float)pos.method_10264() + 0.78125f), (double)pos.method_10260() + zOffset, (double)xSpeed, (double)ySpeed, (double)zSpeed);
                }
            }
        }
    }

    public static void handleChessAnimationPacket(ChessBlockEntity chessBlockEntity, byte actionType, byte currentCord, byte destCord) {
        if (actionType == 0) {
            chessBlockEntity.placedState.method_41322(chessBlockEntity.getTicksExisted());
            chessBlockEntity.moveState = null;
            chessBlockEntity.clearMoveTransitionsCache();
            chessBlockEntity.setCachedPiece(null);
        } else if (actionType == 1) {
            chessBlockEntity.placedState.method_41325();
            chessBlockEntity.placedState.interpolateAndStart(0.2f, EasingBuilder.type(EasingType.EASE_OUT_QUAD).argument(0.2f).build(), false, chessBlockEntity.getTicksExisted());
        } else if (actionType == 2) {
            chessBlockEntity.currentCord = currentCord;
            chessBlockEntity.destCord = destCord;
            Animation animation = ClientPacketHandlerClass.generateAnimation(chessBlockEntity, chessBlockEntity.currentCord, chessBlockEntity.destCord);
            chessBlockEntity.moveState = new AdvancedAnimationState(new AtomicReference<Animation>(animation));
            chessBlockEntity.moveState.method_41322(chessBlockEntity.getTicksExisted());
        }
    }

    public static void handleConnectFourAnimationPacket(ConnectFourBlockEntity blockEntity, byte destCord) {
        blockEntity.movingPiece = destCord;
        int heightMod = destCord % 6;
        float animLength = 1.0f - (float)heightMod * 0.1f;
        AnimationBuilder builder = AnimationBuilder.withLength(animLength);
        builder.addAnimation("root", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.2f, class_7187.method_41823((float)0.0f, (float)(13.0f - (float)(heightMod * 2)), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(animLength, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingBuilder.type(EasingType.EASE_IN_BOUNCE).argument(0.2f - 0.2f * ((float)heightMod * 0.15f)).build())));
        builder.addAnimation("root", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, class_7187.method_41829((float)0.0f, (float)90.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.3f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
        builder.addAnimation("root", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(0.0f, class_7187.method_41822((double)0.1f, (double)0.1f, (double)0.1f), EasingTypes.LINEAR), new BasicKeyframe(0.3f, class_7187.method_41822((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR)));
        Animation animation = builder.build();
        blockEntity.moveState = new AdvancedAnimationState(new AtomicReference<Animation>(animation));
        blockEntity.moveState.method_41322(blockEntity.getTicksExisted());
    }

    public static Animation generateAnimation(ChessBlockEntity blockEntity, byte currentCord, byte destCord) {
        Board board = blockEntity.getBoard();
        int startX = currentCord % 8;
        int startY = currentCord / 8;
        int destX = destCord % 8;
        int destY = destCord / 8;
        int deltaY = startY - destY;
        deltaY = board.getTile(currentCord).getPiece().getPieceColor().isWhite() ? deltaY : -deltaY;
        int deltaX = startX - destX;
        deltaX = board.getTile(currentCord).getPiece().getPieceColor().isWhite() ? -deltaX : deltaX;
        float time = 1.0f;
        switch (board.getTile(currentCord).getPiece().getPieceType()) {
            case PAWN: {
                float f = time = deltaY == 2 || deltaY == -2 ? 1.0f : 0.75f;
                if ((board.getTile(currentCord).getPiece().getPieceColor().isWhite() && startY == 3 || board.getTile(currentCord).getPiece().getPieceColor().isBlack() && startY == 4) && (deltaX == -1 || deltaX == 1) && board.getTile(destCord).getPiece() == null) {
                    time = 1.0f;
                    AnimationBuilder builder = AnimationBuilder.withLength(time);
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, class_7187.method_41823((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.5f, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)1.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)1.0f, (float)((float)deltaY * -0.2f)), EasingTypes.EASE_OUT_CUBIC), new BasicKeyframe(time, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.5f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41829((float)-60.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(time / 4.0f * 2.7f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41823((float)0.0f, (float)8.0f, (float)8.0f), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(time / 4.0f * 2.7f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)-300.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.5f, class_7187.method_41822((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41822((double)0.0, (double)0.0, (double)0.0), EasingTypes.LINEAR)));
                    return builder.build();
                }
                AnimationBuilder builder = AnimationBuilder.withLength(time);
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, class_7187.method_41823((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 3.0f * 2.0f, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)(board.getTile(destCord).getPiece() != null ? 2.5f : 1.0f), (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41822((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41822((double)1.0, (double)0.1f, (double)1.0), EasingTypes.LINEAR)));
                return builder.build();
            }
            case BISHOP: {
                time = Math.abs(deltaX) == 1 ? 0.75f : (Math.abs(deltaX) > 3 ? 1.25f : time);
                AnimationBuilder builder = AnimationBuilder.withLength(time);
                if (Math.abs(deltaX) >= 4 && board.getTile(destCord).getPiece() != null) {
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, class_7187.method_41823((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 3.0f * 2.0f, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)1.0f, (float)((float)deltaY * 2.0f)), EasingTypes.EASE_IN_CUBIC), new BasicKeyframe(time, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.5f, class_7187.method_41829((float)ClientPacketHandlerClass.getRookSlamRotation(deltaX, deltaY, 40.0f), (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.8f, class_7187.method_41829((float)ClientPacketHandlerClass.getRookSlamRotation(deltaX, deltaY, -60.0f), (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(time / 4.0f * 2.5f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41823((float)(deltaX == 0 ? 0.0f : (deltaX > 0 ? -10.0f : 10.0f)), (float)7.0f, (float)(deltaY == 0 ? 0.0f : (deltaY > 0 ? -10.0f : 10.0f))), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(time / 4.0f * 2.5f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)(deltaY != 0 ? -300.0f : 0.0f), (float)0.0f, (float)(deltaX != 0 ? -300.0f : 0.0f)), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.5f, class_7187.method_41822((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41822((double)0.0, (double)0.0, (double)0.0), EasingTypes.LINEAR)));
                    return builder.build();
                }
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, class_7187.method_41823((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 3.0f * 2.0f, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)(board.getTile(destCord).getPiece() != null ? 2.5f : 1.0f), (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41822((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41822((double)1.0, (double)0.1f, (double)1.0), EasingTypes.LINEAR)));
                return builder.build();
            }
            case KNIGHT: {
                AnimationBuilder builder = AnimationBuilder.withLength(time);
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.0f, class_7187.method_41823((float)0.0f, (float)2.5f, (float)0.0f), EasingTypes.CATMULLROM), new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)2.5f, (float)((float)deltaY * 2.0f)), EasingTypes.CATMULLROM), new BasicKeyframe(time, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.CATMULLROM)));
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKnightRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKnightRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41822((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41822((double)1.0, (double)0.1f, (double)1.0), EasingTypes.LINEAR)));
                return builder.build();
            }
            case KING: {
                time = deltaX == 2 || deltaX == -2 ? 1.0f : 0.75f;
                AnimationBuilder builder = AnimationBuilder.withLength(time);
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, class_7187.method_41823((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)(board.getTile(destCord).getPiece() != null ? 2.5f : 1.0f), (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                if (board.getTile(destCord).getPiece() != null) {
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41822((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41822((double)1.0, (double)0.1f, (double)1.0), EasingTypes.LINEAR)));
                }
                if (deltaX == 2 || deltaX == -2) {
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.0f, class_7187.method_41823((float)0.0f, (float)2.5f, (float)0.0f), EasingTypes.CATMULLROM), new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41823((float)((float)(-deltaX) * (destX == 2 ? 3.0f : 2.0f)), (float)2.5f, (float)0.0f), EasingTypes.CATMULLROM), new BasicKeyframe(time, class_7187.method_41823((float)((float)(-deltaX) * (destX == 2 ? 3.0f : 2.0f)), (float)0.0f, (float)0.0f), EasingTypes.CATMULLROM)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(-deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(-deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                }
                return builder.build();
            }
            case QUEEN: {
                time = Math.abs(deltaX) == 1 || Math.abs(deltaY) == 1 ? 0.75f : (Math.abs(deltaX) > 3 || Math.abs(deltaY) > 3 ? 1.25f : time);
                AnimationBuilder builder = AnimationBuilder.withLength(time);
                if ((Math.abs(deltaX) >= 4 && Math.abs(deltaY) == 0 || Math.abs(deltaY) >= 4 && Math.abs(deltaX) == 0 || Math.abs(deltaX) >= 4 && Math.abs(deltaY) >= 4) && board.getTile(destCord).getPiece() != null) {
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, class_7187.method_41823((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 3.0f * 2.0f, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)1.0f, (float)((float)deltaY * 2.0f)), EasingTypes.EASE_IN_CUBIC), new BasicKeyframe(time, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.5f, class_7187.method_41829((float)ClientPacketHandlerClass.getRookSlamRotation(deltaX, deltaY, 40.0f), (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.8f, class_7187.method_41829((float)ClientPacketHandlerClass.getRookSlamRotation(deltaX, deltaY, -60.0f), (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(time / 4.0f * 2.5f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41823((float)(deltaX == 0 ? 0.0f : (deltaX > 0 ? -10.0f : 10.0f)), (float)7.0f, (float)(deltaY == 0 ? 0.0f : (deltaY > 0 ? -10.0f : 10.0f))), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(time / 4.0f * 2.5f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)(deltaY != 0 ? -300.0f : 0.0f), (float)0.0f, (float)(deltaX != 0 ? -300.0f : 0.0f)), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.5f, class_7187.method_41822((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41822((double)0.0, (double)0.0, (double)0.0), EasingTypes.LINEAR)));
                    return builder.build();
                }
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, class_7187.method_41823((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 3.0f * 2.0f, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)(board.getTile(destCord).getPiece() != null ? 2.5f : 1.0f), (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41822((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41822((double)1.0, (double)0.1f, (double)1.0), EasingTypes.LINEAR)));
                return builder.build();
            }
            case ROOK: {
                time = Math.abs(deltaX) == 1 || Math.abs(deltaY) == 1 ? 0.75f : (Math.abs(deltaX) > 3 || Math.abs(deltaY) > 3 ? 1.25f : time);
                AnimationBuilder builder = AnimationBuilder.withLength(time);
                if ((Math.abs(deltaX) >= 5 || Math.abs(deltaY) >= 5) && board.getTile(destCord).getPiece() != null) {
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, class_7187.method_41823((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 3.0f * 2.0f, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)1.0f, (float)((float)deltaY * 2.0f)), EasingTypes.EASE_IN_CUBIC), new BasicKeyframe(time, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.5f, class_7187.method_41829((float)ClientPacketHandlerClass.getRookSlamRotation(deltaX, deltaY, 40.0f), (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.8f, class_7187.method_41829((float)ClientPacketHandlerClass.getRookSlamRotation(deltaX, deltaY, -60.0f), (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(time / 4.0f * 2.5f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41823((float)(deltaX == 0 ? 0.0f : (deltaX > 0 ? -10.0f : 10.0f)), (float)7.0f, (float)(deltaY == 0 ? 0.0f : (deltaY > 0 ? -10.0f : 10.0f))), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(time / 4.0f * 2.5f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)(deltaY != 0 ? -300.0f : 0.0f), (float)0.0f, (float)(deltaX != 0 ? -300.0f : 0.0f)), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.5f, class_7187.method_41822((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41822((double)0.0, (double)0.0, (double)0.0), EasingTypes.LINEAR)));
                    return builder.build();
                }
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, class_7187.method_41823((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, class_7187.method_41823((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 3.0f * 2.0f, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)(board.getTile(destCord).getPiece() != null ? 2.5f : 1.0f), (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41823((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41829((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41829((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.0f, class_7187.method_41822((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, class_7187.method_41822((double)1.0, (double)0.1f, (double)1.0), EasingTypes.LINEAR)));
                return builder.build();
            }
        }
        return null;
    }

    private static float getRookSlamRotation(int deltaX, int deltaY, float rotation) {
        if (deltaY != 0) {
            return deltaY > 0 ? -rotation : rotation;
        }
        if (deltaX != 0) {
            return -rotation;
        }
        return 0.0f;
    }

    private static float getKnightRotation(int deltaX, int deltaY) {
        if (deltaX > 0 && deltaY > 0) {
            return deltaX == 2 ? 53.0f : 26.5f;
        }
        if (deltaX < 0 && deltaY > 0) {
            return deltaX == -2 ? -53.0f : -26.5f;
        }
        if (deltaX < 0 && deltaY < 0) {
            return deltaX == -2 ? 53.0f : 26.5f;
        }
        if (deltaX > 0 && deltaY < 0) {
            return deltaX == 2 ? -53.0f : -26.5f;
        }
        return 0.0f;
    }

    private static float getKingRotation(int deltaX, int deltaY) {
        if (deltaX > 0 && deltaY > 0) {
            return 45.0f;
        }
        if (deltaX > 0 && deltaY == 0) {
            return 90.0f;
        }
        if (deltaX < 0 && deltaY > 0) {
            return -45.0f;
        }
        if (deltaX < 0 && deltaY == 0) {
            return -90.0f;
        }
        if (deltaX < 0) {
            return 45.0f;
        }
        if (deltaX > 0) {
            return -45.0f;
        }
        return 0.0f;
    }
}

