/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.criteria.TTCCriteriaTriggers;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MoveFactory;
import andrews.table_top_craft.game_logic.chess.board.tiles.BaseChessTile;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.player.MoveTransition;
import andrews.table_top_craft.util.NetworkUtil;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class MessageServerDoChessBoardInteraction {
    public static class_2960 PACKET_ID = new class_2960("table_top_craft", "do_chess_board_interaction_packet");

    public static void registerPacket() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PACKET_ID, (minecraftServer, player, packetListener, buf, packetSender) -> {
            class_2338 pos = buf.method_10811();
            byte tileCoordinate = buf.readByte();
            minecraftServer.execute(() -> {
                class_2586 blockEntity;
                if (player == null) {
                    return;
                }
                class_3218 level = player.method_51469();
                if (level != null && (blockEntity = level.method_8321(pos)) instanceof ChessBlockEntity) {
                    ChessBlockEntity chessBlockEntity = (ChessBlockEntity)blockEntity;
                    if (chessBlockEntity.getBoard() == null) {
                        return;
                    }
                    if (chessBlockEntity.doingAnimationTimer > 0L && chessBlockEntity.move != null && chessBlockEntity.transition != null) {
                        chessBlockEntity.setBoard(chessBlockEntity.transition.getTransitionBoard());
                        chessBlockEntity.getMoveLog().addMove(chessBlockEntity.move);
                        if (chessBlockEntity.move.isPawnPromotion()) {
                            chessBlockEntity.setWaitingForPromotion(true);
                            chessBlockEntity.setPromotionCoordinate((byte)chessBlockEntity.move.getDestinationCoordinate());
                            List players = player.method_51469().method_18456();
                            for (class_3222 serverPlayer : players) {
                                if (!serverPlayer.method_5667().equals(chessBlockEntity.getPromotionPlayerUUID())) continue;
                                NetworkUtil.openChessPromotionFromServer(chessBlockEntity.method_11016(), chessBlockEntity.move.getMovedPiece().getPieceColor().isWhite(), serverPlayer);
                            }
                            chessBlockEntity.setPromotionPlayerUUID(null);
                        }
                        if (chessBlockEntity.getDisplayParticles() && !chessBlockEntity.playedParticles && chessBlockEntity.move.isAttack() && !chessBlockEntity.move.isEnPassantMove()) {
                            NetworkUtil.playChesParticlesFromServer(level, pos, (byte)chessBlockEntity.move.getDestinationCoordinate(), chessBlockEntity.move.getMovedPiece().getPieceColor().isBlack(), 0.0f, 0.0f, 0.0f);
                        }
                        chessBlockEntity.doingAnimationTimer = 0L;
                        chessBlockEntity.move = null;
                        chessBlockEntity.transition = null;
                        chessBlockEntity.playedParticles = false;
                        level.method_8413(pos, level.method_8320(pos), level.method_8320(pos), 2);
                        chessBlockEntity.method_5431();
                    }
                    BaseChessTile chessTile = chessBlockEntity.getBoard().getTile(tileCoordinate);
                    if (chessBlockEntity.getSourceTile() == null) {
                        if (chessTile.isTileOccupied() && chessTile.getPiece().getPieceColor() == chessBlockEntity.getBoard().getCurrentChessPlayer().getPieceColor()) {
                            chessBlockEntity.setSourceTile(chessTile);
                            chessBlockEntity.setHumanMovedPiece(chessTile.getPiece());
                            if (chessBlockEntity.getHumanMovedPiece() == null) {
                                chessBlockEntity.setSourceTile(null);
                            }
                            level.method_8413(pos, level.method_8320(pos), level.method_8320(pos), 2);
                            chessBlockEntity.method_5431();
                        }
                    } else {
                        chessBlockEntity.setDestinationTile(chessTile);
                        BaseMove move = MoveFactory.createMove(chessBlockEntity.getBoard(), chessBlockEntity.getSourceTile().getTileCoordinate(), chessBlockEntity.getDestinationTile().getTileCoordinate());
                        MoveTransition transition = chessBlockEntity.getBoard().getCurrentChessPlayer().makeMove(move);
                        if (transition.getMoveStatus().isDone()) {
                            if (move.isPawnPromotion()) {
                                chessBlockEntity.setPromotionPlayerUUID(player.method_5667());
                            }
                            if (chessBlockEntity.getPlayPieceAnimations()) {
                                chessBlockEntity.move = move;
                                chessBlockEntity.transition = transition;
                                int animTime = 1000;
                                if (move.getMovedPiece().getPieceType().isKing() && !move.isCastlingMove()) {
                                    animTime = 750;
                                }
                                if (move.getMovedPiece().getPieceType().equals((Object)BasePiece.PieceType.PAWN) && Math.abs(move.getDestinationCoordinate() - move.getCurrentCoordinate()) <= 9) {
                                    animTime = 750;
                                }
                                if (move.isEnPassantMove()) {
                                    animTime = 1000;
                                }
                                if (move.getMovedPiece().getPieceType().equals((Object)BasePiece.PieceType.ROOK)) {
                                    if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) == 1 || Math.abs(move.getCurrentCoordinate() / 8 - move.getDestinationCoordinate() / 8) == 1) {
                                        animTime = 750;
                                    } else if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) > 3 || Math.abs(move.getCurrentCoordinate() / 8 - move.getDestinationCoordinate() / 8) > 3) {
                                        animTime = 1250;
                                    }
                                }
                                if (move.getMovedPiece().getPieceType().equals((Object)BasePiece.PieceType.BISHOP)) {
                                    if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) == 1) {
                                        animTime = 750;
                                    } else if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) > 3) {
                                        animTime = 1250;
                                    }
                                }
                                if (move.getMovedPiece().getPieceType().equals((Object)BasePiece.PieceType.QUEEN)) {
                                    if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) == 1 || Math.abs(move.getCurrentCoordinate() / 8 - move.getDestinationCoordinate() / 8) == 1) {
                                        animTime = 750;
                                    } else if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) > 3 || Math.abs(move.getCurrentCoordinate() / 8 - move.getDestinationCoordinate() / 8) > 3) {
                                        animTime = 1250;
                                    }
                                }
                                chessBlockEntity.doingAnimationTimer = System.currentTimeMillis() + (long)animTime;
                                NetworkUtil.setChessAnimationForAllTracking(level, pos, (byte)2, (byte)move.getCurrentCoordinate(), (byte)move.getDestinationCoordinate());
                            } else {
                                chessBlockEntity.setBoard(transition.getTransitionBoard());
                                chessBlockEntity.getMoveLog().addMove(move);
                                if (move.isPawnPromotion()) {
                                    chessBlockEntity.setWaitingForPromotion(true);
                                    chessBlockEntity.setPromotionCoordinate((byte)move.getDestinationCoordinate());
                                    List players = player.method_51469().method_18456();
                                    for (class_3222 serverPlayer : players) {
                                        if (!serverPlayer.method_5667().equals(chessBlockEntity.getPromotionPlayerUUID())) continue;
                                        NetworkUtil.openChessPromotionFromServer(chessBlockEntity.method_11016(), move.getMovedPiece().getPieceColor().isWhite(), serverPlayer);
                                    }
                                    chessBlockEntity.setPromotionPlayerUUID(null);
                                }
                                if (chessBlockEntity.getDisplayParticles() && move.isAttack() && !move.isEnPassantMove()) {
                                    NetworkUtil.playChesParticlesFromServer(level, pos, (byte)move.getDestinationCoordinate(), move.getMovedPiece().getPieceColor().isBlack(), 0.0f, 0.0f, 0.0f);
                                }
                            }
                            if (!level.field_9236) {
                                TTCCriteriaTriggers.MAKE_CHESS_MOVE.trigger(player);
                            }
                            if (move.isEnPassantMove() && !level.field_9236) {
                                TTCCriteriaTriggers.MAKE_EN_PASSANT_MOVE.trigger(player);
                            }
                            if (chessBlockEntity.getBoard().getCurrentChessPlayer().isInCheckMate() && !level.field_9236) {
                                TTCCriteriaTriggers.MAKE_CHECK_MATE_MOVE.trigger(player);
                            }
                        }
                        chessBlockEntity.setSourceTile(null);
                        chessBlockEntity.setDestinationTile(null);
                        chessBlockEntity.setHumanMovedPiece(null);
                        level.method_8413(pos, level.method_8320(pos), level.method_8320(pos), 2);
                        chessBlockEntity.method_5431();
                    }
                }
            });
        });
    }
}

