/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnPromotion;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.pieces.BishopPiece;
import andrews.table_top_craft.game_logic.chess.pieces.KnightPiece;
import andrews.table_top_craft.game_logic.chess.pieces.QueenPiece;
import andrews.table_top_craft.game_logic.chess.pieces.RookPiece;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class MessageServerDoPawnPromotion {
    public static class_2960 PACKET_ID = new class_2960("table_top_craft", "do_pawn_promotion_packet");

    public static void registerPacket() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PACKET_ID, (minecraftServer, serverPlayer, packetListener, buf, packetSender) -> {
            class_2338 pos = buf.method_10811();
            byte type = buf.readByte();
            minecraftServer.execute(() -> {
                ChessBlockEntity chessBlockEntity;
                class_2586 blockEntity;
                if (serverPlayer == null) {
                    return;
                }
                class_1937 level = serverPlayer.method_37908();
                if (level != null && (blockEntity = level.method_8321(pos)) instanceof ChessBlockEntity && (chessBlockEntity = (ChessBlockEntity)blockEntity).getWaitingForPromotion()) {
                    Board board = chessBlockEntity.getBoard();
                    Board.Builder builder = new Board.Builder();
                    for (byte i = 0; i < 64; ++i) {
                        if (!board.getTile(i).isTileOccupied()) continue;
                        if (chessBlockEntity.getPromotionCoordinate() == i) {
                            BasePiece piece = board.getTile(i).getPiece();
                            switch (type) {
                                default: {
                                    builder.setPiece(new QueenPiece(piece.getPieceColor(), piece.getPiecePosition()));
                                    break;
                                }
                                case 3: {
                                    builder.setPiece(new BishopPiece(piece.getPieceColor(), piece.getPiecePosition()));
                                    break;
                                }
                                case 4: {
                                    builder.setPiece(new KnightPiece(piece.getPieceColor(), piece.getPiecePosition()));
                                    break;
                                }
                                case 2: {
                                    builder.setPiece(new RookPiece(piece.getPieceColor(), piece.getPiecePosition()));
                                    break;
                                }
                            }
                            continue;
                        }
                        builder.setPiece(board.getTile(i).getPiece());
                    }
                    builder.setMoveMaker(board.getCurrentChessPlayer().getPieceColor());
                    chessBlockEntity.setBoard(builder.build());
                    if (chessBlockEntity.getMoveLog().getMoves().get(chessBlockEntity.getMoveLog().getMoves().size() - 1).isPawnPromotion()) {
                        BaseMove move = chessBlockEntity.getMoveLog().getMoves().get(chessBlockEntity.getMoveLog().getMoves().size() - 1);
                        switch (type) {
                            default: {
                                chessBlockEntity.getMoveLog().getMoves().set(chessBlockEntity.getMoveLog().getMoves().size() - 1, new PawnPromotion(move, "Q"));
                                break;
                            }
                            case 3: {
                                chessBlockEntity.getMoveLog().getMoves().set(chessBlockEntity.getMoveLog().getMoves().size() - 1, new PawnPromotion(move, "B"));
                                break;
                            }
                            case 4: {
                                chessBlockEntity.getMoveLog().getMoves().set(chessBlockEntity.getMoveLog().getMoves().size() - 1, new PawnPromotion(move, "N"));
                                break;
                            }
                            case 2: {
                                chessBlockEntity.getMoveLog().getMoves().set(chessBlockEntity.getMoveLog().getMoves().size() - 1, new PawnPromotion(move, "R"));
                            }
                        }
                    }
                    chessBlockEntity.setWaitingForPromotion(false);
                    chessBlockEntity.setPromotionCoordinate((byte)-1);
                    level.method_8413(pos, level.method_8320(pos), level.method_8320(pos), 2);
                    chessBlockEntity.method_5431();
                }
            });
        });
    }
}

