/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.menus;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.screens.base.BaseScreen;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessBoardColorSettingsButton;
import andrews.table_top_craft.screens.chess.buttons.pieces.ChessBoardPieceSettingsButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessBoardSettingsButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessCopyFENButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessEvaluateBoardButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessLoadFENButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessMoveLogDownButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessMoveLogUpButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessNewGameButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessShowAvailableMovesButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessShowPreviousMoveButton;
import andrews.table_top_craft.screens.chess.buttons.settings.ChessShowTileInfoButton;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class ChessBoardSettingsScreen
extends BaseScreen {
    private static final class_2960 TEXTURE = new class_2960("table_top_craft", "textures/gui/menus/chess_menu.png");
    private static final class_2960 MOVE_LOG_TEXTURE = new class_2960("table_top_craft", "textures/gui/menus/move_log.png");
    private static final class_2561 TITLE = class_2561.method_43471((String)"gui.table_top_craft.chess.board_settings");
    private static final class_2561 MOVE_LOG_TXT = class_2561.method_43471((String)"gui.table_top_craft.chess.move_log");
    private static final class_2561 MOVE_LOG_WHITE_TXT = class_2561.method_43471((String)"gui.table_top_craft.chess.move_log.white");
    private static final class_2561 MOVE_LOG_BLACK_TXT = class_2561.method_43471((String)"gui.table_top_craft.chess.move_log.black");
    private static final class_2561 SHOW_TILE_INFO_TXT = class_2561.method_43471((String)"gui.table_top_craft.chess.show_tile_info");
    private static final class_2561 SHOW_AVAILABLE_MOVES_TXT = class_2561.method_43471((String)"gui.table_top_craft.chess.show_available_moves");
    private static final class_2561 SHOW_PREVIOUS_MOVE_TXT = class_2561.method_43471((String)"gui.table_top_craft.chess.show_previous_move");
    private final ChessBlockEntity chessBlockEntity;
    private int moveLogOffset;

    public ChessBoardSettingsScreen(ChessBlockEntity chessBlockEntity) {
        super(TEXTURE, 177, 198, TITLE);
        this.chessBlockEntity = chessBlockEntity;
        this.moveLogOffset = 0;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)new ChessBoardSettingsButton(this.chessBlockEntity, this.x - 24, this.y + 16));
        this.method_37063((class_364)new ChessBoardColorSettingsButton(this.chessBlockEntity, this.x - 24, this.y + 42));
        this.method_37063((class_364)new ChessBoardPieceSettingsButton(this.chessBlockEntity, this.x - 24, this.y + 68));
        this.method_37063((class_364)new ChessNewGameButton(this.chessBlockEntity.method_11016(), this.x + 5, this.y + 16));
        this.method_37063((class_364)new ChessEvaluateBoardButton(this.chessBlockEntity, this.x + 90, this.y + 16));
        this.method_37063((class_364)new ChessCopyFENButton(this.chessBlockEntity, this.x + 5, this.y + 31));
        this.method_37063((class_364)new ChessLoadFENButton(this.chessBlockEntity, this.x + 90, this.y + 31));
        this.method_37063((class_364)new ChessShowTileInfoButton(this.chessBlockEntity, this.x + 5, this.y + 46));
        this.method_37063((class_364)new ChessShowAvailableMovesButton(this.chessBlockEntity, this.x + 5, this.y + 60));
        this.method_37063((class_364)new ChessShowPreviousMoveButton(this.chessBlockEntity, this.x + 5, this.y + 74));
        this.method_37063((class_364)new ChessMoveLogDownButton(this.x + 161, this.y + 112, this));
        this.method_37063((class_364)new ChessMoveLogUpButton(this.x + 161, this.y + 167, this, this.chessBlockEntity));
    }

    @Override
    public void renderScreenContents(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_25302(TEXTURE, this.x, this.y + 15, 0, 198, 3, 26);
        graphics.method_25302(MOVE_LOG_TEXTURE, this.x + 5, this.y + 101, 0, 0, 155, 89);
        for (int i = 0; i < (this.moveLogOffset % 2 != 0 ? 3 : 4); ++i) {
            graphics.method_25302(MOVE_LOG_TEXTURE, this.x + 6, this.y + 124 + i * 22 - (this.moveLogOffset % 2 != 0 ? 0 : 11), 0, 89, 153, 10);
        }
        this.drawCenteredString(TITLE, this.field_22789 / 2, this.y + 6, 0x404040, false, graphics);
        this.drawCenteredString(MOVE_LOG_TXT, this.field_22789 / 2, this.y + 90, 0x404040, false, graphics);
        graphics.method_51439(this.field_22793, SHOW_TILE_INFO_TXT, this.x + 20, this.y + 49, 0, false);
        graphics.method_51439(this.field_22793, SHOW_AVAILABLE_MOVES_TXT, this.x + 20, this.y + 63, 0, false);
        graphics.method_51439(this.field_22793, SHOW_PREVIOUS_MOVE_TXT, this.x + 20, this.y + 77, 0, false);
        this.drawCenteredString(MOVE_LOG_WHITE_TXT, this.x + 54, this.y + 103, 0, false, graphics);
        this.drawCenteredString(MOVE_LOG_BLACK_TXT, this.x + 124, this.y + 103, 0, false, graphics);
        int offset = 0;
        int currentMoveId = 1;
        if (this.chessBlockEntity.getMoveLog() != null) {
            offset -= this.moveLogOffset * 11;
            for (int i = 0; i < this.chessBlockEntity.getMoveLog().getMoves().size(); ++i) {
                PieceColor pieceColor = this.chessBlockEntity.getMoveLog().getMoves().get(i).getMovedPiece().getPieceColor();
                String moveName = this.chessBlockEntity.getMoveLog().getMoves().get(i).toString();
                if (this.moveLogOffset * 2 <= i && this.moveLogOffset * 2 + 14 > i) {
                    graphics.method_51433(this.field_22793, moveName, this.x - moveName.length() * 6 / 2 + 54 + (pieceColor == PieceColor.WHITE ? 0 : 70), this.y + 114 + offset, 0, false);
                    if (i % 2 == 0) {
                        graphics.method_51433(this.field_22793, String.valueOf(currentMoveId + this.moveLogOffset), this.x + 7 + (currentMoveId + this.moveLogOffset > 9 ? 0 : 3), this.y + 114 + offset, 0, false);
                        ++currentMoveId;
                    }
                }
                if (i % 2 == 0) continue;
                offset += 11;
            }
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        super.method_25404(keyCode, scanCode, modifiers);
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
        }
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    public int getMoveLogOffset() {
        return this.moveLogOffset;
    }

    public void decreaseMoveLogOffset() {
        if (this.moveLogOffset > 0) {
            --this.moveLogOffset;
        }
    }

    public void increaseMoveLogOffset() {
        ++this.moveLogOffset;
    }

    public static void open(ChessBlockEntity chessBlockEntity) {
        class_310.method_1551().method_1507((class_437)new ChessBoardSettingsScreen(chessBlockEntity));
    }
}

