/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.menus.color_selection;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.screens.base.BaseScreen;
import andrews.table_top_craft.screens.base.BaseSlider;
import andrews.table_top_craft.screens.chess.buttons.ChessCancelButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessConfirmColorButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessRandomColorButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessResetColorButton;
import andrews.table_top_craft.screens.chess.sliders.ChessBlueColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessGreenColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessRedColorSlider;
import andrews.table_top_craft.screens.piece_figure.util.ColorPickerToggleButton;
import andrews.table_top_craft.screens.piece_figure.util.IColorPicker;
import andrews.table_top_craft.screens.piece_figure.util.IColorPickerExtended;
import andrews.table_top_craft.screens.piece_figure.util.SaturationSlider;
import andrews.table_top_craft.screens.piece_figure.util.TTCColorPicker;
import andrews.table_top_craft.util.Color;
import andrews.table_top_craft.util.NBTColorSaving;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5348;

public class ChessBoardPieceColorsScreen
extends BaseScreen
implements IColorPicker,
IColorPickerExtended {
    private static final class_2960 TEXTURE = new class_2960("table_top_craft", "textures/gui/menus/chess_menu.png");
    private static final class_2960 PREVIEW_TEXTURE = new class_2960("table_top_craft", "textures/gui/menus/preview_color.png");
    private static final class_2960 PREVIEW_FRAME_TEXTURE = new class_2960("table_top_craft", "textures/gui/menus/medium_chess_menu.png");
    private static final class_2960 COLOR_PICKER_FRAME_TEXTURE = new class_2960("table_top_craft", "textures/gui/color_picker/color_picker_frame.png");
    private static final class_2561 TITLE = class_2561.method_43471((String)"gui.table_top_craft.chess.color.piece");
    private static final class_2561 PREVIEW_COLOR_TXT = class_2561.method_43471((String)"gui.table_top_craft.chess.color.colors_preview");
    private static final class_2561 WHITE_PIECE_SETTINGS_TXT = class_2561.method_43471((String)"gui.table_top_craft.chess.color.white_piece_settings");
    private static final class_2561 BLACK_PIECE_SETTINGS_TXT = class_2561.method_43471((String)"gui.table_top_craft.chess.color.black_piece_settings");
    private final ChessBlockEntity chessBlockEntity;
    private final boolean isColorPickerActive;
    private final boolean isOptionalColorPickerActive;
    private ChessRedColorSlider whiteRedColorSlider;
    private ChessGreenColorSlider whiteGreenColorSlider;
    private ChessBlueColorSlider whiteBlueColorSlider;
    private ChessRedColorSlider blackRedColorSlider;
    private ChessGreenColorSlider blackGreenColorSlider;
    private ChessBlueColorSlider blackBlueColorSlider;
    private TTCColorPicker colorPicker;
    private SaturationSlider saturationSlider;

    public ChessBoardPieceColorsScreen(ChessBlockEntity chessBlockEntity, boolean isColorPickerActive, boolean isOptionalColorPickerActive) {
        super(TEXTURE, 177, 198, TITLE);
        this.chessBlockEntity = chessBlockEntity;
        this.isColorPickerActive = isColorPickerActive;
        this.isOptionalColorPickerActive = isOptionalColorPickerActive;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)new ColorPickerToggleButton(this.chessBlockEntity, this, false, this.x + 68, this.y + 54));
        this.method_37063((class_364)new ColorPickerToggleButton(this.chessBlockEntity, this, true, this.x + 153, this.y + 54));
        this.whiteRedColorSlider = new ChessRedColorSlider(this.x + 5, this.y + 92, 167, 12, NBTColorSaving.getRed(this.chessBlockEntity.getWhitePiecesColor()), this);
        this.method_37063((class_364)this.whiteRedColorSlider);
        this.whiteGreenColorSlider = new ChessGreenColorSlider(this.x + 5, this.y + 105, 167, 12, NBTColorSaving.getGreen(this.chessBlockEntity.getWhitePiecesColor()), this);
        this.method_37063((class_364)this.whiteGreenColorSlider);
        this.whiteBlueColorSlider = new ChessBlueColorSlider(this.x + 5, this.y + 118, 167, 12, NBTColorSaving.getBlue(this.chessBlockEntity.getWhitePiecesColor()), this);
        this.method_37063((class_364)this.whiteBlueColorSlider);
        this.blackRedColorSlider = new ChessRedColorSlider(this.x + 5, this.y + 141, 167, 12, NBTColorSaving.getRed(this.chessBlockEntity.getBlackPiecesColor()), this);
        this.method_37063((class_364)this.blackRedColorSlider);
        this.blackGreenColorSlider = new ChessGreenColorSlider(this.x + 5, this.y + 154, 167, 12, NBTColorSaving.getGreen(this.chessBlockEntity.getBlackPiecesColor()), this);
        this.method_37063((class_364)this.blackGreenColorSlider);
        this.blackBlueColorSlider = new ChessBlueColorSlider(this.x + 5, this.y + 167, 167, 12, NBTColorSaving.getBlue(this.chessBlockEntity.getBlackPiecesColor()), this);
        this.method_37063((class_364)this.blackBlueColorSlider);
        this.method_37063((class_364)new ChessRandomColorButton(this, this.x + 5, this.y + 68));
        this.method_37063((class_364)new ChessResetColorButton(ChessResetColorButton.DefaultColorType.PIECES, this, this.x + 90, this.y + 68));
        this.method_37063((class_364)new ChessCancelButton(this.chessBlockEntity, ChessCancelButton.ChessCancelMenuTarget.CHESS_BOARD_COLORS, ChessCancelButton.ChessCancelButtonText.CANCEL, this.x + 5, this.y + 180));
        this.method_37063((class_364)new ChessConfirmColorButton(ChessConfirmColorButton.ColorMenuType.PIECES, this.chessBlockEntity, this.whiteRedColorSlider, this.blackRedColorSlider, this.whiteGreenColorSlider, this.blackGreenColorSlider, this.whiteBlueColorSlider, this.blackBlueColorSlider, this.x + 90, this.y + 180));
        if (this.isColorPickerActive) {
            Color color = new Color(this.whiteRedColorSlider.getValueInt(), this.whiteGreenColorSlider.getValueInt(), this.whiteBlueColorSlider.getValueInt());
            this.colorPicker = new TTCColorPicker(this.x - 131, this.y + 28, this, color.getHue() / 360.0f, 1.0f - color.getValue());
            this.method_37063((class_364)this.colorPicker);
            float saturation = color.getSaturation() * 100.0f;
            this.saturationSlider = new SaturationSlider(this.x - 132, this.y + 158, 130, 12, Math.round(saturation), this);
            this.method_37063((class_364)this.saturationSlider);
        } else if (this.isOptionalColorPickerActive) {
            Color color = new Color(this.blackRedColorSlider.getValueInt(), this.blackGreenColorSlider.getValueInt(), this.blackBlueColorSlider.getValueInt());
            this.colorPicker = new TTCColorPicker(this.x - 131, this.y + 28, this, color.getHue() / 360.0f, 1.0f - color.getValue());
            this.method_37063((class_364)this.colorPicker);
            float saturation = color.getSaturation() * 100.0f;
            this.saturationSlider = new SaturationSlider(this.x - 132, this.y + 158, 130, 12, Math.round(saturation), this);
            this.method_37063((class_364)this.saturationSlider);
        }
    }

    @Override
    public void renderScreenContents(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isColorPickerActive || this.isOptionalColorPickerActive) {
            graphics.method_25302(COLOR_PICKER_FRAME_TEXTURE, this.x - 136, this.y + 23, 0, 0, 136, 151);
        }
        graphics.method_25302(PREVIEW_FRAME_TEXTURE, this.x + 25, this.y + 25, 0, 131, 42, 42);
        graphics.method_25302(PREVIEW_FRAME_TEXTURE, this.x + 110, this.y + 25, 0, 131, 42, 42);
        graphics.method_51448().method_22903();
        graphics.method_51422(0.003921569f * (float)this.whiteRedColorSlider.getValueInt(), 0.003921569f * (float)this.whiteGreenColorSlider.getValueInt(), 0.003921569f * (float)this.whiteBlueColorSlider.getValueInt(), 1.0f);
        graphics.method_51448().method_46416((float)(this.x + 26), (float)(this.y + 26), 0.0f);
        graphics.method_51448().method_22905(2.5f, 2.5f, 2.5f);
        graphics.method_25302(PREVIEW_TEXTURE, 0, 0, 0, 0, 16, 16);
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.method_51448().method_22909();
        graphics.method_51448().method_22903();
        graphics.method_51422(0.003921569f * (float)this.blackRedColorSlider.getValueInt(), 0.003921569f * (float)this.blackGreenColorSlider.getValueInt(), 0.003921569f * (float)this.blackBlueColorSlider.getValueInt(), 1.0f);
        graphics.method_51448().method_46416((float)(this.x + 111), (float)(this.y + 26), 0.0f);
        graphics.method_51448().method_22905(2.5f, 2.5f, 2.5f);
        graphics.method_25302(PREVIEW_TEXTURE, 0, 0, 0, 0, 16, 16);
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.method_51448().method_22909();
        this.drawCenteredString(TITLE, this.field_22789 / 2 + (this.isColorPickerActive || this.isOptionalColorPickerActive ? 68 : 0), this.y + 6, 0x404040, false, graphics);
        graphics.method_51439(this.field_22793, PREVIEW_COLOR_TXT, this.x + 88 - this.field_22793.method_27525((class_5348)PREVIEW_COLOR_TXT) / 2, this.y + 16, 0, false);
        graphics.method_51439(this.field_22793, WHITE_PIECE_SETTINGS_TXT, this.x + 5, this.y + 83, 0, false);
        graphics.method_51439(this.field_22793, BLACK_PIECE_SETTINGS_TXT, this.x + 5, this.y + 132, 0, false);
    }

    @Override
    public int offsetX() {
        return this.isColorPickerActive || this.isOptionalColorPickerActive ? 136 : super.offsetX();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        super.method_25404(keyCode, scanCode, modifiers);
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
        }
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public TTCColorPicker getColorPicker() {
        return this.colorPicker;
    }

    @Override
    public BaseSlider getRedSlider() {
        return this.whiteRedColorSlider;
    }

    @Override
    public BaseSlider getGreenSlider() {
        return this.whiteGreenColorSlider;
    }

    @Override
    public BaseSlider getBlueSlider() {
        return this.whiteBlueColorSlider;
    }

    @Override
    public BaseSlider getSaturationSlider() {
        return this.saturationSlider;
    }

    @Override
    public boolean isColorPickerActive() {
        return this.isColorPickerActive;
    }

    @Override
    public BaseSlider getOptionalRedSlider() {
        return this.blackRedColorSlider;
    }

    @Override
    public BaseSlider getOptionalGreenSlider() {
        return this.blackGreenColorSlider;
    }

    @Override
    public BaseSlider getOptionalBlueSlider() {
        return this.blackBlueColorSlider;
    }

    @Override
    public boolean isOptionalColorPickerActive() {
        return this.isOptionalColorPickerActive;
    }
}

