/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.enumerations.Direction2D;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import java.awt.geom.Point2D;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_3532;

@Virtual
public class TSliderWidget
extends TButtonWidget {
    protected static final int BUTTON_Y_ENABLED = TSliderWidget.getButtonTextureY(true, false);
    protected static final int BUTTON_Y_DISABLED = TSliderWidget.getButtonTextureY(false, false);
    protected Direction2D sliderDirection = Direction2D.RIGHT;
    protected double value;
    protected int knobSize;

    public TSliderWidget(int x, int y, int width, int height, double value) {
        this(x, y, width, height, null, value);
    }

    public TSliderWidget(int x, int y, int width, int height, class_2561 text, double value) {
        super(x, y, width, height, text);
        this.value = value;
        this.knobSize = 4;
    }

    public final Direction2D getSliderDirection() {
        return this.sliderDirection;
    }

    @Virtual
    public void setSliderDirection(Direction2D direction) {
        if (direction == null) {
            direction = Direction2D.RIGHT;
        }
        this.sliderDirection = direction;
    }

    public final double getValue() {
        return this.value;
    }

    public final void setValue(double value) {
        this.setValue(value, true);
    }

    @Virtual
    public void setValue(double value, boolean applyValue) {
        this.value = class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        if (applyValue) {
            this.click(false);
        }
    }

    public final void setValueFromMouse(double mouseX, double mouseY) {
        int j = this.getKnobSize();
        if (this.getSliderDirection().isHorizontal()) {
            double val = (mouseX - (double)(this.x + j)) / (double)(this.width - j * 2);
            if (this.getSliderDirection() == Direction2D.LEFT) {
                val = 1.0 - class_3532.method_15350((double)val, (double)0.0, (double)1.0);
            }
            this.setValue(val);
        } else {
            double val = (mouseY - (double)(this.y + j)) / (double)(this.height - j * 2);
            if (this.getSliderDirection() == Direction2D.UP) {
                val = 1.0 - class_3532.method_15350((double)val, (double)0.0, (double)1.0);
            }
            this.setValue(val);
        }
    }

    public final int getKnobSize() {
        return this.knobSize;
    }

    @Virtual
    public void setKnobSize(int size) {
        int i0 = this.getSliderDirection().isHorizontal() ? this.getWidth() : this.getHeight();
        this.knobSize = class_3532.method_15340((int)size, (int)4, (int)Math.max(i0, 4));
    }

    @Override
    @Virtual
    public void render(TDrawContext pencil) {
        pencil.drawTButton(BUTTON_Y_DISABLED);
        this.renderSliderProgressBar(pencil);
        this.renderSliderKnob(pencil);
        pencil.drawTElementTextTH(this.text, HorizontalAlignment.CENTER);
    }

    @Virtual
    public void renderSliderProgressBar(TDrawContext pencil) {
        if (!(this.value > 0.0)) {
            return;
        }
        int sX = this.getX();
        int sY = this.getY();
        int sW = this.getWidth();
        int sH = this.getHeight();
        switch (this.getSliderDirection()) {
            case RIGHT: {
                sW = (int)(this.value * (double)sW);
                break;
            }
            case DOWN: {
                sH = (int)(this.value * (double)sH);
                break;
            }
            case LEFT: {
                sW = (int)(this.value * (double)sW);
                sX = this.getEndX() - sW;
                break;
            }
            case UP: {
                sH = (int)(this.value * (double)sH);
                sY = this.getEndY() - sH;
                break;
            }
        }
        pencil.pushTShaderColor(0.6f, 0.6f, 0.6f, 1.0f);
        pencil.method_44379(sX, sY, sX + sW, sY + sH);
        pencil.drawTButton(this.getButtonTextureY());
        pencil.method_44380();
        pencil.popTShaderColor();
    }

    public final void renderSliderKnob(TDrawContext pencil) {
        int j = this.getKnobSize();
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        switch (this.getSliderDirection()) {
            case RIGHT: {
                x = this.getX() + (int)(this.getValue() * (double)(this.getWidth() - j * 2));
                y = this.getY();
                w = j * 2;
                h = this.getHeight();
                break;
            }
            case LEFT: {
                x = this.getEndX() - (int)(this.getValue() * (double)(this.getWidth() - j * 2)) - j * 2;
                y = this.getY();
                w = j * 2;
                h = this.getHeight();
                break;
            }
            case DOWN: {
                x = this.getX();
                y = this.getY() + (int)(this.getValue() * (double)(this.getHeight() - j * 2));
                w = this.getWidth();
                h = j * 2;
                break;
            }
            case UP: {
                x = this.getX();
                y = this.getEndY() - (int)(this.getValue() * (double)(this.getHeight() - j * 2)) - j * 2;
                w = this.getWidth();
                h = j * 2;
                break;
            }
            default: {
                return;
            }
        }
        this.renderSliderKnob(pencil, x, y, w, h);
    }

    @Virtual
    public void renderSliderKnob(TDrawContext pencil, int knobX, int knobY, int knobWidth, int knobHeight) {
        pencil.drawTNineSlicedTexture(class_339.field_22757, knobX, knobY, knobWidth, knobHeight, 0, this.getButtonTextureY(), 200, 20, 256, 256, 3);
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext) {
        if (this.getParentTScreen() == null) {
            return false;
        }
        if (!this.isEnabled()) {
            return false;
        }
        switch (inputContext.getInputType()) {
            case MOUSE_PRESS: {
                if (inputContext.getMouseButton() != 0) break;
                return true;
            }
            case MOUSE_DRAG: {
                if (inputContext.getMouseButton() != 0) break;
                Point2D.Double mousePos = inputContext.getMousePosition();
                this.setValueFromMouse(mousePos.x, mousePos.y);
                return true;
            }
            case MOUSE_DRAG_END: {
                this.click(true);
                return true;
            }
            case KEY_PRESS: {
                float f;
                boolean bl;
                int keyCode = inputContext.getKeyboardKey().keyCode;
                Direction2D dir = this.getSliderDirection();
                boolean bl2 = dir.isHorizontal() ? keyCode == 263 || keyCode == 262 : (bl = keyCode == 265 || keyCode == 264);
                if (!bl) break;
                float f2 = dir.isHorizontal() ? (float)(keyCode == 263 ? -1 : 1) : (f = (float)(keyCode == 265 ? -1 : 1));
                if (dir == Direction2D.LEFT || dir == Direction2D.UP) {
                    f *= -1.0f;
                }
                float w = dir.isHorizontal() ? (float)this.getWidth() : (float)this.getHeight();
                this.setValue(this.getValue() + (double)(f / (w - (float)(this.getKnobSize() * 2))));
                return true;
            }
            case KEY_RELEASE: {
                boolean bl;
                int keyCode = inputContext.getKeyboardKey().keyCode;
                Direction2D dir = this.getSliderDirection();
                boolean bl3 = dir.isHorizontal() ? keyCode == 263 || keyCode == 262 : (bl = keyCode == 265 || keyCode == 264);
                if (!bl) break;
                this.click(true);
                return true;
            }
        }
        return false;
    }
}

