/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.temperature.effects;

import com.github.thedeathlycow.thermoo.api.temperature.effects.TemperatureEffect;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public class StatusEffectTemperatureEffect
extends TemperatureEffect<Config> {
    @Override
    public void apply(class_1309 victim, class_3218 serverWorld, Config config) {
        for (Config.ConfigEffect effect : config.effects) {
            this.addEffect(victim, effect);
        }
    }

    private void addEffect(class_1309 victim, Config.ConfigEffect effect) {
        class_1293 existingEffect = victim.method_6112(effect.type);
        if (existingEffect != null && existingEffect.method_5578() == effect.amplifier && existingEffect.method_5584() > effect.duration / 2) {
            return;
        }
        victim.method_37222(new class_1293(effect.type, effect.duration, effect.amplifier, true, true), null);
    }

    @Override
    public boolean shouldApply(class_1309 victim, Config config) {
        return victim.field_6012 % 5 == 0;
    }

    @Override
    public Config configFromJson(JsonElement json, JsonDeserializationContext context) throws JsonSyntaxException {
        return Config.fromJson(json);
    }

    public record Config(Collection<ConfigEffect> effects) {
        public static Config fromJson(JsonElement json) throws JsonSyntaxException {
            ArrayList<ConfigEffect> effects;
            JsonObject object = json.getAsJsonObject();
            JsonElement effectsJson = object.get("effects");
            if (effectsJson.isJsonArray()) {
                effects = new ArrayList();
                for (JsonElement effect : effectsJson.getAsJsonArray()) {
                    effects.add(Config.deserializeEffect(effect));
                }
            } else {
                effects = Collections.singleton(Config.deserializeEffect(effectsJson));
            }
            return new Config(effects);
        }

        private static ConfigEffect deserializeEffect(JsonElement json) throws JsonSyntaxException {
            class_2960 effectID;
            class_1291 effect;
            JsonObject object = json.getAsJsonObject();
            int amplifier = object.get("amplifier").getAsInt();
            int duration = 20;
            if (object.has("duration")) {
                duration = object.get("duration").getAsInt();
            }
            if ((effect = (class_1291)class_7923.field_41174.method_10223(effectID = new class_2960(object.get("effect").getAsString()))) == null) {
                throw new JsonParseException("Unknown status effect: " + effectID);
            }
            return new ConfigEffect(effect, duration, amplifier);
        }

        protected record ConfigEffect(class_1291 type, int duration, int amplifier) {
        }
    }
}

