/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.client.gui.overlays;

import com.li64.tide.Tide;
import com.li64.tide.data.fishing.MinigameBehavior;
import com.li64.tide.network.messages.MinigameServerMsg;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.util.TideUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class CatchMinigameOverlay {
    private static final int INIT_DELAY_MILLIS = 200;
    private static final class_2960 BAR_BG = Tide.resource("textures/gui/fishing/minigame_bg.png");
    private static final class_2960 FILL_WATER = TideUtils.sprite("fishing/minigame_fill");
    private static final class_2960 FILL_LAVA = TideUtils.sprite("fishing/minigame_fill_lava");
    private static final class_2960 FILL_VOID = TideUtils.sprite("fishing/minigame_fill_void");
    private static final class_2960 BAR_OVERLAY = Tide.resource("textures/gui/fishing/minigame_overlay.png");
    private static final class_2960 MARKER = Tide.resource("textures/gui/fishing/marker.png");
    private static final class_2960 SELECT = Tide.resource("textures/gui/fishing/marker_select.png");
    private static float timeLeft = 100.0f;
    private static float animProgress = 0.0f;
    private static float timer = 20.0f;
    private static boolean isActive = false;
    private static class_5250 accuracyText = null;
    private static class_124 textColor = class_124.field_1068;
    private static byte type;
    private static float area;
    private static float speed;
    private static MinigameBehavior behavior;
    private static long delayTime;

    public static void start(byte type, byte behavior, float area, float speed) {
        if (isActive) {
            return;
        }
        CatchMinigameOverlay.type = type;
        CatchMinigameOverlay.behavior = MinigameBehavior.values()[behavior];
        CatchMinigameOverlay.area = area;
        CatchMinigameOverlay.speed = speed;
        accuracyText = null;
        animProgress = new Random().nextFloat() * 100.0f;
        timeLeft = 0.0f;
        timer = 0.0f;
        isActive = true;
        delayTime = System.currentTimeMillis() + 200L;
    }

    public static void interact() {
        if (!isActive || System.currentTimeMillis() < delayTime) {
            return;
        }
        float accuracy = Math.abs(CatchMinigameOverlay.getMinigamePosition());
        if (accuracy < area) {
            if (accuracy < 0.1f) {
                accuracyText = class_2561.method_43471((String)"minigame.perfect");
                textColor = class_124.field_1065;
                Tide.NETWORK.sendToServer(new MinigameServerMsg(3));
            } else {
                accuracyText = class_2561.method_43471((String)"minigame.catch");
                textColor = class_124.field_1060;
                Tide.NETWORK.sendToServer(new MinigameServerMsg(2));
            }
        } else {
            accuracyText = class_2561.method_43471((String)"minigame.miss");
            textColor = class_124.field_1061;
            Tide.NETWORK.sendToServer(new MinigameServerMsg(1));
        }
        CatchMinigameOverlay.close();
    }

    public static void close() {
        isActive = false;
        timer = 0.0f;
    }

    public static void render(class_332 graphics, float dt) {
        if (timer >= 20.0f) {
            return;
        }
        if (!isActive) {
            timer += dt;
        } else {
            animProgress += dt;
            if ((timeLeft += dt) >= 80.0f || HookAccessor.bobberRemoved((class_1657)class_310.method_1551().field_1724)) {
                CatchMinigameOverlay.close();
                Tide.NETWORK.sendToServer(new MinigameServerMsg(0));
            }
        }
        float alpha = -class_3532.method_15363((float)((timer - 10.0f) / 10.0f), (float)0.0f, (float)1.0f) + 1.0f;
        int texWidth = 60;
        int texHeight = 7;
        int offset = Math.round((float)texWidth / 2.0f * (1.0f - area));
        int x = (graphics.method_51421() - texWidth) / 2;
        int y = graphics.method_51443() / 2 - 18;
        graphics.method_51452();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        class_2960 fillSprite = type == 1 ? FILL_LAVA : (type == 2 ? FILL_VOID : FILL_WATER);
        graphics.method_25290(BAR_BG, x, y, 0.0f, 0.0f, texWidth, texHeight, texWidth, texHeight);
        TideUtils.blitNineSliced(graphics, fillSprite, x + offset, y, texWidth - offset * 2, texHeight, 2, 2, 2, 4, 6, 7, 0, 0, 6, 7);
        graphics.method_25290(BAR_OVERLAY, x, y, 0.0f, 0.0f, texWidth, texHeight, texWidth, texHeight);
        int markerX = Math.round((float)x + (float)texWidth / 2.0f - 2.0f + CatchMinigameOverlay.getMinigamePosition() * ((float)texWidth / 2.0f - 2.0f));
        class_2960 markerTexture = timer % 4.0f < 2.0f ? MARKER : SELECT;
        graphics.method_25290(markerTexture, markerX, y - 1, 0.0f, 0.0f, 4, 9, 4, 9);
        if (Tide.CONFIG.minigame.doFeedback && accuracyText != null) {
            class_327 font = class_310.method_1551().field_1772;
            if (alpha >= 0.03f) {
                graphics.method_51439(font, (class_2561)accuracyText.method_27696(accuracyText.method_10866().method_10977(textColor)), (graphics.method_51421() - font.method_27525((class_5348)accuracyText)) / 2, y - 10, 0xFFFFFF, false);
            }
        }
        graphics.method_51452();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static float getMinigamePosition() {
        return behavior.apply(Float.valueOf(animProgress * speed)).floatValue();
    }

    public static boolean isActive() {
        return isActive;
    }
}

