/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.client.gui.screens;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.screens.journal.FishProfile;
import com.li64.tide.client.gui.screens.journal.ProfileComponent;
import com.li64.tide.client.gui.screens.journal.components.HorizontalLineComponent;
import com.li64.tide.client.gui.screens.journal.components.RarityComponent;
import com.li64.tide.client.gui.screens.journal.components.SilhouetteComponent;
import com.li64.tide.data.fishing.FishData;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.registries.TideSoundEvents;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public class FishyNoteScreen
extends class_437 {
    private static final class_2960 BG = Tide.resource("textures/gui/journal/fishy_note.png");
    private static final class_2960 CHECKMARK = Tide.resource("textures/gui/journal/checkmark.png");
    private static final int WIDTH = 200;
    private static final int HEIGHT = 230;
    private final boolean discovered;
    private final List<ProfileComponent> components;
    private class_4185 xButton;

    public FishyNoteScreen(class_1799 fish) {
        super((class_2561)class_2561.method_43471((String)"item.tide.fishy_note"));
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_5783(TideSoundEvents.PAGE_FLIP, 1.0f, 1.0f + new Random().nextFloat() * 0.2f);
        }
        FishData data = FishData.getOrThrow(fish);
        this.components = FishProfile.buildComponents(data);
        if (!this.components.isEmpty()) {
            this.components.add(0, new HorizontalLineComponent(false));
        }
        if (!(this.components.get(this.components.size() - 1) instanceof HorizontalLineComponent)) {
            this.components.add(new HorizontalLineComponent(false));
        }
        this.components.add(0, new SilhouetteComponent(data.size().orElse(null)));
        this.components.add(new RarityComponent(data.profile().rarity()));
        this.discovered = TidePlayerData.CLIENT_DATA.isFishUnlocked(data.fish());
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        int xX = Math.min(this.field_22789 - 19, (this.field_22789 + 200) / 2 - 16);
        int xY = Math.max(3, (this.field_22790 - 230) / 2);
        this.xButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"X"), button -> this.method_25419()).method_46434(xX, xY, 16, 16).method_46431();
        this.method_25429((class_364)this.xButton);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        int x = (graphics.method_51421() - 200) / 2;
        int y = (graphics.method_51443() - 230) / 2;
        graphics.method_25290(BG, x, y, 0.0f, 0.0f, 200, 230, 200, 230);
        if (this.discovered) {
            graphics.method_25290(CHECKMARK, x + 18, y + 18, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        int cursorY = 0;
        int padding = 4;
        int totalHeight = this.components.stream().mapToInt(area -> area.getRequiredHeight() + 4).sum();
        int originY = y + (230 - totalHeight) / 2;
        for (ProfileComponent area2 : this.components) {
            area2.render(graphics, this.field_22793, x + 14, originY + cursorY, mouseX, mouseY, partialTick);
            cursorY += area2.getRequiredHeight() + 4;
        }
        if (this.xButton != null) {
            this.xButton.method_25394(graphics, mouseX, mouseY, partialTick);
        }
    }
}

